/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.sql.SQLException;
import java.util.List;
import org.apache.kyuubi.jdbc.hive.JdbcColumn;
import org.apache.kyuubi.jdbc.hive.JdbcColumnAttributes;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.adapter.SQLResultSetMetaData;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeId;

public class KyuubiResultSetMetaData
implements SQLResultSetMetaData {
    private final List<String> columnNames;
    private final List<TTypeId> columnTypes;
    private final List<JdbcColumnAttributes> columnAttributes;

    public KyuubiResultSetMetaData(List<String> columnNames, List<TTypeId> columnTypes, List<JdbcColumnAttributes> columnAttributes) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.columnAttributes = columnAttributes;
    }

    private int getSqlType(int column) throws SQLException {
        return JdbcColumn.convertTTypeIdToSqlType(this.columnTypes.get(this.toZeroIndex(column)));
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return JdbcColumn.columnClassName(this.columnTypes.get(this.toZeroIndex(column)), this.columnAttributes.get(this.toZeroIndex(column)));
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnNames.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return JdbcColumn.columnDisplaySize(this.columnTypes.get(this.toZeroIndex(column)), this.columnAttributes.get(this.toZeroIndex(column)));
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnNames.get(this.toZeroIndex(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnNames.get(this.toZeroIndex(column));
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        TTypeId type = this.columnTypes.get(this.toZeroIndex(column));
        return JdbcColumn.convertTTypeIdToSqlType(type);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return JdbcColumn.getColumnTypeName(this.columnTypes.get(this.toZeroIndex(column)));
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return JdbcColumn.columnPrecision(this.columnTypes.get(this.toZeroIndex(column)), this.columnAttributes.get(this.toZeroIndex(column)));
    }

    @Override
    public int getScale(int column) throws SQLException {
        return JdbcColumn.columnScale(this.getSqlType(column), this.columnAttributes.get(this.toZeroIndex(column)));
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        TTypeId type = this.columnTypes.get(this.toZeroIndex(column));
        return type == TTypeId.STRING_TYPE;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    protected int toZeroIndex(int column) throws SQLException {
        if (this.columnTypes == null) {
            throw new KyuubiSQLException("Could not determine column type name for ResultSet");
        }
        if (column < 1 || column > this.columnTypes.size()) {
            throw new KyuubiSQLException("Invalid column value: " + column);
        }
        return column - 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        TTypeId typeId = this.columnTypes.get(this.toZeroIndex(column));
        switch (typeId) {
            case TINYINT_TYPE: 
            case SMALLINT_TYPE: 
            case INT_TYPE: 
            case BIGINT_TYPE: 
            case FLOAT_TYPE: 
            case DOUBLE_TYPE: 
            case DECIMAL_TYPE: 
            case TIMESTAMP_TYPE: 
            case DATE_TYPE: 
            case INTERVAL_YEAR_MONTH_TYPE: 
            case INTERVAL_DAY_TIME_TYPE: 
            case TIMESTAMPLOCALTZ_TYPE: {
                return true;
            }
        }
        return false;
    }
}

