/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication.ldap;

import java.io.Serializable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.ldap.DirSearch;
import org.apache.kyuubi.service.authentication.ldap.LdapUtils$;
import org.apache.kyuubi.service.authentication.ldap.Query;
import org.apache.kyuubi.service.authentication.ldap.QueryFactory;
import org.apache.kyuubi.service.authentication.ldap.SearchResultHandler;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\f\u0018\u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!)q\t\u0001C\u0001\u0011\"9A\n\u0001b\u0001\n\u001bi\u0005BB.\u0001A\u00035a\nC\u0004]\u0001\t\u0007IQB/\t\r\t\u0004\u0001\u0015!\u0004_\u0011\u001d\u0019\u0007A1A\u0005\u000euCa\u0001\u001a\u0001!\u0002\u001bq\u0006bB3\u0001\u0005\u0004%i!\u0018\u0005\u0007M\u0002\u0001\u000bQ\u00020\t\u000f\u001d\u0004!\u0019!C\u0007Q\"1A\u000e\u0001Q\u0001\u000e%DQ!\u001c\u0001\u0005B9DQA\u001d\u0001\u0005BMDq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003[\u0003A\u0011BAX\u0005)aE-\u00199TK\u0006\u00148\r\u001b\u0006\u00031e\tA\u0001\u001c3ba*\u0011!dG\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\taR$A\u0004tKJ4\u0018nY3\u000b\u0005yy\u0012AB6zkV\u0014\u0017N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0015j\u0013\u0007\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!A.\u00198h\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\r=\u0013'.Z2u!\tqs&D\u0001\u0018\u0013\t\u0001tCA\u0005ESJ\u001cV-\u0019:dQB\u0011!gM\u0007\u0002;%\u0011A'\b\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ej\u0012AB2p]\u001aLw-\u0003\u0002<q\tQ1*_;vE&\u001cuN\u001c4\u0002\u0007\r$\b\u0010\u0005\u0002?\u000b6\tqH\u0003\u0002A\u0003\u0006IA-\u001b:fGR|'/\u001f\u0006\u0003\u0005\u000e\u000baA\\1nS:<'\"\u0001#\u0002\u000b)\fg/\u0019=\n\u0005\u0019{$A\u0003#je\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"2!\u0013&L!\tq\u0003\u0001C\u00036\u0007\u0001\u0007a\u0007C\u0003=\u0007\u0001\u0007Q(\u0001\u0004cCN,GI\\\u000b\u0002\u001dB\u0011q\n\u0017\b\u0003!Z\u0003\"!\u0015+\u000e\u0003IS!aU\u0012\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0016!B:dC2\f\u0017BA,U\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011L\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]#\u0016a\u00022bg\u0016$e\u000eI\u0001\u000bOJ|W\u000f\u001d\"bg\u0016\u001cX#\u00010\u0011\u0007}\u0003g*D\u0001U\u0013\t\tGKA\u0003BeJ\f\u00170A\u0006he>,\bOQ1tKN\u0004\u0013\u0001D;tKJ\u0004\u0016\r\u001e;fe:\u001c\u0018!D;tKJ\u0004\u0016\r\u001e;fe:\u001c\b%A\u0005vg\u0016\u0014()Y:fg\u0006QQo]3s\u0005\u0006\u001cXm\u001d\u0011\u0002\u000fE,XM]5fgV\t\u0011\u000e\u0005\u0002/U&\u00111n\u0006\u0002\r#V,'/\u001f$bGR|'/_\u0001\tcV,'/[3tA\u0005)1\r\\8tKR\tq\u000e\u0005\u0002`a&\u0011\u0011\u000f\u0016\u0002\u0005+:LG/\u0001\u0006gS:$Wk]3s\t:$\"A\u0014;\t\u000bU|\u0001\u0019\u0001(\u0002\tU\u001cXM\u001d\u0015\u0004\u001f]t\bcA0yu&\u0011\u0011\u0010\u0016\u0002\u0007i\"\u0014xn^:\u0011\u0005mdX\"A!\n\u0005u\f%a\u0004(b[&tw-\u0012=dKB$\u0018n\u001c82\u000byqu0a\f2\u0013\r\n\t!a\u0002\u0002&\u0005%QcA'\u0002\u0004\u00119\u0011QA\u0012C\u0002\u0005=!!\u0001+\n\t\u0005%\u00111B\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u00055A+\u0001\u0004uQJ|wo]\t\u0005\u0003#\t9\u0002E\u0002`\u0003'I1!!\u0006U\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0007\u0002 9\u0019q,a\u0007\n\u0007\u0005uA+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00121\u0005\u0002\n)\"\u0014xn^1cY\u0016T1!!\bUc%\u0019\u0013qEA\u0015\u0003W\tiAD\u0002`\u0003SI1!!\u0004Uc\u0015\u0011s\fVA\u0017\u0005\u0015\u00198-\u00197bc\t1#0A\bgS:$GI\u001c\"z!\u0006$H/\u001a:o)\u0015q\u0016QGA#\u0011\u001d\t9\u0004\u0005a\u0001\u0003s\t\u0001\u0002]1ui\u0016\u0014hn\u001d\t\u0006\u0003w\t\tE\u0014\b\u0005\u0003{\tYBD\u0002R\u0003\u007fI\u0011!V\u0005\u0005\u0003\u0007\n\u0019CA\u0002TKFDa!a\u0012\u0011\u0001\u0004q\u0015\u0001\u00028b[\u0016DC\u0001E<\u0002LE2aDTA'\u0003'\n\u0014bIA\u0001\u0003\u000f\ty%!\u00032\u0013\r\n9#!\u000b\u0002R\u00055\u0011'\u0002\u0012`)\u00065\u0012G\u0001\u0014{\u0003-1\u0017N\u001c3He>,\b\u000f\u00128\u0015\u00079\u000bI\u0006\u0003\u0004\u0002\\E\u0001\rAT\u0001\u0006OJ|W\u000f\u001d\u0015\u0005#]\fy&\r\u0004\u001f\u001d\u0006\u0005\u0014qM\u0019\nG\u0005\u0005\u0011qAA2\u0003\u0013\t\u0014bIA\u0014\u0003S\t)'!\u00042\u000b\tzF+!\f2\u0005\u0019R\u0018aE5t+N,'/T3nE\u0016\u0014xJZ$s_V\u0004HCBA7\u0003g\n)\bE\u0002`\u0003_J1!!\u001dU\u0005\u001d\u0011un\u001c7fC:DQ!\u001e\nA\u00029Ca!a\u001e\u0013\u0001\u0004q\u0015aB4s_V\u0004HI\u001c\u0015\u0005%]\fY(\r\u0004\u001f\u001d\u0006u\u00141Q\u0019\nG\u0005\u0005\u0011qAA@\u0003\u0013\t\u0014bIA\u0014\u0003S\t\t)!\u00042\u000b\tzF+!\f2\u0005\u0019R\u0018!\u00054j]\u0012<%o\\;qg\u001a{'/V:feR\u0019a,!#\t\r\u0005-5\u00031\u0001O\u0003\u0019)8/\u001a:E]\"\"1c^AHc\u0019qb*!%\u0002\u0018FJ1%!\u0001\u0002\b\u0005M\u0015\u0011B\u0019\nG\u0005\u001d\u0012\u0011FAK\u0003\u001b\tTAI0U\u0003[\t$A\n>\u0002%\u0015DXmY;uK\u000e+8\u000f^8n#V,'/\u001f\u000b\u0004=\u0006u\u0005BBAP)\u0001\u0007a*A\u0003rk\u0016\u0014\u0018\u0010\u000b\u0003\u0015o\u0006\r\u0016G\u0002\u0010O\u0003K\u000bY+M\u0005$\u0003\u0003\t9!a*\u0002\nEJ1%a\n\u0002*\u0005%\u0016QB\u0019\u0006E}#\u0016QF\u0019\u0003Mi\fq!\u001a=fGV$X\r\u0006\u0004\u00022\u0006]\u00161\u0018\t\u0004]\u0005M\u0016bAA[/\t\u00192+Z1sG\"\u0014Vm];mi\"\u000bg\u000e\u001a7fe\"1\u0011\u0011X\u000bA\u0002y\u000bqAY1tK\u0012s7\u000fC\u0004\u0002 V\u0001\r!!0\u0011\u00079\ny,C\u0002\u0002B^\u0011Q!U;fef\u0004")
public class LdapSearch
implements DirSearch,
Logging {
    private final DirContext ctx;
    private final String baseDn;
    private final String[] groupBases;
    private final String[] userPatterns;
    private final String[] userBases;
    private final QueryFactory queries;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private final String baseDn() {
        return this.baseDn;
    }

    private final String[] groupBases() {
        return this.groupBases;
    }

    private final String[] userPatterns() {
        return this.userPatterns;
    }

    private final String[] userBases() {
        return this.userBases;
    }

    private final QueryFactory queries() {
        return this.queries;
    }

    @Override
    public void close() {
        try {
            this.ctx.close();
        }
        catch (NamingException e) {
            this.warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Exception when closing LDAP context:", e);
        }
    }

    @Override
    public String findUserDn(String user) throws NamingException {
        ObjectRef<Object> allLdapNames = ObjectRef.create(null);
        if (LdapUtils$.MODULE$.isDn(user)) {
            String userBaseDn = LdapUtils$.MODULE$.extractBaseDn(user);
            String userRdn = LdapUtils$.MODULE$.extractFirstRdn(user);
            allLdapNames.elem = this.execute((String[])((Object[])new String[]{userBaseDn}), this.queries().findUserDnByRdn(userRdn)).getAllLdapNames();
        } else {
            allLdapNames.elem = this.findDnByPattern(Predef$.MODULE$.wrapRefArray((Object[])this.userPatterns()), user);
            if (new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])((String[])allLdapNames.elem))).isEmpty()) {
                allLdapNames.elem = this.execute(this.userBases(), this.queries().findUserDnByName(user)).getAllLdapNames();
            }
        }
        if (((String[])allLdapNames.elem).length == 1) {
            return (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])((String[])allLdapNames.elem))).head();
        }
        this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Expected exactly one user result for the user: ").append(user).append(", ").append("but got ").append(((String[])allLdapNames$1.elem).length).append(". Returning null").toString());
        this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Matched users: $allLdapNames");
        return null;
    }

    private String[] findDnByPattern(Seq<String> patterns, String name) throws NamingException {
        String[] stringArray;
        Object object = new Object();
        try {
            patterns.foreach((Function1<String, Object> & Serializable & scala.Serializable)pattern -> {
                LdapSearch.$anonfun$findDnByPattern$1(this, name, object, pattern);
                return BoxedUnit.UNIT;
            });
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                stringArray = (String[])ex.value();
            }
            throw ex;
        }
        return stringArray;
    }

    @Override
    public String findGroupDn(String group) throws NamingException {
        return this.execute(this.groupBases(), this.queries().findGroupDnById(group)).getSingleLdapName();
    }

    @Override
    public boolean isUserMemberOfGroup(String user, String groupDn) throws NamingException {
        String userId = LdapUtils$.MODULE$.extractUserName(user);
        return this.execute(this.userBases(), this.queries().isUserMemberOfGroup(userId, groupDn)).hasSingleResult();
    }

    @Override
    public String[] findGroupsForUser(String userDn) throws NamingException {
        String userName = LdapUtils$.MODULE$.extractUserName(userDn);
        return this.execute(this.groupBases(), this.queries().findGroupsForUser(userName, userDn)).getAllLdapNames();
    }

    @Override
    public String[] executeCustomQuery(String query) throws NamingException {
        return this.execute((String[])((Object[])new String[]{this.baseDn()}), this.queries().customQuery(query)).getAllLdapNamesAndAttributes();
    }

    private SearchResultHandler execute(String[] baseDns, Query query) {
        ArrayBuffer searchResults = new ArrayBuffer();
        this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Executing a query: '").append(query.filter()).append("' with base DNs ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])baseDns)).mkString(",")).toString());
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])baseDns)).foreach((Function1<String, Object> & Serializable & scala.Serializable)baseDn -> {
            Object object;
            block3: {
                try {
                    NamingEnumeration<SearchResult> searchResult = $this.ctx.search((String)baseDn, query.filter(), query.controls());
                    if (searchResult != null) {
                        object = searchResults.$plus$eq(searchResult);
                        break block3;
                    }
                    object = BoxedUnit.UNIT;
                }
                catch (NamingException ex) {
                    this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Exception happened for query '").append(query.filter()).append("' with base DN '").append((String)baseDn).append("'").toString(), ex);
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
        return new SearchResultHandler((NamingEnumeration[])searchResults.toArray(ClassTag$.MODULE$.apply(NamingEnumeration.class)));
    }

    public static final /* synthetic */ void $anonfun$findDnByPattern$1(LdapSearch $this, String name$1, Object nonLocalReturnKey1$1, String pattern) {
        String baseDnFromPattern = LdapUtils$.MODULE$.extractBaseDn(pattern);
        String rdn = LdapUtils$.MODULE$.extractFirstRdn(pattern).replaceAll("%s", name$1);
        String[] names = $this.execute((String[])((Object[])new String[]{baseDnFromPattern}), $this.queries().findDnByPattern(rdn)).getAllLdapNames();
        if (!new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])names)).isEmpty()) {
            throw new NonLocalReturnControl<String[]>(nonLocalReturnKey1$1, names);
        }
    }

    public LdapSearch(KyuubiConf conf, DirContext ctx) {
        this.ctx = ctx;
        Logging.$init$(this);
        this.baseDn = (String)((Option)((Object)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_BASE_DN()))).orNull(Predef$.MODULE$.$conforms());
        this.groupBases = LdapUtils$.MODULE$.patternsToBaseDns(LdapUtils$.MODULE$.parseDnPatterns(conf, KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_GROUP_DN_PATTERN()));
        this.userPatterns = LdapUtils$.MODULE$.parseDnPatterns(conf, KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_USER_DN_PATTERN());
        this.userBases = LdapUtils$.MODULE$.patternsToBaseDns(this.userPatterns());
        this.queries = new QueryFactory(conf);
    }
}

