/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kyuubi;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.operation.Operation;
import org.apache.spark.kyuubi.SparkJobInfo;
import org.apache.spark.kyuubi.SparkStageAttempt;
import org.apache.spark.kyuubi.SparkStageInfo;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001\u0002\u000f\u001e\u0001\u0019B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!1\u0006A!A!\u0002\u00139\u0006\"\u00022\u0001\t\u0003\u0019\u0007b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007_\u0002\u0001\u000b\u0011\u00027\t\u000fA\u0004!\u0019!C\u0005c\"1!\u000f\u0001Q\u0001\nMCqa\u001d\u0001C\u0002\u0013%A\u000f\u0003\u0004v\u0001\u0001\u0006Ia\u0011\u0005\bm\u0002\u0001\r\u0011\"\u0003r\u0011\u001d9\b\u00011A\u0005\naDaA \u0001!B\u0013\u0019\u0006\u0002C@\u0001\u0001\u0004%I!!\u0001\t\u0013\u00055\u0001\u00011A\u0005\n\u0005=\u0001\u0002CA\n\u0001\u0001\u0006K!a\u0001\t\u0013\u0005U\u0001A1A\u0005\u0002\u0005]\u0001\u0002CA\u0015\u0001\u0001\u0006I!!\u0007\t\u0013\u0005-\u0002A1A\u0005\n\u00055\u0002\u0002CA\u001c\u0001\u0001\u0006I!a\f\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<!9\u0011Q\b\u0001\u0005\n\u0005}\u0002bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003S\u0002A\u0011BA\u001e\u0011\u001d\tY\u0007\u0001C\u0001\u0003w\u0011qc\u00159be.\u001cuN\\:pY\u0016\u0004&o\\4sKN\u001c()\u0019:\u000b\u0005yy\u0012AB6zkV\u0014\u0017N\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011a\u0006M\u0007\u0002_)\u0011a$I\u0005\u0003c=\u0012q\u0001T8hO&tw-A\u0005pa\u0016\u0014\u0018\r^5p]B\u0011AGN\u0007\u0002k)\u0011!gL\u0005\u0003oU\u0012\u0011b\u00149fe\u0006$\u0018n\u001c8\u0002\u00111Lg/\u001a&pEN\u0004BAO!D\r6\t1H\u0003\u0002={\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005yz\u0014\u0001B;uS2T\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002Cw\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005!\"\u0015BA#*\u0005\rIe\u000e\u001e\t\u0003\u000f\"k\u0011!H\u0005\u0003\u0013v\u0011Ab\u00159be.TuNY%oM>\f!\u0002\\5wKN#\u0018mZ3t!\u0011Q\u0014\tT(\u0011\u0005\u001dk\u0015B\u0001(\u001e\u0005E\u0019\u0006/\u0019:l'R\fw-Z!ui\u0016l\u0007\u000f\u001e\t\u0003\u000fBK!!U\u000f\u0003\u001dM\u0003\u0018M]6Ti\u0006<W-\u00138g_\u0006\u0001R\u000f\u001d3bi\u0016\u0004VM]5pI6\u001bVm\u0019\t\u0003QQK!!V\u0015\u0003\t1{gnZ\u0001\u000bi&lWMR8s[\u0006$\bC\u0001-`\u001d\tIV\f\u0005\u0002[S5\t1L\u0003\u0002]K\u00051AH]8pizJ!AX\u0015\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0017M\u0001\u0004TiJLgn\u001a\u0006\u0003=&\na\u0001P5oSRtDC\u00023fM\u001eD\u0017\u000e\u0005\u0002H\u0001!)!G\u0002a\u0001g!)\u0001H\u0002a\u0001s!)!J\u0002a\u0001\u0017\")!K\u0002a\u0001'\")aK\u0002a\u0001/\u0006\u00111IU\u000b\u0002YB\u0011\u0001&\\\u0005\u0003]&\u0012Aa\u00115be\u0006\u00191I\u0015\u0011\u0002\u001d\u0019L'o\u001d;EK2\f\u00170T*fGV\t1+A\bgSJ\u001cH\u000fR3mCfl5+Z2!\u00035!VM]7j]\u0006dw+\u001b3uQV\t1)\u0001\bUKJl\u0017N\\1m/&$G\u000f\u001b\u0011\u0002\u001d1\f7\u000f^+qI\u0006$X\rV5nK\u0006\u0011B.Y:u+B$\u0017\r^3US6,w\fJ3r)\tIH\u0010\u0005\u0002)u&\u001110\u000b\u0002\u0005+:LG\u000fC\u0004~\u001d\u0005\u0005\t\u0019A*\u0002\u0007a$\u0013'A\bmCN$X\u000b\u001d3bi\u0016$\u0016.\\3!\u0003=a\u0017m\u001d;Qe><'/Z:t\u0005\u0006\u0014XCAA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\u007f\u0005!A.\u00198h\u0013\r\u0001\u0017qA\u0001\u0014Y\u0006\u001cH\u000f\u0015:pOJ,7o\u001d\"be~#S-\u001d\u000b\u0004s\u0006E\u0001\u0002C?\u0012\u0003\u0003\u0005\r!a\u0001\u0002!1\f7\u000f\u001e)s_\u001e\u0014Xm]:CCJ\u0004\u0013a\u00033u\r>\u0014X.\u0019;uKJ,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u00051am\u001c:nCRT1!a\t@\u0003\u0011!\u0018.\\3\n\t\u0005\u001d\u0012Q\u0004\u0002\u0012\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\u0018\u0001\u00043u\r>\u0014X.\u0019;uKJ\u0004\u0013!\u0002;j[\u0016\u0014XCAA\u0018!\u0011\t\t$a\r\u000e\u0003uJ1!!\u000e>\u0005\u0015!\u0016.\\3s\u0003\u0019!\u0018.\\3sA\u00059!/\u001a4sKNDG#A=\u0002\u0013\u0019Lg\u000e\u001a&pE&#G\u0003BA!\u0003\u000f\u0002B\u0001KA\"\u0007&\u0019\u0011QI\u0015\u0003\r=\u0003H/[8o\u0011\u0019\tI\u0005\u0007a\u0001\u0007\u000691\u000f^1hK&#\u0017\u0001B:i_^$R!_A(\u0003'Ba!!\u0015\u001a\u0001\u0004\u0019\u0016a\u00018po\"9\u0011QK\rA\u0002\u0005]\u0013AB:uC\u001e,7\u000fE\u0003\u0002Z\u0005\rtJ\u0004\u0003\u0002\\\u0005}cb\u0001.\u0002^%\t!&C\u0002\u0002b%\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002f\u0005\u001d$aA*fc*\u0019\u0011\u0011M\u0015\u0002\u000b\rdW-\u0019:\u0002\r\u0019Lg.[:i\u0001")
public class SparkConsoleProgressBar
implements Logging {
    private final Operation operation;
    private final ConcurrentHashMap<Object, SparkJobInfo> liveJobs;
    private final ConcurrentHashMap<SparkStageAttempt, SparkStageInfo> liveStages;
    private final char CR;
    private final long firstDelayMSec;
    private final int TerminalWidth;
    private long lastUpdateTime;
    private String lastProgressBar;
    private final DateTimeFormatter dtFormatter;
    private final Timer timer;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private char CR() {
        return this.CR;
    }

    private long firstDelayMSec() {
        return this.firstDelayMSec;
    }

    private int TerminalWidth() {
        return this.TerminalWidth;
    }

    private long lastUpdateTime() {
        return this.lastUpdateTime;
    }

    private void lastUpdateTime_$eq(long x$1) {
        this.lastUpdateTime = x$1;
    }

    private String lastProgressBar() {
        return this.lastProgressBar;
    }

    private void lastProgressBar_$eq(String x$1) {
        this.lastProgressBar = x$1;
    }

    public DateTimeFormatter dtFormatter() {
        return this.dtFormatter;
    }

    private Timer timer() {
        return this.timer;
    }

    public void org$apache$spark$kyuubi$SparkConsoleProgressBar$$refresh() {
        block0: {
            long now = System.currentTimeMillis();
            List stages = (List)((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.liveStages.values()).asScala()).toList().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.stageId()), (Ordering)Ordering.Int$.MODULE$);
            if (!stages.nonEmpty()) break block0;
            this.show(now, (Seq<SparkStageInfo>)stages.take(3));
        }
    }

    private Option<Object> findJobId(int stageId) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.liveJobs).asScala()).collectFirst((PartialFunction)new Serializable(null, stageId){
            private static final long serialVersionUID = 0L;
            private final int stageId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, SparkJobInfo>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int jobId = A1._1$mcI$sp();
                    SparkJobInfo jobInfo = (SparkJobInfo)A1._2();
                    if (jobInfo.stageIds().contains((Object)BoxesRunTime.boxToInteger((int)this.stageId$1))) {
                        object = BoxesRunTime.boxToInteger((int)jobId);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, SparkJobInfo> x1) {
                SparkJobInfo jobInfo;
                Tuple2<Object, SparkJobInfo> tuple2 = x1;
                boolean bl = tuple2 != null && (jobInfo = (SparkJobInfo)tuple2._2()).stageIds().contains((Object)BoxesRunTime.boxToInteger((int)this.stageId$1));
                return bl;
            }
            {
                this.stageId$1 = stageId$1;
            }
        });
    }

    private void show(long now, Seq<SparkStageInfo> stages) {
        String bar;
        int width = this.TerminalWidth() / stages.size();
        String string = bar = ((IterableOnceOps)stages.map((Function1 & Serializable)s -> {
            String string;
            int total = s.numTasks();
            String jobHeader = (String)this.findJobId(s.stageId()).map((Function1 & Serializable)jobId -> SparkConsoleProgressBar.$anonfun$show$2(this, BoxesRunTime.unboxToInt((Object)jobId))).getOrElse((Function0 & Serializable)() -> "[There is no job about this stage] ");
            String header = new StringBuilder(0).append(jobHeader).append(new StringBuilder(8).append("[Stage ").append(s.stageId()).append(":").toString()).toString();
            String tailer = new StringBuilder(9).append("(").append(s.numCompleteTasks()).append(" + ").append(s.numActiveTasks()).append(") / ").append(total).append("]").toString();
            int w = width + jobHeader.length() - header.length() - tailer.length();
            if (w > 0) {
                int percent = w * s.numCompleteTasks().get() / total;
                string = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), w).map((Function1 & Serializable)i -> SparkConsoleProgressBar.$anonfun$show$4(percent, BoxesRunTime.unboxToInt((Object)i))).mkString("");
            } else {
                string = "";
            }
            String bar = string;
            return new StringBuilder(0).append(header).append(bar).append(tailer).toString();
        })).mkString("");
        String string2 = this.lastProgressBar();
        if ((string != null ? !string.equals(string2) : string2 != null) || now - this.lastUpdateTime() > 60000L) {
            this.operation.getOperationLog().foreach((Function1 & Serializable)log -> {
                log.write(new StringBuilder(11).append(this.dtFormatter().format(Instant.ofEpochMilli(now))).append(' ').append(bar).append(this.CR()).toString());
                return BoxedUnit.UNIT;
            });
            this.lastUpdateTime_$eq(now);
        }
        this.lastProgressBar_$eq(bar);
    }

    private void clear() {
        block0: {
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.lastProgressBar()))) break block0;
            this.operation.getOperationLog().foreach((Function1 & Serializable)log -> {
                log.write(new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), this.TerminalWidth())).append(this.CR()).toString());
                return BoxedUnit.UNIT;
            });
            this.lastProgressBar_$eq("");
        }
    }

    public synchronized void finish() {
        this.clear();
        this.timer().cancel();
    }

    public static final /* synthetic */ String $anonfun$show$2(SparkConsoleProgressBar $this, int jobId) {
        return new StringBuilder(0).append(new StringBuilder(8).append("[Job ").append(jobId).append(" (").append($this.liveJobs.get(BoxesRunTime.boxToInteger((int)jobId)).numCompleteStages()).append(" ").toString()).append(new StringBuilder(12).append("/ ").append($this.liveJobs.get(BoxesRunTime.boxToInteger((int)jobId)).numStages()).append(") Stages] ").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$show$4(int percent$1, int i) {
        return i < percent$1 ? "=" : (i == percent$1 ? ">" : " ");
    }

    public SparkConsoleProgressBar(Operation operation, ConcurrentHashMap<Object, SparkJobInfo> liveJobs, ConcurrentHashMap<SparkStageAttempt, SparkStageInfo> liveStages, long updatePeriodMSec, String timeFormat) {
        this.operation = operation;
        this.liveJobs = liveJobs;
        this.liveStages = liveStages;
        Logging.$init$(this);
        this.CR = (char)13;
        this.firstDelayMSec = 500L;
        this.TerminalWidth = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"COLUMNS", (Function0 & Serializable)() -> "80")));
        this.lastUpdateTime = 0L;
        this.lastProgressBar = "";
        this.dtFormatter = DateTimeFormatter.ofPattern(timeFormat).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        this.timer = new Timer(new StringBuilder(21).append("refresh progress for ").append(operation.getHandle().identifier().toString()).toString(), true);
        this.timer().schedule(new TimerTask(this){
            private final /* synthetic */ SparkConsoleProgressBar $outer;

            public void run() {
                this.$outer.org$apache$spark$kyuubi$SparkConsoleProgressBar$$refresh();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.firstDelayMSec(), updatePeriodMSec);
    }
}

