/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark;

import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.engine.spark.SparkSQLEngine$;
import org.apache.kyuubi.util.SemanticVersion;
import org.apache.kyuubi.util.SemanticVersion$;
import org.apache.kyuubi.util.reflect.DynMethods;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.package$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class KyuubiSparkUtil$
implements Logging {
    public static final KyuubiSparkUtil$ MODULE$ = new KyuubiSparkUtil$();
    private static String diagnostics;
    private static SemanticVersion SPARK_ENGINE_RUNTIME_VERSION;
    private static transient Logger org$apache$kyuubi$Logging$$log_;
    private static volatile byte bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public final String SPARK_SCHEDULER_POOL_KEY() {
        return "spark.scheduler.pool";
    }

    public final String SPARK_SQL_EXECUTION_ID_KEY() {
        return "spark.sql.execution.id";
    }

    public SparkContext globalSparkContext() {
        return SparkSession$.MODULE$.active().sparkContext();
    }

    public void initializeSparkSession(SparkSession spark, Seq<String> initializationSQLs) {
        initializationSQLs.foreach((Function1 & Serializable)sql -> BoxesRunTime.boxToBoolean((boolean)KyuubiSparkUtil$.$anonfun$initializeSparkSession$1(spark, sql)));
    }

    public String engineId() {
        return this.globalSparkContext().applicationId();
    }

    public String engineName() {
        return this.globalSparkContext().appName();
    }

    public String engineUrl() {
        SparkConf sparkConf = this.globalSparkContext().getConf();
        return (String)sparkConf.getOption("spark.org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter.param.PROXY_URI_BASES").orElse((Function0 & Serializable)() -> sparkConf.getOption("spark.org.apache.spark.deploy.yarn.AmIpFilter.param.PROXY_URI_BASES")).orElse((Function0 & Serializable)() -> MODULE$.globalSparkContext().uiWebUrl()).getOrElse((Function0 & Serializable)() -> "");
    }

    public String deployMode() {
        return this.globalSparkContext().getConf().getBoolean("spark.kubernetes.submitInDriver", false) ? "cluster" : this.globalSparkContext().deployMode();
    }

    private String diagnostics$lzycompute() {
        KyuubiSparkUtil$ kyuubiSparkUtil$ = this;
        synchronized (kyuubiSparkUtil$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                SparkContext sc = this.globalSparkContext();
                diagnostics = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(298).append("\n       |           Spark application name: ").append(this.engineName()).append("\n       |                 application ID: ").append(this.engineId()).append("\n       |                 application web UI: ").append(this.engineUrl()).append("\n       |                 master: ").append(sc.master()).append("\n       |                 deploy mode: ").append(this.deployMode()).append("\n       |                 version: ").append(sc.version()).append("\n       |           Start time: ").append(LocalDateTime.ofInstant(Instant.ofEpochMilli(sc.startTime()), ZoneId.systemDefault())).append("\n       |           User: ").append(sc.sparkUser()).toString()));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return diagnostics;
    }

    public String diagnostics() {
        return (byte)(bitmap$0 & 1) == 0 ? this.diagnostics$lzycompute() : diagnostics;
    }

    public boolean hiveClassesArePresent() {
        boolean bl;
        try {
            Class.forName("org.apache.spark.sql.hive.HiveSessionStateBuilder");
            Class.forName("org.apache.hadoop.hive.conf.HiveConf");
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl2 = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
            if (!bl2) {
                throw throwable;
            }
            boolean bl3 = false;
            bl = bl3;
        }
        return bl;
    }

    private SemanticVersion SPARK_ENGINE_RUNTIME_VERSION$lzycompute() {
        KyuubiSparkUtil$ kyuubiSparkUtil$ = this;
        synchronized (kyuubiSparkUtil$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                SPARK_ENGINE_RUNTIME_VERSION = SemanticVersion$.MODULE$.apply(package$.MODULE$.SPARK_VERSION());
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return SPARK_ENGINE_RUNTIME_VERSION;
    }

    public SemanticVersion SPARK_ENGINE_RUNTIME_VERSION() {
        return (byte)(bitmap$0 & 2) == 0 ? this.SPARK_ENGINE_RUNTIME_VERSION$lzycompute() : SPARK_ENGINE_RUNTIME_VERSION;
    }

    public <T> T getSessionConf(ConfigEntry<T> configEntry, SparkSession spark) {
        return (T)spark.conf().getOption(configEntry.key()).map(configEntry.valueConverter()).getOrElse((Function0 & Serializable)() -> SparkSQLEngine$.MODULE$.kyuubiConf().get(configEntry));
    }

    public URI buildURI(URI uri, String fragment) {
        URI uRI;
        if (this.SPARK_ENGINE_RUNTIME_VERSION().$greater$eq("4.0")) {
            Object uriBuilder = DynMethods.builder("fromUri").impl("jakarta.ws.rs.core.UriBuilder", URI.class).buildStatic().invoke(uri);
            uriBuilder = DynMethods.builder("fragment").impl("jakarta.ws.rs.core.UriBuilder", String.class).build(uriBuilder).invoke(fragment);
            uRI = (URI)DynMethods.builder("build").impl("jakarta.ws.rs.core.UriBuilder", Object[].class).build(uriBuilder).invoke(Array$.MODULE$.empty(ClassTag$.MODULE$.AnyRef()));
        } else {
            Object uriBuilder = DynMethods.builder("fromUri").impl("javax.ws.rs.core.UriBuilder", URI.class).buildStatic().invoke(uri);
            uriBuilder = DynMethods.builder("fragment").impl("javax.ws.rs.core.UriBuilder", String.class).build(uriBuilder).invoke(fragment);
            uRI = (URI)DynMethods.builder("build").impl("javax.ws.rs.core.UriBuilder", Object[].class).build(uriBuilder).invoke(Array$.MODULE$.empty(ClassTag$.MODULE$.AnyRef()));
        }
        return uRI;
    }

    public static final /* synthetic */ boolean $anonfun$initializeSparkSession$1(SparkSession spark$1, String sql) {
        boolean bl;
        spark$1.sparkContext().setJobGroup("initialization sql queries", sql, true);
        MODULE$.debug((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(28).append("Execute initialization sql: ").append(sql).toString());
        try {
            bl = spark$1.sql(sql).isEmpty();
        }
        finally {
            spark$1.sparkContext().clearJobGroup();
        }
        return bl;
    }

    private KyuubiSparkUtil$() {
    }
}

