/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.client.util.BatchUtils;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.credentials.HadoopCredentialsManager;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.KyuubiOperationManager;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.apache.kyuubi.plugin.PluginLoader$;
import org.apache.kyuubi.plugin.SessionConfAdvisor;
import org.apache.kyuubi.server.metadata.MetadataManager;
import org.apache.kyuubi.server.metadata.MetadataRequestsRetryRef;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionLimiter;
import org.apache.kyuubi.session.SessionLimiter$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.UserIpAddress;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.util.SignUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r-f\u0001B\u001f?\u0001\u001dC\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u00065\u0002!Ia\u0017\u0005\u00065\u0002!\tA\u0018\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u0011\u0019Q\u0007\u0001)A\u0005C\"91\u000e\u0001b\u0001\n\u0003a\u0007BB:\u0001A\u0003%Q\u000eC\u0004u\u0001\t\u0007I\u0011A;\t\rq\u0004\u0001\u0015!\u0003w\u0011\u001di\bA1A\u0005\u0002yDq!a\u0003\u0001A\u0003%q\u0010\u0003\u0006\u0002\u000e\u0001A)\u0019!C\u0001\u0003\u001fA!\"a\n\u0001\u0011\u000b\u0007I\u0011AA\u0015\u0011)\tI\u0005\u0001EC\u0002\u0013\u0005\u00111\n\u0005\n\u0003'\u0002\u0001\u0019!C\u0005\u0003+B\u0011\"a\u0018\u0001\u0001\u0004%I!!\u0019\t\u0011\u00055\u0004\u0001)Q\u0005\u0003/B\u0011\"a\u001c\u0001\u0001\u0004%I!!\u0016\t\u0013\u0005E\u0004\u00011A\u0005\n\u0005M\u0004\u0002CA<\u0001\u0001\u0006K!a\u0016\t\u0019\u0005-\u0004\u0001%A\t\b\u0004&I!!\u001f\t\u0015\u0005]\u0005\u0001#b\u0001\n\u0003\tI\n\u0003\u0006\u0002\u001c\u0002A)\u0019!C\u0001\u0003;C\u0011\"a(\u0001\u0001\u0004%\t!!)\t\u0013\u0005U\u0006\u00011A\u0005\u0002\u0005]\u0006\u0002CA^\u0001\u0001\u0006K!a)\t\u0013\u0005u\u0006A1A\u0005\n\u0005}\u0006\u0002CAd\u0001\u0001\u0006I!!1\t\u000f\u0005%\u0007\u0001\"\u0011\u0002L\"9\u0011Q\u001c\u0001\u0005R\u0005}\u0007b\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005_\u0001A\u0011\tB\u0019\u0011\u001d\u00119\u0004\u0001C\u0001\u0005sA\u0011Ba\u001f\u0001#\u0003%\tA! \t\u0011\tM\u0005\u0001\"\u0001A\u0005+CqAa%\u0001\t\u0003\u0011Y\nC\u0004\u0003>\u0002!\tAa0\t\u000f\t%\u0007\u0001\"\u0001\u0003L\"9!\u0011\u001b\u0001\u0005\u0002\tM\u0007b\u0002Bl\u0001\u0011\u0005!\u0011\u001c\u0005\b\u0005;\u0004A\u0011\u0001Bp\u0011\u001d\u0011i\u000f\u0001C\u0001\u0005_DqAa=\u0001\t\u0003\u0011)\u0010C\u0004\u0004\u0004\u0001!\ta!\u0002\t\u000f\r\u0005\u0002\u0001\"\u0001\u0004$!91q\u0005\u0001\u0005\u0002\r%\u0002bBB$\u0001\u0011\u00053\u0011\n\u0005\b\u0007\u0017\u0002A\u0011AB'\u0011\u001d\u0019)\u0006\u0001C\u0001\u0007/Bqa!\u0018\u0001\t#\u001ay\u0006C\u0004\u0004b\u0001!Iaa\u0019\t\u0011\r\u001d\u0004\u0001\"\u0001A\u0007SB\u0001b!\u001d\u0001\t\u0003\u000151\u000f\u0005\t\u0007o\u0002A\u0011\u0001!\u0004j!A1\u0011\u0010\u0001\u0005\u0002\u0001\u001bY\b\u0003\u0005\u0004\u0000\u0001!\t\u0001QB5\u0011!\u0019\t\t\u0001C\u0001\u0001\u000e\r\u0005bBBD\u0001\u0011%1\u0011\u0012\u0005\b\u0007G\u0003A\u0011BB%\u0011\u001d\u0019)\u000b\u0001C\u0005\u0007O\u0013AcS=vk\nL7+Z:tS>tW*\u00198bO\u0016\u0014(BA A\u0003\u001d\u0019Xm]:j_:T!!\u0011\"\u0002\r-LX/\u001e2j\u0015\t\u0019E)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000b\u0006\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0013\t\u0003\u0013*k\u0011AP\u0005\u0003\u0017z\u0012abU3tg&|g.T1oC\u001e,'/\u0001\u0003oC6,\u0007C\u0001(X\u001d\tyU\u000b\u0005\u0002Q'6\t\u0011K\u0003\u0002S\r\u00061AH]8pizR\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-N\u000ba\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\u0019\u0019FO]5oO*\u0011akU\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005qk\u0006CA%\u0001\u0011\u0015a%\u00011\u0001N)\u0005a\u0016A\u00029beN,'/F\u0001b!\t\u0011\u0007.D\u0001d\u0015\t!W-\u0001\u0004tKJ4XM\u001d\u0006\u0003?\u001aT!a\u001a!\u0002\u0007M\fH.\u0003\u0002jG\na1*_;vE&\u0004\u0016M]:fe\u00069\u0001/\u0019:tKJ\u0004\u0013\u0001E8qKJ\fG/[8o\u001b\u0006t\u0017mZ3s+\u0005i\u0007C\u00018r\u001b\u0005y'B\u00019A\u0003%y\u0007/\u001a:bi&|g.\u0003\u0002s_\n12*_;vE&|\u0005/\u001a:bi&|g.T1oC\u001e,'/A\tpa\u0016\u0014\u0018\r^5p]6\u000bg.Y4fe\u0002\n!c\u0019:fI\u0016tG/[1mg6\u000bg.Y4feV\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002z\u0001\u0006Y1M]3eK:$\u0018.\u00197t\u0013\tY\bP\u0001\rIC\u0012|w\u000e]\"sK\u0012,g\u000e^5bYNl\u0015M\\1hKJ\f1c\u0019:fI\u0016tG/[1mg6\u000bg.Y4fe\u0002\n!#\u00199qY&\u001c\u0017\r^5p]6\u000bg.Y4feV\tq\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001Q\u0001\u0007K:<\u0017N\\3\n\t\u0005%\u00111\u0001\u0002\u0019\u0017f,XOY5BaBd\u0017nY1uS>tW*\u00198bO\u0016\u0014\u0018aE1qa2L7-\u0019;j_:l\u0015M\\1hKJ\u0004\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0016\u0005\u0005E\u0001CBA\n\u0003+\tI\"D\u0001T\u0013\r\t9b\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005m\u00111E\u0007\u0003\u0003;QA!a\b\u0002\"\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002e\u0001&!\u0011QEA\u000f\u0005=iU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018AE:fgNLwN\\\"p]\u001a\fEM^5t_J,\"!a\u000b\u0011\r\u00055\u0012qGA\u001f\u001d\u0011\ty#a\r\u000f\u0007A\u000b\t$C\u0001U\u0013\r\t)dU\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI$a\u000f\u0003\u0007M+\u0017OC\u0002\u00026M\u0003B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007\u0002\u0015A\u00029mk\u001eLg.\u0003\u0003\u0002H\u0005\u0005#AE*fgNLwN\\\"p]\u001a\fEM^5t_J\fQb\u001a:pkB\u0004&o\u001c<jI\u0016\u0014XCAA'!\u0011\ty$a\u0014\n\t\u0005E\u0013\u0011\t\u0002\u000e\u000fJ|W\u000f\u001d)s_ZLG-\u001a:\u0002\u000f1LW.\u001b;feV\u0011\u0011q\u000b\t\u0007\u0003'\t)\"!\u0017\u0011\u0007%\u000bY&C\u0002\u0002^y\u0012abU3tg&|g\u000eT5nSR,'/A\u0006mS6LG/\u001a:`I\u0015\fH\u0003BA2\u0003S\u0002B!a\u0005\u0002f%\u0019\u0011qM*\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003W\u0002\u0012\u0011!a\u0001\u0003/\n1\u0001\u001f\u00132\u0003!a\u0017.\\5uKJ\u0004\u0013\u0001\u00042bi\u000eDG*[7ji\u0016\u0014\u0018\u0001\u00052bi\u000eDG*[7ji\u0016\u0014x\fJ3r)\u0011\t\u0019'!\u001e\t\u0013\u0005-4#!AA\u0002\u0005]\u0013!\u00042bi\u000eDG*[7ji\u0016\u0014\b%\u0006\u0002\u0002|AA\u00111CA?\u0003\u0003\u000b\t*C\u0002\u0002\u0000M\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BAB\u0003\u001bk!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\tg\u0016\u001cWO]5us*\u0011\u00111R\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0010\u0006\u0015%A\u0003)sSZ\fG/Z&fsB!\u00111QAJ\u0013\u0011\t)*!\"\u0003\u0013A+(\r\\5d\u0017\u0016L\u0018!E:jO:Lgn\u001a)sSZ\fG/Z&fsV\u0011\u0011\u0011Q\u0001\u0011g&<g.\u001b8h!V\u0014G.[2LKf,\"!!%\u0002;\u0015tw-\u001b8f'R\f'\u000f^;q!J|7-Z:t'\u0016l\u0017\r\u001d5pe\u0016,\"!a)\u0011\r\u0005M\u0011QCAS!\u0011\t9+!-\u000e\u0005\u0005%&\u0002BAV\u0003[\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0011\ty+!#\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003g\u000bIKA\u0005TK6\f\u0007\u000f[8sK\u0006\tSM\\4j]\u0016\u001cF/\u0019:ukB\u0004&o\\2fgN\u001cV-\\1qQ>\u0014Xm\u0018\u0013fcR!\u00111MA]\u0011%\tY'GA\u0001\u0002\u0004\t\u0019+\u0001\u0010f]\u001eLg.Z*uCJ$X\u000f\u001d)s_\u000e,7o]*f[\u0006\u0004\bn\u001c:fA\u0005aRM\\4j]\u0016\u001cuN\u001c8fGRLwN\\!mSZ,7\t[3dW\u0016\u0014XCAAa!\u0011\t9+a1\n\t\u0005\u0015\u0017\u0011\u0016\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!H3oO&tWmQ8o]\u0016\u001cG/[8o\u00032Lg/Z\"iK\u000e\\WM\u001d\u0011\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0003\u0002d\u00055\u0007bBAh;\u0001\u0007\u0011\u0011[\u0001\u0005G>tg\r\u0005\u0003\u0002T\u0006eWBAAk\u0015\r\t9\u000eQ\u0001\u0007G>tg-[4\n\t\u0005m\u0017Q\u001b\u0002\u000b\u0017f,XOY5D_:4\u0017!D2sK\u0006$XmU3tg&|g\u000e\u0006\u0007\u0002b\u0006\u001d(q\u0001B\u0006\u0005\u001f\u0011\u0019\u0002E\u0002J\u0003GL1!!:?\u0005\u001d\u0019Vm]:j_:Dq!!;\u001f\u0001\u0004\tY/\u0001\u0005qe>$xnY8m!\u0011\tiOa\u0001\u000e\u0005\u0005=(\u0002BAy\u0003g\fa\u0001\u001e5sS\u001a$(\u0002BA{\u0003o\f1A\u001d9d\u0015\u0011\tI0a?\u0002\u000fM,'O^5dK*!\u0011Q`A\u0000\u0003\u0011A\u0017N^3\u000b\u0007\t\u0005\u0001)\u0001\u0004tQ\u0006$W\rZ\u0005\u0005\u0005\u000b\tyO\u0001\tU!J|Go\\2pYZ+'o]5p]\"1!\u0011\u0002\u0010A\u00025\u000bA!^:fe\"1!Q\u0002\u0010A\u00025\u000b\u0001\u0002]1tg^|'\u000f\u001a\u0005\u0007\u0005#q\u0002\u0019A'\u0002\u0013%\u0004\u0018\t\u001a3sKN\u001c\bbBAh=\u0001\u0007!Q\u0003\t\u0006\u001d\n]Q*T\u0005\u0004\u00053I&aA'ba\u0006Yq\u000e]3o'\u0016\u001c8/[8o)1\u0011yB!\n\u0003(\t%\"1\u0006B\u0017!\rI%\u0011E\u0005\u0004\u0005Gq$!D*fgNLwN\u001c%b]\u0012dW\rC\u0004\u0002j~\u0001\r!a;\t\r\t%q\u00041\u0001N\u0011\u0019\u0011ia\ba\u0001\u001b\"1!\u0011C\u0010A\u00025Cq!a4 \u0001\u0004\u0011)\"\u0001\u0007dY>\u001cXmU3tg&|g\u000e\u0006\u0003\u0002d\tM\u0002b\u0002B\u001bA\u0001\u0007!qD\u0001\u000eg\u0016\u001c8/[8o\u0011\u0006tG\r\\3\u0002%\r\u0014X-\u0019;f\u0005\u0006$8\r[*fgNLwN\u001c\u000b\u0019\u0005w\u0011\tEa\u0011\u0003F\t\u001d#\u0011\nB'\u0005'\u00129Fa\u0017\u0003b\tE\u0004cA%\u0003>%\u0019!q\b \u0003%-KX/\u001e2j\u0005\u0006$8\r[*fgNLwN\u001c\u0005\u0007\u0005\u0013\t\u0003\u0019A'\t\r\t5\u0011\u00051\u0001N\u0011\u0019\u0011\t\"\ta\u0001\u001b\"9\u0011qZ\u0011A\u0002\tU\u0001B\u0002B&C\u0001\u0007Q*A\u0005cCR\u001c\u0007\u000eV=qK\"9!qJ\u0011A\u0002\tE\u0013!\u00032bi\u000eDg*Y7f!\u0015\t\u0019\"!\u0006N\u0011\u0019\u0011)&\ta\u0001\u001b\u0006A!/Z:pkJ\u001cW\r\u0003\u0004\u0003Z\u0005\u0002\r!T\u0001\nG2\f7o\u001d(b[\u0016DqA!\u0018\"\u0001\u0004\u0011y&A\u0005cCR\u001c\u0007.\u0011:hgB)\u0011QFA\u001c\u001b\"I\u0011qD\u0011\u0011\u0002\u0003\u0007!1\r\t\u0007\u0003'\t)B!\u001a\u0011\t\t\u001d$QN\u0007\u0003\u0005SRAAa\u001b\u0002\u001e\u0005\u0019\u0011\r]5\n\t\t=$\u0011\u000e\u0002\t\u001b\u0016$\u0018\rZ1uC\"9!1O\u0011A\u0002\tU\u0014\u0001\u00044s_6\u0014VmY8wKJL\b\u0003BA\n\u0005oJ1A!\u001fT\u0005\u001d\u0011un\u001c7fC:\fQd\u0019:fCR,')\u0019;dQN+7o]5p]\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005\u007fRCAa\u0019\u0003\u0002.\u0012!1\u0011\t\u0005\u0005\u000b\u0013y)\u0004\u0002\u0003\b*!!\u0011\u0012BF\u0003%)hn\u00195fG.,GMC\u0002\u0003\u000eN\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tJa\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\tpa\u0016t')\u0019;dQN+7o]5p]R!!q\u0004BL\u0011\u001d\u0011Ij\ta\u0001\u0005w\tABY1uG\"\u001cVm]:j_:$\"Ba\b\u0003\u001e\n}%\u0011\u0015BR\u0011\u0019\u0011I\u0001\na\u0001\u001b\"1!Q\u0002\u0013A\u00025CaA!\u0005%\u0001\u0004i\u0005b\u0002BSI\u0001\u0007!qU\u0001\rE\u0006$8\r\u001b*fcV,7\u000f\u001e\t\u0005\u0005S\u0013I,\u0004\u0002\u0003,*!!Q\u0016BX\u0003\r!Go\u001c\u0006\u0005\u0005c\u0013\u0019,\u0001\u0002wc)!!1\u000eB[\u0015\r\u00119\fQ\u0001\u0007G2LWM\u001c;\n\t\tm&1\u0016\u0002\r\u0005\u0006$8\r\u001b*fcV,7\u000f^\u0001\u0015S:LG/[1mSj,')\u0019;dQN#\u0018\r^3\u0015\u00135\u0013\tMa1\u0003F\n\u001d\u0007B\u0002B\u0005K\u0001\u0007Q\n\u0003\u0004\u0003\u0012\u0015\u0002\r!\u0014\u0005\b\u0003\u001f,\u0003\u0019\u0001B\u000b\u0011\u001d\u0011)+\na\u0001\u0005O\u000bqbZ3u\u0005\u0006$8\r[*fgNLwN\u001c\u000b\u0005\u0005\u001b\u0014y\r\u0005\u0004\u0002\u0014\u0005U!1\b\u0005\b\u0005k1\u0003\u0019\u0001B\u0010\u00039Ign]3si6+G/\u00193bi\u0006$B!a\u0019\u0003V\"9\u0011qD\u0014A\u0002\t\u0015\u0014AD;qI\u0006$X-T3uC\u0012\fG/\u0019\u000b\u0005\u0003G\u0012Y\u000eC\u0004\u0002 !\u0002\rA!\u001a\u00027\u001d,G/T3uC\u0012\fG/\u0019*fcV,7\u000f^:SKR\u0014\u0018PU3g)\u0011\u0011\tO!;\u0011\r\u0005M\u0011Q\u0003Br!\u0011\tYB!:\n\t\t\u001d\u0018Q\u0004\u0002\u0019\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiN\u0014V\r\u001e:z%\u00164\u0007B\u0002BvS\u0001\u0007Q*\u0001\u0006jI\u0016tG/\u001b4jKJ\f!\u0005Z3SK\u001eL7\u000f^3s\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiN\u0014V\r\u001e:z%\u00164G\u0003BA2\u0005cDaAa;+\u0001\u0004i\u0015!G4fi\n\u000bGo\u00195Ge>lW*\u001a;bI\u0006$\u0018m\u0015;pe\u0016$BAa>\u0003\u0000B1\u00111CA\u000b\u0005s\u0004BA!+\u0003|&!!Q BV\u0005\u0015\u0011\u0015\r^2i\u0011\u0019\u0019\ta\u000ba\u0001\u001b\u00069!-\u0019;dQ&#\u0017aG4fi\n\u000bGo\u00195fg\u001a\u0013x.\\'fi\u0006$\u0017\r^1Ti>\u0014X\r\u0006\u0005\u0004\b\r%11CB\u000f!\u0019\ti#a\u000e\u0003z\"911\u0002\u0017A\u0002\r5\u0011A\u00024jYR,'\u000f\u0005\u0003\u0003h\r=\u0011\u0002BB\t\u0005S\u0012a\"T3uC\u0012\fG/\u0019$jYR,'\u000fC\u0004\u0004\u00161\u0002\raa\u0006\u0002\t\u0019\u0014x.\u001c\t\u0005\u0003'\u0019I\"C\u0002\u0004\u001cM\u00131!\u00138u\u0011\u001d\u0019y\u0002\fa\u0001\u0007/\tAa]5{K\u0006\u0001r-\u001a;CCR\u001c\u0007.T3uC\u0012\fG/\u0019\u000b\u0005\u0005G\u001a)\u0003\u0003\u0004\u0004\u00025\u0002\r!T\u0001\u0010G2,\u0017M\\;q\u001b\u0016$\u0018\rZ1uCR!\u00111MB\u0016\u0011\u0019\u0011YO\fa\u0001\u001b\"\u001aafa\f\u0011\t\rE21I\u0007\u0003\u0007gQAa!\u000e\u00048\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\u0019Ida\u000f\u0002\r\r|W.\\8o\u0015\u0011\u0019ida\u0010\u0002\r\u001d|wn\u001a7f\u0015\t\u0019\t%A\u0002d_6LAa!\u0012\u00044\t\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005\r\u0014!G4fi\n\u000bGo\u00195TKN\u001c\u0018n\u001c8t)>\u0014VmY8wKJ$Baa\u0014\u0004RA1\u0011QFA\u001c\u0005wAaaa\u00151\u0001\u0004i\u0015AD6zkV\u0014\u0017.\u00138ti\u0006t7-Z\u0001#O\u0016$\b+Z3s\u0013:\u001cH/\u00198dK\u000ecwn]3e\u0005\u0006$8\r[*fgNLwN\\:\u0015\t\re31\f\t\u0007\u0003[\t9D!\u001a\t\r\rM\u0013\u00071\u0001N\u0003!I7oU3sm\u0016\u0014XC\u0001B;\u0003IIg.\u001b;TKN\u001c\u0018n\u001c8MS6LG/\u001a:\u0015\t\u0005\r4Q\r\u0005\b\u0003\u001f\u001c\u0004\u0019AAi\u0003E9W\r^+oY&l\u0017\u000e^3e+N,'o]\u000b\u0003\u0007W\u0002BATB7\u001b&\u00191qN-\u0003\u0007M+G/A\u000bsK\u001a\u0014Xm\u001d5V]2LW.\u001b;fIV\u001bXM]:\u0015\t\u0005\r4Q\u000f\u0005\b\u0003\u001f,\u0004\u0019AAi\u000319W\r\u001e#f]f,6/\u001a:t\u0003A\u0011XM\u001a:fg\"$UM\\=Vg\u0016\u00148\u000f\u0006\u0003\u0002d\ru\u0004bBAho\u0001\u0007\u0011\u0011[\u0001\u000bO\u0016$H)\u001a8z\u0013B\u001c\u0018A\u0004:fMJ,7\u000f\u001b#f]fL\u0005o\u001d\u000b\u0005\u0003G\u001a)\tC\u0004\u0002Pf\u0002\r!!5\u0002'\u0005\u0004\b\u000f\\=TKN\u001c\u0018n\u001c8MS6LG/\u001a:\u0015\u001d\u0005]31RBH\u0007'\u001b9ja'\u0004 \"91Q\u0012\u001eA\u0002\r]\u0011!C;tKJd\u0015.\\5u\u0011\u001d\u0019\tJ\u000fa\u0001\u0007/\ta\"\u001b9BI\u0012\u0014Xm]:MS6LG\u000fC\u0004\u0004\u0016j\u0002\raa\u0006\u0002%U\u001cXM]%q\u0003\u0012$'/Z:t\u0019&l\u0017\u000e\u001e\u0005\b\u00073S\u0004\u0019AB6\u0003E)8/\u001a:V]2LW.\u001b;fI2K7\u000f\u001e\u0005\b\u0007;S\u0004\u0019AB6\u00031)8/\u001a:EK:LH*[:u\u0011\u001d\u0019\tK\u000fa\u0001\u0007W\n!\"\u001b9EK:LH*[:u\u0003]\u0019H/\u0019:u\u000b:<\u0017N\\3BY&4Xm\u00115fG.,'/A\u0011j]&$XI\\4j]\u0016\u001cF/\u0019:ukB\u0004&o\\2fgN\u001cV-\\1qQ>\u0014X\r\u0006\u0003\u0002d\r%\u0006bBAhy\u0001\u0007\u0011\u0011\u001b")
public class KyuubiSessionManager
extends SessionManager {
    private Option<MetadataManager> metadataManager;
    private Seq<SessionConfAdvisor> sessionConfAdvisor;
    private GroupProvider groupProvider;
    private Tuple2<PrivateKey, PublicKey> x$1;
    private PrivateKey signingPrivateKey;
    private PublicKey signingPublicKey;
    private final KyuubiParser parser = new KyuubiParser();
    private final KyuubiOperationManager operationManager = new KyuubiOperationManager();
    private final HadoopCredentialsManager credentialsManager = new HadoopCredentialsManager();
    private final KyuubiApplicationManager applicationManager = new KyuubiApplicationManager();
    private Option<SessionLimiter> limiter = None$.MODULE$;
    private Option<SessionLimiter> batchLimiter = None$.MODULE$;
    private Option<Semaphore> engineStartupProcessSemaphore = None$.MODULE$;
    private final ScheduledExecutorService engineConnectionAliveChecker;
    private volatile byte bitmap$0;

    private KyuubiParser parser() {
        return this.parser;
    }

    public KyuubiOperationManager operationManager() {
        return this.operationManager;
    }

    public HadoopCredentialsManager credentialsManager() {
        return this.credentialsManager;
    }

    public KyuubiApplicationManager applicationManager() {
        return this.applicationManager;
    }

    private Option<MetadataManager> metadataManager$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metadataManager = this.conf().isRESTEnabled() ? new Some((Object)new MetadataManager()) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metadataManager;
    }

    public Option<MetadataManager> metadataManager() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metadataManager$lzycompute();
        }
        return this.metadataManager;
    }

    private Seq<SessionConfAdvisor> sessionConfAdvisor$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sessionConfAdvisor = PluginLoader$.MODULE$.loadSessionConfAdvisor(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sessionConfAdvisor;
    }

    public Seq<SessionConfAdvisor> sessionConfAdvisor() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sessionConfAdvisor$lzycompute();
        }
        return this.sessionConfAdvisor;
    }

    private GroupProvider groupProvider$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.groupProvider = PluginLoader$.MODULE$.loadGroupProvider(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.groupProvider;
    }

    public GroupProvider groupProvider() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.groupProvider$lzycompute();
        }
        return this.groupProvider;
    }

    private Option<SessionLimiter> limiter() {
        return this.limiter;
    }

    private void limiter_$eq(Option<SessionLimiter> x$1) {
        this.limiter = x$1;
    }

    private Option<SessionLimiter> batchLimiter() {
        return this.batchLimiter;
    }

    private void batchLimiter_$eq(Option<SessionLimiter> x$1) {
        this.batchLimiter = x$1;
    }

    private Tuple2<PrivateKey, PublicKey> x$1$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Tuple2 tuple2 = SignUtils$.MODULE$.generateKeyPair(SignUtils$.MODULE$.generateKeyPair$default$1());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                PrivateKey signingPrivateKey = (PrivateKey)tuple2._1();
                PublicKey signingPublicKey = (PublicKey)tuple2._2();
                this.x$1 = new Tuple2((Object)signingPrivateKey, (Object)signingPublicKey);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.x$1$lzycompute();
        }
        return this.x$1;
    }

    private PrivateKey signingPrivateKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.signingPrivateKey = (PrivateKey)this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.signingPrivateKey;
    }

    public PrivateKey signingPrivateKey() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.signingPrivateKey$lzycompute();
        }
        return this.signingPrivateKey;
    }

    private PublicKey signingPublicKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.signingPublicKey = (PublicKey)this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.signingPublicKey;
    }

    public PublicKey signingPublicKey() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.signingPublicKey$lzycompute();
        }
        return this.signingPublicKey;
    }

    public Option<Semaphore> engineStartupProcessSemaphore() {
        return this.engineStartupProcessSemaphore;
    }

    public void engineStartupProcessSemaphore_$eq(Option<Semaphore> x$1) {
        this.engineStartupProcessSemaphore = x$1;
    }

    private ScheduledExecutorService engineConnectionAliveChecker() {
        return this.engineConnectionAliveChecker;
    }

    public void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.addService((Service)this.applicationManager());
        this.addService((Service)this.credentialsManager());
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)service -> {
            this.addService(service);
            return BoxedUnit.UNIT;
        });
        this.initSessionLimiter(conf);
        this.initEngineStartupProcessSemaphore(conf);
        super.initialize(conf);
    }

    public Session createSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        KyuubiConf userConf = this.getConf().getUserDefaults(user);
        return new KyuubiSessionImpl(protocol, user, password, ipAddress, conf, this, userConf, BoxesRunTime.unboxToBoolean((Object)userConf.get(KyuubiConf$.MODULE$.ENGINE_DO_AS_ENABLED())), this.parser());
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$openSession$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.increment(new UserIpAddress(username, ipAddress));
            return BoxedUnit.UNIT;
        });
        try {
            sessionHandle = super.openSession(protocol, username, password, ipAddress, conf);
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openSession$4(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append("Error opening session for ").append(username).append(" client ip ").append(ipAddress).append(", due to ").append(e.getMessage()).toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        Session session = this.getSession(sessionHandle);
        try {
            super.closeSession(sessionHandle);
        }
        finally {
            Session session2 = session;
            if (session2 instanceof KyuubiBatchSession) {
                this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            } else {
                this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public KyuubiBatchSession createBatchSession(String user, String password, String ipAddress, Map<String, String> conf, String batchType, Option<String> batchName, String resource, String className, Seq<String> batchArgs, Option<Metadata> metadata, boolean fromRecovery) {
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$createBatchSession$1(x$6))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        KyuubiConf sessionConf = this.getConf().getUserDefaults(user);
        return new KyuubiBatchSession(username, password, ipAddress, conf, this, sessionConf, batchType, batchName, resource, className, batchArgs, metadata, fromRecovery);
    }

    public Option<Metadata> createBatchSession$default$10() {
        return None$.MODULE$;
    }

    public SessionHandle openBatchSession(KyuubiBatchSession batchSession) {
        SessionHandle sessionHandle;
        String user = batchSession.user();
        String ipAddress = batchSession.ipAddress();
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.increment(new UserIpAddress(user, ipAddress));
            return BoxedUnit.UNIT;
        });
        SessionHandle handle = batchSession.handle();
        try {
            this.setSession(handle, (Session)batchSession);
            batchSession.open();
            this.logSessionCountInfo((Session)batchSession, "opened");
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                this.closeSession(handle);
            }
            catch (Throwable t) {
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Error closing batch session[").append(handle).append("] for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openBatchSession$3(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(54).append("Error opening batch session[").append(handle).append("] for ").append(user).append(" client ip ").append(ipAddress).append(",").append(" due to ").append(e.getMessage()).toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public SessionHandle openBatchSession(String user, String password, String ipAddress, BatchRequest batchRequest) {
        KyuubiBatchSession batchSession = this.createBatchSession(user, password, ipAddress, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(batchRequest.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()), batchRequest.getBatchType(), (Option<String>)Option$.MODULE$.apply((Object)batchRequest.getName()), batchRequest.getResource(), batchRequest.getClassName(), (Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq(), (Option<Metadata>)None$.MODULE$, false);
        return this.openBatchSession(batchSession);
    }

    public String initializeBatchState(String user, String ipAddress, Map<String, String> conf, BatchRequest batchRequest) {
        String batchId;
        String realUser = (String)conf.getOrElse((Object)"kyuubi.session.real.user", (Function0 & Serializable & scala.Serializable)() -> user);
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initializeBatchState$2(x$8))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        String x$1 = batchId = (String)conf.apply((Object)BatchUtils.KYUUBI_BATCH_ID_KEY);
        Enumeration.Value x$2 = SessionType$.MODULE$.BATCH();
        String x$3 = realUser;
        String x$4 = username;
        String x$5 = ipAddress;
        String x$6 = OperationState$.MODULE$.INITIALIZED().toString();
        String x$7 = batchRequest.getResource();
        String x$82 = batchRequest.getClassName();
        String x$92 = batchRequest.getName();
        Map<String, String> x$102 = conf;
        Seq x$11 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq();
        long x$12 = System.currentTimeMillis();
        String x$13 = batchRequest.getBatchType();
        int x$14 = BoxesRunTime.unboxToInt((Object)conf.get((Object)"kyuubi.batch.priority").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)KyuubiSessionManager.$anonfun$initializeBatchState$4(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10));
        String x$15 = Metadata$.MODULE$.apply$default$6();
        Option<String> x$16 = Metadata$.MODULE$.apply$default$15();
        long x$17 = Metadata$.MODULE$.apply$default$16();
        String x$18 = Metadata$.MODULE$.apply$default$17();
        String x$19 = Metadata$.MODULE$.apply$default$18();
        String x$20 = Metadata$.MODULE$.apply$default$19();
        String x$21 = Metadata$.MODULE$.apply$default$20();
        Option<String> x$22 = Metadata$.MODULE$.apply$default$21();
        long x$23 = Metadata$.MODULE$.apply$default$22();
        boolean x$24 = Metadata$.MODULE$.apply$default$24();
        Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$15, x$6, x$7, x$82, x$92, x$102, (Seq<String>)x$11, x$12, x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$14, x$24);
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.insertMetadata(metadata, false);
            return BoxedUnit.UNIT;
        });
        return batchId;
    }

    public Option<KyuubiBatchSession> getBatchSession(SessionHandle sessionHandle) {
        return this.getSessionOption(sessionHandle).map((Function1 & Serializable & scala.Serializable)x$11 -> (KyuubiBatchSession)((Object)x$11));
    }

    public void insertMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.insertMetadata(metadata, x$12.insertMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void updateMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.updateMetadata(metadata, x$13.updateMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public Option<MetadataRequestsRetryRef> getMetadataRequestsRetryRef(String identifier) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> Option$.MODULE$.apply((Object)mm.getMetadataRequestsRetryRef(identifier)));
    }

    public void deRegisterMetadataRequestsRetryRef(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.deRegisterRequestsRetryRef(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Batch> getBatchFromMetadataStore(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> mm.getBatch(batchId));
    }

    public Seq<Batch> getBatchesFromMetadataStore(MetadataFilter filter, int from, int size) {
        return (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.getBatches(filter, from, size)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public Option<Metadata> getBatchMetadata(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.getBatchSessionMetadata(batchId));
    }

    @VisibleForTesting
    public void cleanupMetadata(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            x$17.cleanupMetadataById(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void start() {
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
            KyuubiSessionManager.$anonfun$start$1(this, ms);
            return BoxedUnit.UNIT;
        });
        super.start();
        this.startEngineAliveChecker();
    }

    public Seq<KyuubiBatchSession> getBatchSessionsToRecover(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToRecover -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)x$18.getBatchesRecoveryMetadata(stateToRecover.toString(), kyuubiInstance, 0, Integer.MAX_VALUE).map((Function1 & Serializable & scala.Serializable)metadata -> this.createBatchSession(metadata.username(), "anonymous", metadata.ipAddress(), metadata.requestConf(), metadata.engineType(), (Option<String>)Option$.MODULE$.apply((Object)metadata.requestName()), metadata.resource(), metadata.className(), metadata.requestArgs(), (Option<Metadata>)new Some(metadata), true), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Metadata> getPeerInstanceClosedBatchSessions(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToKill -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.getPeerInstanceClosedBatchesMetadata(stateToKill.toString(), kyuubiInstance, 0, Integer.MAX_VALUE)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public boolean isServer() {
        return true;
    }

    private void initSessionLimiter(KyuubiConf conf) {
        int userLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Set userUnlimitedList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$4(x$20)));
        Set userDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$5(x$21)));
        Set ipDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_IP_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$6(x$22)));
        this.limiter_$eq(this.applySessionLimiter(userLimit, ipAddressLimit, userIpAddressLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList, (Set<String>)ipDenyList));
        int userBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.batchLimiter_$eq(this.applySessionLimiter(userBatchLimit, ipAddressBatchLimit, userIpAddressBatchLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList, (Set<String>)ipDenyList));
    }

    public Set<String> getUnlimitedUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getUnlimitedUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshUnlimitedUsers(KyuubiConf conf) {
        Set unlimitedUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshUnlimitedUsers$1(x$23)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$24, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$25 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$25, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyUsers(KyuubiConf conf) {
        Set denyUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyUsers$1(x$26)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$27 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$27, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$28 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$28, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyIps() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyIps((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyIps(KyuubiConf conf) {
        Set denyIps = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_IP_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyIps$1(x$29)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$30 -> {
            SessionLimiter$.MODULE$.resetDenyIps(x$30, (Set<String>)denyIps);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$31 -> {
            SessionLimiter$.MODULE$.resetDenyIps(x$31, (Set<String>)denyIps);
            return BoxedUnit.UNIT;
        });
    }

    private Option<SessionLimiter> applySessionLimiter(int userLimit, int ipAddressLimit, int userIpAddressLimit, Set<String> userUnlimitedList, Set<String> userDenyList, Set<String> ipDenyList) {
        if (((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{userLimit, ipAddressLimit, userIpAddressLimit}))).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$32 -> x$32 > 0) || userDenyList.nonEmpty() || ipDenyList.nonEmpty()) {
            return new Some((Object)SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, userUnlimitedList, userDenyList, ipDenyList));
        }
        return None$.MODULE$;
    }

    private void startEngineAliveChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_ALIVE_PROBE_INTERVAL()));
        Runnable checkTask = () -> this.allSessions().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KyuubiSessionManager.$anonfun$startEngineAliveChecker$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.engineConnectionAliveChecker(), checkTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void initEngineStartupProcessSemaphore(KyuubiConf conf) {
        Option engineCreationLimit = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_ENGINE_CREATION());
        engineCreationLimit.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$33 -> x$33 > 0).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)limit -> this.engineStartupProcessSemaphore_$eq((Option<Semaphore>)new Some((Object)new Semaphore(limit))));
    }

    public static final /* synthetic */ boolean $anonfun$openSession$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openSession$4(String user$1, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$1}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.INTERACTIVE().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$createBatchSession$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openBatchSession$3(String user$2, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$2}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.BATCH().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$initializeBatchState$2(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$initializeBatchState$4(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ void $anonfun$start$1(KyuubiSessionManager $this, MetricsSystem ms) {
        ms.registerGauge(MetricsConstants$.MODULE$.CONN_OPEN(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveUserSessionCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ALIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getExecPoolSize(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ACTIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_WORK_QUEUE_SIZE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getWorkQueueSize(), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$4(String x$20) {
        return new StringOps(Predef$.MODULE$.augmentString(x$20)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$5(String x$21) {
        return new StringOps(Predef$.MODULE$.augmentString(x$21)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$6(String x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshUnlimitedUsers$1(String x$23) {
        return new StringOps(Predef$.MODULE$.augmentString(x$23)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyUsers$1(String x$26) {
        return new StringOps(Predef$.MODULE$.augmentString(x$26)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyIps$1(String x$29) {
        return new StringOps(Predef$.MODULE$.augmentString(x$29)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$startEngineAliveChecker$2(KyuubiSessionManager $this, Session x0$1) {
        Session session = x0$1;
        if (session instanceof KyuubiSessionImpl) {
            BoxedUnit boxedUnit;
            KyuubiSessionImpl kyuubiSessionImpl = (KyuubiSessionImpl)session;
            try {
                if (!kyuubiSessionImpl.checkEngineConnectionAlive()) {
                    $this.closeSession(kyuubiSessionImpl.handle());
                    $this.logger().info(new StringBuilder(98).append("The session ").append(kyuubiSessionImpl.handle()).append(" has been closed ").append("due to engine unresponsiveness (checked by the engine alive checker).").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable e) {
                $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error closing session ").append(kyuubiSessionImpl.handle()).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private KyuubiSessionManager(String name) {
        super(name);
        this.engineConnectionAliveChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(21).append(name).append("-engine-alive-checker").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
    }

    public KyuubiSessionManager() {
        this(KyuubiSessionManager.class.getSimpleName());
    }
}

