/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.KyuubiRestFrontendService$;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.v1.ApiRootResource$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.KyuubiHttpAuthenticationFactory;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.ui.JettyServer;
import org.apache.kyuubi.server.ui.JettyServer$;
import org.apache.kyuubi.server.ui.JettyUtils$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.AuthUtils$;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.util.ThreadUtils$;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001\u0002\u0012$\u00011B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0005\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005k!)\u0011\b\u0001C\u0001u!IA\u0005\u0001a\u0001\u0002\u0004%IA\u0010\u0005\n\u000b\u0002\u0001\r\u00111A\u0005\n\u0019C\u0011b\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B \t\u000fA\u0003!\u0019!C\u0005#\"1a\f\u0001Q\u0001\nICQa\u0018\u0001\u0005\n\u0001Da!\u001b\u0001\u0005\u0002\u0015R\u0007bB9\u0001\u0005\u0004%IA\u001d\u0005\u0007o\u0002\u0001\u000b\u0011B:\t\u0011a\u0004\u0001R1A\u0005\u0002eD!\"a\u0003\u0001\u0011\u000b\u0007I\u0011BA\u0007\u0011-\t)\u0002\u0001EC\u0002\u0013\u0005Q%a\u0006\t\u0015\u0005}\u0001\u0001#b\u0001\n\u0013\t\t\u0003C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!1\u00111\t\u0001\u0005BeDq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002J\u0001!I!a\u0012\t\u000f\u0005-\u0003\u0001\"\u0003\u0002H!A\u0011Q\n\u0001\u0005\u0002\u0015\n9\u0005C\u0004\u0002j\u0001!\t!a\u0012\t\u000f\u0005-\u0004\u0001\"\u0011\u0002H!9\u0011Q\u000e\u0001\u0005B\u0005\u001d\u0003bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\t\u0019\b\u0001C\u0001\u0003wBa!a\"\u0001\t\u0003I\bbBAE\u0001\u0011%\u00111\u0012\u0005\n\u0003/\u0003!\u0019!C!\u00033C\u0001\"a*\u0001A\u0003%\u00111\u0014\u0002\u001a\u0017f,XOY5SKN$hI]8oi\u0016tGmU3sm&\u001cWM\u0003\u0002%K\u000511/\u001a:wKJT!AJ\u0014\u0002\r-LX/\u001e2j\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\f\t\u0003]Ej\u0011a\f\u0006\u0003a\u0015\nqa]3sm&\u001cW-\u0003\u00023_\t9\u0012IY:ue\u0006\u001cGO\u0012:p]R,g\u000eZ*feZL7-Z\u0001\u000bg\u0016\u0014h/\u001a:bE2,W#A\u001b\u0011\u000592\u0014BA\u001c0\u0005)\u0019VM\u001d<fe\u0006\u0014G.Z\u0001\fg\u0016\u0014h/\u001a:bE2,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003wu\u0002\"\u0001\u0010\u0001\u000e\u0003\rBQaM\u0002A\u0002U*\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u000e\n!!^5\n\u0005\u0011\u000b%a\u0003&fiRL8+\u001a:wKJ\f!b]3sm\u0016\u0014x\fJ3r)\t9U\n\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0003V]&$\bb\u0002(\u0006\u0003\u0003\u0005\raP\u0001\u0004q\u0012\n\u0014aB:feZ,'\u000fI\u0001\nSN\u001cF/\u0019:uK\u0012,\u0012A\u0015\t\u0003'rk\u0011\u0001\u0016\u0006\u0003+Z\u000ba!\u0019;p[&\u001c'BA,Y\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u00033j\u000bA!\u001e;jY*\t1,\u0001\u0003kCZ\f\u0017BA/U\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006Q\u0011n]*uCJ$X\r\u001a\u0011\u0002\u0015!\fGm\\8q\u0007>tg-F\u0001b!\t\u0011w-D\u0001d\u0015\t!W-\u0001\u0003d_:4'B\u00014(\u0003\u0019A\u0017\rZ8pa&\u0011\u0001n\u0019\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u001dM,7o]5p]6\u000bg.Y4feV\t1\u000e\u0005\u0002m_6\tQN\u0003\u0002oK\u000591/Z:tS>t\u0017B\u00019n\u0005QY\u00150^;cSN+7o]5p]6\u000bg.Y4fe\u0006a!-\u0019;dQ\u000eCWmY6feV\t1\u000f\u0005\u0002uk6\ta+\u0003\u0002w-\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u001b\t\fGo\u00195DQ\u0016\u001c7.\u001a:!\u0003\u0011Awn\u001d;\u0016\u0003i\u00042a_A\u0003\u001d\ra\u0018\u0011\u0001\t\u0003{&k\u0011A \u0006\u0003\u007f.\na\u0001\u0010:p_Rt\u0014bAA\u0002\u0013\u00061\u0001K]3eK\u001aLA!a\u0002\u0002\n\t11\u000b\u001e:j]\u001eT1!a\u0001J\u0003\u0011\u0001xN\u001d;\u0016\u0005\u0005=\u0001c\u0001%\u0002\u0012%\u0019\u00111C%\u0003\u0007%sG/A\btK\u000e,(/\u001b;z\u000b:\f'\r\\3e+\t\tI\u0002E\u0002I\u00037I1!!\bJ\u0005\u001d\u0011un\u001c7fC:\fa\"\u00193nS:L7\u000f\u001e:bi>\u00148/\u0006\u0002\u0002$A!10!\n{\u0013\u0011\t9#!\u0003\u0003\u0007M+G/A\bjg\u0006#W.\u001b8jgR\u0014\u0018\r^8s)\u0011\tI\"!\f\t\r\u0005=\u0012\u00031\u0001{\u0003!)8/\u001a:OC6,\u0017AC5oSRL\u0017\r\\5{KR\u0019q)!\u000e\t\r\u0011\u0014\u0002\u0019AA\u001c!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001fK\u000511m\u001c8gS\u001eLA!!\u0011\u0002<\tQ1*_;vE&\u001cuN\u001c4\u0002\u001b\r|gN\\3di&|g.\u0016:m\u00035\u0019H/\u0019:u\u0013:$XM\u001d8bYR\tq)\u0001\u0007j]N$\u0018\r\u001c7XK\n,\u0016*A\tti\u0006\u0014HOQ1uG\"\u001c\u0005.Z2lKJ\fAC]3d_Z,'OQ1uG\"\u001cVm]:j_:\u001c\bfA\f\u0002RA!\u00111KA3\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013aC1o]>$\u0018\r^5p]NTA!a\u0017\u0002^\u000511m\\7n_:TA!a\u0018\u0002b\u00051qm\\8hY\u0016T!!a\u0019\u0002\u0007\r|W.\u0003\u0003\u0002h\u0005U#!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\u0006!r/Y5u\r>\u00148+\u001a:wKJ\u001cF/\u0019:uK\u0012\fQa\u001d;beR\fAa\u001d;pa\u0006Yq-\u001a;SK\u0006dWk]3s)\u0005Q\u0018AD4fiN+7o]5p]V\u001bXM\u001d\u000b\u0004u\u0006]\u0004BBA=9\u0001\u0007!0A\u0005qe>D\u00180V:feR\u0019!0! \t\u000f\u0005}T\u00041\u0001\u0002\u0002\u0006Y1/Z:tS>t7i\u001c8g!\u0015Y\u00181\u0011>{\u0013\u0011\t))!\u0003\u0003\u00075\u000b\u0007/\u0001\u0007hKRL\u0005/\u00113ee\u0016\u001c8/\u0001\u0007hKR\u0004&o\u001c=z+N,'\u000fF\u0004{\u0003\u001b\u000by)a%\t\u000f\u0005}t\u00041\u0001\u0002\u0002\"1\u0011\u0011S\u0010A\u0002i\f\u0011\"\u001b9BI\u0012\u0014Xm]:\t\r\u0005Uu\u00041\u0001{\u0003!\u0011X-\u00197Vg\u0016\u0014\u0018\u0001\u00053jg\u000e|g/\u001a:z'\u0016\u0014h/[2f+\t\tY\nE\u0003I\u0003;\u000b\t+C\u0002\u0002 &\u0013aa\u00149uS>t\u0007c\u0001\u0018\u0002$&\u0019\u0011QU\u0018\u0003\u000fM+'O^5dK\u0006\tB-[:d_Z,'/_*feZL7-\u001a\u0011")
public class KyuubiRestFrontendService
extends AbstractFrontendService {
    private String host;
    private int port;
    private boolean securityEnabled;
    private Set<String> administrators;
    private final Serverable serverable;
    private JettyServer server;
    private final AtomicBoolean isStarted;
    private final ScheduledExecutorService batchChecker;
    private final Option<Service> discoveryService;
    private volatile byte bitmap$0;

    public Serverable serverable() {
        return this.serverable;
    }

    private JettyServer server() {
        return this.server;
    }

    private void server_$eq(JettyServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean isStarted() {
        return this.isStarted;
    }

    private Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    public KyuubiSessionManager sessionManager() {
        return (KyuubiSessionManager)this.be().sessionManager();
    }

    private ScheduledExecutorService batchChecker() {
        return this.batchChecker;
    }

    private String host$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.host = (String)((Option)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_HOST())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    if (Utils$.MODULE$.isWindows() || Utils$.MODULE$.isMac()) {
                        this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Kyuubi Server run in Windows or Mac environment, binding ").append(this.getName()).append(" to 0.0.0.0").toString());
                        return "0.0.0.0";
                    }
                    if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_CONNECTION_URL_USE_HOSTNAME()))) {
                        return Utils$.MODULE$.findLocalInetAddress().getCanonicalHostName();
                    }
                    return Utils$.MODULE$.findLocalInetAddress().getHostAddress();
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.host;
    }

    public String host() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.host$lzycompute();
        }
        return this.host;
    }

    private int port$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.port = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_PORT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.port;
    }

    private int port() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.port$lzycompute();
        }
        return this.port;
    }

    private boolean securityEnabled$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Seq authTypes = (Seq)((TraversableLike)this.conf().get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).map((Function1 & Serializable & scala.Serializable)s -> AuthTypes$.MODULE$.withName(s), Seq$.MODULE$.canBuildFrom());
                this.securityEnabled = AuthUtils$.MODULE$.kerberosEnabled(authTypes) || !AuthUtils$.MODULE$.effectivePlainAuthType(authTypes).contains((Object)AuthTypes$.MODULE$.NONE());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.securityEnabled;
    }

    public boolean securityEnabled() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.securityEnabled$lzycompute();
        }
        return this.securityEnabled;
    }

    private Set<String> administrators$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.administrators = (Set)((SetLike)this.conf().get(KyuubiConf$.MODULE$.SERVER_ADMINISTRATORS())).$plus((Object)Utils$.MODULE$.currentUser());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.administrators;
    }

    private Set<String> administrators() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.administrators$lzycompute();
        }
        return this.administrators;
    }

    public boolean isAdministrator(String userName) {
        if (this.securityEnabled()) {
            return this.administrators().contains((Object)userName);
        }
        return true;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.server_$eq(JettyServer$.MODULE$.apply(this.getName(), this.host(), this.port(), BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_MAX_WORKER_THREADS())), BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_JETTY_STOP_TIMEOUT()))));
        super.initialize(conf);
    }

    public String connectionUrl() {
        this.checkInitialized();
        Option option = (Option)this.conf().get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_ADVERTISED_HOST());
        if (option instanceof Some) {
            Some some = (Some)option;
            String advertisedHost = (String)some.value();
            return new StringBuilder(1).append(advertisedHost).append(":").append(this.port()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return this.server().getServerUri();
        }
        throw new MatchError((Object)option);
    }

    private void startInternal() {
        ServletContextHandler contextHandler = ApiRootResource$.MODULE$.getServletHandler(this);
        FilterHolder holder = new FilterHolder((Filter)new AuthenticationFilter(this.conf()));
        contextHandler.addFilter(holder, "/v1/*", EnumSet.allOf(DispatcherType.class));
        KyuubiHttpAuthenticationFactory authenticationFactory = new KyuubiHttpAuthenticationFactory(this.conf());
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)contextHandler));
        ServletContextHandler proxyHandler = ApiRootResource$.MODULE$.getEngineUIProxyHandler(this);
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)proxyHandler));
        this.installWebUI();
    }

    private void installWebUI() {
        this.server().addRedirectHandler("/", "/ui");
        ServletContextHandler servletHandler = JettyUtils$.MODULE$.createStaticHandler("dist", "/ui");
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(404, "/");
        servletHandler.setErrorHandler((ErrorHandler)errorHandler);
        this.server().addHandler((Handler)servletHandler);
    }

    private void startBatchChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_CHECK_INTERVAL()));
        Runnable task = new Runnable(this){
            private final /* synthetic */ KyuubiRestFrontendService $outer;

            public void run() {
                try {
                    this.$outer.sessionManager().getPeerInstanceClosedBatchSessions(this.$outer.connectionUrl()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        $anon$1.$anonfun$run$1(this, batch);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable e) {
                    this.$outer.error((Function0 & Serializable & scala.Serializable)() -> "Error checking batch sessions", e);
                }
            }

            public static final /* synthetic */ void $anonfun$run$3(KyuubiBatchSession x$1) {
                x$1.close();
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, Metadata batch) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    SessionHandle sessionHandle = SessionHandle$.MODULE$.fromUUID(batch.identifier());
                    $this.$outer.sessionManager().getBatchSession(sessionHandle).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anon$1.$anonfun$run$3(x$1);
                        return BoxedUnit.UNIT;
                    });
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata ), $anonfun$run$4(), $anonfun$run$3$adapted(org.apache.kyuubi.session.KyuubiBatchSession ), $anonfun$run$2(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata )}, serializedLambda);
            }
        };
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.batchChecker(), task, interval, interval, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public void recoverBatchSessions() {
        int recoveryNumThreads = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_RECOVERY_THREADS()));
        ThreadPoolExecutor batchRecoveryExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(recoveryNumThreads, "batch-recovery-executor");
        try {
            Seq<KyuubiBatchSession> batchSessionsToRecover = this.sessionManager().getBatchSessionsToRecover(this.connectionUrl());
            AtomicInteger pendingRecoveryTasksCount = new AtomicInteger(0);
            Seq tasks = (Seq)batchSessionsToRecover.flatMap((Function1 & Serializable & scala.Serializable)batchSession -> {
                Iterable iterable;
                String batchId = batchSession.batchJobSubmissionOp().batchId();
                try {
                    Future<Object> task = batchRecoveryExecutor.submit(() -> {
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sessionManager().openBatchSession(batchSession));
                        return BoxedUnit.UNIT;
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(task), (Object)batchId)));
                }
                catch (Throwable e) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error while submitting batch[").append(batchId).append("] for recovery").toString(), e);
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
            pendingRecoveryTasksCount.addAndGet(tasks.size());
            tasks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KyuubiRestFrontendService.$anonfun$recoverBatchSessions$5(this, pendingRecoveryTasksCount, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)batchRecoveryExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
        }
    }

    public void waitForServerStarted() {
        while (!this.server().isStarted()) {
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Waiting for ").append(this.getName()).append("'s HTTP server getting started").toString());
            Thread.sleep(1000L);
        }
    }

    public synchronized void start() {
        if (!this.isStarted().get()) {
            try {
                this.server().start();
                this.startInternal();
                this.waitForServerStarted();
                this.isStarted().set(true);
                this.startBatchChecker();
                this.recoverBatchSessions();
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(13).append("Cannot start ").append(this.getName()).toString(), (Throwable)e);
            }
        }
        super.start();
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Exposing REST endpoint at: http://").append(this.server().getServerUri()).toString());
    }

    public synchronized void stop() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.batchChecker(), ThreadUtils$.MODULE$.shutdown$default$2());
        if (this.isStarted().getAndSet(false)) {
            this.server().stop();
        }
        super.stop();
    }

    public String getRealUser() {
        return ServiceUtils$.MODULE$.getShortName((String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserName()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getRealUser$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous"));
    }

    public String getSessionUser(String proxyUser2) {
        Map sessionConf = (Map)Option$.MODULE$.apply((Object)proxyUser2).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getSessionUser$1(x$3))).map((Function1 & Serializable & scala.Serializable)proxyUser -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.PROXY_USER().key()), proxyUser)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return this.getSessionUser((Map<String, String>)sessionConf);
    }

    public String getSessionUser(Map<String, String> sessionConf) {
        String string;
        String ipAddress = AuthenticationFilter$.MODULE$.getUserIpAddress();
        String realUser = this.getRealUser();
        try {
            string = this.getProxyUser(sessionConf, ipAddress, realUser);
        }
        catch (Throwable t) {
            throw new WebApplicationException(t.getMessage(), Response.Status.METHOD_NOT_ALLOWED);
        }
        return string;
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuthenticationFilter$.MODULE$.getUserIpAddress());
    }

    private String getProxyUser(Map<String, String> sessionConf, String ipAddress, String realUser) {
        String proxyUser;
        block1: {
            if (sessionConf == null) {
                return realUser;
            }
            proxyUser = (String)sessionConf.getOrElse((Object)KyuubiConf$.MODULE$.PROXY_USER().key(), (Function0 & Serializable & scala.Serializable)() -> (String)sessionConf.getOrElse((Object)AuthUtils$.MODULE$.HS2_PROXY_USER(), (Function0 & Serializable & scala.Serializable)() -> realUser));
            if (proxyUser.equals(realUser) || this.isAdministrator(realUser)) break block1;
            AuthUtils$.MODULE$.verifyProxyAccess(realUser, proxyUser, ipAddress, this.hadoopConf());
        }
        return proxyUser;
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    public static final /* synthetic */ void $anonfun$recoverBatchSessions$5(KyuubiRestFrontendService $this, AtomicInteger pendingRecoveryTasksCount$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Future task = (Future)tuple2._1();
            String batchId = (String)tuple2._2();
            try {
                BoxedUnit boxedUnit;
                try {
                    boxedUnit = (BoxedUnit)task.get();
                }
                catch (Throwable e) {
                    $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error while recovering batch[").append(batchId).append("]").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                int pendingTasks = pendingRecoveryTasksCount$1.decrementAndGet();
                $this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Batch[").append(batchId).append("] recovery task terminated, current pending tasks ").append(pendingTasks).toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getRealUser$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getSessionUser$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public KyuubiRestFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiRestFrontendService");
        this.isStarted = new AtomicBoolean(false);
        this.batchChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("batch-checker", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.discoveryService = None$.MODULE$;
    }
}

