/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.jdbc.session;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.jdbc.connection.ConnectionProvider$;
import org.apache.kyuubi.engine.jdbc.util.KyuubiJdbcUtils$;
import org.apache.kyuubi.session.AbstractSession;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetInfoType;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001\u0002\f\u0018\u0001\u0011B\u0011B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u001d\t\u0013i\u0002!\u0011!Q\u0001\nmB\u0005\"C%\u0001\u0005\u0003\u0005\u000b\u0011B\u001eK\u0011%Y\u0005A!A!\u0002\u0013YD\nC\u0005N\u0001\t\u0005\t\u0015!\u0003O#\"I!\u000b\u0001B\u0001B\u0003%1K\u0016\u0005\u0006/\u0002!\t\u0001\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0011c\u0011\u00191\u0007\u0001)A\u0005G\"Qq\r\u0001a\u0001\u0002\u0004%\t!\u00075\t\u0015E\u0004\u0001\u0019!a\u0001\n\u0003I\"\u000fC\u0005z\u0001\u0001\u0007\t\u0011)Q\u0005S\"I!\u0010\u0001a\u0001\u0002\u0004%Ia\u001f\u0005\u000b\u007f\u0002\u0001\r\u00111A\u0005\n\u0005\u0005\u0001BCA\u0003\u0001\u0001\u0007\t\u0011)Q\u0005y\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\f!9\u0011\u0011\u0004\u0001\u0005\n\u0005%\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011\u001d\t\u0019\u0004\u0001C!\u0003;\u0011qB\u00133cGN+7o]5p]&k\u0007\u000f\u001c\u0006\u00031e\tqa]3tg&|gN\u0003\u0002\u001b7\u0005!!\u000e\u001a2d\u0015\taR$\u0001\u0004f]\u001eLg.\u001a\u0006\u0003=}\taa[=vk\nL'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001KA\u0011a\u0005K\u0007\u0002O)\u0011\u0001$H\u0005\u0003S\u001d\u0012q\"\u00112tiJ\f7\r^*fgNLwN\\\u0001\taJ|Go\\2pYB\u0011AfN\u0007\u0002[)\u0011afL\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\u0005A\n\u0014a\u0001:qG*\u0011!gM\u0001\bg\u0016\u0014h/[2f\u0015\t!T'\u0001\u0003iSZ,'B\u0001\u001c\u001e\u0003\u0019\u0019\b.\u00193fI&\u0011\u0001(\f\u0002\u0011)B\u0013x\u000e^8d_24VM]:j_:L!A\u000b\u0015\u0002\tU\u001cXM\u001d\t\u0003y\u0015s!!P\"\u0011\u0005y\nU\"A \u000b\u0005\u0001\u001b\u0013A\u0002\u001fs_>$hHC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u0013aa\u0015;sS:<'B\u0001#B\u0013\tQ\u0004&\u0001\u0005qCN\u001cxo\u001c:e\u0013\tI\u0005&A\u0005ja\u0006#GM]3tg&\u00111\nK\u0001\u0005G>tg\r\u0005\u0003=\u001fnZ\u0014B\u0001)H\u0005\ri\u0015\r]\u0005\u0003\u001b\"\nab]3tg&|g.T1oC\u001e,'\u000f\u0005\u0002')&\u0011Qk\n\u0002\u000f'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u0013\t\u0011\u0006&\u0001\u0004=S:LGO\u0010\u000b\b3ncVLX0a!\tQ\u0006!D\u0001\u0018\u0011\u0015Qs\u00011\u0001,\u0011\u0015Qt\u00011\u0001<\u0011\u0015Iu\u00011\u0001<\u0011\u0015Yu\u00011\u0001<\u0011\u0015iu\u00011\u0001O\u0011\u0015\u0011v\u00011\u0001T\u0003\u0019A\u0017M\u001c3mKV\t1\r\u0005\u0002'I&\u0011Qm\n\u0002\u000e'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\u0002\u000f!\fg\u000e\u001a7fA\u0005\t2/Z:tS>t7i\u001c8oK\u000e$\u0018n\u001c8\u0016\u0003%\u0004\"A[8\u000e\u0003-T!\u0001\\7\u0002\u0007M\fHNC\u0001o\u0003\u0011Q\u0017M^1\n\u0005A\\'AC\"p]:,7\r^5p]\u0006)2/Z:tS>t7i\u001c8oK\u000e$\u0018n\u001c8`I\u0015\fHCA:x!\t!X/D\u0001B\u0013\t1\u0018I\u0001\u0003V]&$\bb\u0002=\f\u0003\u0003\u0005\r![\u0001\u0004q\u0012\n\u0014AE:fgNLwN\\\"p]:,7\r^5p]\u0002\n\u0001\u0003Z1uC\n\f7/Z'fi\u0006$\u0015\r^1\u0016\u0003q\u0004\"A[?\n\u0005y\\'\u0001\u0005#bi\u0006\u0014\u0017m]3NKR\fG)\u0019;b\u0003Q!\u0017\r^1cCN,W*\u001a;b\t\u0006$\u0018m\u0018\u0013fcR\u00191/a\u0001\t\u000fat\u0011\u0011!a\u0001y\u0006\tB-\u0019;bE\u0006\u001cX-T3uC\u0012\u000bG/\u0019\u0011\u0002\u0015-LX/\u001e2j\u0007>tg-\u0006\u0002\u0002\fA!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012u\taaY8oM&<\u0017\u0002BA\u000b\u0003\u001f\u0011!bS=vk\nL7i\u001c8g\u0003-Y\u00170^;cS\u000e{gN\u001a\u0011\u0002\u001b9|'/\\1mSj,7i\u001c8g\u0003\u0011y\u0007/\u001a8\u0015\u0003M\fqaZ3u\u0013:4w\u000e\u0006\u0003\u0002$\u0005%\u0002c\u0001\u0017\u0002&%\u0019\u0011qE\u0017\u0003\u001bQ;U\r^%oM>4\u0016\r\\;f\u0011\u001d\tY\u0003\u0006a\u0001\u0003[\t\u0001\"\u001b8g_RK\b/\u001a\t\u0004Y\u0005=\u0012bAA\u0019[\taAkR3u\u0013:4w\u000eV=qK\u0006)1\r\\8tK\u0002")
public class JdbcSessionImpl
extends AbstractSession {
    private final SessionHandle handle = (SessionHandle)super.conf().get((Object)"kyuubi.session.handle").map((Function1 & Serializable & scala.Serializable)uuid -> SessionHandle$.MODULE$.fromUUID(uuid)).getOrElse((Function0 & Serializable & scala.Serializable)() -> SessionHandle$.MODULE$.apply());
    private Connection sessionConnection;
    private DatabaseMetaData databaseMetaData;
    private final KyuubiConf kyuubiConf = this.normalizeConf();

    public SessionHandle handle() {
        return this.handle;
    }

    public Connection sessionConnection() {
        return this.sessionConnection;
    }

    public void sessionConnection_$eq(Connection x$1) {
        this.sessionConnection = x$1;
    }

    private DatabaseMetaData databaseMetaData() {
        return this.databaseMetaData;
    }

    private void databaseMetaData_$eq(DatabaseMetaData x$1) {
        this.databaseMetaData = x$1;
    }

    private KyuubiConf kyuubiConf() {
        return this.kyuubiConf;
    }

    private KyuubiConf normalizeConf() {
        BoxedUnit boxedUnit;
        KyuubiConf kyuubiConf = super.sessionManager().getConf().clone();
        if (BoxesRunTime.unboxToBoolean((Object)kyuubiConf.get(KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_PROPAGATECREDENTIAL()))) {
            kyuubiConf.set(KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_USER(), (Object)super.user());
            boxedUnit = kyuubiConf.set(KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_PASSWORD(), (Object)super.password());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return kyuubiConf;
    }

    public void open() {
        this.info((Function0 & Serializable & scala.Serializable)() -> "Starting to open jdbc session.");
        if (this.sessionConnection() == null) {
            this.sessionConnection_$eq(ConnectionProvider$.MODULE$.create(this.kyuubiConf()));
            this.databaseMetaData_$eq(this.sessionConnection().getMetaData());
        }
        KyuubiJdbcUtils$.MODULE$.initializeJdbcSession(this.kyuubiConf(), this.sessionConnection(), (Seq<String>)((Seq)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_JDBC_SESSION_INITIALIZE_SQL())));
        super.open();
        this.info((Function0 & Serializable & scala.Serializable)() -> "The jdbc session is started.");
    }

    public TGetInfoValue getInfo(TGetInfoType infoType) {
        return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.assert(this.databaseMetaData() != null, (Function0 & Serializable & scala.Serializable)() -> "JDBC session has not been initialized");
            TGetInfoType tGetInfoType = infoType;
            if (TGetInfoType.CLI_SERVER_NAME.equals(tGetInfoType) ? true : TGetInfoType.CLI_DBMS_NAME.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)this.databaseMetaData().getDatabaseProductName());
            }
            if (TGetInfoType.CLI_DBMS_VER.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)this.databaseMetaData().getDatabaseProductVersion());
            }
            if (TGetInfoType.CLI_ODBC_KEYWORDS.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)"Unimplemented");
            }
            if (TGetInfoType.CLI_MAX_COLUMN_NAME_LEN.equals(tGetInfoType)) {
                return TGetInfoValue.lenValue((long)this.databaseMetaData().getMaxColumnNameLength());
            }
            if (TGetInfoType.CLI_MAX_SCHEMA_NAME_LEN.equals(tGetInfoType)) {
                return TGetInfoValue.lenValue((long)this.databaseMetaData().getMaxSchemaNameLength());
            }
            if (TGetInfoType.CLI_MAX_TABLE_NAME_LEN.equals(tGetInfoType)) {
                return TGetInfoValue.lenValue((long)this.databaseMetaData().getMaxTableNameLength());
            }
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    public void close() {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.sessionConnection() != null) {
                this.sessionConnection().close();
                return;
            }
        });
        if (try_ instanceof Success) {
            this.info((Function0 & Serializable & scala.Serializable)() -> "Closed session connection.");
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.warn((Function0 & Serializable & scala.Serializable)() -> "Failed to close session connection, ignored it.", exception);
        } else {
            throw new MatchError((Object)try_);
        }
        super.close();
    }

    public JdbcSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf, SessionManager sessionManager) {
        super(protocol, user, password, ipAddress, conf, sessionManager);
    }
}

