/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1.ServerStorageVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ServerStorageVersionFluent<A extends ServerStorageVersionFluent<A>>
extends BaseFluent<A> {
    private String apiServerID;
    private List<String> decodableVersions = new ArrayList<String>();
    private String encodingVersion;
    private Map<String, Object> additionalProperties;

    public ServerStorageVersionFluent() {
    }

    public ServerStorageVersionFluent(ServerStorageVersion instance) {
        ServerStorageVersion serverStorageVersion = instance = instance != null ? instance : new ServerStorageVersion();
        if (instance != null) {
            this.withApiServerID(instance.getApiServerID());
            this.withDecodableVersions(instance.getDecodableVersions());
            this.withEncodingVersion(instance.getEncodingVersion());
            this.withApiServerID(instance.getApiServerID());
            this.withDecodableVersions(instance.getDecodableVersions());
            this.withEncodingVersion(instance.getEncodingVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiServerID() {
        return this.apiServerID;
    }

    public A withApiServerID(String apiServerID) {
        this.apiServerID = apiServerID;
        return (A)((Object)this);
    }

    public boolean hasApiServerID() {
        return this.apiServerID != null;
    }

    public A addToDecodableVersions(int index, String item) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        this.decodableVersions.add(index, item);
        return (A)((Object)this);
    }

    public A setToDecodableVersions(int index, String item) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        this.decodableVersions.set(index, item);
        return (A)((Object)this);
    }

    public A addToDecodableVersions(String ... items) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.decodableVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDecodableVersions(Collection<String> items) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.decodableVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDecodableVersions(String ... items) {
        if (this.decodableVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.decodableVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDecodableVersions(Collection<String> items) {
        if (this.decodableVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.decodableVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDecodableVersions() {
        return this.decodableVersions;
    }

    public String getDecodableVersion(int index) {
        return this.decodableVersions.get(index);
    }

    public String getFirstDecodableVersion() {
        return this.decodableVersions.get(0);
    }

    public String getLastDecodableVersion() {
        return this.decodableVersions.get(this.decodableVersions.size() - 1);
    }

    public String getMatchingDecodableVersion(Predicate<String> predicate) {
        for (String item : this.decodableVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDecodableVersion(Predicate<String> predicate) {
        for (String item : this.decodableVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDecodableVersions(List<String> decodableVersions) {
        if (decodableVersions != null) {
            this.decodableVersions = new ArrayList<String>();
            for (String item : decodableVersions) {
                this.addToDecodableVersions(item);
            }
        } else {
            this.decodableVersions = null;
        }
        return (A)((Object)this);
    }

    public A withDecodableVersions(String ... decodableVersions) {
        if (this.decodableVersions != null) {
            this.decodableVersions.clear();
            this._visitables.remove((Object)"decodableVersions");
        }
        if (decodableVersions != null) {
            for (String item : decodableVersions) {
                this.addToDecodableVersions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDecodableVersions() {
        return this.decodableVersions != null && !this.decodableVersions.isEmpty();
    }

    public String getEncodingVersion() {
        return this.encodingVersion;
    }

    public A withEncodingVersion(String encodingVersion) {
        this.encodingVersion = encodingVersion;
        return (A)((Object)this);
    }

    public boolean hasEncodingVersion() {
        return this.encodingVersion != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerStorageVersionFluent that = (ServerStorageVersionFluent)((Object)o);
        if (!Objects.equals(this.apiServerID, that.apiServerID)) {
            return false;
        }
        if (!Objects.equals(this.decodableVersions, that.decodableVersions)) {
            return false;
        }
        if (!Objects.equals(this.encodingVersion, that.encodingVersion)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiServerID, this.decodableVersions, this.encodingVersion, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiServerID != null) {
            sb.append("apiServerID:");
            sb.append(this.apiServerID + ",");
        }
        if (this.decodableVersions != null && !this.decodableVersions.isEmpty()) {
            sb.append("decodableVersions:");
            sb.append(this.decodableVersions + ",");
        }
        if (this.encodingVersion != null) {
            sb.append("encodingVersion:");
            sb.append(this.encodingVersion + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

