/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.impl.launcher.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kyuubi.shade.io.vertx.core.cli.annotations.Description;
import org.apache.kyuubi.shade.io.vertx.core.cli.annotations.Name;
import org.apache.kyuubi.shade.io.vertx.core.cli.annotations.Summary;
import org.apache.kyuubi.shade.io.vertx.core.impl.launcher.commands.ExecUtils;
import org.apache.kyuubi.shade.io.vertx.core.spi.launcher.DefaultCommand;

@Name(value="list")
@Summary(value="List vert.x applications")
@Description(value="List all vert.x applications launched with the `start` command")
public class ListCommand
extends DefaultCommand {
    private static final Pattern PS = Pattern.compile("-Dvertx.id=(.*)\\s*");
    private static final Pattern FAT_JAR_EXTRACTION = Pattern.compile("-jar (\\S*)");
    private static final Pattern VERTICLE_EXTRACTION = Pattern.compile("run (\\S*)");

    @Override
    public void run() {
        this.out.println("Listing vert.x applications...");
        ArrayList<String> cmd = new ArrayList<String>();
        if (!ExecUtils.isWindows()) {
            try {
                cmd.add("sh");
                cmd.add("-c");
                cmd.add("ps ax | grep \"vertx.id=\"");
                this.dumpFoundVertxApplications(cmd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace(this.out);
            }
            catch (Exception e) {
                e.printStackTrace(this.out);
            }
        } else {
            try {
                cmd.add("WMIC");
                cmd.add("PROCESS");
                cmd.add("WHERE");
                cmd.add("CommandLine like '%java.exe%'");
                cmd.add("GET");
                cmd.add("CommandLine");
                cmd.add("/VALUE");
                this.dumpFoundVertxApplications(cmd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace(this.out);
            }
            catch (Exception e) {
                e.printStackTrace(this.out);
            }
        }
    }

    private void dumpFoundVertxApplications(List<String> cmd) throws IOException, InterruptedException {
        boolean none = true;
        Process process = new ProcessBuilder(cmd).start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = PS.matcher(line);
                if (!matcher.find()) continue;
                String id = matcher.group(1);
                String details = ListCommand.extractApplicationDetails(line);
                this.out.println(id + "\t" + details);
                none = false;
            }
            process.waitFor();
        }
        if (none) {
            this.out.println("No vert.x application found.");
        }
    }

    protected static String extractApplicationDetails(String line) {
        Matcher matcher = FAT_JAR_EXTRACTION.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        matcher = VERTICLE_EXTRACTION.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }
}

