/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.watch;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kyuubi.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.shade.io.etcd.jetcd.ByteSequence;
import org.apache.kyuubi.shade.io.etcd.jetcd.KeyValue;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.Event;
import org.apache.kyuubi.shade.io.etcd.jetcd.impl.AbstractResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.watch.WatchEvent;

public class WatchResponse
extends AbstractResponse<org.apache.kyuubi.shade.io.etcd.jetcd.api.WatchResponse> {
    private List<WatchEvent> events;
    private final ByteSequence namespace;

    public WatchResponse(org.apache.kyuubi.shade.io.etcd.jetcd.api.WatchResponse response, ByteSequence namespace) {
        super(response, response.getHeader());
        this.namespace = namespace;
    }

    @VisibleForTesting
    public WatchResponse(org.apache.kyuubi.shade.io.etcd.jetcd.api.WatchResponse response) {
        this(response, ByteSequence.EMPTY);
    }

    private static WatchEvent toEvent(Event event, ByteSequence namespace) {
        WatchEvent.EventType eventType;
        switch (event.getType()) {
            case DELETE: {
                eventType = WatchEvent.EventType.DELETE;
                break;
            }
            case PUT: {
                eventType = WatchEvent.EventType.PUT;
                break;
            }
            default: {
                eventType = WatchEvent.EventType.UNRECOGNIZED;
            }
        }
        return new WatchEvent(new KeyValue(event.getKv(), namespace), new KeyValue(event.getPrevKv(), namespace), eventType);
    }

    public synchronized List<WatchEvent> getEvents() {
        if (this.events == null) {
            this.events = ((org.apache.kyuubi.shade.io.etcd.jetcd.api.WatchResponse)this.getResponse()).getEventsList().stream().map(event -> WatchResponse.toEvent(event, this.namespace)).collect(Collectors.toList());
        }
        return this.events;
    }

    public boolean isProgressNotify() {
        return WatchResponse.isProgressNotify((org.apache.kyuubi.shade.io.etcd.jetcd.api.WatchResponse)this.getResponse());
    }

    public static boolean isProgressNotify(org.apache.kyuubi.shade.io.etcd.jetcd.api.WatchResponse response) {
        return response.getEventsCount() == 0 && !response.getCreated() && !response.getCanceled() && response.getCompactRevision() == 0L && response.getHeader().getRevision() != 0L;
    }
}

