/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TTransport;

public final class PlainSaslHelper {
    public static TTransport getPlainTransport(String username, String password, TTransport underlyingTransport) throws SaslException {
        return new TSaslClientTransport("PLAIN", null, null, null, new HashMap(), (CallbackHandler)new PlainCallbackHandler(username, password), underlyingTransport);
    }

    private PlainSaslHelper() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static class PlainCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public PlainCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passCallback = (PasswordCallback)callback;
                    passCallback.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }
}

