/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.time.ZoneId;
import java.util.Objects;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

public class TimestampLocalTZTypeInfo
extends PrimitiveTypeInfo {
    private static final long serialVersionUID = 1L;
    private ZoneId timeZone;

    public TimestampLocalTZTypeInfo() {
        super("timestamp with local time zone");
    }

    public TimestampLocalTZTypeInfo(String timeZoneStr) {
        super("timestamp with local time zone");
        this.timeZone = TimestampTZUtil.parseTimeZone((String)timeZoneStr);
    }

    @Override
    public String getTypeName() {
        return "timestamp with local time zone";
    }

    @Override
    public void setTypeName(String typeName) {
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimestampLocalTZTypeInfo dti = (TimestampLocalTZTypeInfo)other;
        return this.timeZone().equals(dti.timeZone());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.typeName, this.timeZone);
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public String getQualifiedName() {
        return TimestampLocalTZTypeInfo.getQualifiedName(this.timeZone);
    }

    public static String getQualifiedName(ZoneId timeZone) {
        StringBuilder sb = new StringBuilder("timestamp with local time zone");
        sb.append("('");
        sb.append(timeZone);
        sb.append("')");
        return sb.toString();
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
    }
}

