/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.hive;

import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.time.Instant;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.hive.HiveSQLEngine;
import org.apache.kyuubi.engine.hive.events.HiveEngineEvent;
import org.apache.kyuubi.engine.hive.events.HiveEngineEvent$;
import org.apache.kyuubi.engine.hive.events.HiveEventHandlerRegister$;
import org.apache.kyuubi.events.EventBus$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.RetryPolicies$;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.util.SignalRegister$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class HiveSQLEngine$
implements Logging {
    public static HiveSQLEngine$ MODULE$;
    private Option<HiveSQLEngine> currentEngine;
    private final HiveConf hiveConf;
    private final KyuubiConf kyuubiConf;
    private final String user;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new HiveSQLEngine$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Option<HiveSQLEngine> currentEngine() {
        return this.currentEngine;
    }

    public void currentEngine_$eq(Option<HiveSQLEngine> x$1) {
        this.currentEngine = x$1;
    }

    public HiveConf hiveConf() {
        return this.hiveConf;
    }

    public KyuubiConf kyuubiConf() {
        return this.kyuubiConf;
    }

    public String user() {
        return this.user;
    }

    public void startEngine() {
        boolean isEmbeddedMetaStore;
        try {
            this.initLoggerEventHandler(this.kyuubiConf());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = option.get();
                this.warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to initialize Logger EventHandler: ").append(e.getMessage()).toString(), e);
            }
            throw throwable;
        }
        this.kyuubiConf().setIfMissing(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_BIND_PORT(), BoxesRunTime.boxToInteger(0));
        this.kyuubiConf().setIfMissing(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_RETRY_POLICY(), RetryPolicies$.MODULE$.N_TIME().toString());
        this.kyuubiConf().getAll().withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(HiveSQLEngine$.$anonfun$startEngine$2(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$1 -> {
            HiveSQLEngine$.$anonfun$startEngine$3(x$1);
            return BoxedUnit.UNIT;
        });
        String msUri = this.hiveConf().get("hive.metastore.uris");
        String msConnUrl = this.hiveConf().get("javax.jdo.option.ConnectionURL");
        boolean bl = isEmbeddedMetaStore = (msUri == null || msUri.trim().isEmpty()) && msConnUrl != null && msConnUrl.startsWith("jdbc:derby");
        if (isEmbeddedMetaStore) {
            this.hiveConf().setBoolean("hive.metastore.schema.verification", false);
            this.hiveConf().setBoolean("datanucleus.schema.autoCreateAll", true);
            this.hiveConf().set("hive.metastore.warehouse.dir", ((Object)Utils$.MODULE$.createTempDir("kyuubi_hive_warehouse", Utils$.MODULE$.createTempDir$default$2())).toString());
            this.hiveConf().set("hive.metastore.fastpath", "true");
        }
        HiveSQLEngine engine = new HiveSQLEngine();
        String appName = new StringBuilder(13).append("kyuubi_").append(this.user()).append("_hive_").append(Instant.now()).toString();
        this.hiveConf().setIfUnset("hive.engine.name", appName);
        this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Starting ").append(engine.getName()).toString());
        engine.initialize(this.kyuubiConf());
        EventBus$.MODULE$.post(HiveEngineEvent$.MODULE$.apply(engine));
        engine.start();
        HiveEngineEvent event = HiveEngineEvent$.MODULE$.apply(engine);
        this.info((Function0<Object>)(Function0<HiveEngineEvent> & Serializable & scala.Serializable)() -> event);
        EventBus$.MODULE$.post(event);
        Utils$.MODULE$.addShutdownHook(() -> engine.getServices().foreach((Function1<Service, Object> & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        }), Utils$.MODULE$.addShutdownHook$default$2());
        this.currentEngine_$eq(new Some<HiveSQLEngine>(engine));
    }

    private void initLoggerEventHandler(KyuubiConf conf) {
        HiveEventHandlerRegister$.MODULE$.registerEventLoggers(conf);
    }

    public void main(String[] args) {
        block5: {
            SignalRegister$.MODULE$.registerLogger(this.logger());
            try {
                UserGroupInformation realUser;
                Option<String> sessionUser;
                block7: {
                    block6: {
                        Utils$.MODULE$.fromCommandLineArgs(args, this.kyuubiConf());
                        sessionUser = this.kyuubiConf().getOption("kyuubi.session.user");
                        realUser = UserGroupInformation.getLoginUser();
                        if (sessionUser.isEmpty()) break block6;
                        String string = sessionUser.get();
                        String string2 = realUser.getShortUserName();
                        if (string != null ? !string.equals(string2) : string2 != null) break block7;
                    }
                    this.startEngine();
                    break block5;
                }
                UserGroupInformation effectiveUser = UserGroupInformation.createProxyUser((String)sessionUser.get(), (UserGroupInformation)realUser);
                effectiveUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BoxedUnit>(){

                    public void run() {
                        HiveSQLEngine$.MODULE$.startEngine();
                    }
                });
            }
            catch (Throwable t) {
                Option<HiveSQLEngine> option = this.currentEngine();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    HiveSQLEngine engine = (HiveSQLEngine)some.value();
                    engine.stop();
                    HiveEngineEvent qual$1 = HiveEngineEvent$.MODULE$.apply(engine);
                    long x$1 = System.currentTimeMillis();
                    String x$2 = t.getMessage();
                    String x$3 = qual$1.copy$default$1();
                    long x$4 = qual$1.copy$default$2();
                    Enumeration.Value x$5 = qual$1.copy$default$4();
                    Map<String, String> x$6 = qual$1.copy$default$6();
                    HiveEngineEvent event = qual$1.copy(x$3, x$4, x$1, x$5, x$2, x$6);
                    EventBus$.MODULE$.post(event);
                    break block5;
                }
                this.error((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Failed to start Hive SQL engine: ").append(t.getMessage()).append(".").toString(), t);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$startEngine$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$startEngine$3(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            MODULE$.hiveConf().set(k, v);
            return;
        }
        throw new MatchError(tuple2);
    }

    private HiveSQLEngine$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.currentEngine = None$.MODULE$;
        this.hiveConf = new HiveConf();
        this.kyuubiConf = new KyuubiConf(KyuubiConf$.MODULE$.$lessinit$greater$default$1());
        this.user = UserGroupInformation.getCurrentUser().getShortUserName();
    }
}

