/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.CephFSPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.kubernetes.api.model.SecretReferenceBuilder;
import io.fabric8.kubernetes.api.model.SecretReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CephFSPersistentVolumeSourceFluent<A extends CephFSPersistentVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private List<String> monitors = new ArrayList<String>();
    private String path;
    private Boolean readOnly;
    private String secretFile;
    private SecretReferenceBuilder secretRef;
    private String user;
    private Map<String, Object> additionalProperties;

    public CephFSPersistentVolumeSourceFluent() {
    }

    public CephFSPersistentVolumeSourceFluent(CephFSPersistentVolumeSource instance) {
        CephFSPersistentVolumeSource cephFSPersistentVolumeSource = instance = instance != null ? instance : new CephFSPersistentVolumeSource();
        if (instance != null) {
            this.withMonitors(instance.getMonitors());
            this.withPath(instance.getPath());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretFile(instance.getSecretFile());
            this.withSecretRef(instance.getSecretRef());
            this.withUser(instance.getUser());
            this.withMonitors(instance.getMonitors());
            this.withPath(instance.getPath());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretFile(instance.getSecretFile());
            this.withSecretRef(instance.getSecretRef());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToMonitors(int index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.add(index, item);
        return (A)this;
    }

    public A setToMonitors(int index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.set(index, item);
        return (A)this;
    }

    public A addToMonitors(String ... items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    public A addAllToMonitors(Collection<String> items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    public A removeFromMonitors(String ... items) {
        if (this.monitors == null) {
            return (A)this;
        }
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromMonitors(Collection<String> items) {
        if (this.monitors == null) {
            return (A)this;
        }
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (A)this;
    }

    public List<String> getMonitors() {
        return this.monitors;
    }

    public String getMonitor(int index) {
        return this.monitors.get(index);
    }

    public String getFirstMonitor() {
        return this.monitors.get(0);
    }

    public String getLastMonitor() {
        return this.monitors.get(this.monitors.size() - 1);
    }

    public String getMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMonitors(List<String> monitors) {
        if (monitors != null) {
            this.monitors = new ArrayList<String>();
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        } else {
            this.monitors = null;
        }
        return (A)this;
    }

    public A withMonitors(String ... monitors) {
        if (this.monitors != null) {
            this.monitors.clear();
            this._visitables.remove("monitors");
        }
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (A)this;
    }

    public boolean hasMonitors() {
        return this.monitors != null && !this.monitors.isEmpty();
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public String getSecretFile() {
        return this.secretFile;
    }

    public A withSecretFile(String secretFile) {
        this.secretFile = secretFile;
        return (A)this;
    }

    public boolean hasSecretFile() {
        return this.secretFile != null;
    }

    public SecretReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(String name, String namespace) {
        return this.withSecretRef(new SecretReference(name, namespace));
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(SecretReference item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretReferenceBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(SecretReference item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CephFSPersistentVolumeSourceFluent that = (CephFSPersistentVolumeSourceFluent)o;
        if (!Objects.equals(this.monitors, that.monitors)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.secretFile, that.secretFile)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, that.secretRef)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.monitors, this.path, this.readOnly, this.secretFile, this.secretRef, this.user, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.monitors != null && !this.monitors.isEmpty()) {
            sb.append("monitors:");
            sb.append(this.monitors + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretFile != null) {
            sb.append("secretFile:");
            sb.append(this.secretFile + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class SecretRefNested<N>
    extends SecretReferenceFluent<SecretRefNested<N>>
    implements Nested<N> {
        SecretReferenceBuilder builder;

        SecretRefNested(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CephFSPersistentVolumeSourceFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }
}

