/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.flowcontrol.v1beta3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.LimitResponse;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.LimitResponseBuilder;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.LimitResponseFluent;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta3.LimitedPriorityLevelConfiguration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LimitedPriorityLevelConfigurationFluent<A extends LimitedPriorityLevelConfigurationFluent<A>>
extends BaseFluent<A> {
    private Integer borrowingLimitPercent;
    private Integer lendablePercent;
    private LimitResponseBuilder limitResponse;
    private Integer nominalConcurrencyShares;
    private Map<String, Object> additionalProperties;

    public LimitedPriorityLevelConfigurationFluent() {
    }

    public LimitedPriorityLevelConfigurationFluent(LimitedPriorityLevelConfiguration instance) {
        LimitedPriorityLevelConfiguration limitedPriorityLevelConfiguration = instance = instance != null ? instance : new LimitedPriorityLevelConfiguration();
        if (instance != null) {
            this.withBorrowingLimitPercent(instance.getBorrowingLimitPercent());
            this.withLendablePercent(instance.getLendablePercent());
            this.withLimitResponse(instance.getLimitResponse());
            this.withNominalConcurrencyShares(instance.getNominalConcurrencyShares());
            this.withBorrowingLimitPercent(instance.getBorrowingLimitPercent());
            this.withLendablePercent(instance.getLendablePercent());
            this.withLimitResponse(instance.getLimitResponse());
            this.withNominalConcurrencyShares(instance.getNominalConcurrencyShares());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getBorrowingLimitPercent() {
        return this.borrowingLimitPercent;
    }

    public A withBorrowingLimitPercent(Integer borrowingLimitPercent) {
        this.borrowingLimitPercent = borrowingLimitPercent;
        return (A)((Object)this);
    }

    public boolean hasBorrowingLimitPercent() {
        return this.borrowingLimitPercent != null;
    }

    public Integer getLendablePercent() {
        return this.lendablePercent;
    }

    public A withLendablePercent(Integer lendablePercent) {
        this.lendablePercent = lendablePercent;
        return (A)((Object)this);
    }

    public boolean hasLendablePercent() {
        return this.lendablePercent != null;
    }

    public LimitResponse buildLimitResponse() {
        return this.limitResponse != null ? this.limitResponse.build() : null;
    }

    public A withLimitResponse(LimitResponse limitResponse) {
        this._visitables.get((Object)"limitResponse").remove((Object)this.limitResponse);
        if (limitResponse != null) {
            this.limitResponse = new LimitResponseBuilder(limitResponse);
            this._visitables.get((Object)"limitResponse").add(this.limitResponse);
        } else {
            this.limitResponse = null;
            this._visitables.get((Object)"limitResponse").remove((Object)this.limitResponse);
        }
        return (A)((Object)this);
    }

    public boolean hasLimitResponse() {
        return this.limitResponse != null;
    }

    public LimitResponseNested<A> withNewLimitResponse() {
        return new LimitResponseNested(null);
    }

    public LimitResponseNested<A> withNewLimitResponseLike(LimitResponse item) {
        return new LimitResponseNested(item);
    }

    public LimitResponseNested<A> editLimitResponse() {
        return this.withNewLimitResponseLike(Optional.ofNullable(this.buildLimitResponse()).orElse(null));
    }

    public LimitResponseNested<A> editOrNewLimitResponse() {
        return this.withNewLimitResponseLike(Optional.ofNullable(this.buildLimitResponse()).orElse(new LimitResponseBuilder().build()));
    }

    public LimitResponseNested<A> editOrNewLimitResponseLike(LimitResponse item) {
        return this.withNewLimitResponseLike(Optional.ofNullable(this.buildLimitResponse()).orElse(item));
    }

    public Integer getNominalConcurrencyShares() {
        return this.nominalConcurrencyShares;
    }

    public A withNominalConcurrencyShares(Integer nominalConcurrencyShares) {
        this.nominalConcurrencyShares = nominalConcurrencyShares;
        return (A)((Object)this);
    }

    public boolean hasNominalConcurrencyShares() {
        return this.nominalConcurrencyShares != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitedPriorityLevelConfigurationFluent that = (LimitedPriorityLevelConfigurationFluent)((Object)o);
        if (!Objects.equals(this.borrowingLimitPercent, that.borrowingLimitPercent)) {
            return false;
        }
        if (!Objects.equals(this.lendablePercent, that.lendablePercent)) {
            return false;
        }
        if (!Objects.equals((Object)this.limitResponse, (Object)that.limitResponse)) {
            return false;
        }
        if (!Objects.equals(this.nominalConcurrencyShares, that.nominalConcurrencyShares)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.borrowingLimitPercent, this.lendablePercent, this.limitResponse, this.nominalConcurrencyShares, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.borrowingLimitPercent != null) {
            sb.append("borrowingLimitPercent:");
            sb.append(this.borrowingLimitPercent + ",");
        }
        if (this.lendablePercent != null) {
            sb.append("lendablePercent:");
            sb.append(this.lendablePercent + ",");
        }
        if (this.limitResponse != null) {
            sb.append("limitResponse:");
            sb.append((Object)((Object)this.limitResponse) + ",");
        }
        if (this.nominalConcurrencyShares != null) {
            sb.append("nominalConcurrencyShares:");
            sb.append(this.nominalConcurrencyShares + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LimitResponseNested<N>
    extends LimitResponseFluent<LimitResponseNested<N>>
    implements Nested<N> {
        LimitResponseBuilder builder;

        LimitResponseNested(LimitResponse item) {
            this.builder = new LimitResponseBuilder(this, item);
        }

        public N and() {
            return (N)LimitedPriorityLevelConfigurationFluent.this.withLimitResponse(this.builder.build());
        }

        public N endLimitResponse() {
            return this.and();
        }
    }
}

