/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.zookeeper.server;

import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.kyuubi.shade.org.apache.zookeeper.Login;
import org.apache.kyuubi.shade.org.apache.zookeeper.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperSaslServer {
    public static final String LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.serverconfig";
    public static final String DEFAULT_LOGIN_CONTEXT_NAME = "Server";
    Logger LOG = LoggerFactory.getLogger(ZooKeeperSaslServer.class);
    private SaslServer saslServer;

    ZooKeeperSaslServer(Login login) {
        this.saslServer = this.createSaslServer(login);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaslServer createSaslServer(Login login) {
        Login login2 = login;
        synchronized (login2) {
            Subject subject = login.getSubject();
            return SecurityUtils.createSaslServer(subject, "zookeeper", "zk-sasl-md5", login.callbackHandler, this.LOG);
        }
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.saslServer.evaluateResponse(response);
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public String getAuthorizationID() {
        return this.saslServer.getAuthorizationID();
    }
}

