/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha.client.etcd;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClient$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceDiscovery;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.ha.client.etcd.EtcdDiscoveryClient$;
import org.apache.kyuubi.ha.client.etcd.EtcdDiscoveryClient$ServiceNode$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.shade.io.etcd.jetcd.ByteSequence;
import org.apache.kyuubi.shade.io.etcd.jetcd.Client;
import org.apache.kyuubi.shade.io.etcd.jetcd.KV;
import org.apache.kyuubi.shade.io.etcd.jetcd.KeyValue;
import org.apache.kyuubi.shade.io.etcd.jetcd.Lease;
import org.apache.kyuubi.shade.io.etcd.jetcd.Lock;
import org.apache.kyuubi.shade.io.etcd.jetcd.Watch;
import org.apache.kyuubi.shade.io.etcd.jetcd.kv.GetResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.kv.PutResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.DeleteOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.GetOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.PutOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.watch.WatchEvent;
import org.apache.kyuubi.shade.io.etcd.jetcd.watch.WatchResponse;
import org.apache.kyuubi.shade.io.grpc.netty.GrpcSslContexts;
import org.apache.kyuubi.shade.io.grpc.stub.StreamObserver;
import org.apache.kyuubi.shade.io.netty.handler.ssl.SslContext;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011Eb\u0001B/_\u0001-D\u0001B\u001e\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\u0006{\u0002!\tA \u0004\u0007\u0003\u000b\u0001\u0001)a\u0002\t\u0015\u0005U1A!f\u0001\n\u0003\t9\u0002\u0003\u0006\u00020\r\u0011\t\u0012)A\u0005\u00033A!\"!\r\u0004\u0005+\u0007I\u0011AA\u001a\u0011)\tYd\u0001B\tB\u0003%\u0011Q\u0007\u0005\u0007{\u000e!\t!!\u0010\t\u0013\u0005\u001d3!!A\u0005\u0002\u0005%\u0003\"CA(\u0007E\u0005I\u0011AA)\u0011%\t9gAI\u0001\n\u0003\tI\u0007C\u0005\u0002n\r\t\t\u0011\"\u0011\u0002p!I\u0011qP\u0002\u0002\u0002\u0013\u0005\u0011\u0011\u0011\u0005\n\u0003\u0013\u001b\u0011\u0011!C\u0001\u0003\u0017C\u0011\"a&\u0004\u0003\u0003%\t%!'\t\u0013\u0005\u001d6!!A\u0005\u0002\u0005%\u0006\"CAZ\u0007\u0005\u0005I\u0011IA[\u0011%\t9lAA\u0001\n\u0003\nI\fC\u0005\u0002<\u000e\t\t\u0011\"\u0011\u0002>\u001eI\u0011\u0011\u0019\u0001\u0002\u0002#\u0005\u00111\u0019\u0004\n\u0003\u000b\u0001\u0011\u0011!E\u0001\u0003\u000bDa!`\u000b\u0005\u0002\u0005M\u0007\"CA\\+\u0005\u0005IQIA]\u0011%\t).FA\u0001\n\u0003\u000b9\u000eC\u0005\u0002^V\t\t\u0011\"!\u0002`\"Q\u0011\r\u0001a\u0001\u0002\u0004%\t!!=\t\u0017\t\u0015\u0001\u00011AA\u0002\u0013\u0005!q\u0001\u0005\f\u0005#\u0001\u0001\u0019!A!B\u0013\t\u0019\u0010C\u0006\u0003\u0014\u0001\u0001\r\u00111A\u0005\u0002\tU\u0001b\u0003B\u000f\u0001\u0001\u0007\t\u0019!C\u0001\u0005?A1Ba\t\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0018!Y!Q\u0005\u0001A\u0002\u0003\u0007I\u0011\u0001B\u0014\u0011-\u0011y\u0003\u0001a\u0001\u0002\u0004%\tA!\r\t\u0017\tU\u0002\u00011A\u0001B\u0003&!\u0011\u0006\u0005\f\u0005o\u0001\u0001\u0019!a\u0001\n\u0003\u0011I\u0004C\u0006\u0003B\u0001\u0001\r\u00111A\u0005\u0002\t\r\u0003b\u0003B$\u0001\u0001\u0007\t\u0011)Q\u0005\u0005wA1B!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003L!Y!Q\n\u0001A\u0002\u0003\u0007I\u0011\u0001B(\u0011-\u0011\u0019\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u0010\t\u0017\tU\u0003\u00011AA\u0002\u0013\u0005\u00111\u0007\u0005\f\u0005/\u0002\u0001\u0019!a\u0001\n\u0003\u0011I\u0006C\u0006\u0003^\u0001\u0001\r\u0011!Q!\n\u0005U\u0002b\u0002B0\u0001\u0011%!\u0011\r\u0005\b\u0005G\u0002A\u0011\tB3\u0011\u001d\u00119\u0007\u0001C!\u0005KBqA!\u001b\u0001\t\u0003\u0012Y\u0007C\u0005\u0003x\u0001\t\n\u0011\"\u0001\u0003z!9!Q\u0010\u0001\u0005B\t}\u0004b\u0002BH\u0001\u0011\u0005#\u0011\u0013\u0005\b\u00053\u0003A\u0011\tBN\u0011\u001d\u0011\t\f\u0001C!\u0005gCqAa.\u0001\t\u0003\u0012I\fC\u0004\u0003>\u0002!\tEa0\t\u0013\t\u001d\u0007!%A\u0005\u0002\te\u0004b\u0002Be\u0001\u0011\u0005#1\u001a\u0005\b\u0005/\u0004A\u0011\tBm\u0011\u001d\u0019\t\u0001\u0001C!\u0007\u0007Aqa!\u0004\u0001\t\u0003\u001ay\u0001C\u0004\u0004\u0018\u0001!\te!\u0007\t\u0013\rM\u0002!%A\u0005\u0002\rU\u0002\"CB\u001d\u0001E\u0005I\u0011\u0001B=\u0011\u001d\u0019Y\u0004\u0001C!\u0007{A\u0011ba\u0014\u0001#\u0003%\ta!\u0015\t\u0013\rU\u0003!%A\u0005\u0002\te\u0004bBB,\u0001\u0011\u0005#Q\r\u0005\b\u00073\u0002A\u0011IB.\u0011\u001d\u0019y\u0006\u0001C!\u0007CB\u0011ba\u001c\u0001#\u0003%\ta!\u0015\t\u0013\rE\u0004!%A\u0005\u0002\te\u0004bBB:\u0001\u0011\u00053Q\u000f\u0005\n\u0007C\u0003\u0011\u0013!C\u0001\u0005sBqaa)\u0001\t\u0003\u001a)\u000bC\u0005\u0004.\u0002\t\n\u0011\"\u0001\u00040\"911\u0017\u0001\u0005\n\rU\u0006\"CBf\u0001E\u0005I\u0011BB)\u0011%\u0019i\rAI\u0001\n\u0013\u0011I\bC\u0005\u0004P\u0002\t\n\u0011\"\u0003\u0004R\u001a11Q\u001b\u0001\u0001\u0007/D!b!\u001bP\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\u0011ym\u0014B\u0001B\u0003%!\u0011\u001b\u0005\u0007{>#\ta!<\t\u000f\rUx\n\"\u0011\u0004x\"9A\u0011B(\u0005B\u0011-\u0001b\u0002C\f\u001f\u0012\u0005#QM\u0004\b\t3q\u0006\u0012\u0001C\u000e\r\u0019if\f#\u0001\u0005\u001e!1Qp\u0016C\u0001\t?A\u0011\u0002\"\tX\u0005\u0004%i!a\r\t\u0011\u0011\rr\u000b)A\u0007\u0003kA!\u0002\"\nX\u0005\u0004%)A\u0018C\u0014\u0011!!yc\u0016Q\u0001\u000e\u0011%\"aE#uG\u0012$\u0015n]2pm\u0016\u0014\u0018p\u00117jK:$(BA0a\u0003\u0011)Go\u00193\u000b\u0005\u0005\u0014\u0017AB2mS\u0016tGO\u0003\u0002dI\u0006\u0011\u0001.\u0019\u0006\u0003K\u001a\faa[=vk\nL'BA4i\u0003\u0019\t\u0007/Y2iK*\t\u0011.A\u0002pe\u001e\u001c\u0001aE\u0002\u0001YJ\u0004\"!\u001c9\u000e\u00039T\u0011a\\\u0001\u0006g\u000e\fG.Y\u0005\u0003c:\u0014a!\u00118z%\u00164\u0007CA:u\u001b\u0005\u0001\u0017BA;a\u0005=!\u0015n]2pm\u0016\u0014\u0018p\u00117jK:$\u0018\u0001B2p]\u001a\u0004\"\u0001_>\u000e\u0003eT!A\u001f3\u0002\r\r|gNZ5h\u0013\ta\u0018P\u0001\u0006LsV,(-[\"p]\u001a\fa\u0001P5oSRtDcA@\u0002\u0004A\u0019\u0011\u0011\u0001\u0001\u000e\u0003yCQA\u001e\u0002A\u0002]\u00141bU3sm&\u001cWMT8eKN11\u0001\\A\u0005\u0003\u001f\u00012!\\A\u0006\u0013\r\tiA\u001c\u0002\b!J|G-^2u!\ri\u0017\u0011C\u0005\u0004\u0003'q'\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00029bi\",\"!!\u0007\u0011\t\u0005m\u0011\u0011\u0006\b\u0005\u0003;\t)\u0003E\u0002\u0002 9l!!!\t\u000b\u0007\u0005\r\".\u0001\u0004=e>|GOP\u0005\u0004\u0003Oq\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002,\u00055\"AB*ue&twMC\u0002\u0002(9\fQ\u0001]1uQ\u0002\nQ\u0001\\3bg\u0016,\"!!\u000e\u0011\u00075\f9$C\u0002\u0002:9\u0014A\u0001T8oO\u00061A.Z1tK\u0002\"b!a\u0010\u0002D\u0005\u0015\u0003cAA!\u00075\t\u0001\u0001C\u0004\u0002\u0016!\u0001\r!!\u0007\t\u000f\u0005E\u0002\u00021\u0001\u00026\u0005!1m\u001c9z)\u0019\ty$a\u0013\u0002N!I\u0011QC\u0005\u0011\u0002\u0003\u0007\u0011\u0011\u0004\u0005\n\u0003cI\u0001\u0013!a\u0001\u0003k\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002T)\"\u0011\u0011DA+W\t\t9\u0006\u0005\u0003\u0002Z\u0005\rTBAA.\u0015\u0011\ti&a\u0018\u0002\u0013Ut7\r[3dW\u0016$'bAA1]\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00141\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003WRC!!\u000e\u0002V\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u001d\u0011\t\u0005M\u0014QP\u0007\u0003\u0003kRA!a\u001e\u0002z\u0005!A.\u00198h\u0015\t\tY(\u0001\u0003kCZ\f\u0017\u0002BA\u0016\u0003k\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a!\u0011\u00075\f))C\u0002\u0002\b:\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!$\u0002\u0014B\u0019Q.a$\n\u0007\u0005EeNA\u0002B]fD\u0011\"!&\u000f\u0003\u0003\u0005\r!a!\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\n\u0005\u0004\u0002\u001e\u0006\r\u0016QR\u0007\u0003\u0003?S1!!)o\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\u000byJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAV\u0003c\u00032!\\AW\u0013\r\tyK\u001c\u0002\b\u0005>|G.Z1o\u0011%\t)\nEA\u0001\u0002\u0004\ti)\u0001\u0005iCND7i\u001c3f)\t\t\u0019)\u0001\u0005u_N#(/\u001b8h)\t\t\t(\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003W\u000by\fC\u0005\u0002\u0016N\t\t\u00111\u0001\u0002\u000e\u0006Y1+\u001a:wS\u000e,gj\u001c3f!\r\t\t%F\n\u0006+\u0005\u001d\u0017q\u0002\t\u000b\u0003\u0013\fy-!\u0007\u00026\u0005}RBAAf\u0015\r\tiM\\\u0001\beVtG/[7f\u0013\u0011\t\t.a3\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002D\u0006)\u0011\r\u001d9msR1\u0011qHAm\u00037Dq!!\u0006\u0019\u0001\u0004\tI\u0002C\u0004\u00022a\u0001\r!!\u000e\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011]Aw!\u0015i\u00171]At\u0013\r\t)O\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f5\fI/!\u0007\u00026%\u0019\u00111\u001e8\u0003\rQ+\b\u000f\\33\u0011%\ty/GA\u0001\u0002\u0004\ty$A\u0002yIA*\"!a=\u0011\t\u0005U(\u0011A\u0007\u0003\u0003oTA!!?\u0002|\u0006)!.\u001a;dI*\u0019q,!@\u000b\u0005\u0005}\u0018AA5p\u0013\u0011\u0011\u0019!a>\u0003\r\rc\u0017.\u001a8u\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0005\u0005\u0013\u0011y\u0001E\u0002n\u0005\u0017I1A!\u0004o\u0005\u0011)f.\u001b;\t\u0013\u0005U5$!AA\u0002\u0005M\u0018aB2mS\u0016tG\u000fI\u0001\tWZ\u001cE.[3oiV\u0011!q\u0003\t\u0005\u0003k\u0014I\"\u0003\u0003\u0003\u001c\u0005](AA&W\u00031Ygo\u00117jK:$x\fJ3r)\u0011\u0011IA!\t\t\u0013\u0005Ue$!AA\u0002\t]\u0011!C6w\u00072LWM\u001c;!\u0003)awnY6DY&,g\u000e^\u000b\u0003\u0005S\u0001B!!>\u0003,%!!QFA|\u0005\u0011aunY6\u0002\u001d1|7m[\"mS\u0016tGo\u0018\u0013fcR!!\u0011\u0002B\u001a\u0011%\t)*IA\u0001\u0002\u0004\u0011I#A\u0006m_\u000e\\7\t\\5f]R\u0004\u0013a\u00037fCN,7\t\\5f]R,\"Aa\u000f\u0011\t\u0005U(QH\u0005\u0005\u0005\u007f\t9PA\u0003MK\u0006\u001cX-A\bmK\u0006\u001cXm\u00117jK:$x\fJ3r)\u0011\u0011IA!\u0012\t\u0013\u0005UE%!AA\u0002\tm\u0012\u0001\u00047fCN,7\t\\5f]R\u0004\u0013aC:feZL7-\u001a(pI\u0016,\"!a\u0010\u0002\u001fM,'O^5dK:{G-Z0%KF$BA!\u0003\u0003R!I\u0011QS\u0014\u0002\u0002\u0003\u0007\u0011qH\u0001\rg\u0016\u0014h/[2f\u001d>$W\rI\u0001\tY\u0016\f7/\u001a+U\u0019\u0006aA.Z1tKR#Fj\u0018\u0013fcR!!\u0011\u0002B.\u0011%\t)JKA\u0001\u0002\u0004\t)$A\u0005mK\u0006\u001cX\r\u0016+MA\u0005Y!-^5mI\u000ec\u0017.\u001a8u)\t\t\u00190\u0001\u0007de\u0016\fG/Z\"mS\u0016tG\u000f\u0006\u0002\u0003\n\u0005Y1\r\\8tK\u000ec\u0017.\u001a8u\u0003\u0019\u0019'/Z1uKRA\u0011\u0011\u0004B7\u0005_\u0012\u0019\bC\u0004\u0002\u0016=\u0002\r!!\u0007\t\u000f\tEt\u00061\u0001\u0002\u001a\u0005!Qn\u001c3f\u0011%\u0011)h\fI\u0001\u0002\u0004\tY+\u0001\u0007de\u0016\fG/\u001a)be\u0016tG/\u0001\tde\u0016\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0010\u0016\u0005\u0003W\u000b)&A\u0004hKR$\u0015\r^1\u0015\t\t\u0005%Q\u0012\t\u0006[\n\r%qQ\u0005\u0004\u0005\u000bs'!B!se\u0006L\bcA7\u0003\n&\u0019!1\u00128\u0003\t\tKH/\u001a\u0005\b\u0003+\t\u0004\u0019AA\r\u0003\u001d\u0019X\r\u001e#bi\u0006$b!a+\u0003\u0014\nU\u0005bBA\u000be\u0001\u0007\u0011\u0011\u0004\u0005\b\u0005/\u0013\u0004\u0019\u0001BA\u0003\u0011!\u0017\r^1\u0002\u0017\u001d,Go\u00115jY\u0012\u0014XM\u001c\u000b\u0005\u0005;\u0013y\u000b\u0005\u0004\u0003 \n%\u0016\u0011\u0004\b\u0005\u0005C\u0013)K\u0004\u0003\u0002 \t\r\u0016\"A8\n\u0007\t\u001df.A\u0004qC\u000e\\\u0017mZ3\n\t\t-&Q\u0016\u0002\u0005\u0019&\u001cHOC\u0002\u0003(:Dq!!\u00064\u0001\u0004\tI\"\u0001\u0006qCRDW\t_5tiN$B!a+\u00036\"9\u0011Q\u0003\u001bA\u0002\u0005e\u0011!\u00049bi\"tuN\\#ySN$8\u000f\u0006\u0003\u0002,\nm\u0006bBA\u000bk\u0001\u0007\u0011\u0011D\u0001\u0007I\u0016dW\r^3\u0015\r\t%!\u0011\u0019Bb\u0011\u001d\t)B\u000ea\u0001\u00033A\u0011B!27!\u0003\u0005\r!a+\u0002\u001d\u0011,G.\u001a;f\u0007\"LG\u000e\u001a:f]\u0006\u0001B-\u001a7fi\u0016$C-\u001a4bk2$HEM\u0001\r[>t\u0017\u000e^8s'R\fG/\u001a\u000b\u0005\u0005\u0013\u0011i\rC\u0004\u0003Pb\u0002\rA!5\u0002!M,'O^5dK\u0012K7oY8wKJL\bcA:\u0003T&\u0019!Q\u001b1\u0003!M+'O^5dK\u0012K7oY8wKJL\u0018a\u0003;ss^KG\u000f\u001b'pG.,BAa7\u0003dR1!Q\u001cB}\u0005{$BAa8\u0003pB!!\u0011\u001dBr\u0019\u0001!qA!::\u0005\u0004\u00119OA\u0001U#\u0011\u0011I/!$\u0011\u00075\u0014Y/C\u0002\u0003n:\u0014qAT8uQ&tw\r\u0003\u0005\u0003rf\"\t\u0019\u0001Bz\u0003\u00051\u0007#B7\u0003v\n}\u0017b\u0001B|]\nAAHY=oC6,g\bC\u0004\u0003|f\u0002\r!!\u0007\u0002\u00111|7m\u001b)bi\"DqAa@:\u0001\u0004\t)$A\u0004uS6,w.\u001e;\u0002\u001b\u001d,GoU3sm\u0016\u0014\bj\\:u)\u0011\u0019)a!\u0003\u0011\u000b5\f\u0019oa\u0002\u0011\u000f5\fI/!\u0007\u0002\u0004\"911\u0002\u001eA\u0002\u0005e\u0011!\u00038b[\u0016\u001c\b/Y2f\u0003A9W\r^#oO&tWMQ=SK\u001aLE\r\u0006\u0004\u0004\u0006\rE11\u0003\u0005\b\u0007\u0017Y\u0004\u0019AA\r\u0011\u001d\u0019)b\u000fa\u0001\u00033\t1\"\u001a8hS:,'+\u001a4JI\u0006\u0019r-\u001a;TKJ4\u0018nY3O_\u0012,7/\u00138g_RA11DB\u0014\u0007S\u0019y\u0003\u0005\u0004\u0003 \u000eu1\u0011E\u0005\u0005\u0007?\u0011iKA\u0002TKF\u00042a]B\u0012\u0013\r\u0019)\u0003\u0019\u0002\u0010'\u0016\u0014h/[2f\u001d>$W-\u00138g_\"911\u0002\u001fA\u0002\u0005e\u0001\"CB\u0016yA\u0005\t\u0019AB\u0017\u0003\u001d\u0019\u0018N_3PaR\u0004R!\\Ar\u0003\u0007C\u0011b!\r=!\u0003\u0005\r!a+\u0002\rMLG.\u001a8u\u0003u9W\r^*feZL7-\u001a(pI\u0016\u001c\u0018J\u001c4pI\u0011,g-Y;mi\u0012\u0012TCAB\u001cU\u0011\u0019i#!\u0016\u0002;\u001d,GoU3sm&\u001cWMT8eKNLeNZ8%I\u00164\u0017-\u001e7uIM\nqB]3hSN$XM]*feZL7-\u001a\u000b\r\u0005\u0013\u0019yd!\u0011\u0004D\r\u001531\n\u0005\u0006m~\u0002\ra\u001e\u0005\b\u0007\u0017y\u0004\u0019AA\r\u0011\u001d\u0011ym\u0010a\u0001\u0005#D\u0011ba\u0012@!\u0003\u0005\ra!\u0013\u0002\u000fY,'o]5p]B)Q.a9\u0002\u001a!I1QJ \u0011\u0002\u0003\u0007\u00111V\u0001\tKb$XM\u001d8bY\u0006I\"/Z4jgR,'oU3sm&\u001cW\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\u0019F\u000b\u0003\u0004J\u0005U\u0013!\u0007:fO&\u001cH/\u001a:TKJ4\u0018nY3%I\u00164\u0017-\u001e7uIU\n\u0011\u0003Z3sK\u001eL7\u000f^3s'\u0016\u0014h/[2f\u0003U\u0001xn\u001d;EKJ,w-[:uKJ\u001cVM\u001d<jG\u0016$B!a+\u0004^!911B\"A\u0002\u0005e\u0011aF2sK\u0006$X-\u00118e\u000f\u0016$8+\u001a:wS\u000e,gj\u001c3f)1\tIba\u0019\u0004f\r\u001d41NB7\u0011\u00151H\t1\u0001x\u0011\u001d\u0019Y\u0001\u0012a\u0001\u00033Aqa!\u001bE\u0001\u0004\tI\"\u0001\u0005j]N$\u0018M\\2f\u0011%\u00199\u0005\u0012I\u0001\u0002\u0004\u0019I\u0005C\u0005\u0004N\u0011\u0003\n\u00111\u0001\u0002,\u0006\t3M]3bi\u0016\fe\u000eZ$fiN+'O^5dK:{G-\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005\t3M]3bi\u0016\fe\u000eZ$fiN+'O^5dK:{G-\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u0005y1\u000f^1siN+7M]3u\u001d>$W\r\u0006\u0006\u0003\n\r]41PB@\u0007\u0007Cqa!\u001fH\u0001\u0004\tI\"\u0001\u0006de\u0016\fG/Z'pI\u0016Dqa! H\u0001\u0004\tI\"\u0001\u0005cCN,\u0007+\u0019;i\u0011\u001d\u0019\ti\u0012a\u0001\u00033\t\u0001\"\u001b8ji\u0012\u000bG/\u0019\u0005\n\u0007\u000b;\u0005\u0013!a\u0001\u0003W\u000bQ\"^:f!J|G/Z2uS>t\u0007fA$\u0004\nB!11RBO\u001b\t\u0019iI\u0003\u0003\u0004\u0010\u000eE\u0015aC1o]>$\u0018\r^5p]NTAaa%\u0004\u0016\u000611m\\7n_:TAaa&\u0004\u001a\u00061qm\\8hY\u0016T!aa'\u0002\u0007\r|W.\u0003\u0003\u0004 \u000e5%!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\u0006I2\u000f^1siN+7M]3u\u001d>$W\r\n3fM\u0006,H\u000e\u001e\u00135\u0003=9W\r^!oI&s7M]3nK:$HCBAB\u0007O\u001bI\u000bC\u0004\u0002\u0016%\u0003\r!!\u0007\t\u0013\r-\u0016\n%AA\u0002\u0005\r\u0015!\u00023fYR\f\u0017!G4fi\u0006sG-\u00138de\u0016lWM\u001c;%I\u00164\u0017-\u001e7uII*\"a!-+\t\u0005\r\u0015QK\u0001\u0015GJ,\u0017\r^3QKJ\u001c\u0018n\u001d;f]Rtu\u000eZ3\u0015\u001d\u0005}2qWB]\u0007w\u001bila0\u0004B\")ao\u0013a\u0001o\"911B&A\u0002\u0005e\u0001bBB5\u0017\u0002\u0007\u0011\u0011\u0004\u0005\n\u0007\u000fZ\u0005\u0013!a\u0001\u0007\u0013B\u0011b!\u0014L!\u0003\u0005\r!a+\t\u0013\r\r7\n%AA\u0002\r\u0015\u0017AC1uiJL'-\u001e;fgBA\u00111DBd\u00033\tI\"\u0003\u0003\u0004J\u00065\"aA'ba\u0006q2M]3bi\u0016\u0004VM]:jgR,g\u000e\u001e(pI\u0016$C-\u001a4bk2$H\u0005N\u0001\u001fGJ,\u0017\r^3QKJ\u001c\u0018n\u001d;f]Rtu\u000eZ3%I\u00164\u0017-\u001e7uIU\nad\u0019:fCR,\u0007+\u001a:tSN$XM\u001c;O_\u0012,G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\rM'\u0006BBc\u0003+\u0012\u0011\u0003R3SK\u001eL7\u000f^3s/\u0006$8\r[3s'\u0015y5\u0011\\Bp!\u0011\t\u0019ha7\n\t\ru\u0017Q\u000f\u0002\u0007\u001f\nTWm\u0019;\u0011\t\r\u00058q\u001d\b\u0005\u0003k\u001c\u0019/\u0003\u0003\u0004f\u0006]\u0018!B,bi\u000eD\u0017\u0002BBu\u0007W\u0014\u0001\u0002T5ti\u0016tWM\u001d\u0006\u0005\u0007K\f9\u0010\u0006\u0004\u0004p\u000eE81\u001f\t\u0004\u0003\u0003z\u0005bBB5%\u0002\u0007\u0011\u0011\u0004\u0005\b\u0005\u001f\u0014\u0006\u0019\u0001Bi\u0003\u0019ygNT3yiR!!\u0011BB}\u0011\u001d\u0019Yp\u0015a\u0001\u0007{\fQb^1uG\"\u0014Vm\u001d9p]N,\u0007\u0003BB\u0000\t\u000bi!\u0001\"\u0001\u000b\t\u0011\r\u0011q_\u0001\u0006o\u0006$8\r[\u0005\u0005\t\u000f!\tAA\u0007XCR\u001c\u0007NU3ta>t7/Z\u0001\b_:,%O]8s)\u0011\u0011I\u0001\"\u0004\t\u000f\u0011=A\u000b1\u0001\u0005\u0012\u0005IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u0005\u0005?#\u0019\"\u0003\u0003\u0005\u0016\t5&!\u0003+ie><\u0018M\u00197f\u0003-ygnQ8na2,G/\u001a3\u0002'\u0015#8\r\u001a#jg\u000e|g/\u001a:z\u00072LWM\u001c;\u0011\u0007\u0005\u0005qk\u0005\u0002XYR\u0011A1D\u0001\u0011\u0019\u0016\u000b5+R0O+2cuLV!M+\u0016\u000b\u0011\u0003T#B'\u0016{f*\u0016'M?Z\u000bE*V#!\u0003AaujQ&`!\u0006#\u0006jX*V\r\u001aK\u0005,\u0006\u0002\u0005*=\u0011A1F\u0011\u0003\t[\tQa\f7pG.\f\u0011\u0003T(D\u0017~\u0003\u0016\t\u0016%`'V3e)\u0013-!\u0001")
public class EtcdDiscoveryClient
implements DiscoveryClient {
    private volatile EtcdDiscoveryClient$ServiceNode$ ServiceNode$module;
    private final KyuubiConf conf;
    private Client client;
    private KV kvClient;
    private Lock lockClient;
    private Lease leaseClient;
    private ServiceNode serviceNode;
    private long leaseTTL;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    public EtcdDiscoveryClient$ServiceNode$ ServiceNode() {
        if (this.ServiceNode$module == null) {
            this.ServiceNode$lzycompute$1();
        }
        return this.ServiceNode$module;
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Client client() {
        return this.client;
    }

    public void client_$eq(Client x$1) {
        this.client = x$1;
    }

    public KV kvClient() {
        return this.kvClient;
    }

    public void kvClient_$eq(KV x$1) {
        this.kvClient = x$1;
    }

    public Lock lockClient() {
        return this.lockClient;
    }

    public void lockClient_$eq(Lock x$1) {
        this.lockClient = x$1;
    }

    public Lease leaseClient() {
        return this.leaseClient;
    }

    public void leaseClient_$eq(Lease x$1) {
        this.leaseClient = x$1;
    }

    public ServiceNode serviceNode() {
        return this.serviceNode;
    }

    public void serviceNode_$eq(ServiceNode x$1) {
        this.serviceNode = x$1;
    }

    public long leaseTTL() {
        return this.leaseTTL;
    }

    public void leaseTTL_$eq(long x$1) {
        this.leaseTTL = x$1;
    }

    private Client buildClient() {
        String[] endpoints = this.conf.get(HighAvailabilityConf$.MODULE$.HA_ADDRESSES()).split(",");
        boolean sslEnabled = BoxesRunTime.unboxToBoolean((Object)this.conf.get(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_ENABLED()));
        if (!sslEnabled) {
            return Client.builder().endpoints(endpoints).build();
        }
        String caPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CA_PATH().key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CA_PATH().key()).append(" is not defined").toString());
        });
        String crtPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLINET_CRT_PATH().key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLINET_CRT_PATH().key()).append(" is not defined").toString());
        });
        String keyPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLINET_KEY_PATH().key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLINET_KEY_PATH().key()).append(" is not defined").toString());
        });
        SslContext context = GrpcSslContexts.forClient().trustManager(new File(caPath)).keyManager(new File(crtPath), new File(keyPath)).build();
        return Client.builder().endpoints(endpoints).sslContext(context).build();
    }

    @Override
    public void createClient() {
        this.client_$eq(this.buildClient());
        this.kvClient_$eq(this.client().getKVClient());
        this.lockClient_$eq(this.client().getLockClient());
        this.leaseClient_$eq(this.client().getLeaseClient());
        this.leaseTTL_$eq(BoxesRunTime.unboxToLong((Object)this.conf.get(HighAvailabilityConf$.MODULE$.HA_ETCD_LEASE_TIMEOUT())) / 1000L);
    }

    @Override
    public void closeClient() {
        if (this.client() != null) {
            this.client().close();
            return;
        }
    }

    @Override
    public String create(String path, String mode, boolean createParent) {
        String string = mode;
        if (!"PERSISTENT".equals(string)) {
            throw new KyuubiException(new StringBuilder(36).append("Create mode ").append(string).append(" is not support in etcd!").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        this.kvClient().put(ByteSequence.from(path.getBytes()), ByteSequence.from(path.getBytes())).get();
        return path;
    }

    @Override
    public boolean create$default$3() {
        return true;
    }

    @Override
    public byte[] getData(String path) {
        GetResponse response = this.kvClient().get(ByteSequence.from(path.getBytes())).get();
        if (response.getKvs().isEmpty()) {
            throw new KyuubiException(new StringBuilder(42).append("Key[").append(path).append("] not exists in ETCD, please check it.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        return response.getKvs().get(0).getValue().getBytes();
    }

    @Override
    public boolean setData(String path, byte[] data) {
        PutResponse response = this.kvClient().put(ByteSequence.from(path.getBytes()), ByteSequence.from(data)).get();
        return response != null;
    }

    @Override
    public List<String> getChildren(String path) {
        java.util.List<KeyValue> kvs = this.kvClient().get(ByteSequence.from(path.getBytes()), GetOption.newBuilder().isPrefix(true).build()).get().getKvs();
        if (kvs.isEmpty()) {
            return List$.MODULE$.empty();
        }
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(kvs).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(kv.getKey().toString(StandardCharsets.UTF_8))).stripPrefix(path))).stripPrefix("/"), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)EtcdDiscoveryClient.$anonfun$getChildren$2(key)))).toList();
    }

    @Override
    public boolean pathExists(String path) {
        return !this.pathNonExists(path);
    }

    @Override
    public boolean pathNonExists(String path) {
        return this.kvClient().get(ByteSequence.from(path.getBytes())).get().getKvs().isEmpty();
    }

    @Override
    public void delete(String path, boolean deleteChildren) {
        this.kvClient().delete(ByteSequence.from(path.getBytes()), DeleteOption.newBuilder().isPrefix(deleteChildren).build()).get();
    }

    @Override
    public boolean delete$default$2() {
        return false;
    }

    @Override
    public void monitorState(ServiceDiscovery serviceDiscovery) {
    }

    @Override
    public <T> T tryWithLock(String lockPath, long timeout, Function0<T> f) {
        Object object;
        long leaseTime = timeout / 1000L + 3L;
        long leaseId = this.leaseClient().grant(leaseTime).get().getID();
        try {
            try {
                this.lockClient().lock(ByteSequence.from(lockPath.getBytes()), leaseId).get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(111).append("Timeout to lock on path [").append(lockPath).append("] after ").append(timeout).append(" ms. There would be some problem that other session may ").append("create engine timeout.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(22).append("Lock failed on path [").append(lockPath).append("]").toString(), e);
            }
            object = f.apply();
        }
        catch (Throwable throwable) {
            try {
                this.lockClient().unlock(ByteSequence.from(lockPath.getBytes())).get();
                this.leaseClient().revoke(leaseId).get();
            }
            catch (Exception e) {
                throw new KyuubiException(e.getMessage(), e.getCause());
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            this.lockClient().unlock(ByteSequence.from(lockPath.getBytes())).get();
            this.leaseClient().revoke(leaseId).get();
        }
        catch (Exception e) {
            throw new KyuubiException(e.getMessage(), e.getCause());
        }
        return (T)object2;
    }

    @Override
    public Option<Tuple2<String, Object>> getServerHost(String namespace) {
        Seq<ServiceNodeInfo> seq = this.getServiceNodesInfo(namespace, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1)), true);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            ServiceNodeInfo sn = (ServiceNodeInfo)((SeqLike)some.get()).apply(0);
            return new Some((Object)new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port())));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Tuple2<String, Object>> getEngineByRefId(String namespace, String engineRefId) {
        String x$12 = namespace;
        boolean x$2 = true;
        Option<Object> x$3 = this.getServiceNodesInfo$default$2();
        return this.getServiceNodesInfo(x$12, x$3, x$2).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EtcdDiscoveryClient.$anonfun$getEngineByRefId$1(engineRefId, x$1))).map((Function1 & Serializable & scala.Serializable)data -> new Tuple2((Object)data.host(), (Object)BoxesRunTime.boxToInteger((int)data.port())));
    }

    @Override
    public Seq<ServiceNodeInfo> getServiceNodesInfo(String namespace, Option<Object> sizeOpt, boolean silent) {
        Nil$ nil$;
        try {
            List<String> hosts = this.getChildren(DiscoveryPaths$.MODULE$.makePath(null, namespace, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            int size = BoxesRunTime.unboxToInt((Object)sizeOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> hosts.size()));
            nil$ = (Seq)hosts.takeRight(size).map((Function1 & Serializable & scala.Serializable)p -> {
                String path = DiscoveryPaths$.MODULE$.makePath(namespace, (String)p, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                String instance = new String(this.getData(path), StandardCharsets.UTF_8);
                Tuple2<String, Object> tuple2 = DiscoveryClient$.MODULE$.parseInstanceHostPort(instance);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String host = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                String host2 = (String)tuple22._1();
                int port2 = tuple22._2$mcI$sp();
                Map attributes = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.split(";"))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.split("=", 2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EtcdDiscoveryClient.$anonfun$getServiceNodesInfo$4(x$5))))).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).head(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).last()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                Option version = attributes.get((Object)"version");
                Option engineRefId = attributes.get((Object)"refId");
                String engineIdStr = (String)attributes.get((Object)"kyuubi.engine.id").map((Function1 & Serializable & scala.Serializable)x$6 -> new StringBuilder(11).append(" engine id:").append((String)x$6).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Get service instance:").append(instance).append(engineIdStr).append(" and version:").append(version.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" ").append("under ").append(namespace).toString());
                return new ServiceNodeInfo(namespace, (String)p, host2, port2, (Option<String>)version, (Option<String>)engineRefId, (Map<String, String>)attributes);
            }, List$.MODULE$.canBuildFrom());
        }
        catch (Exception exception) {
            if (silent) {
                nil$ = Nil$.MODULE$;
            } else {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Failed to get service node info", exception);
                nil$ = Nil$.MODULE$;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return nil$;
    }

    @Override
    public Option<Object> getServiceNodesInfo$default$2() {
        return None$.MODULE$;
    }

    @Override
    public boolean getServiceNodesInfo$default$3() {
        return false;
    }

    @Override
    public void registerService(KyuubiConf conf, String namespace, ServiceDiscovery serviceDiscovery, Option<String> version, boolean external) {
        String instance = serviceDiscovery.fe().connectionUrl();
        DeRegisterWatcher watcher = new DeRegisterWatcher(this, instance, serviceDiscovery);
        ServiceNode serviceNode = this.createPersistentNode(conf, namespace, instance, version, external, serviceDiscovery.fe().attributes());
        this.client().getWatchClient().watch(ByteSequence.from(serviceNode.path().getBytes()), watcher);
        if (this.pathNonExists(serviceNode.path())) {
            throw new KyuubiException(new StringBuilder(61).append("Unable to create keyValue for this Kyuubi ").append("instance[").append(instance).append("] on ETCD.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    @Override
    public Option<String> registerService$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean registerService$default$5() {
        return false;
    }

    @Override
    public void deregisterService() {
        if (this.serviceNode() != null) {
            if (this.serviceNode().lease() != EtcdDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$$LEASE_NULL_VALUE()) {
                this.client().getLeaseClient().revoke(this.serviceNode().lease());
                this.delete(this.serviceNode().path(), this.delete$default$2());
            }
            this.serviceNode_$eq(null);
            return;
        }
    }

    @Override
    public boolean postDeregisterService(String namespace) {
        if (namespace != null) {
            this.delete(DiscoveryPaths$.MODULE$.makePath(null, namespace, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), true);
            return true;
        }
        return false;
    }

    @Override
    public String createAndGetServiceNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external) {
        return this.createPersistentNode(conf, namespace, instance, version, external, this.createPersistentNode$default$6()).path();
    }

    @Override
    public Option<String> createAndGetServiceNode$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean createAndGetServiceNode$default$5() {
        return false;
    }

    @Override
    @VisibleForTesting
    public void startSecretNode(String createMode, String basePath, String initData, boolean useProtection) {
        this.client().getKVClient().put(ByteSequence.from(basePath.getBytes()), ByteSequence.from(initData.getBytes())).get();
    }

    @Override
    public boolean startSecretNode$default$4() {
        return false;
    }

    @Override
    public int getAndIncrement(String path, int delta) {
        String lockPath = new StringBuilder(13).append(path).append("_tmp_for_lock").toString();
        return BoxesRunTime.unboxToInt(this.tryWithLock(lockPath, 60000L, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Object object;
            if (this.pathNonExists(path)) {
                this.create(path, "PERSISTENT", this.create$default$3());
                object = BoxesRunTime.boxToBoolean((boolean)this.setData(path, String.valueOf(0).getBytes()));
            } else {
                object = BoxedUnit.UNIT;
            }
            int s = new StringOps(Predef$.MODULE$.augmentString(new String(this.getData(path)))).toInt();
            this.setData(path, String.valueOf(s + delta).getBytes());
            return s;
        }));
    }

    @Override
    public int getAndIncrement$default$2() {
        return 1;
    }

    private ServiceNode createPersistentNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external, Map<String, String> attributes) {
        String ns = DiscoveryPaths$.MODULE$.makePath(null, namespace, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.create(ns, "PERSISTENT", this.create$default$3());
        String session = (String)((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID())).map((Function1 & Serializable & scala.Serializable)refId -> new StringBuilder(7).append("refId=").append((String)refId).append(";").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String extraInfo = ((TraversableOnce)attributes.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString(";", ";", "");
        String pathPrefix = DiscoveryPaths$.MODULE$.makePath(namespace, new StringBuilder(30).append("serviceUri=").append(instance).append(";version=").append(version.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.KYUUBI_VERSION())).append(new StringOps(Predef$.MODULE$.augmentString(extraInfo)).stripSuffix(";")).append(";").append(session).append("sequence=").toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        String znode = instance;
        LongRef leaseId = LongRef.create((long)EtcdDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$$LEASE_NULL_VALUE());
        ObjectRef realPath = ObjectRef.create(null);
        long timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.tryWithLock(new StringBuilder(5).append(ns).append("/lock").toString(), timeout, (Function0 & Serializable & scala.Serializable)() -> {
            List instances = (List)this.getChildren(pathPrefix).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)EtcdDiscoveryClient.$anonfun$createPersistentNode$6(pathPrefix, x$7)), List$.MODULE$.canBuildFrom());
            long sequence = instances.isEmpty() ? 0L : BoxesRunTime.unboxToLong((Object)instances.max((Ordering)Ordering.Long$.MODULE$)) + 1L;
            realPath$1.elem = new StringBuilder(0).append(pathPrefix).append(new StringOps(Predef$.MODULE$.augmentString("%010d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sequence)}))).toString();
            if (external) {
                return this.client().getKVClient().put(ByteSequence.from(((String)realPath$1.elem).getBytes()), ByteSequence.from(znode.getBytes())).get();
            }
            leaseId$1.elem = this.client().getLeaseClient().grant(this.leaseTTL()).get().getID();
            this.client().getLeaseClient().keepAlive(leaseId$1.elem, new StreamObserver<LeaseKeepAliveResponse>(null){

                public void onNext(LeaseKeepAliveResponse v) {
                }

                public void onError(Throwable throwable) {
                }

                public void onCompleted() {
                }
            });
            return this.client().getKVClient().put(ByteSequence.from(((String)realPath$1.elem).getBytes()), ByteSequence.from(znode.getBytes()), PutOption.newBuilder().withLeaseId(leaseId$1.elem).build()).get();
        });
        return new ServiceNode(this, (String)realPath.elem, leaseId.elem);
    }

    private Option<String> createPersistentNode$default$4() {
        return None$.MODULE$;
    }

    private boolean createPersistentNode$default$5() {
        return false;
    }

    private Map<String, String> createPersistentNode$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void ServiceNode$lzycompute$1() {
        EtcdDiscoveryClient etcdDiscoveryClient = this;
        synchronized (etcdDiscoveryClient) {
            if (this.ServiceNode$module == null) {
                this.ServiceNode$module = new EtcdDiscoveryClient$ServiceNode$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$getChildren$2(String key) {
        return new StringOps(Predef$.MODULE$.augmentString(key)).nonEmpty() && !key.startsWith("lock");
    }

    public static final /* synthetic */ boolean $anonfun$getEngineByRefId$1(String engineRefId$1, ServiceNodeInfo x$1) {
        return x$1.engineRefId().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals(engineRefId$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getServiceNodesInfo$4(String[] x$5) {
        return x$5.length == 2;
    }

    public static final /* synthetic */ long $anonfun$createPersistentNode$6(String pathPrefix$1, String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(x$7)).stripPrefix(pathPrefix$1))).toLong();
    }

    public EtcdDiscoveryClient(KyuubiConf conf) {
        this.conf = conf;
        Logging.$init$(this);
    }

    public class DeRegisterWatcher
    implements Watch.Listener {
        private final String instance;
        private final ServiceDiscovery serviceDiscovery;
        public final /* synthetic */ EtcdDiscoveryClient $outer;

        @Override
        public void onNext(WatchResponse watchResponse) {
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(watchResponse.getEvents()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeRegisterWatcher.$anonfun$onNext$1(x$8)))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                DeRegisterWatcher.$anonfun$onNext$2(this, x$9);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public void onError(Throwable throwable) {
            throw new KyuubiException(throwable.getMessage(), throwable.getCause());
        }

        @Override
        public void onCompleted() {
        }

        public /* synthetic */ EtcdDiscoveryClient org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$DeRegisterWatcher$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$onNext$1(WatchEvent x$8) {
            WatchEvent.EventType eventType = x$8.getEventType();
            WatchEvent.EventType eventType2 = WatchEvent.EventType.DELETE;
            return !(eventType != null ? !((Object)((Object)eventType)).equals((Object)eventType2) : eventType2 != null);
        }

        public static final /* synthetic */ void $anonfun$onNext$2(DeRegisterWatcher $this, WatchEvent x$9) {
            $this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$DeRegisterWatcher$$$outer().warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(123).append("This Kyuubi instance ").append($this.instance).append(" is now de-registered from").append(" ETCD. The server will be shut down after the last client session completes.").toString());
            $this.serviceDiscovery.stopGracefully($this.serviceDiscovery.stopGracefully$default$1());
        }

        public DeRegisterWatcher(EtcdDiscoveryClient $outer, String instance, ServiceDiscovery serviceDiscovery) {
            this.instance = instance;
            this.serviceDiscovery = serviceDiscovery;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class ServiceNode
    implements Product,
    scala.Serializable {
        private final String path;
        private final long lease;
        public final /* synthetic */ EtcdDiscoveryClient $outer;

        public String path() {
            return this.path;
        }

        public long lease() {
            return this.lease;
        }

        public ServiceNode copy(String path, long lease) {
            return new ServiceNode(this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer(), path, lease);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.lease();
        }

        public String productPrefix() {
            return "ServiceNode";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.path();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.lease());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ServiceNode;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lease()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ServiceNode)) return false;
            if (((ServiceNode)object).org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer() != this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ServiceNode serviceNode = (ServiceNode)x$1;
            String string = this.path();
            String string2 = serviceNode.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.lease() != serviceNode.lease()) return false;
            if (!serviceNode.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ EtcdDiscoveryClient org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer() {
            return this.$outer;
        }

        public ServiceNode(EtcdDiscoveryClient $outer, String path, long lease) {
            this.path = path;
            this.lease = lease;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

