/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.curator.framework.recipes.locks;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kyuubi.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.kyuubi.shade.org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.kyuubi.shade.org.apache.curator.framework.recipes.locks.Reaper;
import org.apache.kyuubi.shade.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.shade.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.org.apache.curator.shaded.com.google.common.collect.Sets;
import org.apache.kyuubi.shade.org.apache.curator.utils.CloseableScheduledExecutorService;
import org.apache.kyuubi.shade.org.apache.curator.utils.CloseableUtils;
import org.apache.kyuubi.shade.org.apache.curator.utils.PathUtils;
import org.apache.kyuubi.shade.org.apache.curator.utils.ThreadUtils;
import org.apache.kyuubi.shade.org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ChildReaper
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Reaper reaper;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final CuratorFramework client;
    private final Collection<String> paths = Sets.newConcurrentHashSet();
    private volatile Iterator<String> pathIterator = null;
    private final Reaper.Mode mode;
    private final CloseableScheduledExecutorService executor;
    private final int reapingThresholdMs;
    private final LeaderLatch leaderLatch;
    private final Set<String> lockSchema;
    private final AtomicInteger maxChildren = new AtomicInteger(-1);
    private volatile Future<?> task;

    public ChildReaper(CuratorFramework client, String path, Reaper.Mode mode) {
        this(client, path, mode, ChildReaper.newExecutorService(), Reaper.DEFAULT_REAPING_THRESHOLD_MS, null);
    }

    public ChildReaper(CuratorFramework client, String path, Reaper.Mode mode, int reapingThresholdMs) {
        this(client, path, mode, ChildReaper.newExecutorService(), reapingThresholdMs, null);
    }

    public ChildReaper(CuratorFramework client, String path, Reaper.Mode mode, ScheduledExecutorService executor, int reapingThresholdMs) {
        this(client, path, mode, executor, reapingThresholdMs, null);
    }

    public ChildReaper(CuratorFramework client, String path, Reaper.Mode mode, ScheduledExecutorService executor, int reapingThresholdMs, String leaderPath) {
        this(client, path, mode, executor, reapingThresholdMs, leaderPath, Collections.emptySet());
    }

    public ChildReaper(CuratorFramework client, String path, Reaper.Mode mode, ScheduledExecutorService executor, int reapingThresholdMs, String leaderPath, Set<String> lockSchema) {
        this.client = client;
        this.mode = mode;
        this.executor = new CloseableScheduledExecutorService(executor);
        this.reapingThresholdMs = reapingThresholdMs;
        this.leaderLatch = leaderPath != null ? new LeaderLatch(client, leaderPath) : null;
        this.reaper = new Reaper(client, executor, reapingThresholdMs, this.leaderLatch);
        this.lockSchema = lockSchema;
        this.addPath(path);
    }

    public void start() throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.task = this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ChildReaper.this.doWork();
            }
        }, this.reapingThresholdMs, this.reapingThresholdMs, TimeUnit.MILLISECONDS);
        if (this.leaderLatch != null) {
            this.leaderLatch.start();
        }
        this.reaper.start();
    }

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            CloseableUtils.closeQuietly(this.reaper);
            if (this.leaderLatch != null) {
                CloseableUtils.closeQuietly(this.leaderLatch);
            }
            this.task.cancel(true);
        }
    }

    public ChildReaper addPath(String path) {
        this.paths.add(PathUtils.validatePath(path));
        return this;
    }

    public boolean removePath(String path) {
        return this.paths.remove(PathUtils.validatePath(path));
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren.set(maxChildren);
    }

    public static ScheduledExecutorService newExecutorService() {
        return ThreadUtils.newFixedThreadScheduledPool(2, "ChildReaper");
    }

    @VisibleForTesting
    protected void warnMaxChildren(String path, Stat stat) {
        this.log.warn(String.format("Skipping %s as it has too many children: %d", path, stat.getNumChildren()));
    }

    private void doWork() {
        if (this.shouldDoWork()) {
            if (this.pathIterator == null || !this.pathIterator.hasNext()) {
                this.pathIterator = this.paths.iterator();
            }
            while (this.pathIterator.hasNext()) {
                String path = this.pathIterator.next();
                try {
                    Stat stat;
                    int maxChildren = this.maxChildren.get();
                    if (maxChildren > 0 && (stat = (Stat)this.client.checkExists().forPath(path)) != null && stat.getNumChildren() > maxChildren) {
                        this.warnMaxChildren(path, stat);
                        continue;
                    }
                    List children = (List)this.client.getChildren().forPath(path);
                    this.log.info(String.format("Found %d children for %s", children.size(), path));
                    for (String name : children) {
                        String childPath = ZKPaths.makePath(path, name);
                        this.addPathToReaperIfEmpty(childPath);
                        for (String subNode : this.lockSchema) {
                            this.addPathToReaperIfEmpty(ZKPaths.makePath(childPath, subNode));
                        }
                    }
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    this.log.error("Could not get children for path: " + path, (Throwable)e);
                }
            }
        }
    }

    private void addPathToReaperIfEmpty(String path) throws Exception {
        Stat stat = (Stat)this.client.checkExists().forPath(path);
        if (stat != null && stat.getNumChildren() == 0) {
            this.log.info("Adding " + path);
            this.reaper.addPath(path, this.mode);
        }
    }

    private boolean shouldDoWork() {
        return this.leaderLatch == null || this.leaderLatch.hasLeadership();
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

