/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.metadata.jdbc;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.google.common.annotations.VisibleForTesting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.server.metadata.MetadataStore;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.server.metadata.jdbc.DatabaseType$;
import org.apache.kyuubi.server.metadata.jdbc.DerbyDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.GenericDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStore$;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStoreConf$;
import org.apache.kyuubi.server.metadata.jdbc.JdbcDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.MysqlDatabaseDialect;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.util.JdbcUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r\u001da\u0001B\u001a5\u0001\u0005C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u00063\u0002!\tA\u0017\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0011\u0019Q\u0007\u0001)A\u0005A\"91\u000e\u0001b\u0001\n\u0013a\u0007B\u0002?\u0001A\u0003%Q\u000eC\u0004~\u0001\t\u0007I\u0011\u0002@\t\r}\u0004\u0001\u0015!\u0003r\u0011%\t\t\u0001\u0001b\u0001\n\u0013\t\u0019\u0001\u0003\u0005\u0002\f\u0001\u0001\u000b\u0011BA\u0003\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\t\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\t\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0011BA\u0012\u0011)\tI\u0004\u0001b\u0001\n\u0007Q\u00141\b\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u0002>!I\u00111\f\u0001C\u0002\u0013%\u0011Q\f\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002`!A\u0011Q\u000f\u0001C\u0002\u0013%a\u0010C\u0004\u0002x\u0001\u0001\u000b\u0011B9\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|!A\u00111\u0011\u0001\u0005\u0002Q\n)\tC\u0004\u0002,\u0002!\t!!,\t\u000f\u0005}\u0006\u0001\"\u0001\u0002B\"9\u0011\u0011\u001c\u0001\u0005B\u0005m\u0004bBAn\u0001\u0011\u0005\u0013Q\u001c\u0005\b\u0003[\u0004A\u0011IAx\u0011\u001d\ty\u0010\u0001C!\u0005\u0003AqA!\u0007\u0001\t\u0003\u0012Y\u0002C\u0004\u0003 \u0001!\tE!\t\t\u000f\t\u0015\u0002\u0001\"\u0011\u0003(!9!1\u0007\u0001\u0005\n\tU\u0002b\u0002B%\u0001\u0011%!1\n\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u0011\t\n\u0001C\u0005\u0005'CqAa*\u0001\t\u0013\u0011I\u000bC\u0004\u00038\u0002!IA!/\t\u000f\t}\u0006\u0001\"\u0003\u0003B\"9!Q\u001a\u0001\u0005\n\t=wa\u0002Bji!\u0005!Q\u001b\u0004\u0007gQB\tAa6\t\reKC\u0011\u0001Bp\u0011%\u0011\t/\u000bb\u0001\n\u0013\u0011\u0019\u000f\u0003\u0005\u0003t&\u0002\u000b\u0011\u0002Bs\u0011%\u0011)0\u000bb\u0001\n\u0013\u00119\u0010\u0003\u0005\u0003~&\u0002\u000b\u0011\u0002B}\u0011!\u0011y0\u000bb\u0001\n\u0013q\bbBB\u0001S\u0001\u0006I!\u001d\u0005\t\u0007\u0007I#\u0019!C\u0005}\"91QA\u0015!\u0002\u0013\t(!\u0005&E\u0005\u000ekU\r^1eCR\f7\u000b^8sK*\u0011QGN\u0001\u0005U\u0012\u00147M\u0003\u00028q\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002:u\u000511/\u001a:wKJT!a\u000f\u001f\u0002\r-LX/\u001e2j\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0011&O!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0003mC:<'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0012\u0013aa\u00142kK\u000e$\bCA&M\u001b\u00051\u0014BA'7\u00055iU\r^1eCR\f7\u000b^8sKB\u0011q\nU\u0007\u0002u%\u0011\u0011K\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0011\u0005Q;V\"A+\u000b\u0005YS\u0014AB2p]\u001aLw-\u0003\u0002Y+\nQ1*_;vE&\u001cuN\u001c4\u0002\rqJg.\u001b;?)\tYV\f\u0005\u0002]\u00015\tA\u0007C\u0003S\u0005\u0001\u00071+\u0001\u0004eERK\b/Z\u000b\u0002AB\u0011\u0011\r\u001a\b\u00039\nL!a\u0019\u001b\u0002\u0019\u0011\u000bG/\u00192bg\u0016$\u0016\u0010]3\n\u0005\u00154'!\u0002,bYV,\u0017BA4i\u0005-)e.^7fe\u0006$\u0018n\u001c8\u000b\u0003%\fQa]2bY\u0006\fq\u0001\u001a2UsB,\u0007%\u0001\bee&4XM]\"mCN\u001cx\n\u001d;\u0016\u00035\u00042A\\8r\u001b\u0005A\u0017B\u00019i\u0005\u0019y\u0005\u000f^5p]B\u0011!/\u001f\b\u0003g^\u0004\"\u0001\u001e5\u000e\u0003UT!A\u001e!\u0002\rq\u0012xn\u001c;?\u0013\tA\b.\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u0014aa\u0015;sS:<'B\u0001=i\u0003=!'/\u001b<fe\u000ec\u0017m]:PaR\u0004\u0013a\u00033sSZ,'o\u00117bgN,\u0012!]\u0001\rIJLg/\u001a:DY\u0006\u001c8\u000fI\u0001\u0010I\u0006$\u0018MY1tK\u0006#\u0017\r\u001d;peV\u0011\u0011Q\u0001\t\u00049\u0006\u001d\u0011bAA\u0005i\t\u0019\"\n\u001a2d\t\u0006$\u0018MY1tK\u0012K\u0017\r\\3di\u0006\u0001B-\u0019;bE\u0006\u001cX-\u00113baR|'\u000fI\u0001\u0015I\u0006$\u0018m]8ve\u000e,\u0007K]8qKJ$\u0018.Z:\u0016\u0005\u0005E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]a)\u0001\u0003vi&d\u0017\u0002BA\u000e\u0003+\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003U!\u0017\r^1t_V\u00148-\u001a)s_B,'\u000f^5fg\u0002\nA\u0002[5lCJL7i\u001c8gS\u001e,\"!a\t\u0011\t\u0005\u0015\u00121G\u0007\u0003\u0003OQA!!\u000b\u0002,\u00051\u0001.[6be&TA!!\f\u00020\u00051!0\u0019=yKJT!!!\r\u0002\u0007\r|W.\u0003\u0003\u00026\u0005\u001d\"\u0001\u0004%jW\u0006\u0014\u0018nQ8oM&<\u0017!\u00045jW\u0006\u0014\u0018nQ8oM&<\u0007%\u0001\tiS.\f'/\u001b#bi\u0006\u001cv.\u001e:dKV\u0011\u0011Q\b\t\u0005\u0003K\ty$\u0003\u0003\u0002B\u0005\u001d\"\u0001\u0005%jW\u0006\u0014\u0018\u000eR1uCN{WO]2f\u0003EA\u0017n[1sS\u0012\u000bG/Y*pkJ\u001cW\r\t\u0015\u0004!\u0005\u001d\u0003\u0003BA%\u0003/j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\fC:tw\u000e^1uS>t7O\u0003\u0003\u0002R\u0005M\u0013AB2p[6|gN\u0003\u0003\u0002V\u0005=\u0012AB4p_\u001edW-\u0003\u0003\u0002Z\u0005-#!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\u00061Q.\u00199qKJ,\"!a\u0018\u0011\t\u0005\u0005\u0014qN\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005AA-\u0019;bE&tGM\u0003\u0003\u0002j\u0005-\u0014a\u00026bG.\u001cxN\u001c\u0006\u0005\u0003[\ny#A\u0005gCN$XM\u001d=nY&!\u0011\u0011OA2\u00051y%M[3di6\u000b\u0007\u000f]3s\u0003\u001di\u0017\r\u001d9fe\u0002\na\u0002^3s[&t\u0017\r\\*uCR,7/A\buKJl\u0017N\\1m'R\fG/Z:!\u0003)Ig.\u001b;TG\",W.\u0019\u000b\u0003\u0003{\u00022A\\A@\u0013\r\t\t\t\u001b\u0002\u0005+:LG/A\u0007hKRLe.\u001b;TG\",W.\u0019\u000b\u0004[\u0006\u001d\u0005B\u00020\u0017\u0001\u0004\tI\t\u0005\u0003\u0002\f\u0006\u0015fbAAGE:!\u0011qRAR\u001d\u0011\t\t*!)\u000f\t\u0005M\u0015q\u0014\b\u0005\u0003+\u000biJ\u0004\u0003\u0002\u0018\u0006meb\u0001;\u0002\u001a&\tq(\u0003\u0002>}%\u00111\bP\u0005\u0003siJ!a\u000e\u001d\n\u0005U2\u0014\u0002BAT\u0003S\u0013A\u0002R1uC\n\f7/\u001a+za\u0016T!a\u0019\u001b\u0002!\u001d,GoU2iK6\fg+\u001a:tS>tG\u0003BAX\u0003w\u0003\u0012B\\AY\u0003k\u000b),!.\n\u0007\u0005M\u0006N\u0001\u0004UkBdWm\r\t\u0004]\u0006]\u0016bAA]Q\n\u0019\u0011J\u001c;\t\r\u0005uv\u00031\u0001r\u0003%\u00198\r[3nCV\u0013H.\u0001\nhKRd\u0015\r^3tiN\u001b\u0007.Z7b+JdGcA7\u0002D\"9\u0011Q\u0019\rA\u0002\u0005\u001d\u0017AC:dQ\u0016l\u0017-\u0016:mgB)\u0011\u0011ZAjc:!\u00111ZAh\u001d\r!\u0018QZ\u0005\u0002S&\u0019\u0011\u0011\u001b5\u0002\u000fA\f7m[1hK&!\u0011Q[Al\u0005\r\u0019V-\u001d\u0006\u0004\u0003#D\u0017!B2m_N,\u0017AD5og\u0016\u0014H/T3uC\u0012\fG/\u0019\u000b\u0005\u0003{\ny\u000e\u0003\u000485\u0001\u0007\u0011\u0011\u001d\t\u0005\u0003G\fI/\u0004\u0002\u0002f*\u0019\u0011q\u001d\u001c\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002l\u0006\u0015(\u0001C'fi\u0006$\u0017\r^1\u0002\u0017\u001d,G/T3uC\u0012\fG/\u0019\u000b\u0007\u0003C\f\t0!>\t\r\u0005M8\u00041\u0001r\u0003)IG-\u001a8uS\u001aLWM\u001d\u0005\b\u0003o\\\u0002\u0019AA}\u0003%\u0019H/\u0019;f\u001f:d\u0017\u0010E\u0002o\u0003wL1!!@i\u0005\u001d\u0011un\u001c7fC:\fqbZ3u\u001b\u0016$\u0018\rZ1uC2K7\u000f\u001e\u000b\u000b\u0005\u0007\u0011)Aa\u0004\u0003\u0014\t]\u0001CBAe\u0003'\f\t\u000fC\u0004\u0003\bq\u0001\rA!\u0003\u0002\r\u0019LG\u000e^3s!\u0011\t\u0019Oa\u0003\n\t\t5\u0011Q\u001d\u0002\u000f\u001b\u0016$\u0018\rZ1uC\u001aKG\u000e^3s\u0011\u001d\u0011\t\u0002\ba\u0001\u0003k\u000bAA\u001a:p[\"9!Q\u0003\u000fA\u0002\u0005U\u0016\u0001B:ju\u0016Dq!a>\u001d\u0001\u0004\tI0\u0001\bva\u0012\fG/Z'fi\u0006$\u0017\r^1\u0015\t\u0005u$Q\u0004\u0005\u0007ou\u0001\r!!9\u00027\rdW-\u00198va6+G/\u00193bi\u0006\u0014\u00150\u00133f]RLg-[3s)\u0011\tiHa\t\t\r\u0005Mh\u00041\u0001r\u0003Q\u0019G.Z1okBlU\r^1eCR\f')_!hKR!\u0011Q\u0010B\u0015\u0011\u001d\u0011Yc\ba\u0001\u0005[\ta!\\1y\u0003\u001e,\u0007c\u00018\u00030%\u0019!\u0011\u00075\u0003\t1{gnZ\u0001\u000eEVLG\u000eZ'fi\u0006$\u0017\r^1\u0015\r\t\r!q\u0007B$\u0011\u001d\u0011I\u0004\ta\u0001\u0005w\t\u0011B]3tk2$8+\u001a;\u0011\t\tu\"1I\u0007\u0003\u0005\u007fQ1A!\u0011G\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0005\u000b\u0012yDA\u0005SKN,H\u000e^*fi\"9\u0011q\u001f\u0011A\u0002\u0005e\u0018aB3yK\u000e,H/\u001a\u000b\t\u0003{\u0012iEa\u0016\u0003Z!9!qJ\u0011A\u0002\tE\u0013\u0001B2p]:\u0004BA!\u0010\u0003T%!!Q\u000bB \u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\u0007\u0005\u0003\n\u0003\u0019A9\t\u000f\tm\u0013\u00051\u0001\u0003^\u00051\u0001/\u0019:b[N\u0004RA\u001cB0\u0005GJ1A!\u0019i\u0005)a$/\u001a9fCR,GM\u0010\t\u0004]\n\u0015\u0014b\u0001B4Q\n\u0019\u0011I\\=\u0002\u001b]LG\u000f\u001b*fgVdGoU3u+\u0011\u0011iG!\u001e\u0015\u0011\t=$1\u0012BG\u0005\u001f#BA!\u001d\u0003\u0002B!!1\u000fB;\u0019\u0001!qAa\u001e#\u0005\u0004\u0011IHA\u0001U#\u0011\u0011YHa\u0019\u0011\u00079\u0014i(C\u0002\u0003\u0000!\u0014qAT8uQ&tw\rC\u0004\u0003\u0004\n\u0002\rA!\"\u0002\u0003\u0019\u0004rA\u001cBD\u0005w\u0011\t(C\u0002\u0003\n\"\u0014\u0011BR;oGRLwN\\\u0019\t\u000f\t=#\u00051\u0001\u0003R!1!\u0011\t\u0012A\u0002EDqAa\u0017#\u0001\u0004\u0011i&A\bxSRDW\u000b\u001d3bi\u0016\u001cu.\u001e8u+\u0011\u0011)Ja'\u0015\u0011\t]%\u0011\u0015BR\u0005K#BA!'\u0003\u001eB!!1\u000fBN\t\u001d\u00119h\tb\u0001\u0005sBqAa!$\u0001\u0004\u0011y\nE\u0004o\u0005\u000f\u000b)L!'\t\u000f\t=3\u00051\u0001\u0003R!1!\u0011I\u0012A\u0002EDqAa\u0017$\u0001\u0004\u0011i&\u0001\ntKR\u001cF/\u0019;f[\u0016tG\u000fU1sC6\u001cHCBA?\u0005W\u0013)\fC\u0004\u0003.\u0012\u0002\rAa,\u0002\u0013M$\u0018\r^3nK:$\b\u0003\u0002B\u001f\u0005cKAAa-\u0003@\t\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\t\u000f\tmC\u00051\u0001\u0003^\u0005ia/\u00197vK\u0006\u001b8\u000b\u001e:j]\u001e$2!\u001dB^\u0011\u001d\u0011i,\na\u0001\u0005G\n1a\u001c2k\u0003)\u0019HO]5oOJj\u0015\r\u001d\u000b\u0005\u0005\u0007\u0014I\rE\u0003s\u0005\u000b\f\u0018/C\u0002\u0003Hn\u00141!T1q\u0011\u0019\u0011YM\na\u0001c\u0006\u00191\u000f\u001e:\u0002\u0015M$(/\u001b8heM+\u0017\u000f\u0006\u0003\u0002H\nE\u0007B\u0002BfO\u0001\u0007\u0011/A\tK\t\n\u001bU*\u001a;bI\u0006$\u0018m\u0015;pe\u0016\u0004\"\u0001X\u0015\u0014\u0007%\u0012I\u000eE\u0002o\u00057L1A!8i\u0005\u0019\te.\u001f*fMR\u0011!Q[\u0001\u0013'\u000eCU)T!`+Jcu\fU!U)\u0016\u0013f*\u0006\u0002\u0003fB!!q\u001dBx\u001b\t\u0011IO\u0003\u0003\u0003l\n5\u0018\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\u0005]\u0001.\u0003\u0003\u0003r\n%(!\u0002*fO\u0016D\u0018aE*D\u0011\u0016k\u0015iX+S\u0019~\u0003\u0016\t\u0016+F%:\u0003\u0013AD'F)\u0006#\u0015\tV!`)\u0006\u0013E*R\u000b\u0003\u0005s\u00042a\u0011B~\u0013\tQH)A\bN\u000bR\u000bE)\u0011+B?R\u000b%\tT#!\u0003miU\tV!E\u0003R\u000bul\u0015+B)\u0016{vJ\u0014'Z?\u000e{E*V'O'\u0006aR*\u0012+B\t\u0006#\u0016iX*U\u0003R+ul\u0014(M3~\u001bu\nT+N\u001dN\u0003\u0013\u0001F'F)\u0006#\u0015\tV!`\u00032culQ(M+6s5+A\u000bN\u000bR\u000bE)\u0011+B?\u0006cEjX\"P\u0019Vkej\u0015\u0011")
public class JDBCMetadataStore
implements MetadataStore,
Logging {
    private final Enumeration.Value dbType;
    private final Option<String> driverClassOpt;
    private final String driverClass;
    private final JdbcDatabaseDialect databaseAdaptor;
    private final Properties datasourceProperties;
    private final HikariConfig hikariConfig;
    @VisibleForTesting
    private final HikariDataSource hikariDataSource;
    private final ObjectMapper mapper;
    private final String terminalStates;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private Enumeration.Value dbType() {
        return this.dbType;
    }

    private Option<String> driverClassOpt() {
        return this.driverClassOpt;
    }

    private String driverClass() {
        return this.driverClass;
    }

    private JdbcDatabaseDialect databaseAdaptor() {
        return this.databaseAdaptor;
    }

    private Properties datasourceProperties() {
        return this.datasourceProperties;
    }

    private HikariConfig hikariConfig() {
        return this.hikariConfig;
    }

    public HikariDataSource hikariDataSource() {
        return this.hikariDataSource;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private String terminalStates() {
        return this.terminalStates;
    }

    private void initSchema() {
        this.getInitSchema(this.dbType()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
            JDBCMetadataStore.$anonfun$initSchema$1(this, schema);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> getInitSchema(Enumeration.Value dbType) {
        ClassLoader classLoader = Utils$.MODULE$.getContextOrKyuubiClassLoader();
        String schemaPackage = new java.lang.StringBuilder(4).append("sql/").append(dbType.toString().toLowerCase()).toString();
        return Option$.MODULE$.apply((Object)classLoader.getResource(schemaPackage)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toURI()).flatMap((Function1 & Serializable & scala.Serializable)uri -> {
            String[] stringArray;
            String string = uri.getScheme();
            String string2 = "jar";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                try (FileSystem fs = FileSystems.newFileSystem(uri, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());){
                    stringArray = (String[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fs.getPath(schemaPackage, new String[0]), 1, new FileVisitOption[0]).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((Object)x$2.getFileName()).toString()).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getInitSchema$4(name))).toArray(ClassTag$.MODULE$.apply(String.class));
                }
            } else {
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Paths.get(uri).toFile().listFiles((x$3, name) -> JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined()))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            String[] pathNames = stringArray;
            return this.getLatestSchemaUrl((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])pathNames)).map((Function1 & Serializable & scala.Serializable)name -> new java.lang.StringBuilder(1).append(schemaPackage).append("/").append((String)name).toString()).map((Function1 & Serializable & scala.Serializable)schemaUrl -> {
                String string;
                try (InputStream inputStream = classLoader.getResourceAsStream((String)schemaUrl);){
                    string = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
                }
                return string;
            });
        });
    }

    public Tuple3<Object, Object, Object> getSchemaVersion(String schemaUrl) {
        Option option = JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)schemaUrl);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(2))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(3))).toInt()));
        }
        throw new KyuubiException(new java.lang.StringBuilder(20).append("Invalid schema url: ").append(schemaUrl).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
    }

    public Option<String> getLatestSchemaUrl(Seq<String> schemaUrls) {
        return ((TraversableLike)schemaUrls.sortWith((Function2 & Serializable & scala.Serializable)(u1, u2) -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getLatestSchemaUrl$1(this, u1, u2)))).headOption();
    }

    @Override
    public void close() {
        this.hikariDataSource().close();
    }

    @Override
    public void insertMetadata(Metadata metadata) {
        String query = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(449).append("\n         |INSERT INTO ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("(\n         |identifier,\n         |session_type,\n         |real_user,\n         |user_name,\n         |ip_address,\n         |kyuubi_instance,\n         |state,\n         |resource,\n         |class_name,\n         |request_name,\n         |request_conf,\n         |request_args,\n         |create_time,\n         |engine_type,\n         |cluster_manager\n         |)\n         |VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n         |").toString())).stripMargin();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata.identifier(), metadata.sessionType().toString(), metadata.realUser(), metadata.username(), metadata.ipAddress(), metadata.kyuubiInstance(), metadata.state(), metadata.resource(), metadata.className(), metadata.requestName(), this.valueAsString(metadata.requestConf()), this.valueAsString(metadata.requestArgs()), BoxesRunTime.boxToLong((long)metadata.createTime()), Option$.MODULE$.apply((Object)metadata.engineType()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toUpperCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms()), metadata.clusterManager().orNull(Predef$.MODULE$.$conforms())}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public Metadata getMetadata(String identifier, boolean stateOnly) {
        String query = stateOnly ? new java.lang.StringBuilder(34).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_STATE_ONLY_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString() : new java.lang.StringBuilder(34).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_ALL_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        return (Metadata)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> (Metadata)this.withResultSet((Connection)connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}), (Function1 & Serializable & scala.Serializable)rs -> (Metadata)this.buildMetadata((ResultSet)rs, stateOnly).headOption().orNull(Predef$.MODULE$.$conforms())), (DataSource)this.hikariDataSource());
    }

    @Override
    public Seq<Metadata> getMetadataList(MetadataFilter filter, int from, int size, boolean stateOnly) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        StringBuilder stringBuilder = stateOnly ? queryBuilder.append(new java.lang.StringBuilder(13).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_STATE_ONLY_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString()) : queryBuilder.append(new java.lang.StringBuilder(13).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_ALL_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        ListBuffer whereConditions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option$.MODULE$.apply((Object)filter.sessionType()).foreach((Function1 & Serializable & scala.Serializable)sessionType -> {
            whereConditions.$plus$eq((Object)"session_type = ?");
            return params.$plus$eq((Object)sessionType.toString());
        });
        Option$.MODULE$.apply((Object)filter.engineType()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$2(x$6))).foreach((Function1 & Serializable & scala.Serializable)engineType -> {
            whereConditions.$plus$eq((Object)"UPPER(engine_type) = ?");
            return params.$plus$eq((Object)engineType.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.username()).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$4(x$7))).foreach((Function1 & Serializable & scala.Serializable)username -> {
            whereConditions.$plus$eq((Object)"user_name = ?");
            return params.$plus$eq(username);
        });
        Option$.MODULE$.apply((Object)filter.state()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$6(x$8))).foreach((Function1 & Serializable & scala.Serializable)state -> {
            whereConditions.$plus$eq((Object)"state = ?");
            return params.$plus$eq((Object)state.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.kyuubiInstance()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$8(x$9))).foreach((Function1 & Serializable & scala.Serializable)kyuubiInstance -> {
            whereConditions.$plus$eq((Object)"kyuubi_instance = ?");
            return params.$plus$eq(kyuubiInstance);
        });
        if (filter.createTime() > 0L) {
            whereConditions.$plus$eq((Object)"create_time >= ?");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.createTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (filter.endTime() > 0L) {
            whereConditions.$plus$eq((Object)"end_time > 0");
            whereConditions.$plus$eq((Object)"end_time <= ?");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.endTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (filter.peerInstanceClosed()) {
            whereConditions.$plus$eq((Object)"peer_instance_closed = ?");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)filter.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = whereConditions.nonEmpty() ? queryBuilder.append(whereConditions.mkString(" WHERE ", " AND ", "")) : BoxedUnit.UNIT;
        queryBuilder.append(" ORDER BY key_id");
        String query = this.databaseAdaptor().addLimitAndOffsetToQuery(queryBuilder.toString(), size, from);
        return (Seq)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> (Seq)this.withResultSet((Connection)connection, query, (Seq<Object>)params, (Function1 & Serializable & scala.Serializable)rs -> this.buildMetadata((ResultSet)rs, stateOnly)), (DataSource)this.hikariDataSource());
    }

    @Override
    public void updateMetadata(Metadata metadata) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append(new java.lang.StringBuilder(7).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        ListBuffer setClauses = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option$.MODULE$.apply((Object)metadata.state()).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            setClauses.$plus$eq((Object)"state = ?");
            return params.$plus$eq((Object)metadata.state());
        });
        if (metadata.endTime() > 0L) {
            setClauses.$plus$eq((Object)"end_time = ?");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.endTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (metadata.engineOpenTime() > 0L) {
            setClauses.$plus$eq((Object)"engine_open_time = ?");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.engineOpenTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Option$.MODULE$.apply((Object)metadata.engineId()).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            setClauses.$plus$eq((Object)"engine_id = ?");
            return params.$plus$eq((Object)metadata.engineId());
        });
        Option$.MODULE$.apply((Object)metadata.engineName()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            setClauses.$plus$eq((Object)"engine_name = ?");
            return params.$plus$eq((Object)metadata.engineName());
        });
        Option$.MODULE$.apply((Object)metadata.engineUrl()).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            setClauses.$plus$eq((Object)"engine_url = ?");
            return params.$plus$eq((Object)metadata.engineUrl());
        });
        Option$.MODULE$.apply((Object)metadata.engineState()).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            setClauses.$plus$eq((Object)"engine_state = ?");
            return params.$plus$eq((Object)metadata.engineState());
        });
        metadata.engineError().foreach((Function1 & Serializable & scala.Serializable)error -> {
            setClauses.$plus$eq((Object)"engine_error = ?");
            return params.$plus$eq(error);
        });
        if (metadata.peerInstanceClosed()) {
            setClauses.$plus$eq((Object)"peer_instance_closed = ?");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)metadata.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = setClauses.nonEmpty() ? queryBuilder.append(setClauses.mkString(" SET ", ", ", "")) : BoxedUnit.UNIT;
        queryBuilder.append(" WHERE identifier = ?");
        params.$plus$eq((Object)metadata.identifier());
        String query = queryBuilder.toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.withUpdateCount(connection, query, (Seq<Object>)params, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)updateCount -> {
                if (updateCount == 0) {
                    throw new KyuubiException(new java.lang.StringBuilder(34).append("Error updating metadata for ").append(metadata$2.identifier()).append(" with ").append(query$4).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
            });
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public void cleanupMetadataByIdentifier(String identifier) {
        String query = new java.lang.StringBuilder(33).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public void cleanupMetadataByAge(long maxAge) {
        long minEndTime = System.currentTimeMillis() - maxAge;
        String query = new java.lang.StringBuilder(47).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE state IN (").append(this.terminalStates()).append(") AND end_time < ?").toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)minEndTime)}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Metadata> buildMetadata(ResultSet resultSet, boolean stateOnly) {
        void v0;
        try {
            void var3_3;
            ListBuffer metadataList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (resultSet.next()) {
                String identifier = resultSet.getString("identifier");
                Enumeration.Value sessionType = SessionType$.MODULE$.withName(resultSet.getString("session_type"));
                String realUser = resultSet.getString("real_user");
                String userName = resultSet.getString("user_name");
                String ipAddress = resultSet.getString("ip_address");
                String kyuubiInstance = resultSet.getString("kyuubi_instance");
                String state = resultSet.getString("state");
                String requestName = resultSet.getString("request_name");
                long createTime = resultSet.getLong("create_time");
                String engineType = resultSet.getString("engine_type");
                Option clusterManager = Option$.MODULE$.apply((Object)resultSet.getString("cluster_manager"));
                String engineId = resultSet.getString("engine_id");
                String engineName = resultSet.getString("engine_name");
                String engineUrl = resultSet.getString("engine_url");
                String engineState = resultSet.getString("engine_state");
                Option engineError = Option$.MODULE$.apply((Object)resultSet.getString("engine_error"));
                long endTime = resultSet.getLong("end_time");
                boolean peerInstanceClosed = resultSet.getBoolean("peer_instance_closed");
                String resource = null;
                String className = null;
                scala.collection.immutable.Map<String, String> requestConf = Predef$.MODULE$.Map().empty();
                Seq<String> requestArgs = (Seq<String>)Nil$.MODULE$;
                if (!stateOnly) {
                    resource = resultSet.getString("resource");
                    className = resultSet.getString("class_name");
                    requestConf = this.string2Map(resultSet.getString("request_conf"));
                    requestArgs = this.string2Seq(resultSet.getString("request_args"));
                }
                String x$1 = identifier;
                Enumeration.Value x$2 = sessionType;
                String x$3 = realUser;
                String x$4 = userName;
                String x$5 = ipAddress;
                String x$6 = kyuubiInstance;
                String x$7 = state;
                String x$8 = resource;
                String x$9 = className;
                String x$10 = requestName;
                scala.collection.immutable.Map<String, String> x$11 = requestConf;
                Seq<String> x$12 = requestArgs;
                long x$13 = createTime;
                String x$14 = engineType;
                Option x$15 = clusterManager;
                String x$16 = engineId;
                String x$17 = engineName;
                String x$18 = engineUrl;
                String x$19 = engineState;
                Option x$20 = engineError;
                long x$21 = endTime;
                boolean x$22 = peerInstanceClosed;
                long x$23 = Metadata$.MODULE$.apply$default$16();
                Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$23, x$16, x$17, x$18, x$19, (Option<String>)x$20, x$21, x$22);
                metadataList.$plus$eq((Object)metadata);
            }
            v0 = var3_3;
        }
        finally {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> resultSet.close());
        }
        return v0;
    }

    private void execute(Connection conn, String sql, Seq<Object> params) {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(28).append("execute sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                ((PreparedStatement)statement.elem).execute();
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$1.elem).close());
            }
        }
    }

    private <T> T withResultSet(Connection conn, String sql, Seq<Object> params, Function1<ResultSet, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("executeQuery sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        ObjectRef resultSet = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                resultSet.elem = ((PreparedStatement)statement.elem).executeQuery();
                object = f.apply((Object)((ResultSet)resultSet.elem));
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((ResultSet)resultSet.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ResultSet)resultSet$2.elem).close());
            }
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$2.elem).close());
            }
        }
        return (T)object;
    }

    private <T> T withUpdateCount(Connection conn, String sql, Seq<Object> params, Function1<Object, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("executeUpdate sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                object = f.apply((Object)BoxesRunTime.boxToInteger((int)((PreparedStatement)statement.elem).executeUpdate()));
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$3.elem).close());
            }
        }
        return (T)object;
    }

    private void setStatementParams(PreparedStatement statement, Seq<Object> params) {
        ((IterableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCMetadataStore.$anonfun$setStatementParams$1(statement, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private String valueAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    private scala.collection.immutable.Map<String, String> string2Map(String str) {
        if (str == null || str.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return (scala.collection.immutable.Map)this.mapper().readValue(str, scala.collection.immutable.Map.class);
    }

    private Seq<String> string2Seq(String str) {
        if (str == null || str.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)this.mapper().readValue(str, Seq.class);
    }

    public static final /* synthetic */ void $anonfun$initSchema$4(JDBCMetadataStore $this, Connection connection$1, String ddlStatement) {
        $this.execute(connection$1, ddlStatement, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(39).append("Execute init schema ddl: ").append(ddlStatement).append(" successfully.").toString());
    }

    public static final /* synthetic */ void $anonfun$initSchema$1(JDBCMetadataStore $this, String schema) {
        String[] ddlStatements = schema.trim().split(";");
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ddlStatements)).foreach((Function1 & Serializable & scala.Serializable)ddlStatement -> {
                JDBCMetadataStore.$anonfun$initSchema$4($this, connection, ddlStatement);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }, (DataSource)$this.hikariDataSource());
    }

    public static final /* synthetic */ boolean $anonfun$getInitSchema$4(String name) {
        return JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestSchemaUrl$1(JDBCMetadataStore $this, String u1, String u2) {
        Tuple3<Object, Object, Object> v1 = $this.getSchemaVersion(u1);
        Tuple3<Object, Object, Object> v2 = $this.getSchemaVersion(u2);
        return BoxesRunTime.unboxToInt((Object)v1._1()) > BoxesRunTime.unboxToInt((Object)v2._1()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) > BoxesRunTime.unboxToInt((Object)v2._2()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) == BoxesRunTime.unboxToInt((Object)v2._2()) && BoxesRunTime.unboxToInt((Object)v1._3()) > BoxesRunTime.unboxToInt((Object)v2._3());
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$2(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$4(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$6(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$8(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$setStatementParams$1(PreparedStatement statement$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object param = tuple2._1();
            int index = tuple2._2$mcI$sp();
            Object object = param;
            if (object == null) {
                statement$4.setObject(index + 1, null);
            } else if (object instanceof String) {
                String string = (String)object;
                statement$4.setString(index + 1, string);
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                statement$4.setInt(index + 1, n);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                statement$4.setLong(index + 1, l);
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                statement$4.setDouble(index + 1, d);
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                statement$4.setFloat(index + 1, f);
            } else if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                statement$4.setBoolean(index + 1, bl);
            } else {
                throw new KyuubiException(new java.lang.StringBuilder(23).append("Unsupported param type ").append(param.getClass().getName()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public JDBCMetadataStore(KyuubiConf conf) {
        block12: {
            JdbcDatabaseDialect jdbcDatabaseDialect;
            String string;
            Logging.$init$((Logging)this);
            this.dbType = DatabaseType$.MODULE$.withName((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_TYPE()));
            this.driverClassOpt = (Option)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DRIVER());
            Enumeration.Value value = this.dbType();
            Enumeration.Value value2 = DatabaseType$.MODULE$.DERBY();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.apache.derby.jdbc.AutoloadedDriver");
            } else {
                Enumeration.Value value4 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "com.mysql.jdbc.Driver");
                } else {
                    Enumeration.Value value6 = DatabaseType$.MODULE$.CUSTOM();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                            throw new IllegalArgumentException("No jdbc driver defined");
                        });
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
            this.driverClass = string;
            Enumeration.Value value8 = this.dbType();
            Enumeration.Value value9 = DatabaseType$.MODULE$.DERBY();
            Enumeration.Value value10 = value8;
            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                jdbcDatabaseDialect = new DerbyDatabaseDialect();
            } else {
                Enumeration.Value value11 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value12 = value8;
                if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                    jdbcDatabaseDialect = new MysqlDatabaseDialect();
                } else {
                    Enumeration.Value value13 = DatabaseType$.MODULE$.CUSTOM();
                    Enumeration.Value value14 = value8;
                    if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                        jdbcDatabaseDialect = new GenericDatabaseDialect();
                    } else {
                        throw new MatchError((Object)value8);
                    }
                }
            }
            this.databaseAdaptor = jdbcDatabaseDialect;
            this.datasourceProperties = JDBCMetadataStoreConf$.MODULE$.getMetadataStoreJDBCDataSourceProperties(conf);
            this.hikariConfig = new HikariConfig(this.datasourceProperties());
            this.hikariConfig().setDriverClassName(this.driverClass());
            this.hikariConfig().setJdbcUrl((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_URL()));
            this.hikariConfig().setUsername((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_USER()));
            this.hikariConfig().setPassword((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_PASSWORD()));
            this.hikariConfig().setPoolName("jdbc-metadata-store-pool");
            this.hikariDataSource = new HikariDataSource(this.hikariConfig());
            this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            this.terminalStates = ((TraversableOnce)OperationState$.MODULE$.terminalStates().map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(2).append("'").append(x).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            if (!BoxesRunTime.unboxToBoolean((Object)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_SCHEMA_INIT()))) break block12;
            this.initSchema();
        }
    }
}

