/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.timer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.timer.TimerFactory;

public class SingletonTimerFactory
implements TimerFactory,
ModuleControl {
    private final Timer singletonTimer;
    private final AtomicInteger cancelCount = new AtomicInteger();
    private StringBuilder warnings = new StringBuilder();

    public SingletonTimerFactory() {
        ClassLoader classLoader = this.getContextClassLoader();
        if (classLoader != null) {
            this.setContextClassLoader(null);
        }
        this.singletonTimer = new Timer(true);
        if (classLoader != null) {
            this.setContextClassLoader(classLoader);
        }
    }

    @Override
    public void schedule(TimerTask timerTask, long l) {
        this.singletonTimer.schedule(timerTask, l);
    }

    @Override
    public void cancel(TimerTask timerTask) {
        timerTask.cancel();
        if (this.cancelCount.incrementAndGet() % 1000 == 0) {
            this.singletonTimer.purge();
        }
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
    }

    @Override
    public void stop() {
        this.singletonTimer.cancel();
    }

    private ClassLoader getContextClassLoader() {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == this.getClass().getClassLoader() || classLoader == Thread.class.getClassLoader()) {
                        return null;
                    }
                    return classLoader;
                }
            });
        }
        catch (SecurityException securityException) {
            this.report(securityException, "M00A");
            return null;
        }
    }

    private void setContextClassLoader(final ClassLoader classLoader) {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            this.report(securityException, "M00B");
        }
    }

    private void report(SecurityException securityException, String string) {
        this.warnings.append(MessageService.getTextMessage(string, securityException.toString()));
        this.warnings.append('\n');
    }

    public String getWarnings() {
        String string = this.warnings.toString();
        this.warnings = null;
        return "".equals(string) ? null : string;
    }
}

