<!--
 - Licensed to the Apache Software Foundation (ASF) under one or more
 - contributor license agreements.  See the NOTICE file distributed with
 - this work for additional information regarding copyright ownership.
 - The ASF licenses this file to You under the Apache License, Version 2.0
 - (the "License"); you may not use this file except in compliance with
 - the License.  You may obtain a copy of the License at
 -
 -   http://www.apache.org/licenses/LICENSE-2.0
 -
 - Unless required by applicable law or agreed to in writing, software
 - distributed under the License is distributed on an "AS IS" BASIS,
 - WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 - See the License for the specific language governing permissions and
 - limitations under the License.
 -->

# The TTL Of Kyuubi Engines

For a multi-tenant cluster, its overall resource utilization is a KPI that measures how effectively its resource is utilized against its availability or capacity.
To better improve the overall resource utilization of the cluster,
- At cluster layer, we leverage the capabilities, such as [Capacity Scheduler](https://hadoop.apache.org/docs/stable/hadoop-yarn/hadoop-yarn-site/CapacityScheduler.html), of resource scheduling management services, such as YARN and K8s.
- At application layer, we'd be better to acquire and release resources according to the real workloads.

## The Big Contributors Of Resource Waste

- The time to wait for the resource to be allocated, such as the scheduling delay, the start/stop cost.
  - A longer time-to-live(TTL) for allocated resources can significantly reduce such time costs within an application.

- The time being idle of the resource.
  - A shorter time to live for allocated resources can make all resources in rapid turnarounds across applications.

## TTL Types In Kyuubi Engines

<body><div class="mxgraph" style="" data-mxgraph="{&quot;lightbox&quot;:false,&quot;nav&quot;:true,&quot;edit&quot;:&quot;_blank&quot;,&quot;xml&quot;:&quot;&lt;mxfile host=\&quot;Electron\&quot; modified=\&quot;2021-12-10T05:54:16.011Z\&quot; agent=\&quot;5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) draw.io/15.8.7 Chrome/91.0.4472.164 Electron/13.6.2 Safari/537.36\&quot; etag=\&quot;OsSJijKpSO7wcXva956r\&quot; version=\&quot;15.8.7\&quot; type=\&quot;device\&quot;&gt;&lt;diagram id=\&quot;5KKAXer4_n0DyOSvi0H2\&quot; name=\&quot;第 1 页\&quot;&gt;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&lt;/diagram&gt;&lt;/mxfile&gt;&quot;}"></div>
<script type="text/javascript" src="https://viewer.diagrams.net/js/viewer-static.min.js"></script>
</body>

- Engine TTL
  - The TTL of engines describes how long an engine will be cached after all sessions are disconnected.
- Executor TTL
  - The TTL of the executor describes how long an executor will be cached when no tasks come.

## Configurations

### Engine TTL

| Key                                          | Default                                                                        | Meaning                                                                                                                                                                                                       | Type                                    | Since                                |
|----------------------------------------------|--------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------|--------------------------------------|
| kyuubi\.session\.engine<br>\.check\.interval | <div style='width: 65pt;word-wrap: break-word;white-space: normal'>PT5M</div>  | <div style='width: 170pt;word-wrap: break-word;white-space: normal'>The check interval for engine timeout</div>                                                                                               | <div style='width: 30pt'>duration</div> | <div style='width: 20pt'>1.0.0</div> |
| kyuubi\.session\.engine<br>\.idle\.timeout   | <div style='width: 65pt;word-wrap: break-word;white-space: normal'>PT30M</div> | <div style='width: 170pt;word-wrap: break-word;white-space: normal'>engine timeout, the engine will self-terminate when it's not accessed for this duration. 0 or negative means not to self-terminate.</div> | <div style='width: 30pt'>duration</div> | <div style='width: 20pt'>1.0.0</div> |

The above two configurations can be used together to set the TTL of engines.
These configurations are user-facing and able to use in JDBC urls.
Note that, for [connection](engine_share_level.html#connection) share level engines that will be terminated at once when the connection is disconnected, these configurations not necessarily work in this case.

### Executor TTL

Executor TTL is part of functionality of Apache Spark's [Dynamic Resource Allocation](./spark/dynamic_allocation.md).
