/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino;

import com.google.common.base.Verify;
import io.trino.client.ClientSession;
import io.trino.client.Column;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.engine.trino.TrinoConf$;
import org.apache.kyuubi.engine.trino.TrinoContext;
import org.apache.kyuubi.engine.trino.TrinoStatement$;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.MapLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\u000f\u001e\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A1\b\u0001B\u0001B\u0003%A\bC\u0003H\u0001\u0011\u0005\u0001\n\u0003\u0005\u001f\u0001!\u0015\r\u0011\"\u0003N\u0011!9\u0006\u0001#b\u0001\n\u0013A\u0006b\u0002/\u0001\u0005\u0004%\u0019!\u0018\u0005\u0007I\u0002\u0001\u000b\u0011\u00020\t\u000b\u0015\u0004A\u0011A'\t\u000b\u0019\u0004A\u0011A4\t\u000b!\u0004A\u0011A5\t\u000bY\u0004A\u0011A<\t\r}\u0004A\u0011AA\u0001\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!!\u0010\u0001\t\u0013\tydB\u0004\u0002HuA\t!!\u0013\u0007\rqi\u0002\u0012AA&\u0011\u00199\u0015\u0003\"\u0001\u0002N!I\u0011qJ\tC\u0002\u00135\u0011\u0011\u000b\u0005\t\u0003/\n\u0002\u0015!\u0004\u0002T!I\u0011\u0011L\tC\u0002\u00135\u00111\f\u0005\t\u0003C\n\u0002\u0015!\u0004\u0002^!I\u00111M\tC\u0002\u00135\u0011Q\r\u0005\t\u0003g\n\u0002\u0015!\u0004\u0002h!I\u0011QO\tC\u0002\u00135\u0011q\u000f\u0005\t\u0003\u000f\u000b\u0002\u0015!\u0004\u0002z!9\u0011\u0011R\t\u0005\u0002\u0005-%A\u0004+sS:|7\u000b^1uK6,g\u000e\u001e\u0006\u0003=}\tQ\u0001\u001e:j]>T!\u0001I\u0011\u0002\r\u0015tw-\u001b8f\u0015\t\u00113%\u0001\u0004lsV,(-\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g-\u0001\u0007ue&twnQ8oi\u0016DH\u000f\u0005\u00022e5\tQ$\u0003\u00024;\taAK]5o_\u000e{g\u000e^3yi\u0006Q1._;vE&\u001cuN\u001c4\u0011\u0005YJT\"A\u001c\u000b\u0005a\n\u0013AB2p]\u001aLw-\u0003\u0002;o\tQ1*_;vE&\u001cuN\u001c4\u0002\u0007M\fH\u000e\u0005\u0002>\t:\u0011aH\u0011\t\u0003\u007f-j\u0011\u0001\u0011\u0006\u0003\u0003\u001e\na\u0001\u0010:p_Rt\u0014BA\",\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r[\u0013A\u0002\u001fj]&$h\b\u0006\u0003J\u0015.c\u0005CA\u0019\u0001\u0011\u0015yC\u00011\u00011\u0011\u0015!D\u00011\u00016\u0011\u0015YD\u00011\u0001=+\u0005q\u0005CA(V\u001b\u0005\u0001&BA)S\u0003\u0019\u0019G.[3oi*\u0011ad\u0015\u0006\u0002)\u0006\u0011\u0011n\\\u0005\u0003-B\u0013qb\u0015;bi\u0016lWM\u001c;DY&,g\u000e^\u0001\u0017I\u0006$\u0018\r\u0015:pG\u0016\u001c8/\u001b8h!>|GnU5{KV\t\u0011\f\u0005\u0002+5&\u00111l\u000b\u0002\u0004\u0013:$\u0018AA3d+\u0005q\u0006CA0c\u001b\u0005\u0001'BA1,\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003G\u0002\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0007\u0015\u001c\u0007%\u0001\bhKR$&/\u001b8p\u00072LWM\u001c;\u0002%\u001d,GoQ;se\u0016tG\u000fR1uC\n\f7/Z\u000b\u0002y\u0005Qq-\u001a;D_2,XN\\:\u0016\u0003)\u00042a\u001b9t\u001d\tagN\u0004\u0002@[&\tA&\u0003\u0002pW\u00059\u0001/Y2lC\u001e,\u0017BA9s\u0005\u0011a\u0015n\u001d;\u000b\u0005=\\\u0003CA(u\u0013\t)\bK\u0001\u0004D_2,XN\\\u0001\bKb,7-\u001e;f)\u0005A\bcA6zw&\u0011!P\u001d\u0002\t\u0013R,'/\u00192mKB\u00191\u000e\u001d?\u0011\u0005)j\u0018B\u0001@,\u0005\r\te._\u0001\u0013kB$\u0017\r^3Ue&twnQ8oi\u0016DH\u000f\u0006\u0002\u0002\u0004A\u0019!&!\u0002\n\u0007\u0005\u001d1F\u0001\u0003V]&$\u0018!\u00053sC&tG)\u001a;fGRLgnZ#oIRQ\u0011QBA\n\u0003S\t)$!\u000f\u0011\u0007)\ny!C\u0002\u0002\u0012-\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002\u00169\u0001\r!a\u0006\u0002\u0011I|w/U;fk\u0016\u0004R!!\u0007\u0002&ml!!a\u0007\u000b\u0007\u0005\fiB\u0003\u0003\u0002 \u0005\u0005\u0012\u0001B;uS2T!!a\t\u0002\t)\fg/Y\u0005\u0005\u0003O\tYB\u0001\nBeJ\f\u0017P\u00117pG.LgnZ)vKV,\u0007bBA\u0016\u001d\u0001\u0007\u0011QF\u0001\u0007EV4g-\u001a:\u0011\u000b\u0005=\u0012\u0011G>\u000e\u0005\u0005u\u0011\u0002BA\u001a\u0003;\u0011\u0011\"\u0011:sCfd\u0015n\u001d;\t\r\u0005]b\u00021\u0001Z\u00035i\u0017\r\u001f\"vM\u001a,'oU5{K\"1\u00111\b\bA\u0002m\f\u0001\"\u001a8e)>\\WM\\\u0001\u000baV$xJ\u001d+ie><HCBA\u0002\u0003\u0003\n\u0019\u0005C\u0004\u0002\u0016=\u0001\r!a\u0006\t\r\u0005\u0015s\u00021\u0001|\u0003\u0005)\u0017A\u0004+sS:|7\u000b^1uK6,g\u000e\u001e\t\u0003cE\u0019\"!E\u0015\u0015\u0005\u0005%\u0013aD'B1~\u000bV+R+F\t~\u0013vjV*\u0016\u0005\u0005MsBAA+;\r\u00011\u0019U\u0001\u0011\u001b\u0006Cv,U+F+\u0016#uLU(X'\u0002\n\u0011#T!Y?\n+fIR#S\u000b\u0012{&kT,T+\t\tif\u0004\u0002\u0002`u\u0011q\u0005E\u0001\u0013\u001b\u0006CvLQ+G\r\u0016\u0013V\tR0S\u001f^\u001b\u0006%A\bN\u0003b{&)\u0016$G\u000bJ{F+S'F+\t\t9\u0007\u0005\u0003\u0002j\u0005=TBAA6\u0015\r\ti\u0007Y\u0001\tIV\u0014\u0018\r^5p]&!\u0011\u0011OA6\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f\u0001#T!Y?\n+fIR#S?RKU*\u0012\u0011\u0002\u0013\u0015sEi\u0018+P\u0017\u0016sUCAA=!\u0015\tY(!\"}\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015!C5n[V$\u0018M\u00197f\u0015\r\t\u0019iK\u0001\u000bG>dG.Z2uS>t\u0017bA9\u0002~\u0005QQI\u0014#`)>[UI\u0014\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f%\u000bi)a$\u0002\u0012\")qf\u0007a\u0001a!)Ag\u0007a\u0001k!)1h\u0007a\u0001y\u0001")
public class TrinoStatement {
    private StatementClient trino;
    private int dataProcessingPoolSize;
    private final TrinoContext trinoContext;
    private KyuubiConf kyuubiConf;
    private String sql;
    private final ExecutionContext ec;
    private volatile byte bitmap$0;

    public static TrinoStatement apply(TrinoContext trinoContext, KyuubiConf kyuubiConf, String string) {
        return TrinoStatement$.MODULE$.apply(trinoContext, kyuubiConf, string);
    }

    private StatementClient trino$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.trino = StatementClientFactory.newStatementClient((OkHttpClient)this.trinoContext.httpClient(), (ClientSession)this.trinoContext.clientSession().get(), (String)this.sql);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.sql = null;
        return this.trino;
    }

    private StatementClient trino() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.trino$lzycompute() : this.trino;
    }

    private int dataProcessingPoolSize$lzycompute() {
        TrinoStatement trinoStatement = this;
        synchronized (trinoStatement) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dataProcessingPoolSize = BoxesRunTime.unboxToInt((Object)this.kyuubiConf.get(TrinoConf$.MODULE$.DATA_PROCESSING_POOL_SIZE()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.kyuubiConf = null;
        return this.dataProcessingPoolSize;
    }

    private int dataProcessingPoolSize() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dataProcessingPoolSize$lzycompute() : this.dataProcessingPoolSize;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public StatementClient getTrinoClient() {
        return this.trino();
    }

    public String getCurrentDatabase() {
        return this.trinoContext.clientSession().get().getSchema();
    }

    public List<Column> getColumns() {
        while (this.trino().isRunning()) {
            QueryStatusInfo results = this.trino().currentStatusInfo();
            java.util.List columns = results.getColumns();
            if (columns != null) {
                return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(columns).asScala()).toList();
            }
            this.trino().advance();
        }
        Verify.verify((boolean)this.trino().isFinished());
        QueryStatusInfo finalStatus = this.trino().finalStatusInfo();
        if (finalStatus.getError() == null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(24).append("Query has no columns (#").append(finalStatus.getId()).append(")").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(18).append("Query failed (#").append(finalStatus.getId()).append("): ").append(finalStatus.getError().getMessage()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
    }

    public Iterable<List<Object>> execute() {
        ArrayBlockingQueue<List<Object>> rowQueue = new ArrayBlockingQueue<List<Object>>(50000);
        Future dataProcessing = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            while (this.trino().isRunning()) {
                java.lang.Iterable data = this.trino().currentData().getData();
                if (data != null) {
                    ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(data).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toList(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)e -> {
                        this.putOrThrow(rowQueue, (List<Object>)e);
                        return BoxedUnit.UNIT;
                    });
                }
                this.trino().advance();
            }
        }, this.ec());
        dataProcessing.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TrinoStatement.$anonfun$execute$4(this, rowQueue, x0$1);
            return BoxedUnit.UNIT;
        }, this.ec());
        ArrayList<List<Object>> rowBuffer = new ArrayList<List<Object>>(10000);
        long bufferStart = System.nanoTime();
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        boolean getDataEnd = false;
        while (!dataProcessing.isCompleted() && !getDataEnd) {
            BoxedUnit boxedUnit;
            boolean atEnd = this.drainDetectingEnd(rowQueue, rowBuffer, 10000, TrinoStatement$.MODULE$.org$apache$kyuubi$engine$trino$TrinoStatement$$END_TOKEN());
            if (!atEnd) {
                Object object;
                List<Object> row;
                if (rowBuffer.size() >= 10000 || Duration$.MODULE$.fromNanos(bufferStart).compareTo((Object)TrinoStatement$.MODULE$.org$apache$kyuubi$engine$trino$TrinoStatement$$MAX_BUFFER_TIME()) >= 0) {
                    result.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rowBuffer).asScala());
                    rowBuffer.clear();
                    bufferStart = System.nanoTime();
                }
                List<Object> list = row = rowQueue.poll(TrinoStatement$.MODULE$.org$apache$kyuubi$engine$trino$TrinoStatement$$MAX_BUFFER_TIME().toMillis(), TimeUnit.MILLISECONDS);
                List<Object> list2 = TrinoStatement$.MODULE$.org$apache$kyuubi$engine$trino$TrinoStatement$$END_TOKEN();
                List<Object> list3 = list;
                if (!(list2 != null ? !list2.equals(list3) : list3 != null)) {
                    getDataEnd = true;
                    object = BoxedUnit.UNIT;
                } else {
                    object = list == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)rowBuffer.add(row));
                }
                boxedUnit = object;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = !rowQueue.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)this.drainDetectingEnd(rowQueue, rowBuffer, Integer.MAX_VALUE, TrinoStatement$.MODULE$.org$apache$kyuubi$engine$trino$TrinoStatement$$END_TOKEN())) : BoxedUnit.UNIT;
        result.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rowBuffer).asScala());
        QueryStatusInfo finalStatus = this.trino().finalStatusInfo();
        if (finalStatus.getError() != null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(15).append("Query ").append(finalStatus.getId()).append(" failed: ").append(finalStatus.getError().getMessage()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        this.updateTrinoContext();
        return result;
    }

    public void updateTrinoContext() {
        ClientSession session = this.trinoContext.clientSession().get();
        ClientSession.Builder builder = ClientSession.builder((ClientSession)session);
        if (this.trino().getSetCatalog().isPresent() || this.trino().getSetSchema().isPresent()) {
            builder = builder.withCatalog(this.trino().getSetCatalog().orElse(session.getCatalog())).withSchema(this.trino().getSetSchema().orElse(session.getSchema()));
        }
        if (this.trino().getSetPath().isPresent()) {
            builder = builder.withPath((String)this.trino().getSetPath().get());
        }
        if (!this.trino().getSetSessionProperties().isEmpty() || !this.trino().getResetSessionProperties().isEmpty()) {
            scala.collection.mutable.Map properties = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(session.getProperties()).asScala()).clone();
            properties.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.trino().getSetSessionProperties()).asScala());
            properties.$minus$minus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.trino().getResetSessionProperties()).asScala());
            builder = builder.withProperties((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(properties).asJava());
        }
        this.trinoContext.clientSession().set(builder.build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean drainDetectingEnd(ArrayBlockingQueue<List<Object>> rowQueue, ArrayList<List<Object>> buffer, int maxBufferSize, List<Object> endToken) {
        int drained = rowQueue.drainTo(buffer, maxBufferSize - buffer.size());
        if (drained <= 0) return false;
        List<Object> list = buffer.get(buffer.size() - 1);
        List<Object> list2 = endToken;
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        buffer.remove(buffer.size() - 1);
        return true;
    }

    private void putOrThrow(ArrayBlockingQueue<List<Object>> rowQueue, List<Object> e) {
        try {
            rowQueue.put(e);
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e2);
        }
    }

    public static final /* synthetic */ void $anonfun$execute$4(TrinoStatement $this, ArrayBlockingQueue rowQueue$1, Try x0$1) {
        Try try_ = x0$1;
        $this.putOrThrow(rowQueue$1, TrinoStatement$.MODULE$.org$apache$kyuubi$engine$trino$TrinoStatement$$END_TOKEN());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public TrinoStatement(TrinoContext trinoContext, KyuubiConf kyuubiConf, String sql) {
        this.trinoContext = trinoContext;
        this.kyuubiConf = kyuubiConf;
        this.sql = sql;
        this.ec = ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newFixedThreadPool(this.dataProcessingPoolSize()));
    }
}

