/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.operation.log;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TRow;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TStringColumn;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005et!B\f\u0019\u0011\u0003\u0019c!B\u0013\u0019\u0011\u00031\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%i\u0001\u000e\u0005\b\u0003\u000b\n\u0001\u0015!\u00046\u0011\u001d\t9%\u0001C\u0001\u0003\u0013Bq!a\u0014\u0002\t\u0003\t\t\u0006C\u0004\u0002T\u0005!\t!a\r\t\u000f\u0005U\u0013\u0001\"\u0001\u0002X!9\u0011qM\u0001\u0005\u0002\u0005%d\u0001B\u0013\u0019\u0001yB\u0001b\u0010\u0006\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\u0006c)!\t\u0001\u0013\u0005\t\u0015*A)\u0019!C\u0005\u0017\"A!K\u0003EC\u0002\u0013%1\u000b\u0003\u0005X\u0015!\u0015\r\u0011\"\u0003Y\u0011\u0015\t'\u0002\"\u0001c\u0011\u00159'\u0002\"\u0001i\u0011\u00151(\u0002\"\u0003x\u0011\u001d\t\u0019B\u0003C\u0001\u0003+Aq!!\r\u000b\t\u0003\t\u0019\u0004C\u0004\u00026)!I!a\u000e\t\u000f\u0005\r#\u0002\"\u0003\u00024\u0005aq\n]3sCRLwN\u001c'pO*\u0011\u0011DG\u0001\u0004Y><'BA\u000e\u001d\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002\u001e=\u000511._;vE&T!a\b\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0013aA8sO\u000e\u0001\u0001C\u0001\u0013\u0002\u001b\u0005A\"\u0001D(qKJ\fG/[8o\u0019><7cA\u0001([A\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"AL\u0018\u000e\u0003qI!\u0001\r\u000f\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012aI\u0001\u000e\u001fB+%+\u0011+J\u001f:{FjT$\u0016\u0003U\u00022AN\u001e>\u001b\u00059$B\u0001\u001d:\u0003\u0011a\u0017M\\4\u000b\u0003i\nAA[1wC&\u0011Ah\u000e\u0002\u0017\u0013:DWM]5uC\ndW\r\u00165sK\u0006$Gj\\2bYB\u0011AEC\n\u0003\u0015\u001d\nA\u0001]1uQB\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0005M&dWM\u0003\u0002Fs\u0005\u0019a.[8\n\u0005\u001d\u0013%\u0001\u0002)bi\"$\"!P%\t\u000b}b\u0001\u0019\u0001!\u0002\r]\u0014\u0018\u000e^3s+\u0005a\u0005CA'Q\u001b\u0005q%BA(:\u0003\tIw.\u0003\u0002R\u001d\nq!)\u001e4gKJ,Gm\u0016:ji\u0016\u0014\u0018A\u0002:fC\u0012,'/F\u0001U!\tiU+\u0003\u0002W\u001d\nq!)\u001e4gKJ,GMU3bI\u0016\u0014\u0018\u0001D3yiJ\f'+Z1eKJ\u001cX#A-\u0011\u0007i{F+D\u0001\\\u0015\taV,A\u0004nkR\f'\r\\3\u000b\u0005yK\u0013AC2pY2,7\r^5p]&\u0011\u0001m\u0017\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\u0018aC1eI\u0016CHO]1M_\u001e$\"a\u00194\u0011\u0005!\"\u0017BA3*\u0005\u0011)f.\u001b;\t\u000b}\u0002\u0002\u0019\u0001!\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005\rL\u0007\"\u00026\u0012\u0001\u0004Y\u0017aA7tOB\u0011An\u001d\b\u0003[F\u0004\"A\\\u0015\u000e\u0003=T!\u0001\u001d\u0012\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0018&\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:*\u0003!\u0011X-\u00193M_\u001e\u001cHc\u0002=\u0002\n\u0005-\u0011q\u0002\t\u0006Qe\\\u00181A\u0005\u0003u&\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001?\u0000W6\tQP\u0003\u0002\u007fs\u0005!Q\u000f^5m\u0013\r\t\t! \u0002\n\u0003J\u0014\u0018-\u001f'jgR\u00042\u0001KA\u0003\u0013\r\t9!\u000b\u0002\u0004\u0013:$\b\"\u0002*\u0013\u0001\u0004!\u0006bBA\u0007%\u0001\u0007\u00111A\u0001\tY\u0006\u001cHOU8xg\"9\u0011\u0011\u0003\nA\u0002\u0005\r\u0011aB7bqJ{wo]\u0001\u0005e\u0016\fG\r\u0006\u0003\u0002\u0018\u0005=\u0002\u0003BA\r\u0003Wi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\t\u0005\u0005\u00121E\u0001\u0004eB\u001c'\u0002BA\u0013\u0003O\tqa]3sm&\u001cWMC\u0002\u0002*y\tA\u0001[5wK&!\u0011QFA\u000e\u0005\u001d!&k\\<TKRDq!!\u0005\u0014\u0001\u0004\t\u0019!A\u0003dY>\u001cX\rF\u0001d\u0003%!(/_*bM\u0016d\u0017\u0010F\u0002d\u0003sA\u0001\"a\u000f\u0016\t\u0003\u0007\u0011QH\u0001\u0002MB!\u0001&a\u0010d\u0013\r\t\t%\u000b\u0002\ty\tLh.Y7f}\u0005\t2\r\\8tK\u0016CHO]1SK\u0006$WM]:\u0002\u001d=\u0003VIU!U\u0013>su\fT(HA\u000512/\u001a;DkJ\u0014XM\u001c;Pa\u0016\u0014\u0018\r^5p]2{w\rF\u0002d\u0003\u0017Ba!!\u0014\u0006\u0001\u0004i\u0014\u0001D8qKJ\fG/[8o\u0019><\u0017AF4fi\u000e+(O]3oi>\u0003XM]1uS>tGj\\4\u0016\u0003u\n\u0011D]3n_Z,7)\u001e:sK:$x\n]3sCRLwN\u001c'pO\u0006y2M]3bi\u0016|\u0005/\u001a:bi&|g\u000eT8h%>|G\u000fR5sK\u000e$xN]=\u0015\u0007\r\fI\u0006C\u0004\u0002\\!\u0001\r!!\u0018\u0002\u000fM,7o]5p]B!\u0011qLA2\u001b\t\t\tGC\u0002\u0002\\qIA!!\u001a\u0002b\t91+Z:tS>t\u0017AE2sK\u0006$Xm\u00149fe\u0006$\u0018n\u001c8M_\u001e$R!PA6\u0003[Bq!a\u0017\n\u0001\u0004\ti\u0006C\u0004\u0002p%\u0001\r!!\u001d\u0002\u0011=\u0004\b*\u00198eY\u0016\u0004B!a\u001d\u0002v5\t!$C\u0002\u0002xi\u0011qb\u00149fe\u0006$\u0018n\u001c8IC:$G.\u001a")
public class OperationLog {
    private BufferedWriter writer;
    private BufferedReader reader;
    private ListBuffer<BufferedReader> extraReaders;
    private final Path path;
    private volatile byte bitmap$0;

    public static OperationLog createOperationLog(Session session, OperationHandle operationHandle) {
        return OperationLog$.MODULE$.createOperationLog(session, operationHandle);
    }

    public static void createOperationLogRootDirectory(Session session) {
        OperationLog$.MODULE$.createOperationLogRootDirectory(session);
    }

    public static void removeCurrentOperationLog() {
        OperationLog$.MODULE$.removeCurrentOperationLog();
    }

    public static OperationLog getCurrentOperationLog() {
        return OperationLog$.MODULE$.getCurrentOperationLog();
    }

    public static void setCurrentOperationLog(OperationLog operationLog) {
        OperationLog$.MODULE$.setCurrentOperationLog(operationLog);
    }

    public static void error(Function0<Object> function0) {
        OperationLog$.MODULE$.error(function0);
    }

    public static void error(Function0<Object> function0, Throwable throwable) {
        OperationLog$.MODULE$.error(function0, throwable);
    }

    public static void warn(Function0<Object> function0, Throwable throwable) {
        OperationLog$.MODULE$.warn(function0, throwable);
    }

    public static void warn(Function0<Object> function0) {
        OperationLog$.MODULE$.warn(function0);
    }

    public static void info(Function0<Object> function0) {
        OperationLog$.MODULE$.info(function0);
    }

    public static void debug(Function0<Object> function0) {
        OperationLog$.MODULE$.debug(function0);
    }

    private BufferedWriter writer$lzycompute() {
        OperationLog operationLog = this;
        synchronized (operationLog) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.writer = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, new OpenOption[0]);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.writer;
    }

    private BufferedWriter writer() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private BufferedReader reader$lzycompute() {
        OperationLog operationLog = this;
        synchronized (operationLog) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.reader = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.reader;
    }

    private BufferedReader reader() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.reader$lzycompute() : this.reader;
    }

    private ListBuffer<BufferedReader> extraReaders$lzycompute() {
        OperationLog operationLog = this;
        synchronized (operationLog) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.extraReaders = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.extraReaders;
    }

    private ListBuffer<BufferedReader> extraReaders() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.extraReaders$lzycompute() : this.extraReaders;
    }

    public void addExtraLog(Path path) {
        OperationLog operationLog = this;
        synchronized (operationLog) {
            this.liftedTree1$1(path);
        }
    }

    public synchronized void write(String msg) {
        try {
            this.writer().write(msg);
            this.writer().flush();
        }
        catch (IOException iOException) {}
    }

    private Tuple2<ArrayList<String>, Object> readLogs(BufferedReader reader, int lastRows, int maxRows) {
        Tuple2 tuple2;
        ArrayList<String> logs = new ArrayList<String>();
        try {
            int i;
            String line = reader.readLine();
            for (i = 0; (i < lastRows || maxRows <= 0) && line != null; ++i) {
                logs.add(line);
                line = reader.readLine();
            }
            tuple2 = new Tuple2(logs, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        catch (IOException e) {
            Path absPath = this.path.toAbsolutePath();
            Path opHandle = absPath.getFileName();
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(34).append("Operation[").append(opHandle).append("] log file ").append(absPath).append(" is not found").toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return tuple2;
    }

    public synchronized TRowSet read(int maxRows) {
        Tuple2<ArrayList<String>, Object> tuple2 = this.readLogs(this.reader(), maxRows, maxRows);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ArrayList logs = (ArrayList)tuple2._1();
        int lines = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)logs, (Object)BoxesRunTime.boxToInteger((int)lines));
        Tuple2 tuple23 = tuple22;
        ArrayList logs2 = (ArrayList)tuple23._1();
        int lines2 = tuple23._2$mcI$sp();
        IntRef lastRows = IntRef.create((int)(maxRows - lines2));
        this.extraReaders().withFilter((Function1 & Serializable & scala.Serializable)extraReader -> BoxesRunTime.boxToBoolean((boolean)OperationLog.$anonfun$read$1(lastRows, maxRows, extraReader))).foreach((Function1 & Serializable & scala.Serializable)extraReader -> BoxesRunTime.boxToBoolean((boolean)OperationLog.$anonfun$read$2(this, lastRows, maxRows, logs2, extraReader)));
        TColumn tColumn = TColumn.stringVal(new TStringColumn(logs2, ByteBuffer.allocate(0)));
        TRowSet tRow = new TRowSet(0L, new ArrayList<TRow>(logs2.size()));
        tRow.addToColumns(tColumn);
        return tRow;
    }

    public synchronized void close() {
        this.closeExtraReaders();
        this.trySafely((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.reader().close());
        this.trySafely((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writer().close());
        this.trySafely((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Files.delete($this.path));
    }

    private void trySafely(Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(54).append("Failed to remove corresponding log file of operation: ").append(this.path.toAbsolutePath()).toString(), e);
        }
    }

    private void closeExtraReaders() {
        this.extraReaders().foreach((Function1 & Serializable & scala.Serializable)extraReader -> {
            OperationLog.$anonfun$closeExtraReaders$1(extraReader);
            return BoxedUnit.UNIT;
        });
    }

    private final /* synthetic */ Object liftedTree1$1(Path path$2) {
        BoxedUnit boxedUnit;
        try {
            boxedUnit = this.extraReaders().$plus$eq((Object)Files.newBufferedReader(path$2, StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$read$1(IntRef lastRows$1, int maxRows$1, BufferedReader extraReader) {
        return lastRows$1.elem > 0 || maxRows$1 <= 0;
    }

    public static final /* synthetic */ boolean $anonfun$read$2(OperationLog $this, IntRef lastRows$1, int maxRows$1, ArrayList logs$1, BufferedReader extraReader) {
        Tuple2<ArrayList<String>, Object> tuple2 = $this.readLogs(extraReader, lastRows$1.elem, maxRows$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ArrayList extraLogs = (ArrayList)tuple2._1();
        int extraRows = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)extraLogs, (Object)BoxesRunTime.boxToInteger((int)extraRows));
        Tuple2 tuple23 = tuple22;
        ArrayList extraLogs2 = (ArrayList)tuple23._1();
        int extraRows2 = tuple23._2$mcI$sp();
        lastRows$1.elem -= extraRows2;
        return logs$1.addAll(extraLogs2);
    }

    public static final /* synthetic */ void $anonfun$closeExtraReaders$1(BufferedReader extraReader) {
        try {
            extraReader.close();
        }
        catch (IOException iOException) {}
    }

    public OperationLog(Path path) {
        this.path = path;
    }
}

