/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink.operation;

import java.io.Serializable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQueryBase;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.types.Row;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.engine.flink.operation.FlinkOperation;
import org.apache.kyuubi.engine.flink.result.ResultSet;
import org.apache.kyuubi.engine.flink.result.ResultSetUtil$;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.OperationType$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\r\u001b\u0001\u001dB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tm\u0001\u0011)\u0019!C!o!AQ\t\u0001B\u0001B\u0003%\u0001\b\u0003\u0005G\u0001\t\u0015\r\u0011\"\u0011H\u0011!a\u0005A!A!\u0002\u0013A\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011E\u0003!\u0011!Q\u0001\nICQ!\u0016\u0001\u0005\u0002YCq!\u0018\u0001C\u0002\u0013%a\f\u0003\u0004g\u0001\u0001\u0006Ia\u0018\u0005\bO\u0002\u0001\r\u0011\"\u0003i\u0011\u001d1\b\u00011A\u0005\n]Da! \u0001!B\u0013I\u0007\"\u0002@\u0001\t\u0003z\bbBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003w\u0001A\u0011AA\u001f\u0011\u001d\t\u0019\u0005\u0001C)\u0003\u000bBq!a\u0012\u0001\t#\n)\u0005C\u0004\u0002J\u0001!\t&!\u0012\t\u000f\u0005-\u0003\u0001\"\u0003\u0002F!9\u0011Q\n\u0001\u0005\n\u0005=\u0003bBA0\u0001\u0011%\u0011\u0011\r\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\t\u0019\b\u0001C\u0005\u0003\u000b\u0012\u0001#\u0012=fGV$Xm\u0015;bi\u0016lWM\u001c;\u000b\u0005ma\u0012!C8qKJ\fG/[8o\u0015\tib$A\u0003gY&t7N\u0003\u0002 A\u00051QM\\4j]\u0016T!!\t\u0012\u0002\r-LX/\u001e2j\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u000b\u0017\u0011\u0005%RS\"\u0001\u000e\n\u0005-R\"A\u0004$mS:\\w\n]3sCRLwN\u001c\t\u0003[9j\u0011\u0001I\u0005\u0003_\u0001\u0012q\u0001T8hO&tw-A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005I\"T\"A\u001a\u000b\u0005A\u0002\u0013BA\u001b4\u0005\u001d\u0019Vm]:j_:\f\u0011b\u001d;bi\u0016lWM\u001c;\u0016\u0003a\u0002\"!\u000f\"\u000f\u0005i\u0002\u0005CA\u001e?\u001b\u0005a$BA\u001f'\u0003\u0019a$o\\8u})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\te(\u0001\u0006ti\u0006$X-\\3oi\u0002\nab\u001d5pk2$'+\u001e8Bgft7-F\u0001I!\tI%*D\u0001?\u0013\tYeHA\u0004C_>dW-\u00198\u0002\u001fMDw.\u001e7e%Vt\u0017i]=oG\u0002\nA\"];fef$\u0016.\\3pkR\u0004\"!S(\n\u0005As$\u0001\u0002'p]\u001e\fQB]3tk2$X*\u0019=S_^\u001c\bCA%T\u0013\t!fHA\u0002J]R\fa\u0001P5oSRtDCB,Y3j[F\f\u0005\u0002*\u0001!)\u0001\u0007\u0003a\u0001c!)a\u0007\u0003a\u0001q!)a\t\u0003a\u0001\u0011\")Q\n\u0003a\u0001\u001d\")\u0011\u000b\u0003a\u0001%\u0006aq\u000e]3sCRLwN\u001c'pOV\tq\f\u0005\u0002aI6\t\u0011M\u0003\u0002cG\u0006\u0019An\\4\u000b\u0005m\u0001\u0013BA3b\u00051y\u0005/\u001a:bi&|g\u000eT8h\u00035y\u0007/\u001a:bi&|g\u000eT8hA\u000592\u000f^1uK6,g\u000e\u001e+j[\u0016|W\u000f^\"mK\u0006tWM]\u000b\u0002SB\u0019\u0011J\u001b7\n\u0005-t$AB(qi&|g\u000e\u0005\u0002ni6\taN\u0003\u0002pa\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005E\u0014\u0018\u0001B;uS2T\u0011a]\u0001\u0005U\u00064\u0018-\u0003\u0002v]\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u00027M$\u0018\r^3nK:$H+[7f_V$8\t\\3b]\u0016\u0014x\fJ3r)\tA8\u0010\u0005\u0002Js&\u0011!P\u0010\u0002\u0005+:LG\u000fC\u0004}\u0019\u0005\u0005\t\u0019A5\u0002\u0007a$\u0013'\u0001\rti\u0006$X-\\3oiRKW.Z8vi\u000ecW-\u00198fe\u0002\nqbZ3u\u001fB,'/\u0019;j_:dunZ\u000b\u0003\u0003\u0003\u00012!\u00136`\u0003-\u0019X\r^#yK\u000e,Ho\u001c:\u0015\u0007a\f9\u0001C\u0004\u0002\n=\u0001\r!a\u0003\u0002\u0011\u0015DXmY;u_J\u0004B!!\u0004\u0002\u001e5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0004hCR,w/Y=\u000b\t\u0005U\u0011qC\u0001\u0007G2LWM\u001c;\u000b\t\u0005e\u00111D\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003;\tJA!a\b\u0002\u0010\tAQ\t_3dkR|'\u000fK\u0002\u0010\u0003G\u0001B!!\n\u000285\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0006b]:|G/\u0019;j_:\u001c(\u0002BA\u0017\u0003_\taaY8n[>t'\u0002BA\u0019\u0003g\taaZ8pO2,'BAA\u001b\u0003\r\u0019w.\\\u0005\u0005\u0003s\t9CA\tWSNL'\r\\3G_J$Vm\u001d;j]\u001e\fAb]3u'\u0016\u001c8/[8o\u0013\u0012$2\u0001_A \u0011\u0019\t\t\u0005\u0005a\u0001q\u0005I1/Z:tS>t\u0017\nZ\u0001\nE\u00164wN]3Sk:$\u0012\u0001_\u0001\tC\u001a$XM\u001d*v]\u0006Y!/\u001e8J]R,'O\\1m\u0003A)\u00070Z2vi\u0016\u001cF/\u0019;f[\u0016tG/A\tsk:\fV/\u001a:z\u001fB,'/\u0019;j_:$2\u0001_A)\u0011\u0019YR\u00031\u0001\u0002TA!\u0011QKA.\u001b\t\t9F\u0003\u0003\u0002Z\u0005]\u0011AC8qKJ\fG/[8og&!\u0011QLA,\u00059\tV/\u001a:z\u001fB,'/\u0019;j_:\fAB];o\u001fB,'/\u0019;j_:$2\u0001_A2\u0011\u0019Yb\u00031\u0001\u0002fA!\u0011QKA4\u0013\u0011\tI'a\u0016\u0003\u0013=\u0003XM]1uS>t\u0017AE2mK\u0006tW\u000f])vKJL(+Z:vYR$2\u0001_A8\u0011\u0019\t\th\u0006a\u0001q\u0005A!/Z:vYRLE-A\tbI\u0012$\u0016.\\3pkRluN\\5u_J\u0004")
public class ExecuteStatement
extends FlinkOperation {
    private final Session session;
    private final String statement;
    private final boolean shouldRunAsync;
    private final long queryTimeout;
    private final int resultMaxRows;
    private final OperationLog org$apache$kyuubi$engine$flink$operation$ExecuteStatement$$operationLog;
    private Option<ScheduledExecutorService> statementTimeoutCleaner;

    @Override
    public String statement() {
        return this.statement;
    }

    @Override
    public boolean shouldRunAsync() {
        return this.shouldRunAsync;
    }

    public OperationLog org$apache$kyuubi$engine$flink$operation$ExecuteStatement$$operationLog() {
        return this.org$apache$kyuubi$engine$flink$operation$ExecuteStatement$$operationLog;
    }

    private Option<ScheduledExecutorService> statementTimeoutCleaner() {
        return this.statementTimeoutCleaner;
    }

    private void statementTimeoutCleaner_$eq(Option<ScheduledExecutorService> x$1) {
        this.statementTimeoutCleaner = x$1;
    }

    @Override
    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this.org$apache$kyuubi$engine$flink$operation$ExecuteStatement$$operationLog());
    }

    @Override
    @VisibleForTesting
    public void setExecutor(Executor executor) {
        super.setExecutor(executor);
    }

    public void setSessionId(String sessionId) {
        this.sessionId_$eq(sessionId);
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this.org$apache$kyuubi$engine$flink$operation$ExecuteStatement$$operationLog());
        this.setState(OperationState$.MODULE$.PENDING());
        this.setHasResultSet(true);
    }

    @Override
    public void afterRun() {
        OperationLog$.MODULE$.removeCurrentOperationLog();
    }

    @Override
    public void runInternal() {
        this.addTimeoutMonitor();
        if (this.shouldRunAsync()) {
            Runnable asyncOperation = new Runnable(this){
                private final /* synthetic */ ExecuteStatement $outer;

                public void run() {
                    OperationLog$.MODULE$.setCurrentOperationLog(this.$outer.org$apache$kyuubi$engine$flink$operation$ExecuteStatement$$operationLog());
                    this.$outer.org$apache$kyuubi$engine$flink$operation$ExecuteStatement$$executeStatement();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            try {
                SessionManager flinkSQLSessionManager = this.session.sessionManager();
                Future<?> backgroundHandle = flinkSQLSessionManager.submitBackgroundOperation(asyncOperation);
                this.setBackgroundHandle(backgroundHandle);
            }
            catch (RejectedExecutionException rejected) {
                this.setState(OperationState$.MODULE$.ERROR());
                KyuubiSQLException ke = KyuubiSQLException$.MODULE$.apply("Error submitting query in background, query rejected", rejected, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                this.setOperationException(ke);
                throw ke;
            }
        } else {
            this.org$apache$kyuubi$engine$flink$operation$ExecuteStatement$$executeStatement();
        }
    }

    public void org$apache$kyuubi$engine$flink$operation$ExecuteStatement$$executeStatement() {
        block14: {
            try {
                try {
                    Operation operation;
                    this.setState(OperationState$.MODULE$.RUNNING());
                    RelMetadataQueryBase.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)DefaultRelMetadataProvider.INSTANCE));
                    Operation operation2 = operation = this.executor().parseStatement(this.sessionId(), this.statement());
                    if (operation2 instanceof QueryOperation) {
                        QueryOperation queryOperation = (QueryOperation)operation2;
                        this.runQueryOperation(queryOperation);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (operation2 instanceof SetOperation) {
                        SetOperation setOperation = (SetOperation)operation2;
                        this.resultSet_$eq(ResultSetUtil$.MODULE$.runSetOperation(setOperation, this.executor(), this.sessionId()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (operation2 instanceof ResetOperation) {
                        ResetOperation resetOperation = (ResetOperation)operation2;
                        this.resultSet_$eq(ResultSetUtil$.MODULE$.runResetOperation(resetOperation, this.executor(), this.sessionId()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (operation2 != null) {
                        Operation operation3 = operation2;
                        this.runOperation(operation3);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)operation2);
                    }
                    this.setState(OperationState$.MODULE$.FINISHED());
                }
                catch (Throwable x$1) {
                    PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(true);
                    if (catchExpr$1.isDefinedAt((Object)x$1)) {
                        catchExpr$1.apply((Object)x$1);
                        break block14;
                    }
                    throw x$1;
                }
            }
            finally {
                this.statementTimeoutCleaner().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.shutdown();
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    private void runQueryOperation(QueryOperation operation) {
        ObjectRef resultId = ObjectRef.create(null);
        try {
            ResultDescriptor resultDescriptor = this.executor().executeQuery(this.sessionId(), operation);
            resultId.elem = resultDescriptor.getResultId();
            ArrayBuffer rows = new ArrayBuffer();
            BooleanRef loop = BooleanRef.create((boolean)true);
            while (loop.elem) {
                BoxedUnit boxedUnit;
                Thread.sleep(50L);
                int pageSize = Math.min(500, this.resultMaxRows);
                TypedResult result = this.executor().snapshotResult(this.sessionId(), (String)resultId.elem, pageSize);
                TypedResult.ResultType resultType = result.getType();
                if (TypedResult.ResultType.PAYLOAD.equals(resultType)) {
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), Predef$.MODULE$.Integer2int((Integer)result.getPayload())).foreach((Function1 & Serializable & scala.Serializable)page -> ExecuteStatement.$anonfun$runQueryOperation$1(this, rows, resultId, loop, BoxesRunTime.unboxToInt((Object)page)));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (TypedResult.ResultType.EOS.equals(resultType)) {
                    loop.elem = false;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (TypedResult.ResultType.EMPTY.equals(resultType)) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)resultType);
            }
            this.resultSet_$eq(ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(resultDescriptor.getResultSchema().getColumns()).data((Row[])((TraversableOnce)rows.slice(0, this.resultMaxRows)).toArray(ClassTag$.MODULE$.apply(Row.class))).build());
        }
        finally {
            if ((String)resultId.elem != null) {
                this.cleanupQueryResult((String)resultId.elem);
            }
        }
    }

    private void runOperation(Operation operation) {
        TableResult result = this.executor().executeOperation(this.sessionId(), operation);
        result.await();
        this.resultSet_$eq(ResultSet.fromTableResult(result));
    }

    private void cleanupQueryResult(String resultId) {
        try {
            this.executor().cancelQuery(this.sessionId(), resultId);
        }
        catch (Throwable t) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Failed to clean result set ").append(resultId).append(" in session ").append(this.sessionId()).toString(), t);
        }
    }

    private void addTimeoutMonitor() {
        block0: {
            if (this.queryTimeout <= 0L) break block0;
            ScheduledExecutorService timeoutExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("query-timeout-thread");
            Runnable action = () -> this.cleanup(OperationState$.MODULE$.TIMEOUT());
            timeoutExecutor.schedule(action, this.queryTimeout, TimeUnit.SECONDS);
            this.statementTimeoutCleaner_$eq((Option<ScheduledExecutorService>)new Some((Object)timeoutExecutor));
        }
    }

    public static final /* synthetic */ Object $anonfun$runQueryOperation$1(ExecuteStatement $this, ArrayBuffer rows$1, ObjectRef resultId$1, BooleanRef loop$1, int page) {
        BoxedUnit boxedUnit;
        if (rows$1.size() < $this.resultMaxRows) {
            boxedUnit = rows$1.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter($this.executor().retrieveResultPage((String)resultId$1.elem, page)).asScala());
        } else {
            loop$1.elem = false;
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public ExecuteStatement(Session session, String statement, boolean shouldRunAsync, long queryTimeout, int resultMaxRows) {
        this.session = session;
        this.statement = statement;
        this.shouldRunAsync = shouldRunAsync;
        this.queryTimeout = queryTimeout;
        this.resultMaxRows = resultMaxRows;
        super(OperationType$.MODULE$.EXECUTE_STATEMENT(), session);
        this.org$apache$kyuubi$engine$flink$operation$ExecuteStatement$$operationLog = OperationLog$.MODULE$.createOperationLog(session, this.getHandle());
        this.statementTimeoutCleaner = None$.MODULE$;
    }
}

