/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import java.io.Serializable;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.EngineSecurityAccessor$;
import org.apache.kyuubi.service.authentication.EngineSecuritySecretProvider;
import org.apache.kyuubi.service.authentication.EngineSecuritySecretProvider$;
import org.apache.kyuubi.service.authentication.KyuubiInternalAccessIdentifier;
import org.apache.kyuubi.service.authentication.KyuubiInternalAccessIdentifier$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\u0014(\u0001IB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\"AQ\t\u0001B\u0001B\u0003%!\tC\u0003G\u0001\u0011\u0005q\tC\u0004M\u0001\t\u0007I\u0011A'\t\rE\u0003\u0001\u0015!\u0003O\u0011\u001d\u0011\u0006A1A\u0005\u00025Caa\u0015\u0001!\u0002\u0013q\u0005b\u0002+\u0001\u0005\u0004%\t!\u0016\u0005\u0007C\u0002\u0001\u000b\u0011\u0002,\t\u000f\t\u0004!\u0019!C\u0001+\"11\r\u0001Q\u0001\nYCq\u0001\u001a\u0001C\u0002\u0013%Q\r\u0003\u0004j\u0001\u0001\u0006IA\u001a\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u0011\u0019y\u0007\u0001)A\u0005Y\"Q\u0001\u000f\u0001I\u0001\u0002\u0007\u0005\u000b\u0011B9\t\u000fq\u0004!\u0019!C\u0005{\"1a\u0010\u0001Q\u0001\nQDqa \u0001C\u0002\u0013%Q\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002;\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006!9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\t\u0003C\u0001A\u0011A\u0014\u0002$!A\u0011\u0011\u0006\u0001\u0005\u0002\u001d\nY\u0003C\u0004\u00020\u0001!I!!\r\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!9\u0011\u0011\n\u0001\u0005\n\u0005-saBA)O!\u0005\u00111\u000b\u0004\u0007M\u001dB\t!!\u0016\t\r\u0019{B\u0011AA0\u0011-\t\tg\ba\u0001\u0002\u0004%I!a\u0019\t\u0017\u0005\u0015t\u00041AA\u0002\u0013%\u0011q\r\u0005\u000b\u0003Wz\u0002\u0019!A!B\u0013A\u0005bBA;?\u0011\u0005\u0011q\u000f\u0005\b\u0003{zB\u0011AA@\u0005Y)enZ5oKN+7-\u001e:jif\f5mY3tg>\u0014(B\u0001\u0015*\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!AK\u0016\u0002\u000fM,'O^5dK*\u0011A&L\u0001\u0007Wf,XOY5\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0007\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VMZ\u0001\u0005G>tg\r\u0005\u0002<}5\tAH\u0003\u0002>W\u000511m\u001c8gS\u001eL!a\u0010\u001f\u0003\u0015-KX/\u001e2j\u0007>tg-\u0001\u0005jgN+'O^3s+\u0005\u0011\u0005C\u0001\u001bD\u0013\t!UGA\u0004C_>dW-\u00198\u0002\u0013%\u001c8+\u001a:wKJ\u0004\u0013A\u0002\u001fj]&$h\bF\u0002I\u0015.\u0003\"!\u0013\u0001\u000e\u0003\u001dBQ!\u000f\u0003A\u0002iBQ\u0001\u0011\u0003A\u0002\t\u000bAc\u0019:zaR|7*Z=MK:<G\u000f\u001b\"zi\u0016\u001cX#\u0001(\u0011\u0005Qz\u0015B\u0001)6\u0005\rIe\u000e^\u0001\u0016GJL\b\u000f^8LKfdUM\\4uQ\nKH/Z:!\u00039\u0019'/\u001f9u_&3H*\u001a8hi\"\fqb\u0019:zaR|\u0017J\u001e'f]\u001e$\b\u000eI\u0001\u0013GJL\b\u000f^8LKf\fEnZ8sSRDW.F\u0001W!\t9fL\u0004\u0002Y9B\u0011\u0011,N\u0007\u00025*\u00111,M\u0001\u0007yI|w\u000e\u001e \n\u0005u+\u0014A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!X\u001b\u0002'\r\u0014\u0018\u0010\u001d;p\u0017\u0016L\u0018\t\\4pe&$\b.\u001c\u0011\u0002\u0019\r\u0014\u0018\u0010\u001d;p\u0007&\u0004\b.\u001a:\u0002\u001b\r\u0014\u0018\u0010\u001d;p\u0007&\u0004\b.\u001a:!\u0003A!xn[3o\u001b\u0006DH*\u001b4f)&lW-F\u0001g!\t!t-\u0003\u0002ik\t!Aj\u001c8h\u0003E!xn[3o\u001b\u0006DH*\u001b4f)&lW\rI\u0001\taJ|g/\u001b3feV\tA\u000e\u0005\u0002J[&\u0011an\n\u0002\u001d\u000b:<\u0017N\\3TK\u000e,(/\u001b;z'\u0016\u001c'/\u001a;Qe>4\u0018\u000eZ3s\u0003%\u0001(o\u001c<jI\u0016\u0014\b%A\u0002yIE\u0002B\u0001\u000e:ui&\u00111/\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018AB2ssB$xNC\u0001z\u0003\u0015Q\u0017M^1y\u0013\tYhO\u0001\u0004DSBDWM]\u0001\nK:\u001c'/\u001f9u_J,\u0012\u0001^\u0001\u000bK:\u001c'/\u001f9u_J\u0004\u0013!\u00033fGJL\b\u000f^8s\u0003)!Wm\u0019:zaR|'\u000fI\u0001\u0012S:LG/[1mSj,gi\u001c:BkRDG#B9\u0002\b\u0005-\u0001BBA\u0005-\u0001\u0007a+\u0001\u0004dSBDWM\u001d\u0005\u0007\u0003\u001b1\u0002\u0019\u0001,\u0002\rM,7M]3u\u0003)I7o];f)>\\WM\u001c\u000b\u0002-\u0006I\u0011-\u001e;i)>\\WM\u001c\u000b\u0005\u0003/\ti\u0002E\u00025\u00033I1!a\u00076\u0005\u0011)f.\u001b;\t\r\u0005}\u0001\u00041\u0001W\u0003!!xn[3o'R\u0014\u0018aB3oGJL\b\u000f\u001e\u000b\u0004-\u0006\u0015\u0002BBA\u00143\u0001\u0007a+A\u0003wC2,X-A\u0004eK\u000e\u0014\u0018\u0010\u001d;\u0015\u0007Y\u000bi\u0003\u0003\u0004\u0002(i\u0001\rAV\u0001\u0010]>\u0014X.\u00197ju\u0016\u001cVm\u0019:fiR\u0019a+a\r\t\r\u000551\u00041\u0001W\u0003QAW\r_*ue&tw\rV8CsR,\u0017I\u001d:bsR!\u0011\u0011HA#!\u0015!\u00141HA \u0013\r\ti$\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004i\u0005\u0005\u0013bAA\"k\t!!)\u001f;f\u0011\u0019\t9\u0005\ba\u0001-\u0006\u00191\u000f\u001e:\u0002)\tLH/Z!se\u0006LHk\u001c%fqN#(/\u001b8h)\r1\u0016Q\n\u0005\b\u0003\u001fj\u0002\u0019AA\u001d\u0003\u0015\u0011\u0017\u0010^3t\u0003Y)enZ5oKN+7-\u001e:jif\f5mY3tg>\u0014\bCA% '\u0011y2'a\u0016\u0011\t\u0005e\u00131L\u0007\u0002W%\u0019\u0011QL\u0016\u0003\u000f1{wmZ5oOR\u0011\u00111K\u0001\u0018?\u0016tw-\u001b8f'\u0016\u001cWO]5us\u0006\u001b7-Z:t_J,\u0012\u0001S\u0001\u001c?\u0016tw-\u001b8f'\u0016\u001cWO]5us\u0006\u001b7-Z:t_J|F%Z9\u0015\t\u0005]\u0011\u0011\u000e\u0005\ba\n\n\t\u00111\u0001I\u0003ayVM\\4j]\u0016\u001cVmY;sSRL\u0018iY2fgN|'\u000f\t\u0015\u0004G\u0005=\u0004c\u0001\u001b\u0002r%\u0019\u00111O\u001b\u0003\u0011Y|G.\u0019;jY\u0016\f!\"\u001b8ji&\fG.\u001b>f)\u0019\t9\"!\u001f\u0002|!)\u0011\b\na\u0001u!)\u0001\t\na\u0001\u0005\u0006\u0019q-\u001a;\u0015\u0003!\u0003")
public class EngineSecurityAccessor {
    private final boolean isServer;
    private final int cryptoKeyLengthBytes;
    private final int cryptoIvLength;
    private final String cryptoKeyAlgorithm;
    private final String cryptoCipher;
    private final long tokenMaxLifeTime;
    private final EngineSecuritySecretProvider provider;
    private final /* synthetic */ Tuple2 x$1;
    private final Cipher encryptor;
    private final Cipher decryptor;

    public static EngineSecurityAccessor get() {
        return EngineSecurityAccessor$.MODULE$.get();
    }

    public static void initialize(KyuubiConf kyuubiConf, boolean bl) {
        EngineSecurityAccessor$.MODULE$.initialize(kyuubiConf, bl);
    }

    public static void error(Function0<Object> function0) {
        EngineSecurityAccessor$.MODULE$.error(function0);
    }

    public static void error(Function0<Object> function0, Throwable throwable) {
        EngineSecurityAccessor$.MODULE$.error(function0, throwable);
    }

    public static void warn(Function0<Object> function0, Throwable throwable) {
        EngineSecurityAccessor$.MODULE$.warn(function0, throwable);
    }

    public static void warn(Function0<Object> function0) {
        EngineSecurityAccessor$.MODULE$.warn(function0);
    }

    public static void info(Function0<Object> function0) {
        EngineSecurityAccessor$.MODULE$.info(function0);
    }

    public static void debug(Function0<Object> function0) {
        EngineSecurityAccessor$.MODULE$.debug(function0);
    }

    public boolean isServer() {
        return this.isServer;
    }

    public int cryptoKeyLengthBytes() {
        return this.cryptoKeyLengthBytes;
    }

    public int cryptoIvLength() {
        return this.cryptoIvLength;
    }

    public String cryptoKeyAlgorithm() {
        return this.cryptoKeyAlgorithm;
    }

    public String cryptoCipher() {
        return this.cryptoCipher;
    }

    private long tokenMaxLifeTime() {
        return this.tokenMaxLifeTime;
    }

    private EngineSecuritySecretProvider provider() {
        return this.provider;
    }

    private Cipher encryptor() {
        return this.encryptor;
    }

    private Cipher decryptor() {
        return this.decryptor;
    }

    private Tuple2<Cipher, Cipher> initializeForAuth(String cipher, String secret) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(secret.getBytes(), this.cryptoKeyAlgorithm());
        byte[] nonce = new byte[this.cryptoIvLength()];
        IvParameterSpec iv = new IvParameterSpec(nonce);
        Cipher _encryptor = Cipher.getInstance(cipher);
        _encryptor.init(1, (Key)secretKeySpec, iv);
        Cipher _decryptor = Cipher.getInstance(cipher);
        _decryptor.init(2, (Key)secretKeySpec, iv);
        return new Tuple2((Object)_encryptor, (Object)_decryptor);
    }

    public String issueToken() {
        return this.encrypt(KyuubiInternalAccessIdentifier$.MODULE$.newIdentifier(this.tokenMaxLifeTime()).toJson());
    }

    public void authToken(String tokenStr) {
        KyuubiInternalAccessIdentifier kyuubiInternalAccessIdentifier;
        try {
            kyuubiInternalAccessIdentifier = KyuubiInternalAccessIdentifier$.MODULE$.fromJson(this.decrypt(tokenStr));
        }
        catch (Exception exception) {
            throw KyuubiSQLException$.MODULE$.apply("Invalid engine access token", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        KyuubiInternalAccessIdentifier identifier = kyuubiInternalAccessIdentifier;
        if (identifier.issueDate() + identifier.maxDate() < System.currentTimeMillis()) {
            throw KyuubiSQLException$.MODULE$.apply("The engine access token is expired", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
    }

    public String encrypt(String value) {
        return this.byteArrayToHexString(this.encryptor().doFinal(value.getBytes()));
    }

    public String decrypt(String value) {
        return new String(this.decryptor().doFinal(this.hexStringToByteArray(value)));
    }

    private String normalizeSecret(String secret) {
        char[] normalizedSecret = new char[this.cryptoKeyLengthBytes()];
        char placeHolder = ' ';
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.cryptoKeyLengthBytes()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            normalizedSecret$1[i] = i < secret.length() ? secret.charAt(i) : placeHolder;
        });
        return new String(normalizedSecret);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] hexStringToByteArray(String str) {
        void var3_3;
        int len = str.length();
        Predef$.MODULE$.assert(len % 2 == 0);
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        return var3_3;
    }

    private String byteArrayToHexString(byte[] bytes) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)object -> EngineSecurityAccessor.$anonfun$byteArrayToHexString$1(BoxesRunTime.unboxToByte((Object)object)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> new StringBuilder(0).append((String)x$2).append((String)x$3).toString());
    }

    public static final /* synthetic */ String $anonfun$byteArrayToHexString$1(byte by) {
        return new StringBuilder(0).append(Integer.toHexString(by >> 4 & 0xF)).append(Integer.toHexString(by & 0xF)).toString();
    }

    public EngineSecurityAccessor(KyuubiConf conf, boolean isServer) {
        this.isServer = isServer;
        this.cryptoKeyLengthBytes = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_KEY_LENGTH())) / 8;
        this.cryptoIvLength = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_IV_LENGTH()));
        this.cryptoKeyAlgorithm = conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_KEY_ALGORITHM());
        this.cryptoCipher = conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_CIPHER_TRANSFORMATION());
        this.tokenMaxLifeTime = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_TOKEN_MAX_LIFETIME()));
        this.provider = EngineSecuritySecretProvider$.MODULE$.create(conf);
        Tuple2<Cipher, Cipher> tuple2 = this.initializeForAuth(this.cryptoCipher(), this.normalizeSecret(this.provider().getSecret()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Cipher encryptor = (Cipher)tuple2._1();
        Cipher decryptor = (Cipher)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)encryptor, (Object)decryptor);
        this.x$1 = tuple22;
        this.encryptor = (Cipher)this.x$1._1();
        this.decryptor = (Cipher)this.x$1._2();
    }
}

