/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Preconditions;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.RequestConfigBuilder;
import io.fabric8.kubernetes.client.dsl.FieldValidateable;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PatchUtils;
import io.fabric8.kubernetes.client.dsl.internal.VersionUsageUtils;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.impl.BaseClient;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSupport {
    private static final String FIELD_MANAGER_PARAM = "?fieldManager=";
    public static final String JSON = "application/json";
    public static final String JSON_PATCH = "application/json-patch+json";
    public static final String STRATEGIC_MERGE_JSON_PATCH = "application/strategic-merge-patch+json";
    public static final String JSON_MERGE_PATCH = "application/merge-patch+json";
    private static final Logger LOG = LoggerFactory.getLogger(OperationSupport.class);
    private static final String CLIENT_STATUS_FLAG = "CLIENT_STATUS_FLAG";
    protected OperationContext context;
    protected final HttpClient httpClient;
    protected final Config config;
    protected final String resourceT;
    protected String namespace;
    protected String name;
    protected String subresource;
    protected String apiGroupName;
    protected String apiGroupVersion;
    protected boolean dryRun;

    public OperationSupport(Client client) {
        this(new OperationContext().withClient(client));
    }

    public OperationSupport(OperationContext ctx) {
        this.context = ctx;
        this.httpClient = ctx.getHttpClient();
        this.config = ctx.getConfig();
        this.resourceT = ctx.getPlural();
        this.namespace = ctx.getNamespace();
        this.name = ctx.getName();
        this.subresource = ctx.getSubresource();
        this.apiGroupName = ctx.getApiGroupName();
        this.dryRun = ctx.getDryRun();
        this.apiGroupVersion = Utils.isNotNullOrEmpty((String)ctx.getApiGroupVersion()) ? ctx.getApiGroupVersion() : (ctx.getConfig() != null && Utils.isNotNullOrEmpty((String)ctx.getConfig().getApiVersion()) ? ctx.getConfig().getApiVersion() : "v1");
    }

    public String getAPIGroupName() {
        return this.apiGroupName;
    }

    public String getAPIGroupVersion() {
        return this.apiGroupVersion;
    }

    public String getResourceT() {
        return this.resourceT;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean isResourceNamespaced() {
        return true;
    }

    protected List<String> getRootUrlParts() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.config.getMasterUrl());
        if (!Utils.isNullOrEmpty((String)this.apiGroupName)) {
            result.add("apis");
            result.add(this.apiGroupName);
            result.add(this.apiGroupVersion);
        } else {
            result.add("api");
            result.add(this.apiGroupVersion);
        }
        return result;
    }

    protected URL getNamespacedUrl(String namespace, String type) throws MalformedURLException {
        List<String> parts = this.getRootUrlParts();
        this.addNamespacedUrlPathParts(parts, namespace, type);
        URL requestUrl = new URL(URLUtils.join((String[])parts.toArray(new String[parts.size()])));
        return requestUrl;
    }

    public URL getNamespacedUrl(String namespace) throws MalformedURLException {
        return this.getNamespacedUrl(namespace, this.resourceT);
    }

    protected void addNamespacedUrlPathParts(List<String> parts, String namespace, String type) {
        if (this.isResourceNamespaced() && Utils.isNotNullOrEmpty((String)namespace)) {
            parts.add("namespaces");
            parts.add(namespace);
        }
        if (Utils.isNotNullOrEmpty((String)type)) {
            parts.add(type);
        }
    }

    public URL getNamespacedUrl() throws MalformedURLException {
        return this.getNamespacedUrl(this.getNamespace());
    }

    public URL getResourceUrl(String namespace, String name, String ... subresources) throws MalformedURLException {
        String subresourcePath = URLUtils.pathJoin((String[])subresources);
        if (name == null) {
            if (Utils.isNotNullOrEmpty((String)subresourcePath)) {
                throw new KubernetesClientException("name not specified for an operation requiring one.");
            }
            return this.getNamespacedUrl(namespace);
        }
        String path = name;
        if (Utils.isNotNullOrEmpty((String)subresourcePath)) {
            path = URLUtils.pathJoin((String[])new String[]{path, subresourcePath});
        }
        return new URL(URLUtils.join((String[])new String[]{this.getNamespacedUrl(namespace).toString(), path}));
    }

    public URL getResourceUrl(String namespace, String name) throws MalformedURLException {
        return this.getResourceUrl(namespace, name, this.subresource);
    }

    public URL getResourceUrl() throws MalformedURLException {
        return this.getResourceUrl(this.namespace, this.name, this.subresource);
    }

    public URL getResourceURLForWriteOperation(URL resourceURL) throws MalformedURLException {
        if (this.dryRun) {
            resourceURL = new URL(URLUtils.join((String[])new String[]{resourceURL.toString(), "?dryRun=All"}));
        }
        if (this.context.fieldValidation != null) {
            resourceURL = new URL(URLUtils.join((String[])new String[]{resourceURL.toString(), "?fieldValidation=" + this.context.fieldValidation.parameterValue()}));
        }
        return resourceURL;
    }

    public URL getResourceURLForPatchOperation(URL resourceUrl, PatchContext patchContext) throws MalformedURLException {
        if (patchContext != null) {
            String fieldValidation;
            String fieldManager;
            String url = resourceUrl.toString();
            Boolean forceConflicts = patchContext.getForce();
            if (forceConflicts == null) {
                forceConflicts = this.context.forceConflicts;
            }
            if (forceConflicts != null) {
                url = URLUtils.join((String[])new String[]{url, "?force=" + forceConflicts});
            }
            if (patchContext.getDryRun() != null && !patchContext.getDryRun().isEmpty() || this.dryRun) {
                url = URLUtils.join((String[])new String[]{url, "?dryRun=All"});
            }
            if ((fieldManager = patchContext.getFieldManager()) == null) {
                fieldManager = this.context.fieldManager;
            }
            if (fieldManager == null && patchContext.getPatchType() == PatchType.SERVER_SIDE_APPLY) {
                fieldManager = "fabric8";
            }
            if (fieldManager != null) {
                url = URLUtils.join((String[])new String[]{url, FIELD_MANAGER_PARAM + fieldManager});
            }
            if ((fieldValidation = patchContext.getFieldValidation()) == null && this.context.fieldValidation != null) {
                fieldValidation = this.context.fieldValidation.parameterValue();
            }
            if (fieldValidation != null) {
                url = URLUtils.join((String[])new String[]{url, "?fieldValidation=" + fieldValidation});
            }
            return new URL(url);
        }
        return resourceUrl;
    }

    protected <T> T correctNamespace(T item) {
        if (!this.isResourceNamespaced() || this.context.isDefaultNamespace() || !(item instanceof HasMetadata)) {
            return item;
        }
        String itemNs = KubernetesResourceUtil.getNamespace((HasMetadata)((HasMetadata)item));
        if (Utils.isNotNullOrEmpty((String)this.namespace) && Utils.isNotNullOrEmpty((String)itemNs) && !this.namespace.equals(itemNs)) {
            item = this.getKubernetesSerialization().clone(item);
            KubernetesResourceUtil.setNamespace((HasMetadata)((HasMetadata)item), (String)this.namespace);
        }
        return item;
    }

    protected <T> String checkNamespace(T item) {
        String itemNs;
        if (!this.isResourceNamespaced()) {
            return null;
        }
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata ? KubernetesResourceUtil.getNamespace((HasMetadata)((HasMetadata)item)) : null;
        if (Utils.isNullOrEmpty((String)operationNs) && Utils.isNullOrEmpty((String)itemNs)) {
            if (this.context.isDefaultNamespace()) {
                throw new KubernetesClientException("namespace not specified for an operation requiring one and no default was found in the Config.");
            }
            throw new KubernetesClientException("namespace not specified for an operation requiring one.");
        }
        if (!Utils.isNullOrEmpty((String)itemNs) && (Utils.isNullOrEmpty((String)operationNs) || this.context.isDefaultNamespace())) {
            return itemNs;
        }
        return operationNs;
    }

    protected <T> String checkName(T item) {
        String itemName;
        String operationName = this.getName();
        ObjectMeta metadata = item instanceof HasMetadata ? ((HasMetadata)item).getMetadata() : null;
        String string = itemName = metadata != null ? metadata.getName() : null;
        if (Utils.isNullOrEmpty((String)operationName) && Utils.isNullOrEmpty((String)itemName)) {
            return null;
        }
        if (Utils.isNullOrEmpty((String)itemName)) {
            return operationName;
        }
        if (Utils.isNullOrEmpty((String)operationName)) {
            return itemName;
        }
        if (Objects.equals(itemName, operationName)) {
            return itemName;
        }
        throw new KubernetesClientException("Name mismatch. Item name:" + itemName + ". Operation name:" + operationName + ".");
    }

    protected <T> T handleMetric(String resourceUrl, Class<T> type) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl);
        return this.handleResponse(requestBuilder, type);
    }

    protected KubernetesResource handleDelete(URL requestUrl, long gracePeriodSeconds, DeletionPropagation propagationPolicy, String resourceVersion) throws InterruptedException, IOException {
        DeleteOptions deleteOptions = new DeleteOptions();
        if (gracePeriodSeconds >= 0L) {
            deleteOptions.setGracePeriodSeconds(Long.valueOf(gracePeriodSeconds));
        }
        if (resourceVersion != null) {
            deleteOptions.setPreconditions(new Preconditions(resourceVersion, null));
        }
        if (propagationPolicy != null) {
            deleteOptions.setPropagationPolicy(propagationPolicy.toString());
        }
        if (this.dryRun) {
            deleteOptions.setDryRun(Collections.singletonList("All"));
        }
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().delete(JSON, this.getKubernetesSerialization().asJson((Object)deleteOptions)).url(requestUrl);
        return this.handleResponse(requestBuilder, KubernetesResource.class);
    }

    protected <T, I> T handleCreate(I resource, Class<T> outputType) throws InterruptedException, IOException {
        resource = this.correctNamespace(resource);
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post(JSON, this.getKubernetesSerialization().asJson(resource)).url(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(resource), null)));
        return this.handleResponse(requestBuilder, outputType);
    }

    protected <T> T handleUpdate(T updated, Class<T> type) throws IOException {
        updated = this.correctNamespace(updated);
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().put(JSON, this.getKubernetesSerialization().asJson(updated)).url(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(updated), this.checkName(updated))));
        return this.handleResponse(requestBuilder, type);
    }

    protected <T> T handlePatch(PatchContext patchContext, T current, T updated, Class<T> type) throws InterruptedException, IOException {
        String patchForUpdate;
        if (current != null && (patchContext == null || patchContext.getPatchType() == PatchType.JSON)) {
            ObjectMeta meta;
            if (current instanceof HasMetadata && (meta = ((HasMetadata)current).getMetadata()) != null) {
                meta.setResourceVersion(null);
            }
            patchForUpdate = PatchUtils.jsonDiff(current, updated, false, this.getKubernetesSerialization());
            if (patchContext == null) {
                patchContext = new PatchContext.Builder().withPatchType(PatchType.JSON).build();
            }
        } else {
            patchForUpdate = this.getKubernetesSerialization().asJson(updated);
            current = updated;
        }
        return this.handlePatch(patchContext, current, patchForUpdate, type);
    }

    protected <T> T handlePatch(PatchContext patchContext, T current, String patchForUpdate, Class<T> type) throws InterruptedException, IOException {
        String bodyContentType = this.getContentTypeFromPatchContextOrDefault(patchContext);
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().patch(bodyContentType, patchForUpdate).url(this.getResourceURLForPatchOperation(this.getResourceUrl(this.checkNamespace(current), this.checkName(current)), patchContext));
        return this.handleResponse(requestBuilder, type);
    }

    protected <T> T handleScale(String resourceUrl, T scale, Class<T> scaleType) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl + "/scale");
        if (scale != null) {
            requestBuilder.put(JSON, this.getKubernetesSerialization().asJson(scale));
        }
        return this.handleResponse(requestBuilder, scaleType);
    }

    protected Status handleDeploymentRollback(String resourceUrl, DeploymentRollback deploymentRollback) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl + "/rollback").post(JSON, this.getKubernetesSerialization().asJson((Object)deploymentRollback));
        return this.handleResponse(requestBuilder, Status.class);
    }

    protected <T> T handleGet(URL resourceUrl, Class<T> type) throws IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().url(resourceUrl);
        return this.handleResponse(requestBuilder, type);
    }

    protected <T> T handleRawGet(URL resourceUrl, Class<T> type) throws IOException {
        return this.handleRaw(type, resourceUrl.toString(), "GET", null);
    }

    HttpRequest.Builder withRequestTimeout(HttpRequest.Builder builder) {
        return builder.timeout((long)this.getRequestConfig().getRequestTimeout(), TimeUnit.MILLISECONDS);
    }

    protected <T> T waitForResult(CompletableFuture<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            InterruptedIOException ie = new InterruptedIOException();
            ie.initCause(e);
            throw ie;
        }
        catch (ExecutionException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof IOException) {
                throw new IOException(t.getMessage(), t);
            }
            if (t instanceof KubernetesClientException) {
                throw ((KubernetesClientException)t).copyAsCause();
            }
            throw new KubernetesClientException(t.getMessage(), t);
        }
    }

    protected <T> T handleResponse(HttpRequest.Builder requestBuilder, final Class<T> type) throws IOException {
        return this.waitForResult(this.handleResponse(this.httpClient, this.withRequestTimeout(requestBuilder), new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        }));
    }

    protected <T> CompletableFuture<T> handleResponse(HttpClient client, HttpRequest.Builder requestBuilder, TypeReference<T> type) {
        VersionUsageUtils.log(this.resourceT, this.apiGroupVersion);
        HttpRequest request = requestBuilder.build();
        return client.sendAsync(request, byte[].class).thenApply(response -> {
            try {
                this.assertResponseCode(request, (HttpResponse<?>)response);
                if (type != null && type.getType() != null) {
                    return this.getKubernetesSerialization().unmarshal((InputStream)new ByteArrayInputStream((byte[])response.body()), type);
                }
                return null;
            }
            catch (KubernetesClientException e) {
                throw e;
            }
            catch (Exception e) {
                throw OperationSupport.requestException(request, e);
            }
        });
    }

    protected void assertResponseCode(HttpRequest request, HttpResponse<?> response) {
        List warnings = response.headers("Warning");
        if (warnings != null && !warnings.isEmpty()) {
            if (this.context.fieldValidation == FieldValidateable.Validation.WARN) {
                LOG.warn("Recieved warning(s) from request {}: {}", (Object)request.uri(), (Object)warnings);
            } else {
                LOG.debug("Recieved warning(s) from request {}: {}", (Object)request.uri(), (Object)warnings);
            }
        }
        if (response.isSuccessful()) {
            return;
        }
        int statusCode = response.code();
        String customMessage = (String)this.config.getErrorMessages().get(statusCode);
        if (customMessage != null) {
            throw OperationSupport.requestFailure(request, OperationSupport.createStatus(statusCode, this.combineMessages(customMessage, OperationSupport.createStatus(response, this.getKubernetesSerialization()))));
        }
        throw OperationSupport.requestFailure(request, OperationSupport.createStatus(response, this.getKubernetesSerialization()));
    }

    private String combineMessages(String customMessage, Status defaultStatus) {
        String message;
        if (defaultStatus != null && (message = defaultStatus.getMessage()) != null && message.length() > 0) {
            return customMessage + " " + message;
        }
        return customMessage;
    }

    public static Status createStatus(HttpResponse<?> response, KubernetesSerialization kubernetesSerialization) {
        int statusCode;
        String statusMessage = "";
        int n = statusCode = response != null ? response.code() : 0;
        if (response == null) {
            statusMessage = "No response";
        } else {
            try {
                Status status;
                String bodyString = response.bodyString();
                if (Utils.isNotNullOrEmpty((String)bodyString) && (status = (Status)kubernetesSerialization.unmarshal(bodyString, Status.class)) != null) {
                    if (status.getCode() == null) {
                        status = ((StatusBuilder)new StatusBuilder(status).withCode(Integer.valueOf(statusCode))).build();
                    }
                    return status;
                }
            }
            catch (IOException | RuntimeException e) {
                LOG.debug("Exception convertion response to Status", (Throwable)e);
            }
            if (response.message() != null) {
                statusMessage = response.message();
            }
        }
        return OperationSupport.createStatus(statusCode, statusMessage);
    }

    public static Status createStatus(int statusCode, String message) {
        Status status = ((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(statusCode))).withMessage(message)).build();
        status.getAdditionalProperties().put(CLIENT_STATUS_FLAG, "true");
        return status;
    }

    public static KubernetesClientException requestFailure(HttpRequest request, Status status) {
        return OperationSupport.requestFailure(request, status, null);
    }

    public static KubernetesClientException requestFailure(HttpRequest request, Status status, String message) {
        StringBuilder sb = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            sb.append(message).append(". ");
        }
        sb.append("Failure executing: ").append(request.method()).append(" at: ").append(request.uri()).append(".");
        if (status.getMessage() != null && !status.getMessage().isEmpty()) {
            sb.append(" Message: ").append(status.getMessage()).append(".");
        }
        if (!status.getAdditionalProperties().containsKey(CLIENT_STATUS_FLAG)) {
            sb.append(" Received status: ").append(status).append(".");
        }
        return new KubernetesClientException(sb.toString(), null, status.getCode().intValue(), status, request);
    }

    public static KubernetesClientException requestException(HttpRequest request, Throwable e, String message) {
        StringBuilder sb = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            sb.append(message).append(". ");
        }
        sb.append("Error executing: ").append(request.method()).append(" at: ").append(request.uri()).append(". Cause: ").append(e.getMessage());
        return new KubernetesClientException(sb.toString(), e, -1, null, request);
    }

    public static KubernetesClientException requestException(HttpRequest request, Exception e) {
        return OperationSupport.requestException(request, e, null);
    }

    public Config getConfig() {
        return this.config;
    }

    public OperationContext getOperationContext() {
        return this.context;
    }

    public RequestConfig getRequestConfig() {
        RequestConfig result = this.context.getRequestConfig();
        if (result == null && this.config != null) {
            result = this.config.getRequestConfig();
        }
        return new RequestConfigBuilder(result).build();
    }

    private String getContentTypeFromPatchContextOrDefault(PatchContext patchContext) {
        if (patchContext != null && patchContext.getPatchType() != null) {
            return patchContext.getPatchType().getContentType();
        }
        return STRATEGIC_MERGE_JSON_PATCH;
    }

    public <R1> R1 restCall(Class<R1> result, String ... path) {
        try {
            URL requestUrl = new URL(this.config.getMasterUrl());
            String url = requestUrl.toString();
            if (path != null && path.length > 0) {
                url = URLUtils.join((String[])new String[]{url, URLUtils.pathJoin((String[])path)});
            }
            HttpRequest.Builder req = this.httpClient.newHttpRequestBuilder().uri(url);
            return this.handleResponse(req, result);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public <R1> R1 handleRaw(Class<R1> result, String uri, String method, Object payload) {
        try {
            if (uri.startsWith("/")) {
                uri = this.config.getMasterUrl() + uri.substring(1, uri.length());
            }
            String body = null;
            if (payload instanceof String) {
                body = (String)payload;
            } else if (payload != null) {
                body = this.getKubernetesSerialization().asJson(payload);
            }
            HttpRequest request = this.withRequestTimeout(this.httpClient.newHttpRequestBuilder().uri(uri).method(method, JSON, body)).build();
            HttpResponse response = (HttpResponse)this.waitForResult(this.httpClient.sendAsync(request, result));
            this.assertResponseCode(request, response);
            return (R1)response.body();
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public KubernetesSerialization getKubernetesSerialization() {
        return ((BaseClient)this.context.getClient().adapt(BaseClient.class)).getKubernetesSerialization();
    }
}

