/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.kyuubi.util.reflect.DynMethods;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.execution.CollectLimitExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkPlanHelper$;
import org.apache.spark.sql.execution.arrow.KyuubiArrowConverters;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.ArrowUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class KyuubiArrowConverters$
implements SQLConfHelper,
Logging {
    public static KyuubiArrowConverters$ MODULE$;
    private DynMethods.UnboundMethod toArrowSchemaMethod;
    private final IpcOption org$apache$spark$sql$execution$arrow$KyuubiArrowConverters$$ARROW_IPC_OPTION_DEFAULT;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new KyuubiArrowConverters$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public byte[] slice(StructType schema, String timeZoneId, byte[] bytes, int start, int length) {
        byte[] byArray;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream(bytes.length);
        VectorSchemaRoot vectorSchemaRoot = null;
        VectorSchemaRoot slicedVectorSchemaRoot = null;
        BufferAllocator sliceAllocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator("slice", 0L, Long.MAX_VALUE);
        Schema arrowSchema = this.org$apache$spark$sql$execution$arrow$KyuubiArrowConverters$$toArrowSchema(schema, timeZoneId, Predef$.MODULE$.boolean2Boolean(true), Predef$.MODULE$.boolean2Boolean(false));
        vectorSchemaRoot = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)sliceAllocator);
        try {
            ArrowRecordBatch recordBatch = MessageSerializer.deserializeRecordBatch((ReadChannel)new ReadChannel(Channels.newChannel(in)), (BufferAllocator)sliceAllocator);
            VectorLoader vectorLoader = new VectorLoader(vectorSchemaRoot);
            vectorLoader.load(recordBatch);
            recordBatch.close();
            slicedVectorSchemaRoot = vectorSchemaRoot.slice(start, length);
            VectorUnloader unloader = new VectorUnloader(slicedVectorSchemaRoot);
            WriteChannel writeChannel = new WriteChannel(Channels.newChannel(out));
            ArrowRecordBatch batch = unloader.getRecordBatch();
            MessageSerializer.serialize((WriteChannel)writeChannel, (ArrowRecordBatch)batch);
            batch.close();
            byArray = out.toByteArray();
        }
        finally {
            in.close();
            out.close();
            if (vectorSchemaRoot != null) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(vectorSchemaRoot.getFieldVectors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.close();
                    return BoxedUnit.UNIT;
                });
                vectorSchemaRoot.close();
            }
            if (slicedVectorSchemaRoot != null) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(slicedVectorSchemaRoot.getFieldVectors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.close();
                    return BoxedUnit.UNIT;
                });
                slicedVectorSchemaRoot.close();
            }
            sliceAllocator.close();
        }
        return byArray;
    }

    public Tuple2<byte[], Object>[] takeAsArrowBatches(CollectLimitExec collectLimitExec, long maxRecordsPerBatch, long maxEstimatedBatchSize, String timeZoneId) {
        Range partsToScan;
        int n = collectLimitExec.limit();
        StructType schema = collectLimitExec.schema();
        if (n == 0) {
            return new Tuple2[0];
        }
        int limitScaleUpFactor = Math.max(this.conf().limitScaleUpFactor(), 2);
        RDD childRDD = collectLimitExec.child().execute();
        ArrayBuffer buf = new ArrayBuffer();
        long bufferedRowSize = 0L;
        int totalParts = childRDD.partitions().length;
        for (int partsScanned = 0; bufferedRowSize < (long)n && partsScanned < totalParts; partsScanned += partsToScan.size()) {
            int numPartsToTry = this.limitInitialNumPartitions();
            if (partsScanned > 0) {
                if (buf.isEmpty()) {
                    numPartsToTry = partsScanned * limitScaleUpFactor;
                } else {
                    long left = (long)n - bufferedRowSize;
                    numPartsToTry = (int)Math.ceil(1.5 * (double)left * (double)partsScanned / (double)bufferedRowSize);
                    numPartsToTry = Math.min(numPartsToTry, partsScanned * limitScaleUpFactor);
                }
            }
            partsToScan = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(partsScanned), package$.MODULE$.min(partsScanned + numPartsToTry, totalParts));
            SparkContext sc = SparkPlanHelper$.MODULE$.sparkSession((SparkPlan)collectLimitExec).sparkContext();
            Tuple2[][] res = (Tuple2[][])sc.runJob(childRDD, (Function1 & Serializable & scala.Serializable)it -> {
                KyuubiArrowConverters.ArrowBatchIterator batches = MODULE$.toBatchIterator((Iterator<InternalRow>)it, schema, maxRecordsPerBatch, maxEstimatedBatchSize, n, timeZoneId);
                return (Tuple2[])batches.map((Function1 & Serializable & scala.Serializable)b -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(b), (Object)BoxesRunTime.boxToLong((long)batches.rowCountInLastBatch()))).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
            }, (Seq)partsToScan, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            for (int i = 0; bufferedRowSize < (long)n && i < res.length; ++i) {
                long batchSize;
                Tuple2[] batches = res[i];
                for (int j = 0; j < batches.length && (long)n > bufferedRowSize; bufferedRowSize += batchSize, ++j) {
                    Tuple2 batch = batches[j];
                    Tuple2 tuple2 = batch;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    long batchSize2 = tuple2._2$mcJ$sp();
                    batchSize = batchSize2;
                    buf.$plus$eq((Object)batch);
                }
            }
        }
        return (Tuple2[])buf.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private int limitInitialNumPartitions() {
        return new StringOps(Predef$.MODULE$.augmentString(this.conf().getConfString("spark.sql.limit.initialNumPartitions", "1"))).toInt();
    }

    public KyuubiArrowConverters.ArrowBatchIterator toBatchIterator(Iterator<InternalRow> rowIter, StructType schema, long maxRecordsPerBatch, long maxEstimatedBatchSize, long limit, String timeZoneId) {
        return new KyuubiArrowConverters.ArrowBatchIterator(rowIter, schema, maxRecordsPerBatch, maxEstimatedBatchSize, limit, timeZoneId, TaskContext$.MODULE$.get());
    }

    private DynMethods.UnboundMethod toArrowSchemaMethod$lzycompute() {
        KyuubiArrowConverters$ kyuubiArrowConverters$ = this;
        synchronized (kyuubiArrowConverters$) {
            if (!this.bitmap$0) {
                this.toArrowSchemaMethod = DynMethods.builder("toArrowSchema").impl("org.apache.spark.sql.util.ArrowUtils", StructType.class, String.class).impl("org.apache.spark.sql.util.ArrowUtils", StructType.class, String.class, Boolean.TYPE, Boolean.TYPE).build();
                this.bitmap$0 = true;
            }
        }
        return this.toArrowSchemaMethod;
    }

    private DynMethods.UnboundMethod toArrowSchemaMethod() {
        if (!this.bitmap$0) {
            return this.toArrowSchemaMethod$lzycompute();
        }
        return this.toArrowSchemaMethod;
    }

    public Schema org$apache$spark$sql$execution$arrow$KyuubiArrowConverters$$toArrowSchema(StructType schema, String timeZone, Boolean errorOnDuplicatedFieldNames, Boolean largeVarTypes) {
        return (Schema)this.toArrowSchemaMethod().invoke(ArrowUtils$.MODULE$, schema, timeZone, errorOnDuplicatedFieldNames, largeVarTypes);
    }

    public final IpcOption org$apache$spark$sql$execution$arrow$KyuubiArrowConverters$$ARROW_IPC_OPTION_DEFAULT() {
        return this.org$apache$spark$sql$execution$arrow$KyuubiArrowConverters$$ARROW_IPC_OPTION_DEFAULT;
    }

    private KyuubiArrowConverters$() {
        MODULE$ = this;
        SQLConfHelper.$init$((SQLConfHelper)this);
        Logging.$init$((Logging)this);
        this.org$apache$spark$sql$execution$arrow$KyuubiArrowConverters$$ARROW_IPC_OPTION_DEFAULT = new IpcOption();
    }
}

