/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class NodeSystemInfoFluent<A extends NodeSystemInfoFluent<A>>
extends BaseFluent<A> {
    private String architecture;
    private String bootID;
    private String containerRuntimeVersion;
    private String kernelVersion;
    private String kubeProxyVersion;
    private String kubeletVersion;
    private String machineID;
    private String operatingSystem;
    private String osImage;
    private String systemUUID;
    private Map<String, Object> additionalProperties;

    public NodeSystemInfoFluent() {
    }

    public NodeSystemInfoFluent(NodeSystemInfo instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeSystemInfo instance) {
        NodeSystemInfo nodeSystemInfo = instance = instance != null ? instance : new NodeSystemInfo();
        if (instance != null) {
            this.withArchitecture(instance.getArchitecture());
            this.withBootID(instance.getBootID());
            this.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
            this.withKernelVersion(instance.getKernelVersion());
            this.withKubeProxyVersion(instance.getKubeProxyVersion());
            this.withKubeletVersion(instance.getKubeletVersion());
            this.withMachineID(instance.getMachineID());
            this.withOperatingSystem(instance.getOperatingSystem());
            this.withOsImage(instance.getOsImage());
            this.withSystemUUID(instance.getSystemUUID());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public A withArchitecture(String architecture) {
        this.architecture = architecture;
        return (A)((Object)this);
    }

    public boolean hasArchitecture() {
        return this.architecture != null;
    }

    public String getBootID() {
        return this.bootID;
    }

    public A withBootID(String bootID) {
        this.bootID = bootID;
        return (A)((Object)this);
    }

    public boolean hasBootID() {
        return this.bootID != null;
    }

    public String getContainerRuntimeVersion() {
        return this.containerRuntimeVersion;
    }

    public A withContainerRuntimeVersion(String containerRuntimeVersion) {
        this.containerRuntimeVersion = containerRuntimeVersion;
        return (A)((Object)this);
    }

    public boolean hasContainerRuntimeVersion() {
        return this.containerRuntimeVersion != null;
    }

    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public A withKernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
        return (A)((Object)this);
    }

    public boolean hasKernelVersion() {
        return this.kernelVersion != null;
    }

    public String getKubeProxyVersion() {
        return this.kubeProxyVersion;
    }

    public A withKubeProxyVersion(String kubeProxyVersion) {
        this.kubeProxyVersion = kubeProxyVersion;
        return (A)((Object)this);
    }

    public boolean hasKubeProxyVersion() {
        return this.kubeProxyVersion != null;
    }

    public String getKubeletVersion() {
        return this.kubeletVersion;
    }

    public A withKubeletVersion(String kubeletVersion) {
        this.kubeletVersion = kubeletVersion;
        return (A)((Object)this);
    }

    public boolean hasKubeletVersion() {
        return this.kubeletVersion != null;
    }

    public String getMachineID() {
        return this.machineID;
    }

    public A withMachineID(String machineID) {
        this.machineID = machineID;
        return (A)((Object)this);
    }

    public boolean hasMachineID() {
        return this.machineID != null;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public A withOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return (A)((Object)this);
    }

    public boolean hasOperatingSystem() {
        return this.operatingSystem != null;
    }

    public String getOsImage() {
        return this.osImage;
    }

    public A withOsImage(String osImage) {
        this.osImage = osImage;
        return (A)((Object)this);
    }

    public boolean hasOsImage() {
        return this.osImage != null;
    }

    public String getSystemUUID() {
        return this.systemUUID;
    }

    public A withSystemUUID(String systemUUID) {
        this.systemUUID = systemUUID;
        return (A)((Object)this);
    }

    public boolean hasSystemUUID() {
        return this.systemUUID != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSystemInfoFluent that = (NodeSystemInfoFluent)((Object)o);
        if (!Objects.equals(this.architecture, that.architecture)) {
            return false;
        }
        if (!Objects.equals(this.bootID, that.bootID)) {
            return false;
        }
        if (!Objects.equals(this.containerRuntimeVersion, that.containerRuntimeVersion)) {
            return false;
        }
        if (!Objects.equals(this.kernelVersion, that.kernelVersion)) {
            return false;
        }
        if (!Objects.equals(this.kubeProxyVersion, that.kubeProxyVersion)) {
            return false;
        }
        if (!Objects.equals(this.kubeletVersion, that.kubeletVersion)) {
            return false;
        }
        if (!Objects.equals(this.machineID, that.machineID)) {
            return false;
        }
        if (!Objects.equals(this.operatingSystem, that.operatingSystem)) {
            return false;
        }
        if (!Objects.equals(this.osImage, that.osImage)) {
            return false;
        }
        if (!Objects.equals(this.systemUUID, that.systemUUID)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.architecture, this.bootID, this.containerRuntimeVersion, this.kernelVersion, this.kubeProxyVersion, this.kubeletVersion, this.machineID, this.operatingSystem, this.osImage, this.systemUUID, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.architecture != null) {
            sb.append("architecture:");
            sb.append(this.architecture + ",");
        }
        if (this.bootID != null) {
            sb.append("bootID:");
            sb.append(this.bootID + ",");
        }
        if (this.containerRuntimeVersion != null) {
            sb.append("containerRuntimeVersion:");
            sb.append(this.containerRuntimeVersion + ",");
        }
        if (this.kernelVersion != null) {
            sb.append("kernelVersion:");
            sb.append(this.kernelVersion + ",");
        }
        if (this.kubeProxyVersion != null) {
            sb.append("kubeProxyVersion:");
            sb.append(this.kubeProxyVersion + ",");
        }
        if (this.kubeletVersion != null) {
            sb.append("kubeletVersion:");
            sb.append(this.kubeletVersion + ",");
        }
        if (this.machineID != null) {
            sb.append("machineID:");
            sb.append(this.machineID + ",");
        }
        if (this.operatingSystem != null) {
            sb.append("operatingSystem:");
            sb.append(this.operatingSystem + ",");
        }
        if (this.osImage != null) {
            sb.append("osImage:");
            sb.append(this.osImage + ",");
        }
        if (this.systemUUID != null) {
            sb.append("systemUUID:");
            sb.append(this.systemUUID + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

