/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.AbstractAclVoter;
import org.springframework.security.acls.domain.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.domain.SidRetrievalStrategyImpl;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.SidRetrievalStrategy;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AclEntryVoter
extends AbstractAclVoter {
    private static final Log logger = LogFactory.getLog(AclEntryVoter.class);
    private final AclService aclService;
    private final String processConfigAttribute;
    private final List<Permission> requirePermission;
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();
    private String internalMethod;

    public AclEntryVoter(AclService aclService, String processConfigAttribute, Permission[] requirePermission) {
        Assert.notNull((Object)processConfigAttribute, "A processConfigAttribute is mandatory");
        Assert.notNull((Object)aclService, "An AclService is mandatory");
        Assert.isTrue(!ObjectUtils.isEmpty(requirePermission), "One or more requirePermission entries is mandatory");
        this.aclService = aclService;
        this.processConfigAttribute = processConfigAttribute;
        this.requirePermission = Arrays.asList(requirePermission);
    }

    protected String getInternalMethod() {
        return this.internalMethod;
    }

    public void setInternalMethod(String internalMethod) {
        this.internalMethod = internalMethod;
    }

    protected String getProcessConfigAttribute() {
        return this.processConfigAttribute;
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        Assert.notNull((Object)objectIdentityRetrievalStrategy, "ObjectIdentityRetrievalStrategy required");
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        Assert.notNull((Object)sidRetrievalStrategy, "SidRetrievalStrategy required");
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }

    @Override
    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().equals(this.getProcessConfigAttribute());
    }

    @Override
    public int vote(Authentication authentication, MethodInvocation object, Collection<ConfigAttribute> attributes) {
        for (ConfigAttribute attr : attributes) {
            Acl acl;
            if (!this.supports(attr)) continue;
            Object domainObject = this.getDomainObjectInstance(object);
            if (domainObject == null) {
                logger.debug((Object)"Voting to abstain - domainObject is null");
                return 0;
            }
            if (StringUtils.hasText(this.internalMethod)) {
                domainObject = this.invokeInternalMethod(domainObject);
            }
            ObjectIdentity objectIdentity = this.objectIdentityRetrievalStrategy.getObjectIdentity(domainObject);
            List<Sid> sids = this.sidRetrievalStrategy.getSids(authentication);
            try {
                acl = this.aclService.readAclById(objectIdentity, sids);
            }
            catch (NotFoundException ex) {
                logger.debug((Object)"Voting to deny access - no ACLs apply for this principal");
                return -1;
            }
            try {
                if (acl.isGranted(this.requirePermission, sids, false)) {
                    logger.debug((Object)"Voting to grant access");
                    return 1;
                }
                logger.debug((Object)"Voting to deny access - ACLs returned, but insufficient permissions for this principal");
                return -1;
            }
            catch (NotFoundException ex) {
                logger.debug((Object)"Voting to deny access - no ACLs apply for this principal");
                return -1;
            }
        }
        return 0;
    }

    private Object invokeInternalMethod(Object domainObject) {
        try {
            Class<?> domainObjectType = domainObject.getClass();
            Method method = domainObjectType.getMethod(this.internalMethod, new Class[0]);
            return method.invoke(domainObject, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new AuthorizationServiceException("Object of class '" + domainObject.getClass() + "' does not provide the requested internalMethod: " + this.internalMethod);
        }
        catch (IllegalAccessException ex) {
            logger.debug((Object)"IllegalAccessException", (Throwable)ex);
            throw new AuthorizationServiceException("Problem invoking internalMethod: " + this.internalMethod + " for object: " + domainObject);
        }
        catch (InvocationTargetException ex) {
            logger.debug((Object)"InvocationTargetException", (Throwable)ex);
            throw new AuthorizationServiceException("Problem invoking internalMethod: " + this.internalMethod + " for object: " + domainObject);
        }
    }
}

