/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.metrics;

import java.io.Serializable;
import org.apache.kylin.metrics.QuerySparkMetrics;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.JobSucceeded$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.sql.metrics.ExecutionInformation;
import org.apache.spark.sql.metrics.QueryInformation;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\u000b\u0016\u0001\u0001BQ!\f\u0001\u0005\u00029Bq!\r\u0001A\u0002\u0013\u0005!\u0007C\u0004E\u0001\u0001\u0007I\u0011A#\t\r-\u0003\u0001\u0015)\u00034\u0011\u001da\u0005\u00011A\u0005\u00025CqA\u0015\u0001A\u0002\u0013\u00051\u000b\u0003\u0004V\u0001\u0001\u0006KA\u0014\u0005\b-\u0002\u0001\r\u0011\"\u0001X\u0011\u001dy\u0006\u00011A\u0005\u0002\u0001DaA\u0019\u0001!B\u0013A\u0006bB2\u0001\u0005\u0004%\t\u0001\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011B3\t\u000b5\u0004A\u0011\t8\t\u000bQ\u0004A\u0011I;\t\u000bi\u0004A\u0011I>\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011Q\u0002\u0001\u0005B\u0005=\u0001bBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003_\u0001A\u0011BA\u0019\u0005Y\u0019\u0006/\u0019:eKJlU\r\u001e:jGNd\u0015n\u001d;f]\u0016\u0014(B\u0001\f\u0018\u0003\u001diW\r\u001e:jGNT!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\t!\u0013$A\u0005tG\",G-\u001e7fe&\u0011ae\t\u0002\u000e'B\f'o\u001b'jgR,g.\u001a:\u0011\u0005!ZS\"A\u0015\u000b\u0005)J\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u00051J#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0002\"\u0001\r\u0001\u000e\u0003U\t1b\u001d;bO\u0016TuNY'baV\t1\u0007\u0005\u00035{\u0001\u0003eBA\u001b<!\t1\u0014(D\u00018\u0015\tAt$\u0001\u0004=e>|GO\u0010\u0006\u0002u\u0005)1oY1mC&\u0011A(O\u0001\u0007!J,G-\u001a4\n\u0005yz$aA'ba*\u0011A(\u000f\t\u0003\u0003\nk\u0011!O\u0005\u0003\u0007f\u00121!\u00138u\u0003=\u0019H/Y4f\u0015>\u0014W*\u00199`I\u0015\fHC\u0001$J!\t\tu)\u0003\u0002Is\t!QK\\5u\u0011\u001dQ5!!AA\u0002M\n1\u0001\u001f\u00132\u00031\u0019H/Y4f\u0015>\u0014W*\u00199!\u0003=QwNY#yK\u000e,H/[8o\u001b\u0006\u0004X#\u0001(\u0011\tQj\u0004i\u0014\t\u0003aAK!!U\u000b\u0003!E+XM]=J]\u001a|'/\\1uS>t\u0017a\u00056pE\u0016CXmY;uS>tW*\u00199`I\u0015\fHC\u0001$U\u0011\u001dQe!!AA\u00029\u000b\u0001C[8c\u000bb,7-\u001e;j_:l\u0015\r\u001d\u0011\u0002/\u0015DXmY;uS>t\u0017J\u001c4pe6\fG/[8o\u001b\u0006\u0004X#\u0001-\u0011\tQj\u0014\f\u0018\t\u0003\u0003jK!aW\u001d\u0003\t1{gn\u001a\t\u0003auK!AX\u000b\u0003)\u0015CXmY;uS>t\u0017J\u001c4pe6\fG/[8o\u0003m)\u00070Z2vi&|g.\u00138g_Jl\u0017\r^5p]6\u000b\u0007o\u0018\u0013fcR\u0011a)\u0019\u0005\b\u0015&\t\t\u00111\u0001Y\u0003a)\u00070Z2vi&|g.\u00138g_Jl\u0017\r^5p]6\u000b\u0007\u000fI\u0001\u0016cV,'/_#yK\u000e,H/[8o\u001b\u0016$(/[2t+\u0005)\u0007C\u00014k\u001b\u00059'B\u0001\fi\u0015\tI7$A\u0003ls2Lg.\u0003\u0002lO\n\t\u0012+^3ssN\u0003\u0018M]6NKR\u0014\u0018nY:\u0002-E,XM]=Fq\u0016\u001cW\u000f^5p]6+GO]5dg\u0002\n!b\u001c8K_\n\u001cF/\u0019:u)\t1u\u000eC\u0003q\u001b\u0001\u0007\u0011/A\u0003fm\u0016tG\u000f\u0005\u0002#e&\u00111o\t\u0002\u0016'B\f'o\u001b'jgR,g.\u001a:K_\n\u001cF/\u0019:u\u0003!ygNS8c\u000b:$GC\u0001$w\u0011\u0015\u0001h\u00021\u0001x!\t\u0011\u00030\u0003\u0002zG\t\u00192\u000b]1sW2K7\u000f^3oKJTuNY#oI\u0006\u0001rN\\*uC\u001e,7+\u001e2nSR$X\r\u001a\u000b\u0003\rrDQ\u0001]\bA\u0002u\u0004\"A\t@\n\u0005}\u001c#aG*qCJ\\G*[:uK:,'o\u0015;bO\u0016\u001cVOY7jiR,G-\u0001\tp]N#\u0018mZ3D_6\u0004H.\u001a;fIR\u0019a)!\u0002\t\rA\u0004\u0002\u0019AA\u0004!\r\u0011\u0013\u0011B\u0005\u0004\u0003\u0017\u0019#aG*qCJ\\G*[:uK:,'o\u0015;bO\u0016\u001cu.\u001c9mKR,G-\u0001\u0007p]>#\b.\u001a:Fm\u0016tG\u000fF\u0002G\u0003#Aa\u0001]\tA\u0002\u0005M\u0001c\u0001\u0012\u0002\u0016%\u0019\u0011qC\u0012\u0003%M\u0003\u0018M]6MSN$XM\\3s\u000bZ,g\u000e^\u0001\u0016_:\fV/\u001a:z\u000bb,7-\u001e;j_:\u001cF/\u0019:u)\r1\u0015Q\u0004\u0005\u0007aJ\u0001\r!a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005\u0011Q/\u001b\u0006\u0004\u0003S9\u0012!C3yK\u000e,H/[8o\u0013\u0011\ti#a\t\u0003=M\u0003\u0018M]6MSN$XM\\3s'FcU\t_3dkRLwN\\*uCJ$\u0018aE8o#V,'/_#yK\u000e,H/[8o\u000b:$Gc\u0001$\u00024!1\u0001o\u0005a\u0001\u0003k\u0001B!!\t\u00028%!\u0011\u0011HA\u0012\u0005q\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8feN\u000bF*\u0012=fGV$\u0018n\u001c8F]\u0012\u0004")
public class SparderMetricsListener
extends SparkListener
implements Logging {
    private Map<Object, Object> stageJobMap;
    private Map<Object, QueryInformation> jobExecutionMap;
    private Map<Object, ExecutionInformation> executionInformationMap;
    private final QuerySparkMetrics queryExecutionMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Map<Object, Object> stageJobMap() {
        return this.stageJobMap;
    }

    public void stageJobMap_$eq(Map<Object, Object> x$1) {
        this.stageJobMap = x$1;
    }

    public Map<Object, QueryInformation> jobExecutionMap() {
        return this.jobExecutionMap;
    }

    public void jobExecutionMap_$eq(Map<Object, QueryInformation> x$1) {
        this.jobExecutionMap = x$1;
    }

    public Map<Object, ExecutionInformation> executionInformationMap() {
        return this.executionInformationMap;
    }

    public void executionInformationMap_$eq(Map<Object, ExecutionInformation> x$1) {
        this.executionInformationMap = x$1;
    }

    public QuerySparkMetrics queryExecutionMetrics() {
        return this.queryExecutionMetrics;
    }

    public void onJobStart(SparkListenerJobStart event) {
        String executionIdString = event.properties().getProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
        String sparderName = event.properties().getProperty("spark.app.name");
        String kylinQueryId = event.properties().getProperty("kylin.query.id");
        if (executionIdString == null || kylinQueryId == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("The job ").append(event.jobId()).append(" is not a query job.").toString());
            return;
        }
        long executionId = new StringOps(Predef$.MODULE$.augmentString(executionIdString)).toLong();
        if (((ExecutionInformation)this.executionInformationMap().apply((Object)BoxesRunTime.boxToLong((long)executionId))).sparderName() == null) {
            ExecutionInformation executionInformation = new ExecutionInformation(kylinQueryId, ((ExecutionInformation)this.executionInformationMap().apply((Object)BoxesRunTime.boxToLong((long)executionId))).executionStartTime(), sparderName);
            this.executionInformationMap_$eq((Map<Object, ExecutionInformation>)this.executionInformationMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)executionId)), (Object)executionInformation)));
        }
        this.jobExecutionMap_$eq((Map<Object, QueryInformation>)this.jobExecutionMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)event.jobId())), (Object)new QueryInformation(kylinQueryId, executionId))));
        for (StageInfo stage : event.stageInfos()) {
            this.stageJobMap_$eq((Map<Object, Object>)this.stageJobMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)stage.stageId())), (Object)BoxesRunTime.boxToInteger((int)event.jobId()))));
        }
        this.queryExecutionMetrics().onJobStart(kylinQueryId, sparderName, executionId, ((ExecutionInformation)this.executionInformationMap().apply((Object)BoxesRunTime.boxToLong((long)executionId))).executionStartTime(), event.jobId(), event.time());
    }

    public void onJobEnd(SparkListenerJobEnd event) {
        block0: {
            if (!this.jobExecutionMap().contains((Object)BoxesRunTime.boxToInteger((int)event.jobId()))) break block0;
            JobResult jobResult = event.jobResult();
            boolean bl = JobSucceeded$.MODULE$.equals(jobResult);
            boolean isSuccess = bl;
            this.queryExecutionMetrics().updateSparkJobMetrics(((QueryInformation)this.jobExecutionMap().apply((Object)BoxesRunTime.boxToInteger((int)event.jobId()))).queryId(), event.jobId(), event.time(), isSuccess);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("The job ").append(event.jobId()).append(" has completed and the relevant metrics are updated to the cache").toString());
            this.jobExecutionMap_$eq((Map<Object, QueryInformation>)((Map)this.jobExecutionMap().$minus((Object)BoxesRunTime.boxToInteger((int)event.jobId()))));
        }
    }

    public void onStageSubmitted(SparkListenerStageSubmitted event) {
        block4: {
            long l;
            String queryId = event.properties().getProperty("kylin.query.id");
            int stageId = event.stageInfo().stageId();
            if (!this.stageJobMap().contains((Object)BoxesRunTime.boxToInteger((int)stageId))) break block4;
            Option option = event.stageInfo().submissionTime();
            if (option instanceof Some) {
                long x;
                Some some = (Some)option;
                l = x = BoxesRunTime.unboxToLong((Object)some.value());
            } else if (None$.MODULE$.equals(option)) {
                l = -1L;
            } else {
                throw new MatchError((Object)option);
            }
            long submitTime = l;
            this.queryExecutionMetrics().onSparkStageStart(queryId, BoxesRunTime.unboxToInt((Object)this.stageJobMap().apply((Object)BoxesRunTime.boxToInteger((int)stageId))), stageId, event.stageInfo().name(), submitTime);
        }
    }

    public void onStageCompleted(SparkListenerStageCompleted event) {
        block0: {
            StageInfo stageInfo = event.stageInfo();
            if (!this.stageJobMap().contains((Object)BoxesRunTime.boxToInteger((int)stageInfo.stageId())) || !this.jobExecutionMap().contains(this.stageJobMap().apply((Object)BoxesRunTime.boxToInteger((int)stageInfo.stageId())))) break block0;
            String string = stageInfo.getStatusString();
            boolean bl = "succeeded".equals(string);
            boolean isSuccess = bl;
            TaskMetrics stageMetrics = stageInfo.taskMetrics();
            QuerySparkMetrics.SparkStageMetrics sparkStageMetrics = new QuerySparkMetrics.SparkStageMetrics();
            sparkStageMetrics.setMetrics(stageMetrics.resultSize(), stageMetrics.executorDeserializeCpuTime(), stageMetrics.executorDeserializeTime(), stageMetrics.executorRunTime(), stageMetrics.executorCpuTime(), stageMetrics.jvmGCTime(), stageMetrics.resultSerializationTime(), stageMetrics.memoryBytesSpilled(), stageMetrics.diskBytesSpilled(), stageMetrics.peakExecutionMemory());
            this.queryExecutionMetrics().updateSparkStageMetrics(((QueryInformation)this.jobExecutionMap().apply(this.stageJobMap().apply((Object)BoxesRunTime.boxToInteger((int)stageInfo.stageId())))).queryId(), BoxesRunTime.unboxToInt((Object)this.stageJobMap().apply((Object)BoxesRunTime.boxToInteger((int)stageInfo.stageId()))), stageInfo.stageId(), isSuccess, sparkStageMetrics);
            this.stageJobMap_$eq((Map<Object, Object>)((Map)this.stageJobMap().$minus((Object)BoxesRunTime.boxToInteger((int)stageInfo.stageId()))));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("The stage ").append(event.stageInfo().stageId()).append(" has completed and the relevant metrics are updated to the cache").toString());
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
            this.onQueryExecutionStart(sparkListenerSQLExecutionStart);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerSQLExecutionEnd) {
            SparkListenerSQLExecutionEnd sparkListenerSQLExecutionEnd = (SparkListenerSQLExecutionEnd)sparkListenerEvent;
            this.onQueryExecutionEnd(sparkListenerSQLExecutionEnd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void onQueryExecutionStart(SparkListenerSQLExecutionStart event) {
        this.executionInformationMap_$eq((Map<Object, ExecutionInformation>)this.executionInformationMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)event.executionId())), (Object)new ExecutionInformation(null, event.time(), null))));
    }

    private void onQueryExecutionEnd(SparkListenerSQLExecutionEnd event) {
        ExecutionInformation executionInformation = (ExecutionInformation)this.executionInformationMap().apply((Object)BoxesRunTime.boxToLong((long)event.executionId()));
        this.queryExecutionMetrics().updateExecutionMetrics(executionInformation.queryId(), event.time());
        this.executionInformationMap_$eq((Map<Object, ExecutionInformation>)((Map)this.executionInformationMap().$minus((Object)BoxesRunTime.boxToLong((long)event.executionId()))));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("QueryExecution ").append(event.executionId()).append(" is completed at ").append(event.time()).append(" ").append("and the relevant metrics are updated to the cache").toString());
    }

    public SparderMetricsListener() {
        Logging.$init$((Logging)this);
        this.stageJobMap = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.jobExecutionMap = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.executionInformationMap = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.queryExecutionMetrics = QuerySparkMetrics.getInstance();
    }
}

