/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.dict;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.dict.NBucketDictionary;
import org.apache.spark.dict.NGlobalDictHDFSStore;
import org.apache.spark.dict.NGlobalDictMetaInfo;
import org.apache.spark.dict.NGlobalDictStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NGlobalDictionary
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(NGlobalDictionary.class);
    private static final String WORKING_DIR = "working";
    public static final String SEPARATOR = "_0_DOT_0_";
    private NGlobalDictMetaInfo metadata;
    private String baseDir;
    private String project;
    private String sourceTable;
    private String sourceColumn;
    private boolean isFirst = true;
    private String skewDictStorageFile;

    public String getResourceDir() {
        return "/" + this.project + "/dict/global_dict" + "/" + this.sourceTable + "/" + this.sourceColumn + "/";
    }

    private String getWorkingDir() {
        return this.baseDir + WORKING_DIR;
    }

    public NGlobalDictionary(String project, String sourceTable, String sourceColumn, String baseDir) throws IOException {
        this.project = project;
        this.sourceTable = sourceTable;
        this.sourceColumn = sourceColumn;
        this.baseDir = baseDir + this.getResourceDir();
        this.metadata = this.getMetaInfo();
        if (this.metadata != null) {
            this.isFirst = false;
        }
    }

    public NGlobalDictionary(String dictParams) throws IOException {
        String[] dictInfo = dictParams.split(SEPARATOR);
        this.project = dictInfo[0];
        this.sourceTable = dictInfo[1];
        this.sourceColumn = dictInfo[2];
        this.baseDir = dictInfo[3];
        this.baseDir = this.baseDir + this.getResourceDir();
        this.metadata = this.getMetaInfo();
        if (this.metadata != null) {
            this.isFirst = false;
        }
        if (dictInfo.length >= 5) {
            this.skewDictStorageFile = dictInfo[4];
        }
    }

    public NBucketDictionary loadBucketDictionary(int bucketId) throws IOException {
        if (null == this.metadata) {
            this.metadata = this.getMetaInfo();
        }
        return new NBucketDictionary(this.baseDir, this.getWorkingDir(), bucketId, this.metadata, this.skewDictStorageFile);
    }

    public NBucketDictionary createNewBucketDictionary() {
        return new NBucketDictionary(this.getWorkingDir());
    }

    public void prepareWrite() throws IOException {
        NGlobalDictStore globalDictStore = NGlobalDictionary.getResourceStore(this.baseDir);
        globalDictStore.prepareForWrite(this.getWorkingDir());
    }

    public void writeMetaDict(int bucketSize, int maxVersions, long versionTTL) throws IOException {
        NGlobalDictStore globalDictStore = NGlobalDictionary.getResourceStore(this.baseDir);
        globalDictStore.writeMetaInfo(bucketSize, this.getWorkingDir());
        this.commit(maxVersions, versionTTL);
    }

    public NGlobalDictMetaInfo getMetaInfo() throws IOException {
        NGlobalDictStore globalDictStore = NGlobalDictionary.getResourceStore(this.baseDir);
        Long[] versions = globalDictStore.listAllVersions();
        if (versions.length == 0) {
            return null;
        }
        NGlobalDictMetaInfo metadata = globalDictStore.getMetaInfo(versions[versions.length - 1]);
        return metadata;
    }

    public int getBucketSizeOrDefault(int defaultSize) {
        int bucketPartitionSize = this.metadata == null ? defaultSize : this.metadata.getBucketSize();
        return bucketPartitionSize;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public void setFirst(boolean first) {
        this.isFirst = first;
    }

    private void commit(int maxVersions, long versionTTL) throws IOException {
        NGlobalDictStore globalDictStore = NGlobalDictionary.getResourceStore(this.baseDir);
        globalDictStore.commit(this.getWorkingDir(), maxVersions, versionTTL);
    }

    private static NGlobalDictStore getResourceStore(String baseDir) throws IOException {
        return new NGlobalDictHDFSStore(baseDir);
    }
}

