/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.util.Iterator;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.PeekingIterator;

class PeekingImpl<E>
implements PeekingIterator<E> {
    public final Iterator<? extends E> iterator;
    private boolean hasPeeked;
    private E peekedElement;

    public PeekingImpl(Iterator<? extends E> iterator) {
        this.iterator = Preconditions.checkNotNull(iterator);
    }

    @Override
    public boolean hasNext() {
        return this.hasPeeked || this.iterator.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasPeeked) {
            return this.iterator.next();
        }
        E result = this.peekedElement;
        this.hasPeeked = false;
        this.peekedElement = null;
        return result;
    }

    @Override
    public void remove() {
        Preconditions.checkState(!this.hasPeeked, "Can't remove after you've peeked at next");
        this.iterator.remove();
    }

    @Override
    public E peek() {
        if (!this.hasPeeked) {
            this.peekedElement = this.iterator.next();
            this.hasPeeked = true;
        }
        return this.peekedElement;
    }
}

