/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectionStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(GarbageCollectionStep.class);

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        KylinConfig config = context.getConfig();
        StringBuffer output = new StringBuffer();
        try {
            output.append(this.cleanUpIntermediateFlatTable(config));
        }
        catch (IOException e) {
            logger.error("job:" + this.getId() + " execute finished with exception", e);
            return ExecuteResult.createError(e);
        }
        return new ExecuteResult(ExecuteResult.State.SUCCEED, output.toString());
    }

    private String cleanUpIntermediateFlatTable(KylinConfig config) throws IOException {
        StringBuffer output = new StringBuffer();
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder(this.getName());
        List<String> hiveTables = this.getIntermediateTables();
        if (!config.isHiveKeepFlatTable()) {
            for (String hiveTable : hiveTables) {
                if (!StringUtils.isNotEmpty(hiveTable)) continue;
                hiveCmdBuilder.addStatement("USE " + config.getHiveDatabaseForIntermediateTable() + ";");
                hiveCmdBuilder.addStatement("DROP TABLE IF EXISTS " + hiveTable + ";");
                output.append("Hive table " + hiveTable + " is dropped. \n");
            }
            this.rmdirOnHDFS(this.getExternalDataPaths());
        }
        config.getCliCommandExecutor().execute(hiveCmdBuilder.build());
        output.append("Path " + this.getExternalDataPaths() + " is deleted. \n");
        return output.toString();
    }

    private void rmdirOnHDFS(List<String> paths) throws IOException {
        for (String path : paths) {
            Path externalDataPath = new Path(path);
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            if (!fs.exists(externalDataPath)) continue;
            fs.delete(externalDataPath, true);
        }
    }

    public void setIntermediateTables(List<String> tableIdentity) {
        this.setParam("oldHiveTables", StringUtil.join(tableIdentity, ","));
    }

    private List<String> getIntermediateTables() {
        String[] tables;
        ArrayList<String> intermediateTables = Lists.newArrayList();
        String hiveTables = this.getParam("oldHiveTables");
        if (this.getParams().containsKey("oldHiveViewIntermediateTables")) {
            hiveTables = hiveTables + "," + this.getParam("oldHiveViewIntermediateTables");
        }
        for (String t : tables = StringUtil.splitAndTrim(hiveTables, ",")) {
            intermediateTables.add(t);
        }
        return intermediateTables;
    }

    public void setExternalDataPaths(List<String> externalDataPaths) {
        this.setParam("externalDataPaths", StringUtil.join(externalDataPaths, ","));
    }

    private List<String> getExternalDataPaths() {
        String[] paths = StringUtil.splitAndTrim(this.getParam("externalDataPaths"), ",");
        ArrayList<String> result = Lists.newArrayList();
        for (String s : paths) {
            result.add(s);
        }
        return result;
    }

    public void setHiveViewIntermediateTableIdentities(String tableIdentities) {
        this.setParam("oldHiveViewIntermediateTables", tableIdentities);
    }
}

