/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.softaffinity;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kylin.softaffinity.strategy.SoftAffinityStrategy;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SoftAffinityManager$
implements Logging {
    public static SoftAffinityManager$ MODULE$;
    private int minOnTargetHosts;
    private boolean usingSoftAffinity;
    private final ReentrantReadWriteLock resourceRWLock;
    private final SoftAffinityStrategy softAffinityAllocation;
    private final ListBuffer<Option<Tuple2<String, String>>> fixedIdForExecutors;
    private final HashMap<String, HashSet<String>> nodesExecutorsMap;
    private final AtomicInteger totalRegisteredExecutors;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    static {
        new SoftAffinityManager$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ReentrantReadWriteLock resourceRWLock() {
        return this.resourceRWLock;
    }

    public SoftAffinityStrategy softAffinityAllocation() {
        return this.softAffinityAllocation;
    }

    private int minOnTargetHosts$lzycompute() {
        SoftAffinityManager$ softAffinityManager$ = this;
        synchronized (softAffinityManager$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.minOnTargetHosts = SparkEnv$.MODULE$.get().conf().getInt("spark.kylin.soft-affinity.min.target-hosts", 1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.minOnTargetHosts;
    }

    public int minOnTargetHosts() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.minOnTargetHosts$lzycompute() : this.minOnTargetHosts;
    }

    public ListBuffer<Option<Tuple2<String, String>>> fixedIdForExecutors() {
        return this.fixedIdForExecutors;
    }

    public HashMap<String, HashSet<String>> nodesExecutorsMap() {
        return this.nodesExecutorsMap;
    }

    public AtomicInteger totalRegisteredExecutors() {
        return this.totalRegisteredExecutors;
    }

    private boolean usingSoftAffinity$lzycompute() {
        SoftAffinityManager$ softAffinityManager$ = this;
        synchronized (softAffinityManager$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.usingSoftAffinity = SparkEnv$.MODULE$.get().conf().getBoolean("spark.kylin.soft-affinity.enabled", false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.usingSoftAffinity;
    }

    public boolean usingSoftAffinity() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.usingSoftAffinity$lzycompute() : this.usingSoftAffinity;
    }

    public int totalExecutors() {
        return this.totalRegisteredExecutors().intValue();
    }

    public void handleExecutorAdded(Tuple2<String, String> execHostId) {
        this.resourceRWLock().writeLock().lock();
        try {
            Object object;
            if (!this.fixedIdForExecutors().exists((Function1 & Serializable & scala.Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)SoftAffinityManager$.$anonfun$handleExecutorAdded$1(execHostId, exec)))) {
                ListBuffer listBuffer;
                HashSet executorsSet = (HashSet)this.nodesExecutorsMap().getOrElseUpdate(execHostId._2(), (Function0 & Serializable & scala.Serializable)() -> new HashSet());
                executorsSet.add(execHostId._1());
                if (this.fixedIdForExecutors().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))) {
                    int replaceIdx = this.fixedIdForExecutors().indexWhere((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty()));
                    this.fixedIdForExecutors().update(replaceIdx, (Object)Option$.MODULE$.apply(execHostId));
                    listBuffer = BoxedUnit.UNIT;
                } else {
                    listBuffer = this.fixedIdForExecutors().$plus$eq((Object)Option$.MODULE$.apply(execHostId));
                }
                object = BoxesRunTime.boxToInteger((int)this.totalRegisteredExecutors().addAndGet(1));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(108).append("After adding executor ").append(execHostId._1()).append(" on host ").append(execHostId._2()).append(", ").append("fixedIdForExecutors is ").append(MODULE$.fixedIdForExecutors().mkString(",")).append(", ").append("nodesExecutorsMap is ").append(MODULE$.nodesExecutorsMap().keySet().mkString(",")).append(", ").append("actual executors count is ").append(MODULE$.totalRegisteredExecutors().intValue()).append(".").toString());
        }
        finally {
            this.resourceRWLock().writeLock().unlock();
        }
    }

    public void handleExecutorRemoved(String execId) {
        this.resourceRWLock().writeLock().lock();
        try {
            Object object;
            int execIdx = this.fixedIdForExecutors().indexWhere((Function1 & Serializable & scala.Serializable)execHost -> BoxesRunTime.boxToBoolean((boolean)SoftAffinityManager$.$anonfun$handleExecutorRemoved$1(execId, execHost)));
            if (execIdx != -1) {
                Option findedExecId = (Option)this.fixedIdForExecutors().apply(execIdx);
                this.fixedIdForExecutors().update(execIdx, (Object)None$.MODULE$);
                HashSet nodeExecs = (HashSet)this.nodesExecutorsMap().get(((Tuple2)findedExecId.get())._2()).get();
                nodeExecs.$minus$eq(((Tuple2)findedExecId.get())._1());
                Object object2 = nodeExecs.isEmpty() ? this.nodesExecutorsMap().remove(((Tuple2)findedExecId.get())._2()) : BoxedUnit.UNIT;
                object = BoxesRunTime.boxToInteger((int)this.totalRegisteredExecutors().addAndGet(-1));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("After removing executor ").append(execId).append(", ").append("fixedIdForExecutors is ").append(MODULE$.fixedIdForExecutors().mkString(",")).append(", ").append("nodesExecutorsMap is ").append(MODULE$.nodesExecutorsMap().keySet().mkString(",")).append(", ").append("actual executors count is ").append(MODULE$.totalRegisteredExecutors().intValue()).append(".").toString());
        }
        finally {
            this.resourceRWLock().writeLock().unlock();
        }
    }

    public boolean checkTargetHosts(String[] hosts) {
        boolean bl;
        this.resourceRWLock().readLock().lock();
        try {
            if (hosts.length < 1) {
                bl = false;
            } else if (this.nodesExecutorsMap().size() < 1) {
                bl = true;
            } else {
                int minHostsNum = Math.min(this.minOnTargetHosts(), hosts.length);
                bl = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)this.nodesExecutorsMap().map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._1(), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).intersect((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])hosts)))).size() >= minHostsNum;
            }
        }
        finally {
            this.resourceRWLock().readLock().unlock();
        }
        return bl;
    }

    public Tuple2<String, String>[] askExecutors(String file) {
        Object[] objectArray;
        this.resourceRWLock().readLock().lock();
        try {
            objectArray = this.nodesExecutorsMap().size() < 1 ? (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)) : this.softAffinityAllocation().allocateExecs(file, this.fixedIdForExecutors());
        }
        finally {
            this.resourceRWLock().readLock().unlock();
        }
        return objectArray;
    }

    public static final /* synthetic */ boolean $anonfun$handleExecutorAdded$1(Tuple2 execHostId$1, Option exec) {
        return exec.isDefined() && ((String)((Tuple2)exec.get())._1()).equals(execHostId$1._1());
    }

    public static final /* synthetic */ boolean $anonfun$handleExecutorRemoved$1(String execId$1, Option execHost) {
        return execHost.isDefined() ? ((String)((Tuple2)execHost.get())._1()).equals(execId$1) : false;
    }

    private SoftAffinityManager$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.resourceRWLock = new ReentrantReadWriteLock(true);
        this.softAffinityAllocation = new SoftAffinityStrategy();
        this.fixedIdForExecutors = new ListBuffer();
        this.nodesExecutorsMap = new HashMap();
        this.totalRegisteredExecutors = new AtomicInteger(0);
    }
}

