/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.exec;

import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.query.exec.QueryEngineFactory;
import org.apache.kylin.query.relnode.OLAPLimitRel;
import org.apache.kylin.query.relnode.OLAPRel;

public class SparkExec {
    public static Enumerable<Object[]> collectToEnumerable(DataContext dataContext) {
        if (BackdoorToggles.getPrepareOnly()) {
            return Linq4j.emptyEnumerable();
        }
        OLAPRel olapRel = (OLAPRel)QueryContextFacade.current().getOlapRel();
        RelDataType rowType = (RelDataType)QueryContextFacade.current().getResultType();
        try {
            Enumerable<Object[]> computer = QueryEngineFactory.compute(dataContext, olapRel, rowType);
            if (olapRel instanceof OLAPLimitRel && ((OLAPLimitRel)olapRel).localOffset != null) {
                RexLiteral literal = (RexLiteral)((OLAPLimitRel)olapRel).localOffset;
                return computer.skip(Integer.valueOf(literal.getValue().toString()).intValue());
            }
            return computer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Enumerable<Object> collectToScalarEnumerable(DataContext dataContext) {
        if (BackdoorToggles.getPrepareOnly()) {
            return Linq4j.emptyEnumerable();
        }
        OLAPRel olapRel = (OLAPRel)QueryContextFacade.current().getOlapRel();
        RelDataType rowType = (RelDataType)QueryContextFacade.current().getResultType();
        try {
            Enumerable<Object> objects = QueryEngineFactory.computeSCALA(dataContext, olapRel, rowType);
            if (olapRel instanceof OLAPLimitRel && ((OLAPLimitRel)olapRel).localOffset != null) {
                RexLiteral literal = (RexLiteral)((OLAPLimitRel)olapRel).localOffset;
                return objects.skip(Integer.valueOf(literal.getValue().toString()).intValue());
            }
            return objects;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Enumerable<Object[]> asyncResult(DataContext dataContext) {
        if (BackdoorToggles.getPrepareOnly()) {
            return Linq4j.emptyEnumerable();
        }
        OLAPRel olapRel = (OLAPRel)QueryContextFacade.current().getOlapRel();
        RelDataType rowType = (RelDataType)QueryContextFacade.current().getResultType();
        return QueryEngineFactory.computeAsync(dataContext, olapRel, rowType);
    }
}

