/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.util.Comparator;

public class SegmentRange<T extends Comparable>
implements Comparable<SegmentRange>,
Serializable {
    public final Endpoint<T> start;
    public final Endpoint<T> end;

    public SegmentRange(Endpoint start, Endpoint end) {
        this.start = start;
        this.end = end;
        this.checkState();
    }

    public SegmentRange(T start, T end) {
        if (start != null && end != null && start.getClass() != end.getClass()) {
            throw new IllegalArgumentException();
        }
        this.start = new Endpoint((Comparable)start, start == null, false, null);
        this.end = new Endpoint((Comparable)end, false, end == null, null);
        this.checkState();
    }

    @Override
    public int compareTo(SegmentRange o) {
        int comp = this.start.compareTo(o.start);
        if (comp != 0) {
            return comp;
        }
        return this.end.compareTo(o.end);
    }

    private void checkState() {
        if (this.start.compareTo(this.end) > 0) {
            throw new IllegalStateException();
        }
    }

    public boolean isInfinite() {
        return this.start.isMin && this.end.isMax;
    }

    public boolean contains(SegmentRange o) {
        return this.start.compareTo(o.start) <= 0 && o.end.compareTo(this.end) <= 0;
    }

    public boolean overlaps(SegmentRange o) {
        return this.start.compareTo(o.end) < 0 && o.start.compareTo(this.end) < 0;
    }

    public boolean connects(SegmentRange o) {
        return this.end.compareTo(o.start) == 0;
    }

    public boolean apartBefore(SegmentRange o) {
        return this.end.compareTo(o.start) < 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.start + "," + this.end + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentRange other = (SegmentRange)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }

    public static class Endpoint<T extends Comparable>
    implements Comparable<Endpoint>,
    Serializable {
        public static final Comparator<Endpoint> comparator = Endpoint.getComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        });
        public final T v;
        public final boolean isMin;
        public final boolean isMax;

        public static Comparator<Endpoint> getComparator(final Comparator valueComparator) {
            return new Comparator<Endpoint>(){

                @Override
                public int compare(Endpoint a, Endpoint b) {
                    if (a == null || b == null) {
                        throw new IllegalStateException();
                    }
                    if (a.isMin) {
                        return b.isMin ? 0 : -1;
                    }
                    if (b.isMin) {
                        return a.isMin ? 0 : 1;
                    }
                    if (a.isMax) {
                        return b.isMax ? 0 : 1;
                    }
                    if (b.isMax) {
                        return a.isMax ? 0 : -1;
                    }
                    return valueComparator.compare(a.v, b.v);
                }
            };
        }

        private Endpoint(T v, boolean isMin, boolean isMax) {
            this.v = v;
            this.isMin = isMin;
            this.isMax = isMax;
        }

        @Override
        public int compareTo(Endpoint o) {
            return comparator.compare(this, o);
        }

        public String toString() {
            String s = "" + this.v;
            if (this.isMin) {
                s = s + "[min]";
            }
            if (this.isMax) {
                s = s + "[max]";
            }
            return s;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isMax ? 1231 : 1237);
            result = 31 * result + (this.isMin ? 1231 : 1237);
            result = 31 * result + (this.v == null ? 0 : this.v.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Endpoint other = (Endpoint)obj;
            if (this.isMax != other.isMax) {
                return false;
            }
            if (this.isMin != other.isMin) {
                return false;
            }
            return comparator.compare(this, other) == 0;
        }

        /* synthetic */ Endpoint(Comparable x0, boolean x1, boolean x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class TSRange
    extends SegmentRange<Long> {
        public TSRange(Long start, Long end) {
            super(new Endpoint(Long.valueOf(TSRange.isInfinite(start, end) ? 0L : start), TSRange.isInfinite(start, end), false, null), new Endpoint(Long.valueOf(TSRange.isInfinite(start, end) ? Long.MAX_VALUE : end), false, TSRange.isInfinite(start, end), null));
        }

        private static boolean isInfinite(Long start, Long end) {
            return !(start != null && start > 0L || end != null && end != Long.MAX_VALUE);
        }

        public long duration() {
            return (Long)this.end.v - (Long)this.start.v;
        }

        public long startValue() {
            return (Long)this.start.v;
        }

        public long endValue() {
            return (Long)this.end.v;
        }
    }
}

