/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;

public abstract class MeasureType<T>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public void validate(FunctionDesc functionDesc) throws IllegalArgumentException {
    }

    public boolean isMemoryHungry() {
        return false;
    }

    public boolean onlyAggrInBaseCuboid() {
        return false;
    }

    public abstract MeasureIngester<T> newIngester();

    public abstract MeasureAggregator<T> newAggregator();

    public List<TblColRef> getColumnsNeedDictionary(FunctionDesc functionDesc) {
        return Collections.emptyList();
    }

    public CapabilityResult.CapabilityInfluence influenceCapabilityCheck(Collection<TblColRef> unmatchedDimensions, Collection<FunctionDesc> unmatchedAggregations, SQLDigest digest, MeasureDesc measureDesc) {
        return null;
    }

    public abstract boolean needRewrite();

    public boolean needRewriteField() {
        return true;
    }

    public Map<String, Class<?>> getRewriteCalciteAggrFunctions() {
        return null;
    }

    public void adjustSqlDigest(List<MeasureDesc> measureDescs, SQLDigest sqlDigest) {
    }

    public boolean needAdvancedTupleFilling() {
        return false;
    }

    public void fillTupleSimply(Tuple tuple, int indexInTuple, Object measureValue) {
        tuple.setMeasureValue(indexInTuple, measureValue);
    }

    public IAdvMeasureFiller getAdvancedTupleFiller(FunctionDesc function, TupleInfo returnTupleInfo, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        throw new UnsupportedOperationException();
    }

    public static interface IAdvMeasureFiller {
        public void reload(Object var1);

        public int getNumOfRows();

        public void fillTuple(Tuple var1, int var2);
    }
}

