/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSFileTableReader
implements IReadableTable.TableReader {
    private static final Logger logger = LoggerFactory.getLogger(DFSFileTableReader.class);
    private static final char CSV_QUOTE = '\"';
    private static final String[] DETECT_DELIMS = new String[]{"\u007f", "|", "\t", ","};
    private String filePath;
    private String delim;
    private List<RowReader> readerList;
    private String curLine;
    private String[] curColumns;
    private int expectedColumnNumber = -1;

    public DFSFileTableReader(String filePath, int expectedColumnNumber) throws IOException {
        this(filePath, "auto", expectedColumnNumber);
    }

    public DFSFileTableReader(String filePath, String delim, int expectedColumnNumber) throws IOException {
        this.filePath = filePath = HadoopUtil.fixWindowsPath(filePath);
        this.delim = delim;
        this.expectedColumnNumber = expectedColumnNumber;
        this.readerList = new ArrayList<RowReader>();
        FileSystem fs = HadoopUtil.getFileSystem(filePath);
        ArrayList<FileStatus> allFiles = new ArrayList<FileStatus>();
        FileStatus status = fs.getFileStatus(new Path(filePath));
        if (status.isFile()) {
            allFiles.add(status);
        } else {
            FileStatus[] listStatus = fs.listStatus(new Path(filePath));
            allFiles.addAll(Arrays.asList(listStatus));
        }
        try {
            for (FileStatus f : allFiles) {
                SeqRowReader rowReader = new SeqRowReader(HadoopUtil.getCurrentConfiguration(), f.getPath().toString());
                this.readerList.add(rowReader);
            }
        }
        catch (IOException e) {
            if (!this.isExceptionSayingNotSeqFile(e)) {
                throw e;
            }
            this.readerList = new ArrayList<RowReader>();
            for (FileStatus f : allFiles) {
                CsvRowReader rowReader = new CsvRowReader(fs, f.getPath().toString());
                this.readerList.add(rowReader);
            }
        }
    }

    private boolean isExceptionSayingNotSeqFile(IOException e) {
        if (e.getMessage() != null && e.getMessage().contains("not a SequenceFile")) {
            return true;
        }
        return e instanceof EOFException;
    }

    @Override
    public boolean next() throws IOException {
        int curReaderIndex = -1;
        while (++curReaderIndex < this.readerList.size()) {
            RowReader curReader = this.readerList.get(curReaderIndex);
            this.curLine = curReader.nextLine();
            this.curColumns = null;
            if (this.curLine == null) continue;
            return true;
        }
        return false;
    }

    public String getLine() {
        return this.curLine;
    }

    @Override
    public String[] getRow() {
        if (this.curColumns == null) {
            if ("auto".equals(this.delim)) {
                this.delim = this.autoDetectDelim(this.curLine);
            }
            this.curColumns = this.delim == null ? new String[]{this.curLine} : this.split(this.curLine, this.delim);
        }
        return this.curColumns;
    }

    private String[] split(String line, String delim) {
        String[] str = StringSplitter.split(line, delim);
        if (",".equals(delim)) {
            for (int i = 0; i < str.length; ++i) {
                str[i] = this.unescapeCsv(str[i]);
            }
        }
        return str;
    }

    private String unescapeCsv(String str) {
        if (str == null || str.length() < 2) {
            return str;
        }
        if ((str = StringEscapeUtils.unescapeCsv(str)).charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    @Override
    public void close() {
        for (RowReader reader : this.readerList) {
            IOUtils.closeQuietly((Closeable)reader);
        }
    }

    private String autoDetectDelim(String line) {
        if (this.expectedColumnNumber > 0) {
            for (String delim : DETECT_DELIMS) {
                if (StringSplitter.split(line, delim).length != this.expectedColumnNumber) continue;
                logger.info("Auto detect delim to be '" + delim + "', split line to " + this.expectedColumnNumber + " columns -- " + line);
                return delim;
            }
        }
        logger.info("Auto detect delim to be null, will take THE-WHOLE-LINE as a single value, for " + this.filePath);
        return null;
    }

    private class CsvRowReader
    implements RowReader {
        BufferedReader reader;

        CsvRowReader(FileSystem fs, String path) throws IOException {
            FSDataInputStream in = fs.open(new Path(path));
            this.reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        }

        @Override
        public String nextLine() throws IOException {
            return this.reader.readLine();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    private class SeqRowReader
    implements RowReader {
        SequenceFile.Reader reader;
        Writable key;
        Text value;

        SeqRowReader(Configuration hconf, String path) throws IOException {
            this.reader = new SequenceFile.Reader(hconf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)new Path(path))});
            this.key = (Writable)ReflectionUtils.newInstance((Class)this.reader.getKeyClass(), (Configuration)hconf);
            this.value = new Text();
        }

        @Override
        public String nextLine() throws IOException {
            boolean hasNext = this.reader.next(this.key, (Writable)this.value);
            if (hasNext) {
                return Bytes.toString(this.value.getBytes(), 0, this.value.getLength());
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static interface RowReader
    extends Closeable {
        public String nextLine() throws IOException;
    }
}

