/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class KeyValueBuilder
implements Serializable {
    public static final String HIVE_NULL = "\\N";
    public static final String ZERO = "0";
    public static final String ONE = "1";
    private Set<String> nullStrs;
    private CubeJoinedFlatTableEnrich flatDesc;
    private CubeDesc cubeDesc;

    public KeyValueBuilder(CubeJoinedFlatTableEnrich intermediateTableDesc) {
        this.flatDesc = intermediateTableDesc;
        this.cubeDesc = this.flatDesc.getCubeDesc();
        this.initNullStrings();
    }

    private void initNullStrings() {
        this.nullStrs = Sets.newHashSet();
        this.nullStrs.add(HIVE_NULL);
        String[] nullStrings = this.cubeDesc.getNullStrings();
        if (nullStrings != null) {
            for (String s : nullStrings) {
                this.nullStrs.add(s);
            }
        }
    }

    public boolean isNull(String v) {
        return this.nullStrs.contains(v);
    }

    private String getCell(int i, String[] flatRow) {
        if (i >= flatRow.length) {
            return null;
        }
        if (this.isNull(flatRow[i])) {
            return null;
        }
        return flatRow[i];
    }

    public String[] buildKey(String[] row) {
        int keySize = this.flatDesc.getRowKeyColumnIndexes().length;
        String[] key = new String[keySize];
        for (int i = 0; i < keySize; ++i) {
            key[i] = this.getCell(this.flatDesc.getRowKeyColumnIndexes()[i], row);
        }
        return key;
    }

    public String[] buildValueOf(int idxOfMeasure, String[] row) {
        MeasureDesc measure = this.cubeDesc.getMeasures().get(idxOfMeasure);
        FunctionDesc function = measure.getFunction();
        int[] colIdxOnFlatTable = this.flatDesc.getMeasureColumnIndexes()[idxOfMeasure];
        int paramCount = function.getParameterCount();
        ArrayList<String> inputToMeasure = Lists.newArrayListWithExpectedSize(paramCount);
        ParameterDesc param = function.getParameter();
        int colParamIdx = 0;
        int i = 0;
        while (i < paramCount) {
            String value;
            if (param.isColumnType()) {
                value = this.getCell(colIdxOnFlatTable[colParamIdx++], row);
                if (function.isCount() && value == null) {
                    value = ZERO;
                } else if (function.isCount()) {
                    value = ONE;
                }
            } else {
                value = param.getValue();
                if (function.isCount()) {
                    value = ONE;
                }
            }
            inputToMeasure.add(value);
            ++i;
            param = param.getNextParameter();
        }
        return inputToMeasure.toArray(new String[inputToMeasure.size()]);
    }
}

