/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RandomSampler<T> {
    private Random rdm = new Random();

    public List<T> sample(List<T> data, int sampleNumber) {
        if (data == null) {
            throw new IllegalArgumentException("Input list is null");
        }
        if (data.size() < sampleNumber) {
            return data;
        }
        ArrayList<T> result = new ArrayList<T>(sampleNumber);
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            if (i < sampleNumber) {
                result.add(data.get(i));
                continue;
            }
            int j = this.rdm.nextInt(i);
            if (j >= sampleNumber) continue;
            result.set(j, data.get(i));
        }
        return result;
    }
}

