/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.storage.IStorageProvider;
import org.apache.kylin.common.threadlocal.InternalThreadLocal;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtil {
    public static final String JOB_TMP_ROOT = "/job_tmp";
    public static final String PARQUET_STORAGE_ROOT = "/parquet";
    public static final String DICT_STORAGE_ROOT = "/dict";
    public static final String GLOBAL_DICT_STORAGE_ROOT = "/dict/global_dict";
    public static final String SNAPSHOT_STORAGE_ROOT = "/table_snapshot";
    public static final String TABLE_EXD_STORAGE_ROOT = "/table_exd";
    private static final Logger logger = LoggerFactory.getLogger(HadoopUtil.class);
    private static final transient InternalThreadLocal<Configuration> hadoopConfig = new InternalThreadLocal();

    private HadoopUtil() {
        throw new IllegalStateException("Class HadoopUtil is an utility class !");
    }

    public static void setCurrentConfiguration(Configuration conf) {
        hadoopConfig.set(conf);
    }

    public static Configuration getCurrentConfiguration() {
        if (hadoopConfig.get() == null) {
            Configuration conf = HadoopUtil.healSickConfig(new Configuration());
            return conf;
        }
        Configuration conf = hadoopConfig.get();
        return conf;
    }

    public static Configuration healSickConfig(Configuration conf) {
        if (StringUtils.isBlank(conf.get("hadoop.tmp.dir"))) {
            conf.set("hadoop.tmp.dir", "/tmp");
        }
        if (StringUtils.isBlank(conf.get("hbase.fs.tmp.dir"))) {
            conf.set("hbase.fs.tmp.dir", "/tmp");
        }
        conf.set("yarn.timeline-service.enabled", "false");
        return conf;
    }

    public static FileSystem getWorkingFileSystem() {
        return HadoopUtil.getFileSystem(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory());
    }

    public static FileSystem getWorkingFileSystem(Configuration conf) throws IOException {
        Path workingPath = new Path(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory());
        return HadoopUtil.getFileSystem(workingPath, conf);
    }

    public static FileSystem getReadFileSystem() throws IOException {
        return HadoopUtil.getFileSystem(KylinConfig.getInstanceFromEnv().getReadHdfsWorkingDirectory());
    }

    public static FileSystem getFileSystem(String path) {
        return HadoopUtil.getFileSystem(new Path(HadoopUtil.makeURI(path)));
    }

    public static FileSystem getFileSystem(String path, Configuration conf) throws IOException {
        return HadoopUtil.getFileSystem(new Path(HadoopUtil.makeURI(path)), conf);
    }

    public static FileSystem getFileSystem(Path path) {
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        return HadoopUtil.getFileSystem(path, conf);
    }

    public static FileSystem getFileSystem(Path path, Configuration conf) {
        try {
            return path.getFileSystem(conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI makeURI(String filePath) {
        try {
            return new URI(HadoopUtil.fixWindowsPath(filePath));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot create FileSystem from URI: " + filePath, e);
        }
    }

    public static String fixWindowsPath(String path) {
        if (path.startsWith("file://") && !path.startsWith("file:///") && path.contains(":\\")) {
            path = path.replace("file://", "file:///");
        }
        if (path.startsWith("file:///")) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static String[] parseHiveTableName(String table) {
        int cut = table.indexOf(46);
        String database = cut >= 0 ? table.substring(0, cut).trim() : "DEFAULT";
        String tableName = cut >= 0 ? table.substring(cut + 1).trim() : table.trim();
        return new String[]{database, tableName};
    }

    public static void deletePath(Configuration conf, Path path) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
    }

    public static byte[] toBytes(Writable writable) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            writable.write((DataOutput)out);
            out.close();
            bout.close();
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path getFilterOnlyPath(FileSystem fs, Path baseDir, final String filter) throws IOException {
        if (!fs.exists(baseDir)) {
            return null;
        }
        FileStatus[] fileStatus = fs.listStatus(baseDir, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith(filter);
            }
        });
        if (fileStatus.length == 1) {
            return fileStatus[0].getPath();
        }
        return null;
    }

    public static Path[] getFilteredPath(FileSystem fs, Path baseDir, final String prefix) throws IOException {
        if (!fs.exists(baseDir)) {
            return null;
        }
        FileStatus[] fileStatus = fs.listStatus(baseDir, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith(prefix);
            }
        });
        Path[] result = new Path[fileStatus.length];
        for (int i = 0; i < fileStatus.length; ++i) {
            result[i] = fileStatus[i].getPath();
        }
        return result;
    }

    public static void deleteHDFSMeta(String metaUrl) throws IOException {
        String realHdfsPath = StorageURL.valueOf(metaUrl).getParameter("path");
        HadoopUtil.getFileSystem(realHdfsPath).delete(new Path(realHdfsPath), true);
        logger.info("Delete metadata in HDFS for this job: " + realHdfsPath);
    }

    public static void writeToSequenceFile(Configuration conf, String outputPath, Map<String, String> counterMap) throws IOException {
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)HadoopUtil.getWorkingFileSystem(conf), (Configuration)conf, (Path)new Path(outputPath), Text.class, Text.class);){
            for (Map.Entry<String, String> counterEntry : counterMap.entrySet()) {
                writer.append((Writable)new Text(counterEntry.getKey()), (Writable)new Text(counterEntry.getValue()));
            }
        }
    }

    public static Map<String, String> readFromSequenceFile(Configuration conf, String inputPath) throws IOException {
        try (SequenceFile.Reader reader = new SequenceFile.Reader(HadoopUtil.getWorkingFileSystem(conf), new Path(inputPath), conf);){
            HashMap<String, String> map = Maps.newHashMap();
            Text key = (Text)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Text value = (Text)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            while (reader.next((Writable)key, (Writable)value)) {
                map.put(key.toString(), value.toString());
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
    }

    public static List<String> readDistinctColumnValues(Configuration conf, String inputPath) throws IOException {
        try (SequenceFile.Reader reader = new SequenceFile.Reader(HadoopUtil.getWorkingFileSystem(conf), new Path(inputPath), conf);){
            ArrayList<String> values = Lists.newArrayList();
            NullWritable key = (NullWritable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Text value = (Text)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            while (reader.next((Writable)key, (Writable)value)) {
                values.add(value.toString());
            }
            ArrayList<String> arrayList = values;
            return arrayList;
        }
    }

    public static List<String> readDistinctColumnValues(String inputPath) throws IOException {
        return HadoopUtil.readDistinctColumnValues(HadoopUtil.getCurrentConfiguration(), inputPath);
    }

    public static Map<String, String> readFromSequenceFile(String inputPath) throws IOException {
        return HadoopUtil.readFromSequenceFile(HadoopUtil.getCurrentConfiguration(), inputPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSequenceFile(Configuration conf, Path filePath) {
        try (SequenceFile.Reader reader = new SequenceFile.Reader(HadoopUtil.getWorkingFileSystem(conf), filePath, conf);){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.warn("Read sequence file {} failed.", (Object)filePath.getName(), (Object)e);
            return false;
        }
    }

    public static boolean isSequenceDir(Configuration conf, Path fileDir) throws IOException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem(conf);
        FileStatus[] fileStatuses = fs.listStatus(fileDir, new PathFilter(){

            public boolean accept(Path path) {
                return !"_SUCCESS".equals(path.getName());
            }
        });
        if (fileStatuses != null && fileStatuses.length > 0) {
            return HadoopUtil.isSequenceFile(conf, fileStatuses[0].getPath());
        }
        return true;
    }

    public static ContentSummary getContentSummary(FileSystem fileSystem, Path path) throws IOException {
        IStorageProvider provider = (IStorageProvider)ClassUtil.newInstance(KylinConfig.getInstanceFromEnv().getStorageProvider());
        logger.debug("Use provider:{}", (Object)provider.getClass().getCanonicalName());
        return provider.getContentSummary(fileSystem, path);
    }
}

