/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.kylin.common.util.OrderedProperties;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackwardCompatibilityConfig {
    private static final Logger logger = LoggerFactory.getLogger(BackwardCompatibilityConfig.class);
    private static final String KYLIN_BACKWARD_COMPATIBILITY = "kylin-backward-compatibility";
    private static final String PROPERTIES_SUFFIX = ".properties";
    private final Map<String, String> old2new = Maps.newConcurrentMap();
    private final Map<String, String> old2newPrefix = Maps.newConcurrentMap();

    public BackwardCompatibilityConfig() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.init(loader.getResourceAsStream("kylin-backward-compatibility.properties"));
        for (int i = 0; i < 10; ++i) {
            this.init(loader.getResourceAsStream(KYLIN_BACKWARD_COMPATIBILITY + i + PROPERTIES_SUFFIX));
        }
    }

    BackwardCompatibilityConfig(InputStream is) {
        this.init(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream is) {
        if (is == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            logger.error("", e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        for (Map.Entry<Object, Object> kv : props.entrySet()) {
            String value;
            String key = (String)kv.getKey();
            if (key.equals(value = (String)kv.getValue())) continue;
            if (value.contains(key)) {
                throw new IllegalStateException("New key '" + value + "' contains old key '" + key + "' causes trouble to repeated find & replace");
            }
            if (value.endsWith(".")) {
                this.old2newPrefix.put(key, value);
                continue;
            }
            this.old2new.put(key, value);
        }
    }

    public String check(String key) {
        String newKey = this.old2new.get(key);
        if (newKey != null) {
            logger.warn("Config '{}' is deprecated, use '{}' instead", (Object)key, (Object)newKey);
            return newKey;
        }
        for (String oldPrefix : this.old2newPrefix.keySet()) {
            if (!key.startsWith(oldPrefix)) continue;
            String newPrefix = this.old2newPrefix.get(oldPrefix);
            newKey = newPrefix + key.substring(oldPrefix.length());
            logger.warn("Config '{}' is deprecated, use '{}' instead", (Object)key, (Object)newKey);
            return newKey;
        }
        return key;
    }

    public Map<String, String> check(Map<String, String> props) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> kv : props.entrySet()) {
            result.put(this.check(kv.getKey()), kv.getValue());
        }
        return result;
    }

    public Properties check(Properties props) {
        Properties result = new Properties();
        for (Map.Entry<Object, Object> kv : props.entrySet()) {
            result.setProperty(this.check((String)kv.getKey()), (String)kv.getValue());
        }
        return result;
    }

    public OrderedProperties check(OrderedProperties props) {
        OrderedProperties result = new OrderedProperties();
        for (Map.Entry<String, String> kv : props.entrySet()) {
            result.setProperty(this.check(kv.getKey()), kv.getValue());
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        String kylinRepoDir = args.length > 0 ? args[0] : ".";
        String outputDir = args.length > 1 ? args[1] : kylinRepoDir;
        BackwardCompatibilityConfig.generateFindAndReplaceScript(kylinRepoDir, outputDir);
    }

    private static void generateFindAndReplaceScript(String kylinRepoPath, String outputPath) throws IOException {
        BackwardCompatibilityConfig bcc = new BackwardCompatibilityConfig();
        File repoDir = new File(kylinRepoPath).getCanonicalFile();
        File outputDir = new File(outputPath).getCanonicalFile();
        File sedFile = new File(outputDir, "upgrade-old-config.sed");
        try (PrintWriter out = new PrintWriter(sedFile, "UTF-8");){
            for (Map.Entry<String, String> e : bcc.old2new.entrySet()) {
                out.println("s/" + BackwardCompatibilityConfig.quote(e.getKey()) + "/" + e.getValue() + "/g");
            }
            for (Map.Entry<String, String> e : bcc.old2newPrefix.entrySet()) {
                out.println("s/" + BackwardCompatibilityConfig.quote(e.getKey()) + "/" + e.getValue() + "/g");
            }
        }
        File shFile = new File(outputDir, "upgrade-old-config.sh");
        PrintWriter out = new PrintWriter(shFile, "UTF-8");
        Object object = null;
        try {
            out.println("#!/bin/bash");
            Stack<File> stack = new Stack<File>();
            stack.push(repoDir);
            while (!stack.isEmpty()) {
                File dir = (File)stack.pop();
                for (File f : dir.listFiles()) {
                    if (f.getName().startsWith(".")) continue;
                    if (f.isDirectory()) {
                        if (!BackwardCompatibilityConfig.acceptSourceDir(f)) continue;
                        stack.push(f);
                        continue;
                    }
                    if (!BackwardCompatibilityConfig.acceptSourceFile(f)) continue;
                    out.println("sed -i -f upgrade-old-config.sed " + f.getAbsolutePath());
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (object != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
        System.out.println("Files generated:");
        System.out.println(shFile);
        System.out.println(sedFile);
    }

    private static String quote(String key) {
        return key.replace(".", "[.]");
    }

    private static boolean acceptSourceDir(File f) {
        if (f.getName().equals("components") && f.getParentFile().getName().equals("app")) {
            return false;
        }
        if (f.getName().equals("node_modules") && f.getParentFile().getName().equals("webapp")) {
            return false;
        }
        return !f.getName().equals("target");
    }

    private static boolean acceptSourceFile(File f) {
        String name = f.getName();
        if (name.startsWith(KYLIN_BACKWARD_COMPATIBILITY)) {
            return false;
        }
        if (name.equals("KylinConfigTest.java")) {
            return false;
        }
        if (name.endsWith("-site.xml")) {
            return false;
        }
        return name.endsWith(".java") || name.endsWith(".js") || name.endsWith(".sh") || name.endsWith(PROPERTIES_SUFFIX) || name.endsWith(".xml");
    }
}

