/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.fs;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemCacheFileInputStream
extends FSInputStream
implements ByteBufferReadable {
    private static final Logger LOG = LoggerFactory.getLogger(MemCacheFileInputStream.class);
    private final FileSystem.Statistics statistics;
    private ByteBuffer buf;
    private Path file;
    private int fileLength;

    public MemCacheFileInputStream(Path file, ByteBuffer buf, int fileLength, FileSystem.Statistics statistics) throws IOException {
        this.file = file;
        this.buf = buf;
        this.fileLength = fileLength;
        this.statistics = statistics;
        assert (this.fileLength == buf.capacity());
        this.buf.flip();
        this.buf.limit(fileLength);
    }

    public synchronized long getPos() throws IOException {
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        return this.buf.position();
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public synchronized int available() throws IOException {
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        return this.buf.remaining();
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("Mark/reset not supported");
    }

    public synchronized int read() throws IOException {
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        this.statistics.incrementBytesRead(1L);
        return this.buf.get() & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        int read = Math.min(this.buf.remaining(), len);
        if (read > 0) {
            this.buf.get(b, off, read);
            this.statistics.incrementBytesRead((long)read);
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(long pos, byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (pos < 0L || pos > (long)this.buf.limit()) {
            throw new EOFException("Reading file " + this.file.toString() + " error, position is negative");
        }
        if (b == null || off < 0 || len < 0 || b.length - off < len) {
            throw new IllegalArgumentException("Reading file " + this.file.toString() + " error, invalid arguments: " + off + " " + len);
        }
        int oldPos = this.buf.position();
        this.buf.position((int)pos);
        int got = Math.min(this.buf.remaining(), len);
        try {
            if (got > 0) {
                this.buf.get(b, off, len);
                this.statistics.incrementBytesRead((long)got);
            }
        }
        finally {
            this.buf.position(oldPos);
        }
        return got;
    }

    public synchronized int read(ByteBuffer b) throws IOException {
        if (!b.hasRemaining()) {
            return 0;
        }
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        int got = Math.min(b.remaining(), this.buf.remaining());
        if (got > 0) {
            byte[] readedBytes = new byte[got];
            this.buf.get(readedBytes, 0, got);
            b.put(readedBytes, 0, got);
            this.statistics.incrementBytesRead((long)got);
        }
        return got;
    }

    public synchronized void seek(long p) throws IOException {
        if (p < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        if (p > (long)this.buf.limit()) {
            throw new EOFException("Attempted to seek or read past the end of the file");
        }
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        this.buf.position((int)p);
    }

    public synchronized long skip(long n) throws IOException {
        if (n < 0L) {
            return -1L;
        }
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        if (n > (long)this.buf.remaining()) {
            throw new EOFException("Attempted to skip past the end of the file");
        }
        this.buf.position(this.buf.position() + (int)n);
        return n;
    }

    public synchronized void close() throws IOException {
        if (this.buf != null) {
            this.buf = null;
        }
    }

    public FileSystem.Statistics getStatistics() {
        return this.statistics;
    }

    public ByteBuffer getBuf() {
        return this.buf;
    }

    public void setBuf(ByteBuffer buf) {
        this.buf = buf;
    }

    public Path getFile() {
        return this.file;
    }

    public void setFile(Path file) {
        this.file = file;
    }
}

