/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.fs;

import alluxio.client.file.FileInStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.DirectBufferPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFileInputStream
extends FSInputStream
implements ByteBufferReadable {
    public static final int EINVAL = -22;
    private static final Logger LOG = LoggerFactory.getLogger(CacheFileInputStream.class);
    private final DirectBufferPool bufferPool;
    private final FileSystem.Statistics statistics;
    private final FileInStream mInputStream;
    private ByteBuffer buf;
    private Path file;
    private boolean mClosed = false;

    public CacheFileInputStream(Path file, FileInStream inputStream, DirectBufferPool directBufferPool, FileSystem.Statistics statistics, int size) throws IOException {
        this.file = file;
        this.mInputStream = inputStream;
        this.bufferPool = directBufferPool;
        this.buf = this.bufferPool != null ? this.bufferPool.getBuffer(size) : ByteBuffer.allocate(size);
        this.statistics = statistics;
        this.buf.limit(0);
    }

    public synchronized long getPos() throws IOException {
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        return this.mInputStream.getPos() - (long)this.buf.remaining();
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public synchronized int available() throws IOException {
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        return this.buf.remaining() + this.mInputStream.available();
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("Mark/reset not supported");
    }

    public synchronized int read() throws IOException {
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        if (!this.buf.hasRemaining() && !this.refill()) {
            return -1;
        }
        assert (this.buf.hasRemaining());
        this.statistics.incrementBytesRead(1L);
        return this.buf.get() & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        if (!this.buf.hasRemaining() && len <= this.buf.capacity() && !this.refill()) {
            return -1;
        }
        int read = Math.min(this.buf.remaining(), len);
        if (read > 0) {
            this.buf.get(b, off, read);
            this.statistics.incrementBytesRead((long)read);
            off += read;
            len -= read;
        }
        if (len == 0) {
            return read;
        }
        int more = this.readInternal(b, off, len);
        if (more <= 0) {
            if (read > 0) {
                return read;
            }
            return -1;
        }
        this.buf.position(0);
        this.buf.limit(0);
        return read + more;
    }

    protected synchronized int readInternal(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        if (b == null || off < 0 || len < 0 || b.length - off < len) {
            throw new IllegalArgumentException("Reading file " + this.file.toString() + " error, invalid arguments: " + off + " " + len);
        }
        int got = this.mInputStream.read(b, off, len);
        if (got == 0) {
            return -1;
        }
        if (got == -22) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        if (got < 0) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        this.statistics.incrementBytesRead((long)got);
        return got;
    }

    private boolean refill() throws IOException {
        this.buf.clear();
        int read = this.readInternal(this.buf);
        if (read <= 0) {
            this.buf.limit(0);
            return false;
        }
        this.statistics.incrementBytesRead((long)(-read));
        this.buf.flip();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(long pos, byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (pos < 0L) {
            throw new EOFException("Reading file " + this.file.toString() + " error, position is negative");
        }
        if (b == null || off < 0 || len < 0 || b.length - off < len) {
            throw new IllegalArgumentException("Reading file " + this.file.toString() + " error, invalid arguments: " + off + " " + len);
        }
        long oldPos = this.mInputStream.getPos();
        this.mInputStream.seek(pos);
        int got = -1;
        try {
            got = this.mInputStream.read(b, off, len);
            if (got == 0) {
                int n = -1;
                return n;
            }
            if (got == -22) {
                throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
            }
            if (got < 0) {
                throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
            }
        }
        finally {
            this.mInputStream.seek(oldPos);
        }
        this.statistics.incrementBytesRead((long)got);
        return got;
    }

    public synchronized int read(ByteBuffer b) throws IOException {
        if (!b.hasRemaining()) {
            return 0;
        }
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        if (!this.buf.hasRemaining() && b.remaining() <= this.buf.capacity() && !this.refill()) {
            return -1;
        }
        int got = Math.min(b.remaining(), this.buf.remaining());
        if (got > 0) {
            byte[] readedBytes = new byte[got];
            this.buf.get(readedBytes, 0, got);
            b.put(readedBytes, 0, got);
            this.statistics.incrementBytesRead((long)got);
        }
        if (!b.hasRemaining()) {
            return got;
        }
        int more = this.readInternal(b);
        if (more <= 0) {
            return got > 0 ? got : -1;
        }
        this.buf.position(0);
        this.buf.limit(0);
        return got + more;
    }

    protected synchronized int readInternal(ByteBuffer b) throws IOException {
        int got;
        if (!b.hasRemaining()) {
            return 0;
        }
        if (b.hasArray()) {
            got = this.readInternal(b.array(), b.position(), b.remaining());
            if (got <= 0) {
                return got;
            }
            b.position(b.position() + got);
        } else {
            assert (b.isDirect());
            got = this.mInputStream.read(b, b.position(), b.remaining());
            if (got == -22) {
                throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
            }
            if (got < 0) {
                throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
            }
            if (got == 0) {
                return -1;
            }
            this.statistics.incrementBytesRead((long)got);
        }
        return got;
    }

    public synchronized void seek(long p) throws IOException {
        if (p < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        if (p < this.mInputStream.getPos() && p >= this.mInputStream.getPos() - (long)this.buf.limit()) {
            this.buf.position((int)(p - (this.mInputStream.getPos() - (long)this.buf.limit())));
        } else {
            this.buf.position(0);
            this.buf.limit(0);
            this.mInputStream.seek(p);
        }
    }

    public synchronized long skip(long n) throws IOException {
        if (n < 0L) {
            return -1L;
        }
        if (this.buf == null) {
            throw new IOException("Reading file " + this.file.toString() + " error, stream was closed");
        }
        if (n < (long)this.buf.remaining()) {
            this.buf.position(this.buf.position() + (int)n);
        } else {
            this.mInputStream.skip(n - (long)this.buf.remaining());
            this.buf.position(0);
            this.buf.limit(0);
        }
        return n;
    }

    public synchronized void close() throws IOException {
        if (!this.mClosed) {
            this.mInputStream.close();
            this.mClosed = true;
        }
        if (this.bufferPool != null && this.buf != null) {
            this.bufferPool.returnBuffer(this.buf);
        }
        this.buf = null;
    }
}

