/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.kylin.jdbc.IRemoteClient;
import org.apache.kylin.jdbc.JdbcFactory;
import org.apache.kylin.jdbc.KylinClient;
import org.apache.kylin.jdbc.KylinConnection;
import org.apache.kylin.jdbc.KylinConnectionInfo;
import org.apache.kylin.jdbc.KylinPreparedStatement;
import org.apache.kylin.jdbc.KylinResultSet;
import org.apache.kylin.jdbc.KylinStatement;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaDatabaseMetaData;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaFactory;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaPreparedStatement;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSetMetaData;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.QueryState;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.UnregisteredDriver;

public class KylinJdbcFactory
implements JdbcFactory {
    final int major;
    final int minor;

    protected KylinJdbcFactory(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    @Override
    public int getJdbcMajorVersion() {
        return this.major;
    }

    @Override
    public int getJdbcMinorVersion() {
        return this.minor;
    }

    @Override
    public AvaticaConnection newConnection(UnregisteredDriver driver, AvaticaFactory factory, String url, Properties info) throws SQLException {
        return new KylinConnection(driver, (KylinJdbcFactory)factory, url, info);
    }

    @Override
    public AvaticaDatabaseMetaData newDatabaseMetaData(AvaticaConnection connection) {
        return new AvaticaDatabaseMetaData(connection){};
    }

    @Override
    public AvaticaStatement newStatement(AvaticaConnection connection, Meta.StatementHandle h, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new KylinStatement((KylinConnection)connection, h, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public AvaticaPreparedStatement newPreparedStatement(AvaticaConnection connection, Meta.StatementHandle h, Meta.Signature signature, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new KylinPreparedStatement((AvaticaConnection)((KylinConnection)connection), h, signature, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public AvaticaResultSet newResultSet(AvaticaStatement statement, QueryState state, Meta.Signature signature, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        AvaticaResultSetMetaData resultSetMetaData = new AvaticaResultSetMetaData(statement, null, signature);
        return new KylinResultSet(statement, state, signature, resultSetMetaData, timeZone, firstFrame);
    }

    @Override
    public ResultSetMetaData newResultSetMetaData(AvaticaStatement statement, Meta.Signature signature) throws SQLException {
        return new AvaticaResultSetMetaData(statement, null, signature);
    }

    @Override
    public IRemoteClient newRemoteClient(KylinConnectionInfo conn) {
        return new KylinClient(conn);
    }

    public static class Version41
    extends KylinJdbcFactory {
        public Version41() {
            super(4, 1);
        }
    }

    public static class Version40
    extends KylinJdbcFactory {
        public Version40() {
            super(4, 0);
        }
    }
}

