/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.knox.gateway.shell.Credentials;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.apache.knox.gateway.shell.jdbc.KnoxLine;
import org.apache.knox.gateway.shell.knox.token.Get;
import org.apache.knox.gateway.shell.knox.token.Token;
import org.apache.knox.gateway.shell.util.ClientTrustStoreHelper;
import org.apache.knox.gateway.util.JsonUtils;
import org.apache.knox.gateway.util.X509CertificateUtil;

public class KnoxSh {
    private static final String USAGE_PREFIX = "KnoxSh {cmd} [options]";
    private static final String COMMANDS = "   [--help]\n   [buildTrustStore --gateway server-url]\n   [init --gateway topology-url]\n   [destroy]\n   [list]\n   [knoxline]\n";
    PrintStream out = System.out;
    PrintStream err = System.err;
    private Command command;
    private String gateway;

    public int run(String[] args) throws Exception {
        int exitCode;
        try {
            exitCode = this.init(args);
            if (exitCode != 0) {
                return exitCode;
            }
            if (this.command != null && this.command.validate()) {
                this.command.execute();
            } else {
                this.out.println("ERROR: Invalid Command\nUnrecognized option:" + args[0] + "\nA fatal exception has occurred. Program will exit.");
                exitCode = -2;
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.err);
            this.err.flush();
            return -3;
        }
        return exitCode;
    }

    private int init(String[] args) throws IOException {
        if (args.length == 0) {
            this.printKnoxShellUsage();
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("destroy")) {
                this.command = new KnoxDestroy();
                continue;
            }
            if (args[i].equals("buildTrustStore")) {
                this.command = new KnoxBuildTrustStore();
                continue;
            }
            if (args[i].equals("init")) {
                this.command = new KnoxInit();
                continue;
            }
            if (args[i].equals("list")) {
                this.command = new KnoxList();
                continue;
            }
            if (args[i].equals("knoxline")) {
                this.command = new KnoxLineCommand();
                continue;
            }
            if (args[i].equals("--gateway")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    this.printKnoxShellUsage();
                    return -1;
                }
                this.gateway = args[++i];
                continue;
            }
            if (args[i].equals("--help")) {
                this.printKnoxShellUsage();
                return -1;
            }
            this.printKnoxShellUsage();
            return -1;
        }
        return 0;
    }

    private void printKnoxShellUsage() {
        this.out.println("KnoxSh {cmd} [options]\n   [--help]\n   [buildTrustStore --gateway server-url]\n   [init --gateway topology-url]\n   [destroy]\n   [list]\n   [knoxline]\n");
        if (this.command != null) {
            this.out.println(this.command.getUsage());
        } else {
            char[] chars = new char[79];
            Arrays.fill(chars, '=');
            String div = new String(chars);
            this.out.println(div);
            this.out.println("init --gateway topology-url\n\nInitializes a Knox token session.");
            this.out.println();
            this.out.println(div);
            this.out.println("destroy\n\nDestroys an Knox token session.");
            this.out.println();
            this.out.println(div);
            this.out.println("list\n\nDisplays Knox token details.");
            this.out.println();
            this.out.println(div);
            this.out.println("knoxline\n\nSimple SQL Client.");
            this.out.println();
            this.out.println(div);
        }
    }

    private void displayTokenDetails(Map<String, String> json) {
        System.out.println("Token Type: " + json.get("token_type"));
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss", Locale.getDefault());
        long milliSeconds = Long.parseLong(json.get("expires_in"));
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        calendar.setTimeInMillis(milliSeconds);
        System.out.println("Expires On: " + formatter.format(calendar.getTime()));
        String targetUrl = json.get("target_url");
        if (targetUrl != null) {
            System.out.println("Target URL: " + json.get("target_url"));
        } else {
            System.out.println("No specific target URL configured.");
        }
    }

    /*
     * Exception decompiling
     */
    private String readFile(String file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) throws Exception {
        KnoxSh sh = new KnoxSh();
        int res = sh.run(args);
        System.exit(res);
    }

    private class KnoxLineCommand
    extends Command {
        public static final String USAGE = "knoxline";
        public static final String DESC = "Simple SQL Client.";

        private KnoxLineCommand() {
        }

        @Override
        public void execute() throws Exception {
            KnoxLine line = new KnoxLine();
            line.execute(new ArrayList().toArray(new String[0]));
        }

        @Override
        public String getUsage() {
            return "knoxline:\n\nSimple SQL Client.";
        }
    }

    private class KnoxList
    extends Command {
        public static final String USAGE = "list";
        public static final String DESC = "Displays Knox token details.";

        private KnoxList() {
        }

        @Override
        public void execute() throws Exception {
            String tokenFilePath = System.getProperty("user.home") + File.separator + ".knoxtokencache";
            if (new File(tokenFilePath).exists()) {
                String tokenfile = KnoxSh.this.readFile(tokenFilePath);
                if (tokenfile != null) {
                    Map json = JsonUtils.getMapFromJsonString((String)tokenfile);
                    KnoxSh.this.displayTokenDetails(json);
                }
            } else {
                System.out.println("Knox token cache does not exist. Please login with init.");
            }
        }

        @Override
        public String getUsage() {
            return "list:\n\nDisplays Knox token details.";
        }
    }

    private class KnoxDestroy
    extends Command {
        public static final String USAGE = "destroy";
        public static final String DESC = "Destroys an Knox token session.";

        private KnoxDestroy() {
        }

        @Override
        public void execute() throws Exception {
            File tokenfile = new File(System.getProperty("user.home"), ".knoxtokencache");
            tokenfile.delete();
        }

        @Override
        public String getUsage() {
            return "destroy:\n\nDestroys an Knox token session.";
        }
    }

    private class KnoxInit
    extends Command {
        public static final String USAGE = "init --gateway topology-url";
        public static final String DESC = "Initializes a Knox token session.";

        private KnoxInit() {
        }

        @Override
        public void execute() throws Exception {
            Credentials credentials = new Credentials();
            credentials.add("ClearInput", "Enter username: ", "user").add("HiddenInput", "Enter password: ", "pass");
            credentials.collect();
            String username = credentials.get("user").string();
            String pass = credentials.get("pass").string();
            KnoxSession session = null;
            try {
                session = KnoxSession.login(KnoxSh.this.gateway, username, pass);
                Get.Response response = (Get.Response)Token.get(session).now();
                String text = response.getString();
                Map json = JsonUtils.getMapFromJsonString((String)text);
                System.out.println("knoxinit successful!");
                KnoxSh.this.displayTokenDetails(json);
                File tokenfile = new File(System.getProperty("user.home"), ".knoxtokencache");
                try (OutputStream fos = Files.newOutputStream(tokenfile.toPath(), new OpenOption[0]);){
                    fos.write(text.getBytes(StandardCharsets.UTF_8));
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                    perms.add(PosixFilePermission.OWNER_READ);
                    perms.add(PosixFilePermission.OWNER_WRITE);
                    Files.setPosixFilePermissions(Paths.get(System.getProperty("user.home") + "/.knoxtokencache", new String[0]), perms);
                }
            }
            catch (KnoxShellException he) {
                String rc;
                String message = "Failure to acquire token. Please verify your credentials, Knox URL, and TLS truststore configuration.";
                Throwable t = he.getCause();
                if (t != null && (rc = t.getMessage()) != null) {
                    message = message + " Cause: " + rc;
                }
                System.out.println(message);
            }
            if (session != null) {
                session.shutdown();
            }
        }

        @Override
        public String getUsage() {
            return "init --gateway topology-url:\n\nInitializes a Knox token session.";
        }
    }

    class KnoxBuildTrustStore
    extends Command {
        private static final String USAGE = "buildTrustStore --gateway server-url";
        private static final String DESC = "Downloads the gateway server's public certificate and builds a trust store.";
        private static final String GATEWAY_CERT_NOT_EXPORTED = "Finished work without building truststore";
        private static final String GATEWAY_CERT_EXPORTED_MESSAGE_PREFIX = "Gateway server's certificate is exported into ";

        KnoxBuildTrustStore() {
        }

        @Override
        public void execute() throws Exception {
            String result = GATEWAY_CERT_NOT_EXPORTED;
            try {
                Certificate[] gatewayServerPublicCerts = X509CertificateUtil.fetchPublicCertsFromServer((String)KnoxSh.this.gateway, (boolean)false, (PrintStream)KnoxSh.this.out);
                if (gatewayServerPublicCerts != null) {
                    File trustStoreFile = ClientTrustStoreHelper.getClientTrustStoreFile();
                    String trustStorePassword = ClientTrustStoreHelper.getClientTrustStoreFilePassword();
                    X509CertificateUtil.writeCertificatesToJks((Certificate[])gatewayServerPublicCerts, (File)trustStoreFile, (String)trustStorePassword);
                    result = GATEWAY_CERT_EXPORTED_MESSAGE_PREFIX + trustStoreFile.getAbsolutePath();
                }
            }
            catch (Exception e) {
                throw new KnoxShellException("Error while building trust store", e);
            }
            KnoxSh.this.out.println(result);
        }

        @Override
        public String getUsage() {
            return "buildTrustStore --gateway server-url:\n\nDownloads the gateway server's public certificate and builds a trust store.";
        }
    }

    private abstract class Command {
        private Command() {
        }

        public boolean validate() {
            return true;
        }

        public abstract void execute() throws Exception;

        public abstract String getUsage();
    }
}

