/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.hadoop.xml;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.hadoop.xml.HadoopXmlResourceMessages;
import org.apache.knox.gateway.topology.hadoop.xml.HadoopXmlResourceParser;
import org.apache.knox.gateway.topology.hadoop.xml.HadoopXmlResourceParserResult;
import org.apache.knox.gateway.util.JsonUtils;

public class HadoopXmlResourceMonitor {
    private static final String HADOOP_XML_RESOURCE_FILE_EXTENSION = ".hxr";
    private static final HadoopXmlResourceMessages LOG = (HadoopXmlResourceMessages)MessagesFactory.get(HadoopXmlResourceMessages.class);
    private final String sharedProvidersDir;
    private final String descriptorsDir;
    private final String topologyDir;
    private final long monitoringInterval;
    private final HadoopXmlResourceParser hadoopXmlResourceParser;
    private final Map<Path, FileTime> lastReloadTimes;
    private final Lock monitorLock = new ReentrantLock();

    public HadoopXmlResourceMonitor(GatewayConfig gatewayConfig, HadoopXmlResourceParser hadoopXmlResourceParser) {
        this.hadoopXmlResourceParser = hadoopXmlResourceParser;
        this.sharedProvidersDir = gatewayConfig.getGatewayProvidersConfigDir();
        this.descriptorsDir = gatewayConfig.getGatewayDescriptorsDir();
        this.topologyDir = gatewayConfig.getGatewayTopologyDir();
        this.monitoringInterval = gatewayConfig.getClouderaManagerDescriptorsMonitoringInterval();
        this.lastReloadTimes = new ConcurrentHashMap<Path, FileTime>();
    }

    public void setupMonitor() {
        if (this.monitoringInterval > 0L) {
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("ClouderaManagerDescriptorMonitor-%d").build());
            this.monitorClouderaManagerDescriptors();
            executorService.scheduleAtFixedRate(() -> this.monitorClouderaManagerDescriptors(), this.monitoringInterval, this.monitoringInterval, TimeUnit.MILLISECONDS);
            LOG.monitoringHadoopXmlResources(this.descriptorsDir);
        }
    }

    private void monitorClouderaManagerDescriptors() {
        File[] clouderaManagerDescriptorFiles;
        for (File clouderaManagerDescriptorFile : clouderaManagerDescriptorFiles = new File(this.descriptorsDir).listFiles((FileFilter)new SuffixFileFilter(HADOOP_XML_RESOURCE_FILE_EXTENSION))) {
            this.monitorClouderaManagerDescriptor(Paths.get(clouderaManagerDescriptorFile.getAbsolutePath(), new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorClouderaManagerDescriptor(Path clouderaManagerDescriptorFile) {
        this.monitorLock.lock();
        try {
            if (Files.isReadable(clouderaManagerDescriptorFile)) {
                FileTime lastModifiedTime = Files.getLastModifiedTime(clouderaManagerDescriptorFile, new LinkOption[0]);
                FileTime lastReloadTime = this.lastReloadTimes.get(clouderaManagerDescriptorFile);
                if (lastReloadTime == null || lastReloadTime.compareTo(lastModifiedTime) < 0) {
                    this.lastReloadTimes.put(clouderaManagerDescriptorFile, lastModifiedTime);
                    LOG.processHadoopXmlResource(clouderaManagerDescriptorFile.toString(), lastReloadTime, lastModifiedTime);
                    this.processClouderaManagerDescriptor(clouderaManagerDescriptorFile.toString());
                } else {
                    LOG.skipMonitorHadoopXmlResource(clouderaManagerDescriptorFile.toString(), lastReloadTime, lastModifiedTime);
                }
            } else {
                LOG.failedToMonitorHadoopXmlResource(clouderaManagerDescriptorFile.toString(), "File is not readable!", null);
            }
        }
        catch (IOException e) {
            LOG.failedToMonitorHadoopXmlResource(clouderaManagerDescriptorFile.toString(), e.getMessage(), e);
        }
        finally {
            this.monitorLock.unlock();
        }
    }

    private void processClouderaManagerDescriptor(String descriptorFilePath) {
        HadoopXmlResourceParserResult result = this.hadoopXmlResourceParser.parse(descriptorFilePath);
        this.processSharedProviders(result);
        this.processDescriptors(result);
        this.processDeleted(this.topologyDir, result.getDeletedDescriptors(), ".xml");
        this.processDeleted(this.descriptorsDir, result.getDeletedDescriptors(), ".json");
        this.processDeleted(this.sharedProvidersDir, result.getDeletedProviders(), ".json");
    }

    private void processDeleted(String parentDirectory, Set<String> deletedFileNames, String extension) {
        for (String each : deletedFileNames) {
            File fileToBeDeleted = new File(parentDirectory, each + extension);
            if (!fileToBeDeleted.exists()) continue;
            LOG.deleteFile(fileToBeDeleted.getAbsolutePath());
            fileToBeDeleted.delete();
        }
    }

    private void processSharedProviders(HadoopXmlResourceParserResult result) {
        result.getProviders().forEach((key, value) -> {
            try {
                File knoxProviderConfigFile = new File(this.sharedProvidersDir, key + ".json");
                String providersConfiguration = JsonUtils.renderAsJsonString((Object)value);
                if (this.isResourceChangedOrNew(knoxProviderConfigFile, providersConfiguration)) {
                    FileUtils.writeStringToFile((File)knoxProviderConfigFile, (String)providersConfiguration, (Charset)StandardCharsets.UTF_8);
                    LOG.savedResource("shared provider", knoxProviderConfigFile.getAbsolutePath());
                } else {
                    LOG.resourceDidNotChange((String)key, "shared provider");
                }
            }
            catch (IOException e) {
                LOG.failedToProduceKnoxProvider(e.getMessage(), e);
            }
        });
    }

    private void processDescriptors(HadoopXmlResourceParserResult result) {
        result.getDescriptors().forEach(simpleDescriptor -> {
            try {
                File knoxDescriptorFile = new File(this.descriptorsDir, simpleDescriptor.getName() + ".json");
                String simpleDescriptorJsonString = JsonUtils.renderAsJsonString((Object)simpleDescriptor);
                if (this.isResourceChangedOrNew(knoxDescriptorFile, simpleDescriptorJsonString)) {
                    FileUtils.writeStringToFile((File)knoxDescriptorFile, (String)JsonUtils.renderAsJsonString((Object)simpleDescriptor), (Charset)StandardCharsets.UTF_8);
                    LOG.savedResource("descriptor", knoxDescriptorFile.getAbsolutePath());
                } else {
                    LOG.resourceDidNotChange(simpleDescriptor.getName(), "descriptor");
                }
            }
            catch (IOException e) {
                LOG.failedToProduceKnoxDescriptor(e.getMessage(), e);
            }
        });
    }

    private boolean isResourceChangedOrNew(File knoxDescriptorFile, String simpleDescriptorJsonString) throws IOException {
        if (knoxDescriptorFile.exists()) {
            String currentContent = FileUtils.readFileToString((File)knoxDescriptorFile, (Charset)StandardCharsets.UTF_8);
            return !simpleDescriptorJsonString.equals(currentContent);
        }
        return true;
    }
}

