/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExUtils {
    public static boolean checkWhitelist(String whitelist, String tomatch) {
        String[] patterns;
        for (String patternString : patterns = whitelist.split(";")) {
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(tomatch);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean checkBaseUrlAgainstWhitelist(String whitelist, String fullUrl) throws MalformedURLException {
        String decodedURL = fullUrl;
        try {
            decodedURL = URLDecoder.decode(fullUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        URL url = new URL(decodedURL);
        String baseUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), "").toString();
        return RegExUtils.checkWhitelist(whitelist, baseUrl);
    }
}

