/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.nntp;

public class SimpleNNTPHeader {
    private final String subject;
    private final String from;
    private final StringBuilder newsgroups;
    private final StringBuilder headerFields;
    private int newsgroupCount;

    public SimpleNNTPHeader(String from, String subject) {
        this.from = from;
        this.subject = subject;
        this.newsgroups = new StringBuilder();
        this.headerFields = new StringBuilder();
        this.newsgroupCount = 0;
    }

    public void addHeaderField(String headerField, String value) {
        this.headerFields.append(headerField);
        this.headerFields.append(": ");
        this.headerFields.append(value);
        this.headerFields.append('\n');
    }

    public void addNewsgroup(String newsgroup) {
        if (this.newsgroupCount++ > 0) {
            this.newsgroups.append(',');
        }
        this.newsgroups.append(newsgroup);
    }

    public String getFromAddress() {
        return this.from;
    }

    public String getNewsgroups() {
        return this.newsgroups.toString();
    }

    public String getSubject() {
        return this.subject;
    }

    public String toString() {
        StringBuilder header = new StringBuilder();
        header.append("From: ");
        header.append(this.from);
        header.append("\nNewsgroups: ");
        header.append(this.newsgroups.toString());
        header.append("\nSubject: ");
        header.append(this.subject);
        header.append('\n');
        if (this.headerFields.length() > 0) {
            header.append(this.headerFields.toString());
        }
        header.append('\n');
        return header.toString();
    }
}

