/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.token.KnoxToken;
import org.apache.knox.gateway.services.security.token.TokenMetadata;
import org.apache.knox.gateway.services.security.token.TokenStateService;
import org.apache.knox.gateway.services.security.token.TokenUtils;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.services.token.TokenStateServiceStatistics;
import org.apache.knox.gateway.services.token.impl.TokenStateServiceMessages;
import org.apache.knox.gateway.util.Tokens;

public class DefaultTokenStateService
implements TokenStateService {
    protected static final long DEFAULT_RENEWAL_INTERVAL = TimeUnit.HOURS.toMillis(24L);
    protected static final int MAX_RENEWALS = 7;
    protected static final long DEFAULT_MAX_LIFETIME = 7L * DEFAULT_RENEWAL_INTERVAL;
    protected static final TokenStateServiceMessages log = (TokenStateServiceMessages)MessagesFactory.get(TokenStateServiceMessages.class);
    private final Map<String, Long> tokenExpirations = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> tokenIssueTimes = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> maxTokenLifetimes = new ConcurrentHashMap<String, Long>();
    private final Map<String, TokenMetadata> metadataMap = new ConcurrentHashMap<String, TokenMetadata>();
    private long tokenEvictionInterval;
    protected long tokenEvictionGracePeriod;
    protected boolean permissiveValidationEnabled;
    private final ScheduledExecutorService evictionScheduler = Executors.newScheduledThreadPool(1);
    protected TokenStateServiceStatistics tokenStateServiceStatistics;

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.tokenEvictionInterval = config.getKnoxTokenEvictionInterval();
        this.tokenEvictionGracePeriod = config.getKnoxTokenEvictionGracePeriod();
        this.permissiveValidationEnabled = config.isKnoxTokenPermissiveValidationEnabled();
        if (config.isMetricsEnabled() && config.isJmxMetricsReportingEnabled()) {
            try {
                this.tokenStateServiceStatistics = new TokenStateServiceStatistics();
                ObjectName objectName = ObjectName.getInstance("metrics:type=Statistics,name=TokenStateService");
                ManagementFactory.getPlatformMBeanServer().registerMBean(this.tokenStateServiceStatistics, objectName);
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
                throw new ServiceLifecycleException("Could not register token state service MBean", (Exception)e);
            }
        }
    }

    public void start() throws ServiceLifecycleException {
        if (this.tokenEvictionInterval > 0L) {
            this.evictionScheduler.scheduleAtFixedRate(this::evictExpiredTokens, this.tokenEvictionInterval, this.tokenEvictionInterval, TimeUnit.SECONDS);
        }
    }

    public void stop() throws ServiceLifecycleException {
        this.evictionScheduler.shutdown();
    }

    public long getDefaultRenewInterval() {
        return DEFAULT_RENEWAL_INTERVAL;
    }

    public long getDefaultMaxLifetimeDuration() {
        return DEFAULT_MAX_LIFETIME;
    }

    public void addToken(JWTToken token, long issueTime) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null.");
        }
        this.addToken(TokenUtils.getTokenId((JWT)token), issueTime, token.getExpiresDate().getTime());
    }

    public void addToken(String tokenId, long issueTime, long expiration) {
        this.addToken(tokenId, issueTime, expiration, this.getDefaultMaxLifetimeDuration());
    }

    public void addToken(String tokenId, long issueTime, long expiration, long maxLifetimeDuration) {
        this.validateTokenIdentifier(tokenId);
        this.setIssueTime(tokenId, issueTime);
        this.tokenExpirations.put(tokenId, expiration);
        this.setMaxLifetime(tokenId, issueTime, maxLifetimeDuration);
        log.addedToken(Tokens.getTokenIDDisplayText((String)tokenId), this.getTimestampDisplay(expiration));
        if (this.tokenStateServiceStatistics != null) {
            this.tokenStateServiceStatistics.addToken();
        }
    }

    protected void setIssueTime(String tokenId, long issueTime) {
        this.tokenIssueTimes.put(tokenId, issueTime);
    }

    public long getTokenIssueTime(String tokenId) throws UnknownTokenException {
        this.validateToken(tokenId);
        Long issueTime = this.tokenIssueTimes.get(tokenId);
        if (issueTime == null) {
            throw new UnknownTokenException(tokenId);
        }
        return issueTime;
    }

    public long getTokenExpiration(JWT token) throws UnknownTokenException {
        long expiration;
        block3: {
            expiration = -1L;
            try {
                expiration = this.getTokenExpiration(TokenUtils.getTokenId((JWT)token));
            }
            catch (UnknownTokenException e) {
                String exp;
                if (this.permissiveValidationEnabled && (exp = token.getExpires()) != null) {
                    log.permissiveTokenHandling(Tokens.getTokenIDDisplayText((String)TokenUtils.getTokenId((JWT)token)), e.getMessage());
                    expiration = Long.parseLong(exp);
                }
                if (expiration != -1L) break block3;
                throw e;
            }
        }
        return expiration;
    }

    public long getTokenExpiration(String tokenId) throws UnknownTokenException {
        return this.getTokenExpiration(tokenId, true);
    }

    public long getTokenExpiration(String tokenId, boolean validate) throws UnknownTokenException {
        Long expiration;
        if (validate) {
            this.validateToken(tokenId);
        }
        if ((expiration = this.tokenExpirations.get(tokenId)) == null) {
            throw new UnknownTokenException(tokenId);
        }
        return expiration;
    }

    public long renewToken(JWTToken token) throws UnknownTokenException {
        return this.renewToken(token, DEFAULT_RENEWAL_INTERVAL);
    }

    public long renewToken(JWTToken token, long renewInterval) throws UnknownTokenException {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null.");
        }
        return this.renewToken(TokenUtils.getTokenId((JWT)token), renewInterval);
    }

    public long renewToken(String tokenId) throws UnknownTokenException {
        return this.renewToken(tokenId, DEFAULT_RENEWAL_INTERVAL);
    }

    public long renewToken(String tokenId, long renewInterval) throws UnknownTokenException {
        long expiration;
        this.validateToken(tokenId);
        if (this.hasRemainingRenewals(tokenId, renewInterval)) {
            expiration = System.currentTimeMillis() + renewInterval;
            this.updateExpiration(tokenId, expiration);
            log.renewedToken(Tokens.getTokenIDDisplayText((String)tokenId), this.getTimestampDisplay(expiration));
            if (this.tokenStateServiceStatistics != null) {
                this.tokenStateServiceStatistics.renewToken();
            }
        } else {
            log.renewalLimitExceeded(Tokens.getTokenIDDisplayText((String)tokenId));
            throw new IllegalArgumentException("The renewal limit for the token has been exceeded");
        }
        return expiration;
    }

    public void revokeToken(JWTToken token) throws UnknownTokenException {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null.");
        }
        this.revokeToken(TokenUtils.getTokenId((JWT)token));
    }

    public void revokeToken(String tokenId) throws UnknownTokenException {
        this.removeToken(tokenId);
        log.revokedToken(Tokens.getTokenIDDisplayText((String)tokenId));
    }

    public boolean isExpired(JWTToken token) throws UnknownTokenException {
        return this.getTokenExpiration((JWT)token) <= System.currentTimeMillis();
    }

    protected void setMaxLifetime(String token, long maxLifeTime) {
        this.maxTokenLifetimes.put(token, maxLifeTime);
    }

    protected void setMaxLifetime(String token, long issueTime, long maxLifetimeDuration) {
        long maxLifetime = maxLifetimeDuration < 0L ? maxLifetimeDuration : issueTime + maxLifetimeDuration;
        this.setMaxLifetime(token, maxLifetime);
    }

    protected boolean isUnknown(String token) {
        return !this.tokenExpirations.containsKey(token);
    }

    protected void updateExpiration(String tokenId, long expiration) {
        this.tokenExpirations.put(tokenId, expiration);
    }

    protected void removeToken(String tokenId) throws UnknownTokenException {
        this.validateToken(tokenId);
        this.removeTokens(Collections.singleton(tokenId));
    }

    protected void removeTokens(Set<String> tokenIds) {
        this.removeTokenState(tokenIds);
    }

    private void removeTokenState(Set<String> tokenIds) {
        this.tokenIssueTimes.keySet().removeAll(tokenIds);
        this.tokenExpirations.keySet().removeAll(tokenIds);
        this.maxTokenLifetimes.keySet().removeAll(tokenIds);
        this.metadataMap.keySet().removeAll(tokenIds);
        log.removedTokenState(String.join((CharSequence)", ", Tokens.getDisplayableTokenIDsText(tokenIds)));
    }

    protected boolean hasRemainingRenewals(String tokenId, long renewInterval) {
        long maximumTokenLifetime = this.getMaxLifetime(tokenId);
        return maximumTokenLifetime < 0L ? true : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L) + renewInterval < maximumTokenLifetime;
    }

    protected long getMaxLifetime(String tokenId) {
        return this.maxTokenLifetimes.getOrDefault(tokenId, 0L);
    }

    private void validateTokenIdentifier(String tokenId) {
        if (tokenId == null || tokenId.isEmpty()) {
            throw new IllegalArgumentException("Token identifier cannot be null or empty.");
        }
    }

    protected void validateToken(String tokenId) throws IllegalArgumentException, UnknownTokenException {
        this.validateTokenIdentifier(tokenId);
        if (this.isUnknown(tokenId)) {
            log.unknownToken(Tokens.getTokenIDDisplayText((String)tokenId));
            throw new UnknownTokenException(tokenId);
        }
    }

    private String getTimestampDisplay(long timestamp) {
        return Instant.ofEpochMilli(timestamp).toString();
    }

    protected void evictExpiredTokens() {
        if (this.readyForEviction()) {
            Set<String> tokensToEvict = this.getExpiredTokens();
            if (!tokensToEvict.isEmpty()) {
                this.removeTokens(tokensToEvict);
            }
        } else {
            log.skipEviction();
        }
    }

    protected boolean readyForEviction() {
        return true;
    }

    protected Set<String> getExpiredTokens() {
        HashSet<String> expiredTokens = new HashSet<String>();
        for (String tokenId : this.getTokenIds()) {
            try {
                if (!this.needsEviction(tokenId)) continue;
                log.evictToken(Tokens.getTokenIDDisplayText((String)tokenId));
                expiredTokens.add(tokenId);
            }
            catch (Exception e) {
                log.failedExpiredTokenEviction(Tokens.getTokenIDDisplayText((String)tokenId), e);
            }
        }
        return expiredTokens;
    }

    protected boolean needsEviction(String tokenId) throws UnknownTokenException {
        long tokenExpiration = this.getTokenExpiration(tokenId, false);
        long expirationWithGrace = tokenExpiration + TimeUnit.SECONDS.toMillis(this.tokenEvictionGracePeriod);
        return tokenExpiration > 0L && expirationWithGrace <= System.currentTimeMillis();
    }

    protected List<String> getTokenIds() {
        return this.tokenExpirations.keySet().stream().collect(Collectors.toList());
    }

    public void addMetadata(String tokenId, TokenMetadata metadata) {
        this.metadataMap.put(tokenId, metadata);
    }

    public TokenMetadata getTokenMetadata(String tokenId) throws UnknownTokenException {
        if (!this.metadataMap.containsKey(tokenId)) {
            throw new UnknownTokenException(tokenId);
        }
        return this.metadataMap.get(tokenId);
    }

    public Collection<KnoxToken> getAllTokens() {
        return this.fetchTokens(null, false);
    }

    public Collection<KnoxToken> getTokens(String userName) {
        return this.fetchTokens(userName, false);
    }

    public Collection<KnoxToken> getDoAsTokens(String createdBy) {
        return this.fetchTokens(createdBy, true);
    }

    private Collection<KnoxToken> fetchTokens(String userName, boolean createdBy) {
        TreeSet<KnoxToken> tokens = new TreeSet<KnoxToken>();
        Predicate<Map.Entry> filterPredicate = userName == null ? entry -> true : (createdBy ? entry -> userName.equals(((TokenMetadata)entry.getValue()).getCreatedBy()) : entry -> userName.equals(((TokenMetadata)entry.getValue()).getUserName()));
        this.metadataMap.entrySet().stream().filter(filterPredicate).forEach(metadata -> {
            String tokenId = (String)metadata.getKey();
            try {
                tokens.add(new KnoxToken(tokenId, this.getTokenIssueTime(tokenId), this.getTokenExpiration(tokenId), this.getMaxLifetime(tokenId), (TokenMetadata)metadata.getValue()));
            }
            catch (UnknownTokenException unknownTokenException) {
                // empty catch block
            }
        });
        return tokens;
    }
}

